# 📦 DigUpDOG ULTIMATE Installation Guide

## Step-by-Step Installation

### 1️⃣ Prerequisites
- PHP 8.0+
- MySQL 8.0+
- Apache/Nginx web server
- 512MB RAM minimum

### 2️⃣ Extract Files
```bash
unzip DigUpDOG_ULTIMATE_v10.0.zip
cd DigUpDOG_ULTIMATE
```

### 3️⃣ Create Database
```sql
CREATE DATABASE digupdog_FEED CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

### 4️⃣ Import Schema
```bash
mysql -u root -p digupdog_FEED < sql/digupdog_FEED.sql
```

### 5️⃣ Configure
Edit `config.php`:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'digupdog_FEED');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
define('SITE_URL', 'https://yourdomain.com');
```

### 6️⃣ Set Permissions
```bash
chmod 755 uploads/ cache/ logs/
chmod 644 config.php
```

### 7️⃣ Test Installation
Visit: `http://yourdomain.com/`

Login with:
- Username: `testuser`
- Password: `test123`

### 8️⃣ Security
**IMPORTANT**: Change default passwords!
```php
// In config.php
define('SECRET_KEY', 'your-random-secret-key');
define('JWT_SECRET', 'your-random-jwt-secret');
```

## Troubleshooting

### Database Connection Error
- Check credentials in config.php
- Verify MySQL is running
- Check user permissions

### 404 Errors
- Enable mod_rewrite (Apache)
- Check .htaccess file exists
- Verify DocumentRoot points to DigUpDOG_ULTIMATE

### Upload Errors
- Check folder permissions
- Verify PHP upload_max_filesize
- Check available disk space

## Support
Email: hello@digupdog.com
