<?php
require_once __DIR__ . '/../config.php';

/**
 * File: api_author_feeds.php
 * GET ?author=username&limit=24&page=1
 * Returns:
 *   { success, feeds: [...], pagination: { page, pages, limit, total } }
 */
session_start();
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store');

$host='localhost'; $db='digupdog_FEED'; $user='digupdog_FEEDadmin'; $pass='Raimundinho1'; $charset='utf8mb4';

try{
  $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset",$user,$pass,[
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
  ]);
}catch(PDOException $e){
  http_response_code(500); echo json_encode(['success'=>false,'error'=>'db']); exit;
}

$author = isset($_GET['author']) ? trim((string)$_GET['author']) : '';
if ($author === '' && isset($_GET['autor'])) $author = trim((string)$_GET['autor']);
if ($author === '') { echo json_encode(['success'=>false,'error'=>'missing_author']); exit; }

$limit = isset($_GET['limit']) ? max(1, min(100, (int)$_GET['limit'])) : 24;
$page  = isset($_GET['page'])  ? max(1, (int)$_GET['page']) : 1;
$off   = ($page-1) * $limit;

/* Total */
$st = $pdo->prepare("SELECT COUNT(*) FROM pinfeeds WHERE author = ?");
$st->execute([$author]);
$total = (int)$st->fetchColumn();
$pages = max(1, (int)ceil($total / $limit));

/* Rows (join shares; comments_count via subquery) */
$sql = "SELECT 
          p.id, p.title, p.link, p.thumbnail, p.author, p.source_domain, p.pubDate,
          COALESCE(p.likes,0)   AS likes,
          COALESCE(p.dislikes,0) AS dislikes,
          (SELECT COUNT(*) FROM comments c WHERE c.feed_id = p.id) AS comments_count,
          COALESCE(s.share_count,0) AS shares_count
        FROM pinfeeds p
        LEFT JOIN feed_share_counters s ON s.feed_id = p.id
        WHERE p.author = ?
        ORDER BY p.pubDate DESC
        LIMIT ? OFFSET ?";
$st = $pdo->prepare($sql);
$st->bindValue(1, $author, PDO::PARAM_STR);
$st->bindValue(2, (int)$limit, PDO::PARAM_INT);
$st->bindValue(3, (int)$off,   PDO::PARAM_INT);
$st->execute();
$rows = $st->fetchAll();

/* Output */
echo json_encode([
  'success'    => true,
  'feeds'      => array_map(function($r){
    $r['id']            = (int)$r['id'];
    $r['likes']         = (int)$r['likes'];
    $r['dislikes']      = (int)$r['dislikes'];
    $r['comments_count']= (int)$r['comments_count'];
    $r['shares_count']  = (int)$r['shares_count'];
    return $r;
  }, $rows),
  'pagination' => [ 'page'=>$page, 'pages'=>$pages, 'limit'=>$limit, 'total'=>$total ]
]);
