<?php
require_once __DIR__ . '/../config.php';

/**
 * File: api_author_info.php
 * GET ?author=username
 * Returns: { success, username, profile_picture, bio, user_role, account_plan, stats:{...} }
 */
session_start();
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store');

$host='localhost'; $db='digupdog_FEED'; $user='digupdog_FEEDadmin'; $pass='Raimundinho1'; $charset='utf8mb4';

try{
  $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset",$user,$pass,[
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
  ]);
}catch(PDOException $e){
  http_response_code(500); echo json_encode(['success'=>false,'error'=>'db']); exit;
}

$author = isset($_GET['author']) ? trim((string)$_GET['author']) : '';
if ($author === '' && isset($_GET['autor'])) $author = trim((string)$_GET['autor']);
if ($author === '') { echo json_encode(['success'=>false,'error'=>'missing_author']); exit; }

/* Basic profile */
$st = $pdo->prepare("SELECT username, profile_picture, bio, user_role, account_plan 
                     FROM user_myhashtag WHERE username = ? LIMIT 1");
$st->execute([$author]);
$u = $st->fetch() ?: ['username'=>$author,'profile_picture'=>null,'bio'=>null,'user_role'=>null,'account_plan'=>null];

/* Stats */
$stats = [
  'total_feeds'    => 0,
  'total_likes'    => 0,
  'total_comments' => 0,
  'total_shares'   => 0,
];

$st = $pdo->prepare("SELECT COUNT(*) FROM pinfeeds WHERE author = ?");
$st->execute([$author]);
$stats['total_feeds'] = (int)$st->fetchColumn();

$st = $pdo->prepare("SELECT COALESCE(SUM(likes),0) FROM pinfeeds WHERE author = ?");
$st->execute([$author]);
$stats['total_likes'] = (int)$st->fetchColumn();

$st = $pdo->prepare("SELECT COALESCE(COUNT(*),0) 
                     FROM comments 
                     WHERE feed_id IN (SELECT id FROM pinfeeds WHERE author = ?)");
$st->execute([$author]);
$stats['total_comments'] = (int)$st->fetchColumn();

$st = $pdo->prepare("SELECT COALESCE(SUM(f.share_count),0)
                     FROM feed_share_counters f
                     INNER JOIN pinfeeds p ON p.id = f.feed_id
                     WHERE p.author = ?");
$st->execute([$author]);
$stats['total_shares'] = (int)$st->fetchColumn();

/* Output */
echo json_encode([
  'success'          => true,
  'username'         => $u['username'],
  'profile_picture'  => $u['profile_picture'],
  'bio'              => $u['bio'],
  'user_role'        => $u['user_role'],
  'account_plan'     => $u['account_plan'],
  'stats'            => $stats
]);
