<?php
require_once __DIR__ . '/../config.php';

/**
 * File: api_comment_flags.php
 * POST JSON { comment_id, reason }
 */
session_start();
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store');

$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
} catch (PDOException $e) {
    http_response_code(500); echo json_encode(['success'=>false]); exit;
}

// CSRF só para POST
$hdr = $_SERVER['HTTP_X_CSRF_TOKEN'] ?? '';
if (empty($_SESSION['csrf_token']) || empty($hdr) || !hash_equals($_SESSION['csrf_token'], $hdr)) {
    http_response_code(403); echo json_encode(['success'=>false, 'error'=>'CSRF']); exit;
}

$in = json_decode(file_get_contents('php://input'), true) ?: [];
$cid = (int)($in['comment_id'] ?? 0);
$reason = trim((string)($in['reason'] ?? 'report'));
if ($cid <= 0) { echo json_encode(['success'=>false]); exit; }

$ip = $_SERVER['REMOTE_ADDR'] ?? '';
$ua = substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 180);
$user_hash = hash('sha256', ($\_SESSION['username'] ?? 'guest').'|'.$ip.'|'.$ua);

$st = $pdo->prepare("INSERT INTO comment_flags (comment_id, reporter, reason, created_at) VALUES (?, ?, ?, NOW())");
$st->execute([$cid, $user_hash, $reason]);

echo json_encode(['success'=>true]);
