<?php
require_once __DIR__ . '/../config.php';

//api_comment_upload.php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

/* Limits and whitelists */
$MAX_IMG_MB = 10;
$MAX_VID_MB = 50;
$ALLOWED_IMG = ['image/jpeg','image/png','image/webp','image/gif'];
$ALLOWED_VID = ['video/mp4'];

/* Paths */
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host   = $_SERVER['HTTP_HOST'] ?? 'myhashtag.io';
$BASE_URL = $scheme.'://'.$host.'/';
$UPLOAD_DIR = __DIR__.'/uploads/comments/';
$PUBLIC_BASE = $BASE_URL.'uploads/comments/';

if (!is_dir($UPLOAD_DIR)) { @mkdir($UPLOAD_DIR, 0755, true); }

$out = ['success'=>false, 'urls'=>[]];

if (empty($_FILES['files'])) { echo json_encode($out); exit; }

$files = $_FILES['files'];
$count = is_array($files['name']) ? count($files['name']) : 0;

for ($i=0; $i<$count; $i++) {
  if ($files['error'][$i] !== UPLOAD_ERR_OK) continue;

  $tmp  = $files['tmp_name'][$i];
  $name = $files['name'][$i];
  $type = mime_content_type($tmp) ?: $files['type'][$i];

  $isImg = in_array($type, $ALLOWED_IMG, true);
  $isVid = in_array($type, $ALLOWED_VID, true);
  if (!$isImg && !$isVid) continue;

  $size = filesize($tmp);
  if ($isImg && $size > $MAX_IMG_MB*1024*1024) continue;
  if ($isVid && $size > $MAX_VID_MB*1024*1024) continue;

  $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
  if ($isVid) $ext = 'mp4';
  if ($isImg && !in_array($ext, ['jpg','jpeg','png','webp','gif'], true)) {
    $ext = match ($type) {
      'image/jpeg' => 'jpg',
      'image/png'  => 'png',
      'image/webp' => 'webp',
      'image/gif'  => 'gif',
      default      => 'bin'
    };
  }

  $slug = bin2hex(random_bytes(8)).'_'.(time());
  $fname = $slug.'.'.$ext;
  $dest = $UPLOAD_DIR.$fname;

  if (@move_uploaded_file($tmp, $dest)) {
    @chmod($dest, 0644);
    $out['urls'][] = $PUBLIC_BASE.$fname;
  }
}

$out['success'] = count($out['urls'])>0;
echo json_encode($out, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
