<?php
require_once __DIR__ . '/../config.php';

// api_likes.php
session_start();
header('Content-Type: application/json; charset=utf-8');

$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'db_connection_failed']);
    exit;
}

function getUserId(PDO $pdo): ?int {
    if (!isset($_SESSION['username'])) return null;
    $st = $pdo->prepare("SELECT ID FROM user_myhashtag WHERE username = :u LIMIT 1");
    $st->execute([':u' => $_SESSION['username']]);
    $r = $st->fetch(PDO::FETCH_ASSOC);
    return $r ? (int)$r['ID'] : null;
}
function counts(PDO $pdo, int $feedId): array {
    $likes = $pdo->prepare("SELECT COUNT(*) FROM likes_dislikes WHERE feed_id = ? AND action = 'like'");
    $likes->execute([$feedId]);
    $dislikes = $pdo->prepare("SELECT COUNT(*) FROM likes_dislikes WHERE feed_id = ? AND action = 'dislike'");
    $dislikes->execute([$feedId]);
    return ['likes' => (int)$likes->fetchColumn(), 'dislikes' => (int)$dislikes->fetchColumn()];
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $feedId = isset($_GET['feed_id']) ? (int)$_GET['feed_id'] : 0;
    if ($feedId <= 0) { echo json_encode(['success'=>false, 'error'=>'invalid_feed']); exit; }
    $userId = getUserId($pdo);

    $c = counts($pdo, $feedId);
    $reaction = null;
    if ($userId) {
        $st = $pdo->prepare("SELECT action FROM likes_dislikes WHERE feed_id = ? AND user_id = ? LIMIT 1");
        $st->execute([$feedId, $userId]);
        $reaction = $st->fetchColumn() ?: null;
    }
    echo json_encode(['success'=>true, 'likes'=>$c['likes'], 'dislikes'=>$c['dislikes'], 'user_reaction'=>$reaction]);
    exit;
}

if ($method === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $feedId = isset($data['feed_id']) ? (int)$data['feed_id'] : 0;
    $action = isset($data['action']) ? ($data['action']==='like'?'like':'dislike') : 'like';

    if ($feedId <= 0) { echo json_encode(['success'=>false, 'error'=>'invalid_feed']); exit; }

    $userId = getUserId($pdo);
    if (!$userId) { echo json_encode(['success'=>false, 'error'=>'not_logged_in']); exit; }

    $st = $pdo->prepare("SELECT id, action FROM likes_dislikes WHERE feed_id = ? AND user_id = ? LIMIT 1");
    $st->execute([$feedId, $userId]);
    $row = $st->fetch(PDO::FETCH_ASSOC);

    $resultAction = null;
    if ($row) {
        if ($row['action'] === $action) {
            $del = $pdo->prepare("DELETE FROM likes_dislikes WHERE id = ?");
            $del->execute([$row['id']]);
            $resultAction = 'removed';
        } else {
            $upd = $pdo->prepare("UPDATE likes_dislikes SET action = ? WHERE id = ?");
            $upd->execute([$action, $row['id']]);
            $resultAction = 'updated';
        }
    } else {
        $ins = $pdo->prepare("INSERT INTO likes_dislikes (user_id, feed_id, action) VALUES (?, ?, ?)");
        $ins->execute([$userId, $feedId, $action]);
        $resultAction = 'added';
    }

    $c = counts($pdo, $feedId);
    echo json_encode([
        'success'=>true,
        'action'=>$resultAction,
        'likes'=>$c['likes'],
        'dislikes'=>$c['dislikes'],
        'user_reaction'=>($resultAction==='removed'?null:$action)
    ]);
    exit;
}

http_response_code(405);
echo json_encode(['success'=>false,'error'=>'method_not_allowed']);
