<?php
require_once __DIR__ . '/../config.php';

/**
 * =========================================================
 *  File: api_og.php
 *  Purpose: Fetch Open Graph / fallback meta (title/description/image) for a URL
 *  Input: GET url=https://...
 *  Output: { success:true, url:"...", title:"...", description:"...", image:"..." }
 *  Notes:
 *    - Timeout curto, e limpeza básica de HTML.
 *    - Normaliza imagem relativa para absoluta.
 * =========================================================
 */
header('Content-Type: application/json; charset=utf-8');

$url = isset($_GET['url']) ? trim($_GET['url']) : '';
if (!$url || !preg_match('~^https?://~i', $url)) {
    echo json_encode(['success'=>false,'error'=>'invalid_url']); exit;
}

function http_get($url, $timeout=6){
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_MAXREDIRS      => 4,
        CURLOPT_CONNECTTIMEOUT => $timeout,
        CURLOPT_TIMEOUT        => $timeout,
        CURLOPT_USERAGENT      => 'MyHashtagOG/1.0 (+https://myhashtag.io)',
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_HTTPHEADER     => ['Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8']
    ]);
    $body = curl_exec($ch);
    $err  = curl_error($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($err || $code >= 400 || !$body) return false;
    return $body;
}

function abs_url($maybe, $base){
    if (!$maybe) return '';
    if (preg_match('~^https?://~i', $maybe)) return $maybe;
    // construir absoluto
    $p = parse_url($base);
    if (!$p) return '';
    $scheme = $p['scheme'] ?? 'https';
    $host   = $p['host'] ?? '';
    if (!$host) return '';
    if (strpos($maybe, '//') === 0) return $scheme.':'.$maybe;
    if ($maybe[0] === '/') return $scheme.'://'.$host.$maybe;
    $path = isset($p['path']) ? preg_replace('~/[^/]*$~','/',$p['path']) : '/';
    return $scheme.'://'.$host.$path.$maybe;
}

$body = http_get($url, 7);
if ($body === false){
    echo json_encode(['success'=>false,'error'=>'fetch_failed']); exit;
}

// capturar meta
libxml_use_internal_errors(true);
$dom = new DOMDocument();
@$dom->loadHTML($body);
$xpath = new DOMXPath($dom);

function meta($xpath, $props){
    foreach ($props as $p){
        $nodes = $xpath->query("//meta[@property='$p' or @name='$p']");
        if ($nodes && $nodes->length){
            $content = $nodes->item(0)->getAttribute('content');
            if ($content) return $content;
        }
    }
    return '';
}

$title = meta($xpath, ['og:title','twitter:title','title']);
if (!$title){
    $tNodes = $xpath->query('//title');
    if ($tNodes && $tNodes->length) $title = trim($tNodes->item(0)->textContent);
}
$desc  = meta($xpath, ['og:description','description','twitter:description']);
$image = meta($xpath, ['og:image','twitter:image','og:image:url']);

$image = abs_url($image, $url);

echo json_encode([
    'success'     => true,
    'url'         => $url,
    'title'       => $title,
    'description' => $desc,
    'image'       => $image
]);
