<?php
require_once __DIR__ . '/../config.php';

/**
 * =========================================================
 *  File: api_share_stats.php
 *  Purpose: Read share counters per feed/channel
 *  Input: GET feed_id
 *  Output: { success: true, total: int, by_channel: { channel: count, ... } }
 * =========================================================
 */
header('Content-Type: application/json; charset=utf-8');

$host    = 'localhost';
$db      = 'digupdog_FEED';
$user    = 'digupdog_FEEDadmin';
$pass    = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    $pdo = new PDO(
        "mysql:host={$host};dbname={$db};charset={$charset}",
        $user,
        $pass,
        [ PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
          PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC ]
    );
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'db_connection_failed']);
    exit;
}

$feed_id = isset($_GET['feed_id']) ? (int)$_GET['feed_id'] : 0;
if ($feed_id <= 0) {
    echo json_encode(['success' => false, 'error' => 'invalid_feed_id']);
    exit;
}

try {
    $st = $pdo->prepare("SELECT channel, count FROM share_stats WHERE feed_id = ?");
    $st->execute([$feed_id]);

    $by    = [];
    $total = 0;
    while ($row = $st->fetch()) {
        $c = (int)$row['count'];
        $by[(string)$row['channel']] = $c;
        $total += $c;
    }

    echo json_encode(['success' => true, 'total' => $total, 'by_channel' => $by]);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'db_error']);
}
