/**
 * Colored Tags System
 */

// Tags functions not found in demo

/**
 * Colorize navigation items
 */
function colorizeNavItems() {
  const navItems = document.querySelectorAll('.nav-item[data-tab]');
  navItems.forEach(item => {
    const tab = item.getAttribute('data-tab');
    const color = stringToColor(tab);
    item.style.borderLeft = `3px solid ${color}`;

    item.addEventListener('mouseenter', function() {
      this.style.background = `linear-gradient(90deg, ${color}22, transparent)`;
    });

    item.addEventListener('mouseleave', function() {
      this.style.background = '';
    });
  });
}

/**
 * Initialize tags on posts
 */
function initializeTags() {
  const posts = document.querySelectorAll('.post-card');
  posts.forEach(post => {
    const title = post.querySelector('h3, .post-title');
    const tagsContainer = post.querySelector('.post-tags');

    if (title && tagsContainer && !tagsContainer.innerHTML.trim()) {
      const titleText = title.textContent.replace(/^[\s\S]{0,3}\s*/, '');
      tagsContainer.innerHTML = generateColoredTags(titleText);
    }
  });
}

// Export functions
if (typeof module !== 'undefined' && module.exports) {
  module.exports = { stringToColor, generateColoredTags, colorizeNavItems, initializeTags };
}
