<?php
require_once __DIR__ . '/../config.php';

function connectToDatabase() {
    $host = 'localhost';
    $db = 'digupdog_FEED';
    $user = 'digupdog_FEEDadmin';
    $pass = 'Raimundinho1';
    $charset = 'utf8mb4';

    $conn = new mysqli($host, $user, $pass, $db);
    if ($conn->connect_error) {
        die("Erro na conexão: " . $conn->connect_error);
    }
    return $conn;
}

function extractTagsFromTitle($title) {
    // Implemente a lógica para extrair as tags do título aqui
    // Exemplo simples: dividir por espaços e remover caracteres especiais
    return preg_split("/\s+/", preg_replace("/[^a-zA-Z0-9\s]/", "", strtolower($title)));
}

function getRandomTags() {
    $conn = connectToDatabase();
    $result = $conn->query("SELECT title FROM pinfeeds");
    $allTags = [];

    while ($row = $result->fetch_assoc()) {
        $tags = extractTagsFromTitle($row['title']);
        $allTags = array_merge($allTags, $tags);
    }

    $uniqueTags = array_unique($allTags);
    shuffle($uniqueTags); // Embaralha as tags
    $randomTags = array_slice($uniqueTags, 0, 12); // Pega as primeiras 12 tags

    $conn->close();
    return $randomTags;
}

// Chamada da função
header('Content-Type: application/json');
echo json_encode(getRandomTags());
?>
