# 🗄️ DATABASE INSTALLATION GUIDE

## Prerequisites
- MySQL 8.0+ or MariaDB 10.5+
- Database credentials:
  - **Host**: localhost
  - **Database**: digupdog_FEED
  - **User**: digupdog_FEEDadmin
  - **Password**: Raimundinho1

---

## Installation Methods

### Method 1: Command Line (Recommended)
```bash
# 1. Create database
mysql -u root -p -e "CREATE DATABASE IF NOT EXISTS digupdog_FEED CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"

# 2. Create user and grant privileges
mysql -u root -p -e "CREATE USER IF NOT EXISTS 'digupdog_FEEDadmin'@'localhost' IDENTIFIED BY 'Raimundinho1';"
mysql -u root -p -e "GRANT ALL PRIVILEGES ON digupdog_FEED.* TO 'digupdog_FEEDadmin'@'localhost';"
mysql -u root -p -e "FLUSH PRIVILEGES;"

# 3. Import database
mysql -u digupdog_FEEDadmin -pRaimundinho1 digupdog_FEED < digupdog_FEED.sql
```

### Method 2: phpMyAdmin
1. Open phpMyAdmin
2. Click "New" to create database
3. Database name: `digupdog_FEED`
4. Collation: `utf8mb4_unicode_ci`
5. Click "Import" tab
6. Choose file: `digupdog_FEED.sql`
7. Click "Go"

### Method 3: MySQL Workbench
1. Open MySQL Workbench
2. Connect to server
3. Data Import/Restore
4. Import from Self-Contained File
5. Select `digupdog_FEED.sql`
6. Start Import

---

## Verify Installation

```bash
# Check tables count (should be 162)
mysql -u digupdog_FEEDadmin -pRaimundinho1 -e "USE digupdog_FEED; SELECT COUNT(*) as table_count FROM information_schema.tables WHERE table_schema = 'digupdog_FEED';"

# Check main tables exist
mysql -u digupdog_FEEDadmin -pRaimundinho1 -e "USE digupdog_FEED; SHOW TABLES LIKE '%pinfeeds%';"
```

---

## Database Statistics
- **Total Tables**: 162
- **Character Set**: utf8mb4
- **Collation**: utf8mb4_unicode_ci
- **Estimated Size**: ~50MB (varies with data)

---

## Key Tables
- `pinfeeds` - Main content/posts
- `user_myhashtag` - User accounts
- `likes_dislikes` - Engagement tracking
- `comments` - Comments system
- `follows` - Follow relationships
- `favorites` - Bookmarks
- `hashtags` - Tag system
- `reactions` - Emoji reactions
- `shares` - Share tracking

---

## Troubleshooting

### "Access denied for user"
- Check MySQL root password
- Verify user creation commands executed successfully

### "Database already exists"
- Drop existing database: `DROP DATABASE digupdog_FEED;`
- Or import into existing database

### "Character set issues"
- Ensure MySQL server uses utf8mb4 as default
- Add to my.cnf: `default-character-set=utf8mb4`

---

## Security Notes
⚠️ **Production Deployment**:
- Change default password `Raimundinho1` to a strong password
- Update `config.php` with new credentials
- Restrict database user to necessary privileges only
- Enable SSL for database connections
