-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Oct 05, 2025 at 05:49 PM
-- Server version: 8.0.43
-- PHP Version: 8.4.11

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `digupdog_FEED`
--

-- --------------------------------------------------------

--
-- Table structure for table `activity_logs`
--

CREATE TABLE `activity_logs` (
  `id` int UNSIGNED NOT NULL,
  `user_id` int UNSIGNED DEFAULT NULL,
  `action` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` json DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ai_recommendations_x`
--

CREATE TABLE `ai_recommendations_x` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `feed_id` int NOT NULL,
  `recommendation_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `score` decimal(5,3) NOT NULL,
  `reasoning` text COLLATE utf8mb4_unicode_ci,
  `model_version` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` json DEFAULT NULL,
  `shown_at` timestamp NULL DEFAULT NULL,
  `clicked_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp NULL DEFAULT ((now() + interval 7 day))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `analytics_events_x`
--

CREATE TABLE `analytics_events_x` (
  `id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_data` json DEFAULT NULL,
  `url` text COLLATE utf8mb4_unicode_ci,
  `referrer` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `api_idempotency_x`
--

CREATE TABLE `api_idempotency_x` (
  `id` int NOT NULL,
  `endpoint` varchar(64) NOT NULL,
  `key_hash` char(64) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `api_keys_x`
--

CREATE TABLE `api_keys_x` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key_hash` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` json DEFAULT NULL,
  `rate_limit` int DEFAULT '1000',
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `blocked_ips`
--

CREATE TABLE `blocked_ips` (
  `id` int UNSIGNED NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reason` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `blocked_patterns`
--

CREATE TABLE `blocked_patterns` (
  `id` bigint UNSIGNED NOT NULL,
  `pattern` varchar(512) NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `board_collaborators`
--

CREATE TABLE `board_collaborators` (
  `id` int UNSIGNED NOT NULL,
  `board_id` int UNSIGNED NOT NULL,
  `user_id` int NOT NULL,
  `permission_level` enum('viewer','editor','admin') COLLATE utf8mb4_unicode_ci DEFAULT 'viewer',
  `invited_by` int DEFAULT NULL,
  `accepted_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `board_items`
--

CREATE TABLE `board_items` (
  `id` int UNSIGNED NOT NULL,
  `board_id` int UNSIGNED NOT NULL,
  `feed_id` int NOT NULL,
  `position` int DEFAULT '0',
  `custom_title` varchar(1500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_description` text COLLATE utf8mb4_unicode_ci,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `tags` json DEFAULT NULL,
  `is_pinned` tinyint(1) DEFAULT '0',
  `added_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cache_keys_x`
--

CREATE TABLE `cache_keys_x` (
  `id` int NOT NULL,
  `cache_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `chat_messages`
--

CREATE TABLE `chat_messages` (
  `id` int NOT NULL,
  `room_id` int NOT NULL,
  `user_id` int NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `message_type` enum('text','image','file','system') COLLATE utf8mb4_unicode_ci DEFAULT 'text',
  `reply_to` int DEFAULT NULL,
  `is_deleted` tinyint(1) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `chat_participants`
--

CREATE TABLE `chat_participants` (
  `id` int NOT NULL,
  `room_id` int NOT NULL,
  `user_id` int NOT NULL,
  `role` enum('member','moderator','admin') COLLATE utf8mb4_unicode_ci DEFAULT 'member',
  `is_muted` tinyint(1) DEFAULT '0',
  `last_read_message_id` int DEFAULT NULL,
  `joined_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `chat_rooms`
--

CREATE TABLE `chat_rooms` (
  `id` int NOT NULL,
  `feed_id` int NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) DEFAULT '1',
  `max_users` int DEFAULT '100',
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `comments`
--

CREATE TABLE `comments` (
  `comment_id` int NOT NULL,
  `feed_id` int NOT NULL,
  `user_id` int NOT NULL,
  `comment_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `parent_comment_id` int DEFAULT NULL,
  `link_preview` text COLLATE utf8mb4_unicode_ci,
  `link` text COLLATE utf8mb4_unicode_ci,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `thumbnail` text COLLATE utf8mb4_unicode_ci,
  `is_edited` tinyint(1) DEFAULT '0',
  `is_deleted` tinyint(1) DEFAULT '0',
  `is_pinned` tinyint(1) DEFAULT '0',
  `has_poll` tinyint(1) DEFAULT '0',
  `attachments` text COLLATE utf8mb4_unicode_ci,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Triggers `comments`
--
DELIMITER $$
CREATE TRIGGER `cleanup_orphaned_polls` AFTER DELETE ON `comments` FOR EACH ROW BEGIN
    DELETE FROM comment_polls WHERE comment_id = OLD.comment_id;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `comments_polls`
--

CREATE TABLE `comments_polls` (
  `poll_id` int NOT NULL,
  `comment_id` int NOT NULL,
  `question` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `comments_poll_options`
--

CREATE TABLE `comments_poll_options` (
  `option_id` int NOT NULL,
  `poll_id` int NOT NULL,
  `option_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `comments_poll_votes`
--

CREATE TABLE `comments_poll_votes` (
  `vote_id` int NOT NULL,
  `poll_id` int NOT NULL,
  `option_id` int NOT NULL,
  `user_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `comment_attachments`
--

CREATE TABLE `comment_attachments` (
  `id` int NOT NULL,
  `comment_id` int NOT NULL,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_size` int NOT NULL,
  `file_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `thumbnail_url` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `comment_edit_history`
--

CREATE TABLE `comment_edit_history` (
  `id` int NOT NULL,
  `comment_id` int NOT NULL,
  `old_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `edited_by` int NOT NULL,
  `edit_reason` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `comment_flags`
--

CREATE TABLE `comment_flags` (
  `id` int NOT NULL,
  `comment_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `reason` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `comment_mentions`
--

CREATE TABLE `comment_mentions` (
  `id` int NOT NULL,
  `comment_id` int NOT NULL,
  `mentioned_user_id` int NOT NULL,
  `mentioned_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `comment_polls`
--

CREATE TABLE `comment_polls` (
  `id` int NOT NULL,
  `comment_id` int NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `allow_multiple_votes` tinyint(1) DEFAULT '0',
  `anonymous_voting` tinyint(1) DEFAULT '0',
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `comment_reactions`
--

CREATE TABLE `comment_reactions` (
  `id` int NOT NULL,
  `comment_id` int NOT NULL,
  `user_id` int NOT NULL,
  `reaction` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'like',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Triggers `comment_reactions`
--
DELIMITER $$
CREATE TRIGGER `update_comment_stats_after_reaction` AFTER INSERT ON `comment_reactions` FOR EACH ROW BEGIN
    -- Could update a comments_stats table or trigger real-time updates
    INSERT INTO notifications (user_id, type, data, created_at) 
    SELECT c.user_id, 'comment_reaction', 
           JSON_OBJECT(
               'comment_id', NEW.comment_id,
               'reaction', NEW.reaction,
               'reactor_id', NEW.user_id
           ),
           NOW()
    FROM comments c 
    WHERE c.comment_id = NEW.comment_id 
      AND c.user_id != NEW.user_id;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `comment_reports`
--

CREATE TABLE `comment_reports` (
  `id` int NOT NULL,
  `comment_id` int NOT NULL,
  `reporter_id` int NOT NULL,
  `reason` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `status` enum('pending','reviewed','resolved','dismissed') COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `reviewed_by` int DEFAULT NULL,
  `reviewed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Stand-in structure for view `comment_stats`
-- (See below for the actual view)
--
CREATE TABLE `comment_stats` (
`comment_id` int
,`dislikes_count` bigint
,`feed_id` int
,`likes_count` bigint
,`replies_count` bigint
,`total_reactions` bigint
,`user_id` int
);

-- --------------------------------------------------------

--
-- Table structure for table `content_categories`
--

CREATE TABLE `content_categories` (
  `id` int NOT NULL,
  `category_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_id` int NOT NULL DEFAULT '0',
  `title` text COLLATE utf8mb4_unicode_ci,
  `description_id` int NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci,
  `tag_id` int NOT NULL DEFAULT '0',
  `tag` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_cache`
--

CREATE TABLE `crawler_cache` (
  `id` int NOT NULL,
  `cache_key` varchar(255) NOT NULL,
  `cache_value` longtext,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_domains`
--

CREATE TABLE `crawler_domains` (
  `id` int NOT NULL,
  `domain` varchar(255) NOT NULL,
  `total_crawled` int DEFAULT '0',
  `total_imported` int DEFAULT '0',
  `last_crawled` timestamp NULL DEFAULT NULL,
  `crawl_delay` int DEFAULT '1',
  `max_concurrent` int DEFAULT '10',
  `robots_txt` text,
  `sitemap_url` varchar(500) DEFAULT NULL,
  `is_blocked` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_domain_configs`
--

CREATE TABLE `crawler_domain_configs` (
  `id` int NOT NULL,
  `domain` varchar(255) NOT NULL,
  `crawl_delay` decimal(4,2) DEFAULT '1.00',
  `max_concurrent` int DEFAULT '5',
  `max_pages_per_session` int DEFAULT '1000',
  `respect_robots` tinyint(1) DEFAULT '1',
  `follow_redirects` tinyint(1) DEFAULT '1',
  `extract_images` tinyint(1) DEFAULT '1',
  `extract_videos` tinyint(1) DEFAULT '1',
  `extract_links` tinyint(1) DEFAULT '1',
  `extract_emails` tinyint(1) DEFAULT '0',
  `max_page_size_mb` int DEFAULT '10',
  `allowed_content_types` text,
  `blocked_paths` text,
  `custom_headers` json DEFAULT NULL,
  `proxy_config` json DEFAULT NULL,
  `auth_config` json DEFAULT NULL,
  `last_crawled` timestamp NULL DEFAULT NULL,
  `total_pages_crawled` bigint DEFAULT '0',
  `success_rate` decimal(5,2) DEFAULT '100.00',
  `avg_response_time` decimal(8,3) DEFAULT '0.000',
  `is_blocked` tinyint(1) DEFAULT '0',
  `block_reason` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_domain_rules`
--

CREATE TABLE `crawler_domain_rules` (
  `id` int NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','paused','blocked') COLLATE utf8mb4_unicode_ci DEFAULT 'active',
  `priority` int DEFAULT '3',
  `max_depth` int DEFAULT NULL,
  `max_pages` int DEFAULT NULL,
  `crawl_delay` int DEFAULT '0',
  `follow_external` tinyint(1) DEFAULT '1',
  `respect_robots` tinyint(1) DEFAULT '1',
  `custom_rules` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_domain_stats`
--

CREATE TABLE `crawler_domain_stats` (
  `id` bigint NOT NULL,
  `process_id` varchar(255) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `total_links` int DEFAULT '0',
  `processed_links` int DEFAULT '0',
  `imported_links` int DEFAULT '0',
  `error_links` int DEFAULT '0',
  `duplicate_links` int DEFAULT '0',
  `ignored_links` int DEFAULT '0',
  `avg_response_time` float DEFAULT '0',
  `total_size_mb` float DEFAULT '0',
  `last_crawled` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_errors`
--

CREATE TABLE `crawler_errors` (
  `id` bigint NOT NULL,
  `url` text NOT NULL,
  `url_hash` varchar(64) NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `error_type` varchar(100) NOT NULL,
  `error_code` varchar(50) DEFAULT NULL,
  `error_message` text,
  `http_status` smallint DEFAULT NULL,
  `curl_error` text,
  `response_headers` text,
  `request_headers` text,
  `user_agent` varchar(500) DEFAULT NULL,
  `retry_count` tinyint DEFAULT '0',
  `phase` tinyint DEFAULT '1',
  `process_id` varchar(255) DEFAULT NULL,
  `worker_id` varchar(50) DEFAULT NULL,
  `stack_trace` text,
  `context_data` json DEFAULT NULL,
  `occurred_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_error_log`
--

CREATE TABLE `crawler_error_log` (
  `id` bigint NOT NULL,
  `process_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error_message` text COLLATE utf8mb4_unicode_ci,
  `http_code` int DEFAULT NULL,
  `retry_count` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_error_logs`
--

CREATE TABLE `crawler_error_logs` (
  `id` bigint NOT NULL,
  `process_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `error_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error_message` text COLLATE utf8mb4_unicode_ci,
  `http_code` int DEFAULT NULL,
  `phase` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_logs`
--

CREATE TABLE `crawler_logs` (
  `id` bigint NOT NULL,
  `process_id` varchar(255) DEFAULT NULL,
  `level` enum('DEBUG','INFO','WARNING','ERROR','CRITICAL') DEFAULT 'INFO',
  `message` text,
  `context` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_metrics`
--

CREATE TABLE `crawler_metrics` (
  `id` bigint NOT NULL,
  `metric_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metric_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags` text COLLATE utf8mb4_unicode_ci,
  `timestamp` decimal(16,6) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_nodes`
--

CREATE TABLE `crawler_nodes` (
  `node_id` varchar(36) NOT NULL,
  `node_name` varchar(100) DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `port` int DEFAULT NULL,
  `status` enum('active','idle','busy','offline') DEFAULT 'idle',
  `cpu_cores` int DEFAULT NULL,
  `memory_mb` int DEFAULT NULL,
  `current_load` float DEFAULT '0',
  `urls_processed` bigint DEFAULT '0',
  `last_heartbeat` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_performance`
--

CREATE TABLE `crawler_performance` (
  `id` bigint NOT NULL,
  `process_id` varchar(255) DEFAULT NULL,
  `metric_name` varchar(100) DEFAULT NULL,
  `metric_value` decimal(15,4) DEFAULT NULL,
  `recorded_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_processed`
--

CREATE TABLE `crawler_processed` (
  `id` bigint NOT NULL,
  `url_hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `processed_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_processes`
--

CREATE TABLE `crawler_processes` (
  `id` int NOT NULL,
  `process_id` varchar(255) NOT NULL,
  `status` enum('pending','running','paused','stopped','completed','failed') DEFAULT 'pending',
  `total_links` int DEFAULT '0',
  `processed_links` int DEFAULT '0',
  `imported_links` int DEFAULT '0',
  `error_links` int DEFAULT '0',
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `config` json DEFAULT NULL,
  `last_update` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_queue`
--

CREATE TABLE `crawler_queue` (
  `id` bigint NOT NULL,
  `process_id` varchar(255) NOT NULL,
  `url` text NOT NULL,
  `depth` int DEFAULT '0',
  `priority` int DEFAULT '0',
  `status` enum('pending','processing','completed','failed') DEFAULT 'pending',
  `retry_count` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `processed_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_robots_cache`
--

CREATE TABLE `crawler_robots_cache` (
  `id` int NOT NULL,
  `domain` varchar(255) NOT NULL,
  `robots_content` text,
  `crawl_delay` decimal(4,2) DEFAULT '0.00',
  `sitemaps` json DEFAULT NULL,
  `disallowed_paths` json DEFAULT NULL,
  `allowed_paths` json DEFAULT NULL,
  `last_fetched` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp NULL DEFAULT NULL,
  `is_valid` tinyint(1) DEFAULT '1',
  `fetch_error` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_search_engines`
--

CREATE TABLE `crawler_search_engines` (
  `id` int NOT NULL,
  `name` varchar(100) NOT NULL,
  `enabled` tinyint(1) DEFAULT '1',
  `base_url` varchar(500) NOT NULL,
  `max_pages` int DEFAULT '10',
  `delay_seconds` decimal(4,2) DEFAULT '1.00',
  `user_agent` varchar(500) DEFAULT NULL,
  `headers` json DEFAULT NULL,
  `query_params` json DEFAULT NULL,
  `result_selector` varchar(255) DEFAULT NULL,
  `link_selector` varchar(255) DEFAULT NULL,
  `rate_limit_per_hour` int DEFAULT '100',
  `last_used` timestamp NULL DEFAULT NULL,
  `usage_count_today` int DEFAULT '0',
  `success_rate` decimal(5,2) DEFAULT '100.00',
  `avg_response_time` decimal(8,3) DEFAULT '0.000',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_seeds`
--

CREATE TABLE `crawler_seeds` (
  `id` int NOT NULL,
  `seed_type` enum('url','domain','search_term','rss_feed','sitemap') COLLATE utf8mb4_unicode_ci NOT NULL,
  `seed_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `priority` tinyint DEFAULT '5',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `usage_count` int DEFAULT '0',
  `success_rate` decimal(5,2) DEFAULT '0.00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_seen_links`
--

CREATE TABLE `crawler_seen_links` (
  `id` bigint NOT NULL,
  `process_id` varchar(255) NOT NULL,
  `link` text NOT NULL,
  `depth` int NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_statistics`
--

CREATE TABLE `crawler_statistics` (
  `id` bigint NOT NULL,
  `process_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stat_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stat_value` bigint DEFAULT NULL,
  `metadata` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawler_stats`
--

CREATE TABLE `crawler_stats` (
  `id` int NOT NULL,
  `date` date NOT NULL,
  `hour` int NOT NULL,
  `urls_processed` int DEFAULT '0',
  `urls_imported` int DEFAULT '0',
  `errors` int DEFAULT '0',
  `avg_response_time` decimal(10,2) DEFAULT NULL,
  `memory_peak` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawl_metrics`
--

CREATE TABLE `crawl_metrics` (
  `metric_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `node_id` varchar(36) NOT NULL,
  `urls_per_second` float DEFAULT NULL,
  `bytes_per_second` bigint DEFAULT NULL,
  `active_threads` int DEFAULT NULL,
  `queue_size` int DEFAULT NULL,
  `memory_usage_mb` int DEFAULT NULL,
  `cpu_usage_percent` float DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `crawl_queue_shard`
--

CREATE TABLE `crawl_queue_shard` (
  `shard_id` int NOT NULL,
  `url_hash` char(64) NOT NULL,
  `url` text NOT NULL,
  `priority` int DEFAULT '0',
  `depth` int DEFAULT '0',
  `retry_count` int DEFAULT '0',
  `scheduled_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `claimed_by` varchar(36) DEFAULT NULL,
  `claimed_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci
PARTITION BY RANGE (`shard_id`)
(
PARTITION p0 VALUES LESS THAN (10) ENGINE=InnoDB,
PARTITION p1 VALUES LESS THAN (20) ENGINE=InnoDB,
PARTITION p2 VALUES LESS THAN (30) ENGINE=InnoDB,
PARTITION p3 VALUES LESS THAN (40) ENGINE=InnoDB,
PARTITION p4 VALUES LESS THAN (50) ENGINE=InnoDB,
PARTITION p5 VALUES LESS THAN (60) ENGINE=InnoDB,
PARTITION p6 VALUES LESS THAN (70) ENGINE=InnoDB,
PARTITION p7 VALUES LESS THAN (80) ENGINE=InnoDB,
PARTITION p8 VALUES LESS THAN (90) ENGINE=InnoDB,
PARTITION p9 VALUES LESS THAN (100) ENGINE=InnoDB
);

-- --------------------------------------------------------

--
-- Table structure for table `domain_config`
--

CREATE TABLE `domain_config` (
  `id` int NOT NULL,
  `host` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `crawl_delay` int DEFAULT '1',
  `max_depth` int DEFAULT '3',
  `respect_robots_txt` tinyint(1) DEFAULT '1',
  `custom_headers` text COLLATE utf8mb4_unicode_ci,
  `selector_config` text COLLATE utf8mb4_unicode_ci,
  `is_enabled` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `domain_index`
--

CREATE TABLE `domain_index` (
  `id` bigint NOT NULL,
  `domain` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `feed_id` int NOT NULL,
  `occurrence_count` int DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `domain_policies`
--

CREATE TABLE `domain_policies` (
  `id` bigint UNSIGNED NOT NULL,
  `domain` varchar(255) NOT NULL,
  `crawl_delay_ms` int DEFAULT NULL,
  `max_pages` int DEFAULT NULL,
  `respect_robots` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `favorites`
--

CREATE TABLE `favorites` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `feed_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feeds`
--

CREATE TABLE `feeds` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'text',
  `is_deleted` tinyint(1) DEFAULT '0',
  `is_pinned` tinyint(1) DEFAULT '0',
  `has_poll` tinyint(1) DEFAULT '0',
  `has_media` tinyint(1) DEFAULT '0',
  `has_link_preview` tinyint(1) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_comments`
--

CREATE TABLE `feed_comments` (
  `id` int NOT NULL,
  `feed_id` int NOT NULL,
  `parent_comment_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `username` varchar(80) NOT NULL,
  `comment_text` text NOT NULL,
  `link` text,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(500) DEFAULT NULL,
  `thumbnail` text,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_comment_polls`
--

CREATE TABLE `feed_comment_polls` (
  `poll_id` int NOT NULL,
  `comment_id` int NOT NULL,
  `question` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_comment_poll_options`
--

CREATE TABLE `feed_comment_poll_options` (
  `option_id` int NOT NULL,
  `poll_id` int NOT NULL,
  `option_text` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_comment_poll_votes`
--

CREATE TABLE `feed_comment_poll_votes` (
  `vote_id` int NOT NULL,
  `poll_id` int NOT NULL,
  `option_id` int NOT NULL,
  `voter_hash` char(64) NOT NULL,
  `user_id` int DEFAULT NULL,
  `username` varchar(80) DEFAULT NULL,
  `created_at` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_data`
--

CREATE TABLE `feed_data` (
  `id` int NOT NULL,
  `website_base` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `website_feed` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `main_category_id` int DEFAULT NULL,
  `subcategory_id` int DEFAULT NULL,
  `subcategory_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subsubcategory_id` int DEFAULT NULL,
  `subsubcategory_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_added` datetime DEFAULT CURRENT_TIMESTAMP,
  `last_updated` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `is_active` tinyint(1) DEFAULT '1',
  `status_feed` int DEFAULT '3',
  `check_date` datetime DEFAULT NULL,
  `feeds_rss_atom` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT 'Not checked'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_hashtags`
--

CREATE TABLE `feed_hashtags` (
  `id` int NOT NULL,
  `feed_id` int NOT NULL,
  `hashtag` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_media`
--

CREATE TABLE `feed_media` (
  `id` int NOT NULL,
  `feed_id` int NOT NULL,
  `media_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `media_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `thumbnail_url` text COLLATE utf8mb4_unicode_ci,
  `duration` int DEFAULT NULL,
  `sort_order` tinyint DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_mentions`
--

CREATE TABLE `feed_mentions` (
  `id` int NOT NULL,
  `feed_id` int NOT NULL,
  `mentioned_user_id` int NOT NULL,
  `mentioned_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_reactions`
--

CREATE TABLE `feed_reactions` (
  `id` int NOT NULL,
  `feed_id` int NOT NULL,
  `user_id` int NOT NULL,
  `reaction_type` enum('like','dislike') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'like',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_reports`
--

CREATE TABLE `feed_reports` (
  `id` int NOT NULL,
  `feed_id` int NOT NULL,
  `reporter_id` int NOT NULL,
  `reason` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `status` enum('pending','reviewed','resolved','dismissed') COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_shares`
--

CREATE TABLE `feed_shares` (
  `id` int NOT NULL,
  `feed_id` int NOT NULL,
  `user_id` int NOT NULL,
  `share_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'internal',
  `share_data` json DEFAULT NULL,
  `shared_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_share_counters`
--

CREATE TABLE `feed_share_counters` (
  `feed_id` int NOT NULL,
  `share_count` int NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `feed_views`
--

CREATE TABLE `feed_views` (
  `id` int NOT NULL,
  `feed_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `viewed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fetch_log`
--

CREATE TABLE `fetch_log` (
  `id` bigint UNSIGNED NOT NULL,
  `url_id` bigint UNSIGNED NOT NULL,
  `started_at` timestamp NULL DEFAULT NULL,
  `finished_at` timestamp NULL DEFAULT NULL,
  `http_status` int DEFAULT NULL,
  `bytes` int DEFAULT NULL,
  `elapsed_ms` int DEFAULT NULL,
  `out_links` int DEFAULT NULL,
  `relevant_found` tinyint(1) DEFAULT '0',
  `error` text,
  `depth` int DEFAULT NULL,
  `retry_after` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `filter_rules`
--

CREATE TABLE `filter_rules` (
  `id` int NOT NULL,
  `rule_name` varchar(100) DEFAULT NULL,
  `rule_type` enum('domain','path','keyword','regex','content_type','tag') NOT NULL,
  `rule_pattern` text NOT NULL,
  `action` enum('include','exclude','prioritize','deprioritize') DEFAULT 'include',
  `priority` int DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `follows`
--

CREATE TABLE `follows` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `follow_type` enum('author','source_domain','tag') COLLATE utf8mb4_unicode_ci NOT NULL,
  `follow_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hashtags`
--

CREATE TABLE `hashtags` (
  `id` int NOT NULL,
  `tag` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` int DEFAULT '1',
  `last_used` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hc_content`
--

CREATE TABLE `hc_content` (
  `id` bigint UNSIGNED NOT NULL,
  `url_id` bigint UNSIGNED NOT NULL,
  `title` varchar(500) DEFAULT NULL,
  `description` text,
  `content` longtext,
  `content_hash` varchar(32) DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `images` json DEFAULT NULL,
  `videos` json DEFAULT NULL,
  `meta_data` json DEFAULT NULL,
  `extracted_terms` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hc_domains`
--

CREATE TABLE `hc_domains` (
  `id` int NOT NULL,
  `domain` varchar(255) NOT NULL,
  `quality_score` float DEFAULT '0.5',
  `success_rate` float DEFAULT '0',
  `total_urls` bigint DEFAULT '0',
  `imported_urls` bigint DEFAULT '0',
  `last_crawled` timestamp NULL DEFAULT NULL,
  `robots_txt` text,
  `crawl_delay` int DEFAULT '1',
  `blocked` tinyint(1) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hc_imports`
--

CREATE TABLE `hc_imports` (
  `id` bigint NOT NULL,
  `url_id` bigint UNSIGNED NOT NULL,
  `pinfeeds_id` bigint DEFAULT NULL,
  `status` enum('success','duplicate','failed') DEFAULT 'success',
  `error_message` text,
  `imported_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hc_patterns`
--

CREATE TABLE `hc_patterns` (
  `id` int NOT NULL,
  `pattern_type` enum('url','content','structure','trending') NOT NULL,
  `pattern_value` text NOT NULL,
  `success_count` bigint DEFAULT '0',
  `total_count` bigint DEFAULT '0',
  `score` float DEFAULT '0',
  `last_seen` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hc_processes`
--

CREATE TABLE `hc_processes` (
  `id` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` enum('manual','automatic','subdivision','trending','infinite') DEFAULT 'manual',
  `status` enum('idle','running','paused','completed','failed','stopped') DEFAULT 'idle',
  `parent_id` varchar(64) DEFAULT NULL,
  `config` json NOT NULL,
  `stats` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hc_stats`
--

CREATE TABLE `hc_stats` (
  `id` int NOT NULL,
  `metric_name` varchar(100) NOT NULL,
  `metric_value` bigint DEFAULT '0',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hc_terms`
--

CREATE TABLE `hc_terms` (
  `id` int NOT NULL,
  `term` varchar(255) NOT NULL,
  `frequency` bigint DEFAULT '1',
  `relevance_score` float DEFAULT '0.5',
  `success_rate` float DEFAULT '0',
  `last_used` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hc_trending`
--

CREATE TABLE `hc_trending` (
  `id` int NOT NULL,
  `term` varchar(255) NOT NULL,
  `score` float DEFAULT '0',
  `source` varchar(50) DEFAULT NULL,
  `discovered_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `hc_urls`
--

CREATE TABLE `hc_urls` (
  `id` bigint UNSIGNED NOT NULL,
  `process_id` varchar(64) NOT NULL,
  `url` varchar(2048) NOT NULL,
  `url_hash` varchar(32) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `depth` int DEFAULT '0',
  `priority` float DEFAULT '50',
  `status` enum('pending','processing','completed','failed','skipped') DEFAULT 'pending',
  `http_status` int DEFAULT NULL,
  `relevance_score` float DEFAULT '0',
  `retry_count` int DEFAULT '0',
  `processed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `likes_dislikes`
--

CREATE TABLE `likes_dislikes` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `feed_id` int NOT NULL,
  `action` enum('like','dislike') COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `link_graph`
--

CREATE TABLE `link_graph` (
  `id` bigint NOT NULL,
  `source_hash` char(64) DEFAULT NULL,
  `target_hash` char(64) DEFAULT NULL,
  `anchor_text` text,
  `link_context` text,
  `link_type` enum('internal','external','subdomain','javascript','redirect') DEFAULT 'external',
  `follow` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `link_og_cache`
--

CREATE TABLE `link_og_cache` (
  `id` int NOT NULL,
  `url_hash` char(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `image` text COLLATE utf8mb4_unicode_ci,
  `fetched_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `link_previews`
--

CREATE TABLE `link_previews` (
  `id` int NOT NULL,
  `feed_id` int NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `image_url` text COLLATE utf8mb4_unicode_ci,
  `domain` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `link_short`
--

CREATE TABLE `link_short` (
  `id` int NOT NULL,
  `slug` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `long_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `login_attempts`
--

CREATE TABLE `login_attempts` (
  `id` int UNSIGNED NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `attempted_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mega_crawler_host_stats`
--

CREATE TABLE `mega_crawler_host_stats` (
  `id` bigint NOT NULL,
  `process_id` varchar(100) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `total_urls` int DEFAULT '0',
  `successful_urls` int DEFAULT '0',
  `failed_urls` int DEFAULT '0',
  `avg_response_time` float DEFAULT '0',
  `last_crawled` timestamp NULL DEFAULT NULL,
  `robots_txt` text,
  `sitemap_urls` json DEFAULT NULL,
  `rate_limited_count` int DEFAULT '0',
  `last_rate_limit` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mega_crawler_queue`
--

CREATE TABLE `mega_crawler_queue` (
  `id` bigint NOT NULL,
  `process_id` varchar(100) NOT NULL,
  `url_hash` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `domain` varchar(255) NOT NULL,
  `depth` int DEFAULT '0',
  `priority` int DEFAULT '5',
  `phase` int DEFAULT '1',
  `status` enum('pending','processing','completed','failed','retry') DEFAULT 'pending',
  `attempts` int DEFAULT '0',
  `last_attempt` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `processed_at` timestamp NULL DEFAULT NULL,
  `response_time` float DEFAULT NULL,
  `http_status` int DEFAULT NULL,
  `content_length` int DEFAULT NULL,
  `error_message` text,
  `robots_allowed` tinyint DEFAULT '1',
  `relevance_score` float DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `mega_crawler_results`
--

CREATE TABLE `mega_crawler_results` (
  `id` bigint NOT NULL,
  `process_id` varchar(100) NOT NULL,
  `url_hash` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `canonical_url` text,
  `title` varchar(1000) DEFAULT NULL,
  `description` text,
  `content` longtext,
  `content_hash` varchar(64) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `language` varchar(10) DEFAULT 'en',
  `word_count` int DEFAULT '0',
  `images_count` int DEFAULT '0',
  `links_count` int DEFAULT '0',
  `quality_score` decimal(4,3) DEFAULT '0.000',
  `relevance_score` decimal(4,3) DEFAULT '0.000',
  `thumbnail_url` text,
  `favicon_url` text,
  `embed_code` text,
  `author` varchar(255) DEFAULT NULL,
  `pub_date` timestamp NULL DEFAULT NULL,
  `meta_keywords` text,
  `meta_robots` varchar(500) DEFAULT NULL,
  `social_shares` int DEFAULT '0',
  `crawled_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `messages`
--

CREATE TABLE `messages` (
  `id` int UNSIGNED NOT NULL,
  `sender_id` int UNSIGNED NOT NULL,
  `recipient_id` int UNSIGNED NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `media_url` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `media_type` enum('image','video','file') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_status` tinyint(1) DEFAULT '0',
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` json NOT NULL,
  `is_read` tinyint(1) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `notifications_x`
--

CREATE TABLE `notifications_x` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci,
  `data` json DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `numbers`
--

CREATE TABLE `numbers` (
  `n` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payments_x`
--

CREATE TABLE `payments_x` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `subscription_id` int DEFAULT NULL,
  `stripe_payment_intent_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` int NOT NULL,
  `currency` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT 'USD',
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `metadata` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `pinfeeds`
--

CREATE TABLE `pinfeeds` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `title` varchar(1500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `category` int DEFAULT NULL,
  `tags` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `thumbnail` varchar(4096) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website_source` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upload_date` datetime DEFAULT NULL,
  `user_reactions` json DEFAULT NULL,
  `user_level` enum('basic','premium','admin') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'basic',
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `pubDate` datetime NOT NULL,
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `favicon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `embed` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `iframe` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `categories` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actors` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source_website` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `channel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `video_time` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `embed_code` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `source_domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `main_category_id` int DEFAULT NULL,
  `source_domain_id` int DEFAULT NULL,
  `title_cat_id` int DEFAULT '0',
  `description_cat_id` int DEFAULT '0',
  `tag_cat_id` int DEFAULT '0',
  `likes` int DEFAULT '0',
  `dislikes` int DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Triggers `pinfeeds`
--
DELIMITER $$
CREATE TRIGGER `after_pinfeeds_insert` AFTER INSERT ON `pinfeeds` FOR EACH ROW BEGIN
    DECLARE word VARCHAR(255);
    DECLARE i INT DEFAULT 1;
    DECLARE title_len INT;
    DECLARE description_len INT;

    -- Processa o título do novo registro
    SET title_len = LENGTH(NEW.title) - LENGTH(REPLACE(NEW.title, ' ', '')) + 1;
    WHILE i <= title_len DO
        SET word = TRIM(SUBSTRING_INDEX(SUBSTRING_INDEX(NEW.title, ' ', i), ' ', -1));
        IF word IS NOT NULL AND word <> '' THEN
            INSERT INTO title_description_index (feed_id, word, occurrence_count)
            VALUES (NEW.id, word, 1)
            ON DUPLICATE KEY UPDATE occurrence_count = occurrence_count + 1;
        END IF;
        SET i = i + 1;
    END WHILE;

    -- Processa a descrição do novo registro
    SET i = 1;
    SET description_len = LENGTH(NEW.description) - LENGTH(REPLACE(NEW.description, ' ', '')) + 1;
    WHILE i <= description_len DO
        SET word = TRIM(SUBSTRING_INDEX(SUBSTRING_INDEX(NEW.description, ' ', i), ' ', -1));
        IF word IS NOT NULL AND word <> '' THEN
            INSERT INTO title_description_index (feed_id, word, occurrence_count)
            VALUES (NEW.id, word, 1)
            ON DUPLICATE KEY UPDATE occurrence_count = occurrence_count + 1;
        END IF;
        SET i = i + 1;
    END WHILE;
END
$$
DELIMITER ;
DELIMITER $$
CREATE TRIGGER `after_pinfeeds_update` AFTER UPDATE ON `pinfeeds` FOR EACH ROW BEGIN
    -- Variáveis locais sem DECLARE
    SET @word = '';
    SET @i = 1;
    SET @title_len = LENGTH(NEW.title) - LENGTH(REPLACE(NEW.title, ' ', '')) + 1;
    SET @description_len = LENGTH(NEW.description) - LENGTH(REPLACE(NEW.description, ' ', '')) + 1;

    -- Processa o título atualizado, palavra por palavra
    WHILE @i <= @title_len DO
        SET @word = TRIM(SUBSTRING_INDEX(SUBSTRING_INDEX(NEW.title, ' ', @i), ' ', -1));
        IF @word IS NOT NULL AND @word <> '' THEN
            INSERT INTO title_description_index (feed_id, word, occurrence_count)
            VALUES (NEW.id, @word, 1)
            ON DUPLICATE KEY UPDATE occurrence_count = occurrence_count + 1;
        END IF;
        SET @i = @i + 1;
    END WHILE;

    -- Processa a descrição atualizada, palavra por palavra
    SET @i = 1;
    WHILE @i <= @description_len DO
        SET @word = TRIM(SUBSTRING_INDEX(SUBSTRING_INDEX(NEW.description, ' ', @i), ' ', -1));
        IF @word IS NOT NULL AND @word <> '' THEN
            INSERT INTO title_description_index (feed_id, word, occurrence_count)
            VALUES (NEW.id, @word, 1)
            ON DUPLICATE KEY UPDATE occurrence_count = occurrence_count + 1;
        END IF;
        SET @i = @i + 1;
    END WHILE;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `pinfeeds_compatible`
--

CREATE TABLE `pinfeeds_compatible` (
  `id` bigint NOT NULL,
  `url` text NOT NULL,
  `url_hash` varchar(64) NOT NULL,
  `title` varchar(500) DEFAULT NULL,
  `description` text,
  `content` longtext,
  `domain` varchar(255) DEFAULT NULL,
  `language` varchar(10) DEFAULT 'pt',
  `country` varchar(10) DEFAULT 'BR',
  `category` varchar(100) DEFAULT NULL,
  `tags` text,
  `author` varchar(255) DEFAULT NULL,
  `publish_date` timestamp NULL DEFAULT NULL,
  `crawled_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `last_updated` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `content_quality_score` decimal(3,2) DEFAULT '0.00',
  `social_shares` int DEFAULT '0',
  `backlinks_count` int DEFAULT '0',
  `word_count` int DEFAULT '0',
  `reading_time` int DEFAULT '0',
  `sentiment_score` decimal(3,2) DEFAULT '0.00',
  `keywords` text,
  `meta_keywords` text,
  `images_count` int DEFAULT '0',
  `videos_count` int DEFAULT '0',
  `external_links_count` int DEFAULT '0',
  `internal_links_count` int DEFAULT '0',
  `http_status` int DEFAULT '200',
  `response_time` decimal(8,3) DEFAULT '0.000',
  `content_hash` varchar(64) DEFAULT NULL,
  `duplicate_of` bigint DEFAULT NULL,
  `indexed_for_search` tinyint(1) DEFAULT '0',
  `featured_image` text,
  `amp_url` text,
  `canonical_url` text,
  `structured_data` json DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `polls`
--

CREATE TABLE `polls` (
  `poll_id` int NOT NULL,
  `feed_id` int NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` json NOT NULL,
  `allow_multiple` tinyint(1) DEFAULT '0',
  `end_date` timestamp NULL DEFAULT NULL,
  `total_votes` int DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `poll_options`
--

CREATE TABLE `poll_options` (
  `id` int NOT NULL,
  `poll_id` int NOT NULL,
  `option_text` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `option_order` tinyint NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `poll_votes`
--

CREATE TABLE `poll_votes` (
  `id` int NOT NULL,
  `option_id` int NOT NULL,
  `user_id` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `post_hashtags`
--

CREATE TABLE `post_hashtags` (
  `id` int UNSIGNED NOT NULL,
  `post_id` int UNSIGNED NOT NULL,
  `hashtag` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `post_reports`
--

CREATE TABLE `post_reports` (
  `id` int UNSIGNED NOT NULL,
  `post_id` int UNSIGNED NOT NULL,
  `reporter_id` int UNSIGNED NOT NULL,
  `reason` enum('spam','harassment','violence','hate_speech','misinformation','copyright','other') COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `status` enum('pending','reviewed','resolved','dismissed') COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `post_views`
--

CREATE TABLE `post_views` (
  `id` int UNSIGNED NOT NULL,
  `post_id` int UNSIGNED NOT NULL,
  `user_id` int UNSIGNED DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `viewed_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `professional_crawler_queue`
--

CREATE TABLE `professional_crawler_queue` (
  `id` bigint UNSIGNED NOT NULL,
  `url` text NOT NULL,
  `url_hash` varchar(64) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `phase` tinyint UNSIGNED DEFAULT '1',
  `depth` int DEFAULT '0',
  `priority` int DEFAULT '5',
  `search_terms` text,
  `relevance_score` decimal(8,2) DEFAULT '0.00',
  `status` enum('pending','processing','completed','failed','deferred') DEFAULT 'pending',
  `retry_count` tinyint DEFAULT '0',
  `last_attempt` timestamp NULL DEFAULT NULL,
  `scheduled_for` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `process_id` varchar(255) DEFAULT NULL,
  `worker_id` varchar(50) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `processed_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `profile_views`
--

CREATE TABLE `profile_views` (
  `id` int UNSIGNED NOT NULL,
  `profile_user_id` int UNSIGNED NOT NULL,
  `viewer_user_id` int UNSIGNED DEFAULT NULL,
  `view_count` int UNSIGNED DEFAULT '1',
  `last_viewed` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `viewed_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `push_subscriptions`
--

CREATE TABLE `push_subscriptions` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `endpoint` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `p256dh_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `auth_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `rate_limits_x`
--

CREATE TABLE `rate_limits_x` (
  `id` int NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `resource` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` int DEFAULT '1',
  `window_start` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `reactions`
--

CREATE TABLE `reactions` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `feed_id` int NOT NULL,
  `reaction_type` enum('like','dislike') COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `relevant_links`
--

CREATE TABLE `relevant_links` (
  `id` bigint UNSIGNED NOT NULL,
  `url_id` bigint UNSIGNED NOT NULL,
  `url` varchar(2048) NOT NULL,
  `normalized_url` varchar(2048) NOT NULL,
  `url_hash` char(32) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `title` varchar(512) DEFAULT NULL,
  `description` text,
  `author` varchar(255) DEFAULT NULL,
  `published_at` datetime DEFAULT NULL,
  `detected_type` enum('article','video','blog','news','forum','pdf','other') DEFAULT 'other',
  `language` varchar(12) DEFAULT NULL,
  `depth` int NOT NULL,
  `score` float NOT NULL DEFAULT '0',
  `og_title` varchar(512) DEFAULT NULL,
  `og_description` text,
  `og_type` varchar(128) DEFAULT NULL,
  `og_image` varchar(1024) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `robots_cache`
--

CREATE TABLE `robots_cache` (
  `id` bigint UNSIGNED NOT NULL,
  `host` varchar(255) NOT NULL,
  `user_agent` varchar(128) NOT NULL,
  `robots_txt` mediumtext,
  `fetched_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `etag` varchar(128) DEFAULT NULL,
  `last_modified` varchar(128) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `search_analytics`
--

CREATE TABLE `search_analytics` (
  `id` int UNSIGNED NOT NULL,
  `engine_id` int UNSIGNED NOT NULL,
  `query` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `results_count` int DEFAULT '0',
  `search_duration_ms` int DEFAULT '0',
  `user_id` int DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filters_used` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `search_boards`
--

CREATE TABLE `search_boards` (
  `id` int UNSIGNED NOT NULL,
  `engine_id` int UNSIGNED NOT NULL,
  `board_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `board_slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `board_type` enum('public','private','shared') COLLATE utf8mb4_unicode_ci DEFAULT 'public',
  `description` text COLLATE utf8mb4_unicode_ci,
  `cover_image` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `settings` json DEFAULT NULL,
  `position` int DEFAULT '0',
  `items_count` int DEFAULT '0',
  `views_count` int DEFAULT '0',
  `shares_count` int DEFAULT '0',
  `is_featured` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `search_index`
--

CREATE TABLE `search_index` (
  `id` int UNSIGNED NOT NULL,
  `engine_id` int UNSIGNED NOT NULL,
  `content_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_id` int NOT NULL,
  `title` varchar(1500) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `tags` json DEFAULT NULL,
  `metadata` json DEFAULT NULL,
  `relevance_score` decimal(5,2) DEFAULT '0.00',
  `click_count` int DEFAULT '0',
  `indexed_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `search_queue`
--

CREATE TABLE `search_queue` (
  `id` int NOT NULL,
  `search_term` varchar(500) DEFAULT NULL,
  `engine` varchar(50) DEFAULT NULL,
  `status` enum('pending','processing','completed') DEFAULT NULL,
  `priority` int DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `processed_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `security_logs`
--

CREATE TABLE `security_logs` (
  `id` int UNSIGNED NOT NULL,
  `event` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int UNSIGNED DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `details` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `seeds`
--

CREATE TABLE `seeds` (
  `id` bigint UNSIGNED NOT NULL,
  `url` varchar(2048) NOT NULL,
  `label` varchar(128) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `shares`
--

CREATE TABLE `shares` (
  `feed_id` int NOT NULL,
  `count` int NOT NULL DEFAULT '0',
  `last_share_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `share_stats`
--

CREATE TABLE `share_stats` (
  `id` int NOT NULL,
  `feed_id` int NOT NULL,
  `channel` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `count` int NOT NULL DEFAULT '0',
  `last_shared_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `shortlinks`
--

CREATE TABLE `shortlinks` (
  `id` int NOT NULL,
  `code` varchar(24) NOT NULL,
  `target_url` varchar(2048) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `simple_crawler_queue`
--

CREATE TABLE `simple_crawler_queue` (
  `id` int NOT NULL,
  `url` text NOT NULL,
  `status` enum('pending','processing','completed','failed') DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `processed_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `stream_gifts`
--

CREATE TABLE `stream_gifts` (
  `id` int UNSIGNED NOT NULL,
  `room_id` int UNSIGNED NOT NULL,
  `from_user_id` int NOT NULL,
  `to_user_id` int NOT NULL,
  `gift_id` int NOT NULL,
  `quantity` int DEFAULT '1',
  `coins_spent` int DEFAULT '0',
  `message` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `subscriptions_x`
--

CREATE TABLE `subscriptions_x` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `stripe_subscription_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_price_id` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `plan_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'free',
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `current_period_start` timestamp NULL DEFAULT NULL,
  `current_period_end` timestamp NULL DEFAULT NULL,
  `cancel_at_period_end` tinyint(1) DEFAULT '0',
  `canceled_at` timestamp NULL DEFAULT NULL,
  `trial_start` timestamp NULL DEFAULT NULL,
  `trial_end` timestamp NULL DEFAULT NULL,
  `metadata` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `title_description_index`
--

CREATE TABLE `title_description_index` (
  `id` int NOT NULL,
  `feed_id` int NOT NULL,
  `word` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `occurrence_count` int DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `title_description_index_2`
--

CREATE TABLE `title_description_index_2` (
  `id` bigint NOT NULL,
  `word_id` int NOT NULL,
  `feed_id` int NOT NULL,
  `occurrence_count` int DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ultra_crawler_domains`
--

CREATE TABLE `ultra_crawler_domains` (
  `id` bigint UNSIGNED NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_crawled` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `last_crawled` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `total_pages` int UNSIGNED DEFAULT '0',
  `successful_pages` int UNSIGNED DEFAULT '0',
  `failed_pages` int UNSIGNED DEFAULT '0',
  `avg_response_time` decimal(8,3) DEFAULT '0.000',
  `robots_txt_url` text COLLATE utf8mb4_unicode_ci,
  `sitemap_url` text COLLATE utf8mb4_unicode_ci,
  `crawl_delay` int UNSIGNED DEFAULT '1',
  `status` enum('active','rate_limited','blocked','error') COLLATE utf8mb4_unicode_ci DEFAULT 'active'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ultra_crawler_domain_configs`
--

CREATE TABLE `ultra_crawler_domain_configs` (
  `id` int NOT NULL,
  `domain` varchar(255) NOT NULL,
  `crawl_delay` float DEFAULT '1',
  `max_concurrent` int DEFAULT '5',
  `respect_robots` tinyint(1) DEFAULT '1',
  `follow_redirects` tinyint(1) DEFAULT '1',
  `extract_images` tinyint(1) DEFAULT '1',
  `extract_emails` tinyint(1) DEFAULT '1',
  `max_page_size` int DEFAULT '10485760',
  `allowed_content_types` text,
  `blocked_paths` text,
  `custom_headers` json DEFAULT NULL,
  `proxy_settings` json DEFAULT NULL,
  `last_updated` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ultra_crawler_domain_stats`
--

CREATE TABLE `ultra_crawler_domain_stats` (
  `id` bigint NOT NULL,
  `domain` varchar(255) NOT NULL,
  `date_crawled` date NOT NULL,
  `pages_crawled` int DEFAULT '0',
  `pages_successful` int DEFAULT '0',
  `pages_failed` int DEFAULT '0',
  `bytes_downloaded` bigint DEFAULT '0',
  `avg_response_time` decimal(8,3) DEFAULT '0.000',
  `unique_links_found` int DEFAULT '0',
  `unique_images_found` int DEFAULT '0',
  `unique_emails_found` int DEFAULT '0',
  `crawl_duration` int DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ultra_crawler_errors`
--

CREATE TABLE `ultra_crawler_errors` (
  `id` bigint UNSIGNED NOT NULL,
  `url_hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `error_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `error_message` text COLLATE utf8mb4_unicode_ci,
  `http_code` smallint UNSIGNED DEFAULT '0',
  `occurred_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ultra_crawler_images`
--

CREATE TABLE `ultra_crawler_images` (
  `id` bigint UNSIGNED NOT NULL,
  `source_url_hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image_url_hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt_text` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_text` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `width` int UNSIGNED DEFAULT '0',
  `height` int UNSIGNED DEFAULT '0',
  `file_size` int UNSIGNED DEFAULT '0',
  `discovered_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ultra_crawler_links`
--

CREATE TABLE `ultra_crawler_links` (
  `id` bigint UNSIGNED NOT NULL,
  `source_url_hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_url_hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `anchor_text` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_type` enum('internal','external') COLLATE utf8mb4_unicode_ci DEFAULT 'external',
  `discovered_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ultra_crawler_queue`
--

CREATE TABLE `ultra_crawler_queue` (
  `id` bigint UNSIGNED NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `url_hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `depth` tinyint UNSIGNED DEFAULT '0',
  `priority` tinyint UNSIGNED DEFAULT '5',
  `status` enum('pending','processing','completed','failed') COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `processed_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ultra_crawler_results`
--

CREATE TABLE `ultra_crawler_results` (
  `id` bigint UNSIGNED NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `url_hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `meta_keywords` text COLLATE utf8mb4_unicode_ci,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `http_code` smallint UNSIGNED DEFAULT '0',
  `response_time` decimal(8,3) DEFAULT '0.000',
  `content_length` int UNSIGNED DEFAULT '0',
  `content_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `last_modified` timestamp NULL DEFAULT NULL,
  `crawled_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ultra_crawler_seeds`
--

CREATE TABLE `ultra_crawler_seeds` (
  `id` int NOT NULL,
  `seed_type` enum('url','domain','keyword','sitemap') NOT NULL,
  `seed_value` text NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `max_depth` int DEFAULT '10',
  `max_pages` int DEFAULT '100000',
  `crawl_frequency` int DEFAULT '3600',
  `last_crawled` timestamp NULL DEFAULT NULL,
  `next_crawl` timestamp NULL DEFAULT NULL,
  `status` enum('active','paused','completed','error') DEFAULT 'active',
  `priority` int DEFAULT '5',
  `notes` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ultra_crawler_settings`
--

CREATE TABLE `ultra_crawler_settings` (
  `id` int UNSIGNED NOT NULL,
  `setting_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `setting_value` text COLLATE utf8mb4_unicode_ci,
  `setting_type` enum('string','integer','boolean','json') COLLATE utf8mb4_unicode_ci DEFAULT 'string',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ultra_crawler_smart_queue`
--

CREATE TABLE `ultra_crawler_smart_queue` (
  `id` bigint NOT NULL,
  `url_hash` varchar(64) NOT NULL,
  `url` text NOT NULL,
  `domain` varchar(255) NOT NULL,
  `seed_id` int DEFAULT NULL,
  `depth` int DEFAULT '0',
  `priority` int DEFAULT '5',
  `estimated_importance` decimal(5,2) DEFAULT '0.00',
  `last_modified` timestamp NULL DEFAULT NULL,
  `content_type` varchar(100) DEFAULT NULL,
  `expected_size` int DEFAULT '0',
  `retry_count` int DEFAULT '0',
  `status` enum('pending','processing','completed','failed','blocked','rate_limited') DEFAULT 'pending',
  `scheduled_for` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `worker_id` varchar(50) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `processed_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ultra_crawler_stats`
--

CREATE TABLE `ultra_crawler_stats` (
  `id` bigint UNSIGNED NOT NULL,
  `stat_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stat_value` bigint UNSIGNED DEFAULT '0',
  `stat_data` json DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `uploaded_media`
--

CREATE TABLE `uploaded_media` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_size` int NOT NULL,
  `file_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `thumbnail_url` text COLLATE utf8mb4_unicode_ci,
  `upload_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'image',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `urls`
--

CREATE TABLE `urls` (
  `id` bigint UNSIGNED NOT NULL,
  `url` text NOT NULL,
  `normalized_url` text NOT NULL,
  `url_hash` char(32) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `depth` int NOT NULL DEFAULT '0',
  `priority` tinyint NOT NULL DEFAULT '5',
  `source` varchar(32) NOT NULL DEFAULT 'seed',
  `seed_id` bigint UNSIGNED DEFAULT NULL,
  `discoverer_url_id` bigint UNSIGNED DEFAULT NULL,
  `crawl_status` enum('new','queued','fetching','fetched','failed','skipped') NOT NULL DEFAULT 'new',
  `attempts` int NOT NULL DEFAULT '0',
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `last_crawled_at` timestamp NULL DEFAULT NULL,
  `last_status_code` int DEFAULT NULL,
  `content_type` varchar(255) DEFAULT NULL,
  `is_relevant` tinyint(1) NOT NULL DEFAULT '0',
  `relevant_score` float NOT NULL DEFAULT '0',
  `canonical_url` varchar(2048) DEFAULT NULL,
  `error` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `urls_master`
--

CREATE TABLE `urls_master` (
  `url_hash` char(64) NOT NULL,
  `url` text NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `subdomain` varchar(255) DEFAULT NULL,
  `path` text,
  `protocol` varchar(10) DEFAULT NULL,
  `port` int DEFAULT NULL,
  `depth` int DEFAULT '0',
  `parent_hash` char(64) DEFAULT NULL,
  `node_id` varchar(36) DEFAULT NULL,
  `status` enum('discovered','queued','processing','completed','failed') DEFAULT 'discovered',
  `priority` int DEFAULT '0',
  `relevance_score` float DEFAULT '0',
  `content_hash` char(64) DEFAULT NULL,
  `response_code` int DEFAULT NULL,
  `content_type` varchar(100) DEFAULT NULL,
  `content_length` bigint DEFAULT NULL,
  `crawl_timestamp` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `url_hashes`
--

CREATE TABLE `url_hashes` (
  `id` bigint NOT NULL,
  `url_hash` varchar(64) DEFAULT NULL,
  `url` text,
  `content_hash` varchar(64) DEFAULT NULL,
  `last_checked` datetime DEFAULT NULL,
  `status` enum('active','dead','redirect') DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `url_tags`
--

CREATE TABLE `url_tags` (
  `id` bigint NOT NULL,
  `url_hash` char(64) DEFAULT NULL,
  `tag` varchar(100) DEFAULT NULL,
  `confidence` float DEFAULT '1',
  `auto_generated` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_badges`
--

CREATE TABLE `user_badges` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `badge_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `badge_data` json DEFAULT NULL,
  `awarded_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `awarded_by` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_blocks`
--

CREATE TABLE `user_blocks` (
  `id` int UNSIGNED NOT NULL,
  `blocker_id` int UNSIGNED NOT NULL,
  `blocked_id` int UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_collections`
--

CREATE TABLE `user_collections` (
  `id` int UNSIGNED NOT NULL,
  `user_id` int UNSIGNED NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `is_public` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_follows`
--

CREATE TABLE `user_follows` (
  `id` int NOT NULL,
  `follower_id` int NOT NULL,
  `following_id` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_hidden_posts`
--

CREATE TABLE `user_hidden_posts` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `feed_id` int NOT NULL,
  `hidden_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_myhashtag`
--

CREATE TABLE `user_myhashtag` (
  `ID` int NOT NULL,
  `username` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified` tinyint(1) DEFAULT '0',
  `senha` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_verified` tinyint(1) DEFAULT '0',
  `two_factor_auth` tinyint(1) DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `birthdate` date DEFAULT NULL,
  `profile_picture` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bio` mediumtext COLLATE utf8mb4_unicode_ci,
  `profile_completion` int DEFAULT '0',
  `favorite_tags` mediumtext COLLATE utf8mb4_unicode_ci,
  `cover_photo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'active',
  `account_plan` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'basic',
  `account_restrictions` mediumtext COLLATE utf8mb4_unicode_ci,
  `user_role` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT 'user',
  `privacy_settings` mediumtext COLLATE utf8mb4_unicode_ci,
  `social_links` mediumtext COLLATE utf8mb4_unicode_ci,
  `preferences` mediumtext COLLATE utf8mb4_unicode_ci,
  `blocked_users` mediumtext COLLATE utf8mb4_unicode_ci,
  `notifications` mediumtext COLLATE utf8mb4_unicode_ci,
  `custom_notifications` mediumtext COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  `online_status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT 'offline',
  `login_history` mediumtext COLLATE utf8mb4_unicode_ci,
  `report_count` int DEFAULT '0',
  `profile_views` int DEFAULT '0',
  `link_shares` int DEFAULT '0',
  `engagement_score` int DEFAULT '0',
  `recent_activity` mediumtext COLLATE utf8mb4_unicode_ci,
  `verification_documents` mediumtext COLLATE utf8mb4_unicode_ci,
  `account_flags` mediumtext COLLATE utf8mb4_unicode_ci,
  `timezone` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `points` int DEFAULT '0',
  `badges` mediumtext COLLATE utf8mb4_unicode_ci,
  `groups_joined` mediumtext COLLATE utf8mb4_unicode_ci,
  `account_reputation` int DEFAULT '0',
  `linked_accounts` mediumtext COLLATE utf8mb4_unicode_ci,
  `search_history` mediumtext COLLATE utf8mb4_unicode_ci,
  `saved_links` mediumtext COLLATE utf8mb4_unicode_ci,
  `device_info` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser_info` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `session_count` int DEFAULT '0',
  `failed_login_attempts` int DEFAULT '0',
  `custom_css` mediumtext COLLATE utf8mb4_unicode_ci,
  `email_subscription` tinyint(1) DEFAULT '0',
  `marketing_preferences` mediumtext COLLATE utf8mb4_unicode_ci,
  `content_preferences` mediumtext COLLATE utf8mb4_unicode_ci,
  `inbox_message_count` int DEFAULT '0',
  `sent_message_count` int DEFAULT '0',
  `draft_message_count` int DEFAULT '0',
  `deleted_message_count` int DEFAULT '0',
  `notes` mediumtext COLLATE utf8mb4_unicode_ci,
  `total_records` int DEFAULT '0',
  `follower_count` int DEFAULT '0',
  `following_count` int DEFAULT '0',
  `link_count` int DEFAULT '0',
  `comment_count` int DEFAULT '0',
  `verified` tinyint(1) DEFAULT '0',
  `last_online` timestamp NULL DEFAULT NULL,
  `notification_settings` json DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_points`
--

CREATE TABLE `user_points` (
  `id` int UNSIGNED NOT NULL,
  `user_id` int UNSIGNED NOT NULL,
  `points` int NOT NULL DEFAULT '0',
  `reason` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_saves`
--

CREATE TABLE `user_saves` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `feed_id` int NOT NULL,
  `saved_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_search_engines`
--

CREATE TABLE `user_search_engines` (
  `id` int UNSIGNED NOT NULL,
  `user_id` int DEFAULT NULL,
  `anonymous_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `engine_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `engine_slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_public` tinyint(1) DEFAULT '1',
  `theme_settings` json DEFAULT NULL,
  `search_algorithms` json DEFAULT NULL,
  `custom_filters` json DEFAULT NULL,
  `indexed_items_count` int DEFAULT '0',
  `last_indexed_at` datetime DEFAULT NULL,
  `settings` json DEFAULT NULL,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `meta_keywords` json DEFAULT NULL,
  `analytics_enabled` tinyint(1) DEFAULT '1',
  `federation_enabled` tinyint(1) DEFAULT '1',
  `api_key` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `api_secret` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max_boards` int DEFAULT '20',
  `max_items_per_board` int DEFAULT '1000',
  `storage_used` bigint DEFAULT '0',
  `storage_limit` bigint DEFAULT '1073741824',
  `last_activity_at` datetime DEFAULT NULL,
  `popularity_score` decimal(5,2) DEFAULT '0.00',
  `quality_score` decimal(5,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_search_history`
--

CREATE TABLE `user_search_history` (
  `id` int UNSIGNED NOT NULL,
  `user_id` int UNSIGNED NOT NULL,
  `search_term` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `search_count` int UNSIGNED DEFAULT '1',
  `last_searched` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_sessions`
--

CREATE TABLE `user_sessions` (
  `id` int UNSIGNED NOT NULL,
  `user_id` int UNSIGNED NOT NULL,
  `remember_token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expires_at` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `user_sessions_x`
--

CREATE TABLE `user_sessions_x` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `session_token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `device_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `os` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` json DEFAULT NULL,
  `last_activity` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `video_rooms`
--

CREATE TABLE `video_rooms` (
  `id` int UNSIGNED NOT NULL,
  `room_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `room_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `host_user_id` int DEFAULT NULL,
  `room_type` enum('public','private','premium') COLLATE utf8mb4_unicode_ci DEFAULT 'public',
  `max_participants` int DEFAULT '100',
  `current_participants` int DEFAULT '0',
  `is_recording` tinyint(1) DEFAULT '0',
  `stream_key` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `settings` json DEFAULT NULL,
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `words`
--

CREATE TABLE `words` (
  `id` int NOT NULL,
  `phrase` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `occurrence_count` int DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `xwc_errors`
--

CREATE TABLE `xwc_errors` (
  `id` bigint NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci,
  `http_status` int DEFAULT NULL,
  `occurred_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `xwc_hosts`
--

CREATE TABLE `xwc_hosts` (
  `host` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `robots_txt` mediumtext COLLATE utf8mb4_unicode_ci,
  `robots_fetched_at` datetime DEFAULT NULL,
  `crawl_delay_seconds` int DEFAULT '1',
  `last_fetch_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `xwc_pages`
--

CREATE TABLE `xwc_pages` (
  `id` bigint NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `canonical_url` text COLLATE utf8mb4_unicode_ci,
  `host` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `depth` int DEFAULT NULL,
  `http_status` int DEFAULT NULL,
  `content_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content_length` int DEFAULT NULL,
  `title` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fetched_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `xwc_queue`
--

CREATE TABLE `xwc_queue` (
  `id` bigint NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `url_hash` binary(32) NOT NULL,
  `host` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `depth` int NOT NULL DEFAULT '0',
  `priority` int NOT NULL DEFAULT '0',
  `next_allowed_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `enqueued_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `xwc_relevant_links`
--

CREATE TABLE `xwc_relevant_links` (
  `id` bigint NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `url_hash` binary(32) NOT NULL,
  `source_url` text COLLATE utf8mb4_unicode_ci,
  `title` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `score` int NOT NULL,
  `reason` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discovered_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `xwc_seeds`
--

CREATE TABLE `xwc_seeds` (
  `id` bigint NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `depth_limit` int NOT NULL DEFAULT '4',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `xwc_seen`
--

CREATE TABLE `xwc_seen` (
  `url_hash` binary(32) NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `first_seen` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `xwc_settings`
--

CREATE TABLE `xwc_settings` (
  `skey` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `svalue` text COLLATE utf8mb4_unicode_ci,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `activity_logs`
--
ALTER TABLE `activity_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_action` (`action`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `ai_recommendations_x`
--
ALTER TABLE `ai_recommendations_x`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_ai_recommendations_user` (`user_id`,`created_at`),
  ADD KEY `idx_ai_recommendations_feed` (`feed_id`),
  ADD KEY `idx_ai_recommendations_expires` (`expires_at`);

--
-- Indexes for table `analytics_events_x`
--
ALTER TABLE `analytics_events_x`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_analytics_events_user` (`user_id`),
  ADD KEY `idx_analytics_events_type` (`event_type`,`created_at`),
  ADD KEY `idx_analytics_events_created` (`created_at`);

--
-- Indexes for table `api_idempotency_x`
--
ALTER TABLE `api_idempotency_x`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_ep_key` (`endpoint`,`key_hash`);

--
-- Indexes for table `api_keys_x`
--
ALTER TABLE `api_keys_x`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `key_hash` (`key_hash`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `blocked_ips`
--
ALTER TABLE `blocked_ips`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_ip` (`ip_address`);

--
-- Indexes for table `blocked_patterns`
--
ALTER TABLE `blocked_patterns`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `board_collaborators`
--
ALTER TABLE `board_collaborators`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_board_user` (`board_id`,`user_id`),
  ADD KEY `idx_user_id` (`user_id`);

--
-- Indexes for table `board_items`
--
ALTER TABLE `board_items`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_board_feed` (`board_id`,`feed_id`),
  ADD KEY `idx_board_id` (`board_id`),
  ADD KEY `idx_feed_id` (`feed_id`),
  ADD KEY `idx_position` (`position`),
  ADD KEY `idx_added_at` (`added_at`);

--
-- Indexes for table `cache_keys_x`
--
ALTER TABLE `cache_keys_x`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `cache_key` (`cache_key`),
  ADD KEY `idx_cache_keys_key` (`cache_key`),
  ADD KEY `idx_cache_keys_expires` (`expires_at`);

--
-- Indexes for table `chat_messages`
--
ALTER TABLE `chat_messages`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_room_created` (`room_id`,`created_at`),
  ADD KEY `idx_user_created` (`user_id`,`created_at`),
  ADD KEY `idx_reply_to` (`reply_to`);

--
-- Indexes for table `chat_participants`
--
ALTER TABLE `chat_participants`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_room_user` (`room_id`,`user_id`),
  ADD KEY `idx_user_joined` (`user_id`,`joined_at`),
  ADD KEY `idx_role` (`role`),
  ADD KEY `last_read_message_id` (`last_read_message_id`);

--
-- Indexes for table `chat_rooms`
--
ALTER TABLE `chat_rooms`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_feed_active` (`feed_id`,`is_active`),
  ADD KEY `idx_created_by` (`created_by`);

--
-- Indexes for table `comments`
--
ALTER TABLE `comments`
  ADD PRIMARY KEY (`comment_id`),
  ADD KEY `idx_comments_feed_id` (`feed_id`),
  ADD KEY `idx_comments_user_id` (`user_id`),
  ADD KEY `idx_comments_created_at` (`created_at`),
  ADD KEY `idx_feed_created` (`feed_id`,`created_at`),
  ADD KEY `idx_feed_parent` (`feed_id`,`parent_comment_id`),
  ADD KEY `idx_user_created` (`user_id`,`created_at`),
  ADD KEY `idx_pinned_created` (`is_pinned`,`created_at`),
  ADD KEY `idx_comments_feed_created` (`feed_id`,`created_at` DESC),
  ADD KEY `idx_comments_user_created` (`user_id`,`created_at` DESC),
  ADD KEY `idx_comments_parent_created` (`parent_comment_id`,`created_at`),
  ADD KEY `ix_comments_feed_created` (`feed_id`,`created_at`),
  ADD KEY `ix_comments_parent` (`parent_comment_id`),
  ADD KEY `ix_comments_user` (`user_id`),
  ADD KEY `ix_comments_feed_parent` (`feed_id`,`parent_comment_id`);

--
-- Indexes for table `comments_polls`
--
ALTER TABLE `comments_polls`
  ADD PRIMARY KEY (`poll_id`),
  ADD UNIQUE KEY `uq_comment` (`comment_id`),
  ADD UNIQUE KEY `uq_comments_polls_comment` (`comment_id`),
  ADD KEY `idx_cp_comment` (`comment_id`);

--
-- Indexes for table `comments_poll_options`
--
ALTER TABLE `comments_poll_options`
  ADD PRIMARY KEY (`option_id`),
  ADD KEY `idx_cpo_poll` (`poll_id`),
  ADD KEY `idx_poll` (`poll_id`);

--
-- Indexes for table `comments_poll_votes`
--
ALTER TABLE `comments_poll_votes`
  ADD PRIMARY KEY (`vote_id`),
  ADD UNIQUE KEY `uniq_poll_user` (`poll_id`,`user_id`),
  ADD UNIQUE KEY `uq_poll_user` (`poll_id`,`user_id`),
  ADD KEY `idx_cpv_poll` (`poll_id`),
  ADD KEY `idx_cpv_option` (`option_id`),
  ADD KEY `idx_opt_user` (`option_id`,`user_id`);

--
-- Indexes for table `comment_attachments`
--
ALTER TABLE `comment_attachments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_comment_created` (`comment_id`,`created_at`),
  ADD KEY `idx_file_type` (`file_type`),
  ADD KEY `idx_cid2` (`comment_id`);

--
-- Indexes for table `comment_edit_history`
--
ALTER TABLE `comment_edit_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_comment_created` (`comment_id`,`created_at`),
  ADD KEY `idx_edited_by` (`edited_by`);

--
-- Indexes for table `comment_flags`
--
ALTER TABLE `comment_flags`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_cf_comment` (`comment_id`),
  ADD KEY `ix_flags_comment` (`comment_id`),
  ADD KEY `ix_flags_created` (`created_at`);

--
-- Indexes for table `comment_mentions`
--
ALTER TABLE `comment_mentions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_comment_mention` (`comment_id`,`mentioned_user_id`),
  ADD KEY `idx_mentioned_user` (`mentioned_user_id`,`created_at`),
  ADD KEY `idx_mentioned_by` (`mentioned_by`),
  ADD KEY `idx_cid_m` (`comment_id`),
  ADD KEY `idx_mentioned` (`mentioned_user_id`);

--
-- Indexes for table `comment_polls`
--
ALTER TABLE `comment_polls`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_comment_poll` (`comment_id`),
  ADD KEY `idx_expires_at` (`expires_at`);

--
-- Indexes for table `comment_reactions`
--
ALTER TABLE `comment_reactions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_comment_reaction` (`comment_id`,`user_id`,`reaction`),
  ADD UNIQUE KEY `uq_comment_user_reaction` (`comment_id`,`user_id`,`reaction`),
  ADD KEY `idx_comment_reaction` (`comment_id`,`reaction`),
  ADD KEY `idx_user_reaction` (`user_id`,`reaction`),
  ADD KEY `idx_created_at` (`created_at`),
  ADD KEY `idx_cid` (`comment_id`),
  ADD KEY `idx_cid_user` (`comment_id`,`user_id`);

--
-- Indexes for table `comment_reports`
--
ALTER TABLE `comment_reports`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_comment_status` (`comment_id`,`status`),
  ADD KEY `idx_reporter_created` (`reporter_id`,`created_at`),
  ADD KEY `idx_status_created` (`status`,`created_at`),
  ADD KEY `reviewed_by` (`reviewed_by`),
  ADD KEY `idx_cid_r` (`comment_id`);

--
-- Indexes for table `content_categories`
--
ALTER TABLE `content_categories`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_title_id` (`title_id`),
  ADD KEY `idx_description_id` (`description_id`),
  ADD KEY `idx_tag_id` (`tag_id`),
  ADD KEY `idx_category_name` (`category_name`);

--
-- Indexes for table `crawler_cache`
--
ALTER TABLE `crawler_cache`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `cache_key` (`cache_key`),
  ADD KEY `idx_cache_key` (`cache_key`);

--
-- Indexes for table `crawler_domains`
--
ALTER TABLE `crawler_domains`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `domain` (`domain`),
  ADD KEY `idx_domain` (`domain`);

--
-- Indexes for table `crawler_domain_configs`
--
ALTER TABLE `crawler_domain_configs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_domain` (`domain`),
  ADD KEY `idx_last_crawled` (`last_crawled`),
  ADD KEY `idx_is_blocked` (`is_blocked`);

--
-- Indexes for table `crawler_domain_rules`
--
ALTER TABLE `crawler_domain_rules`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `domain` (`domain`),
  ADD KEY `idx_domain` (`domain`),
  ADD KEY `idx_status` (`status`);

--
-- Indexes for table `crawler_domain_stats`
--
ALTER TABLE `crawler_domain_stats`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_stats` (`process_id`(191),`domain`),
  ADD KEY `idx_process` (`process_id`(191)),
  ADD KEY `idx_domain` (`domain`);

--
-- Indexes for table `crawler_errors`
--
ALTER TABLE `crawler_errors`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_url_hash` (`url_hash`),
  ADD KEY `idx_domain` (`domain`),
  ADD KEY `idx_error_type` (`error_type`),
  ADD KEY `idx_occurred_at` (`occurred_at`),
  ADD KEY `idx_process_id` (`process_id`);

--
-- Indexes for table `crawler_error_log`
--
ALTER TABLE `crawler_error_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_process` (`process_id`(191)),
  ADD KEY `idx_error_type` (`error_type`),
  ADD KEY `idx_domain` (`domain`);

--
-- Indexes for table `crawler_error_logs`
--
ALTER TABLE `crawler_error_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_process` (`process_id`(191)),
  ADD KEY `idx_error_type` (`error_type`),
  ADD KEY `idx_http_code` (`http_code`);

--
-- Indexes for table `crawler_logs`
--
ALTER TABLE `crawler_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_process` (`process_id`),
  ADD KEY `idx_level` (`level`);

--
-- Indexes for table `crawler_metrics`
--
ALTER TABLE `crawler_metrics`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_metric_name` (`metric_name`),
  ADD KEY `idx_timestamp` (`timestamp`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `crawler_nodes`
--
ALTER TABLE `crawler_nodes`
  ADD PRIMARY KEY (`node_id`),
  ADD KEY `idx_status_load` (`status`,`current_load`);

--
-- Indexes for table `crawler_performance`
--
ALTER TABLE `crawler_performance`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_process_metric` (`process_id`,`metric_name`);

--
-- Indexes for table `crawler_processed`
--
ALTER TABLE `crawler_processed`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `url_hash` (`url_hash`),
  ADD KEY `url_hash_2` (`url_hash`);

--
-- Indexes for table `crawler_processes`
--
ALTER TABLE `crawler_processes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `process_id` (`process_id`),
  ADD KEY `idx_process` (`process_id`),
  ADD KEY `idx_status` (`status`);

--
-- Indexes for table `crawler_queue`
--
ALTER TABLE `crawler_queue`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_process_status` (`process_id`,`status`),
  ADD KEY `idx_priority` (`priority` DESC);

--
-- Indexes for table `crawler_robots_cache`
--
ALTER TABLE `crawler_robots_cache`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_domain` (`domain`),
  ADD KEY `idx_last_fetched` (`last_fetched`),
  ADD KEY `idx_expires_at` (`expires_at`);

--
-- Indexes for table `crawler_search_engines`
--
ALTER TABLE `crawler_search_engines`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_name` (`name`),
  ADD KEY `idx_enabled` (`enabled`),
  ADD KEY `idx_last_used` (`last_used`);

--
-- Indexes for table `crawler_seeds`
--
ALTER TABLE `crawler_seeds`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_seed_type` (`seed_type`),
  ADD KEY `idx_is_active` (`is_active`),
  ADD KEY `idx_priority` (`priority`);

--
-- Indexes for table `crawler_seen_links`
--
ALTER TABLE `crawler_seen_links`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_proc_link` (`process_id`(191),`link`(191)),
  ADD KEY `ix_process` (`process_id`(191));

--
-- Indexes for table `crawler_statistics`
--
ALTER TABLE `crawler_statistics`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_process` (`process_id`(191)),
  ADD KEY `idx_type` (`stat_type`),
  ADD KEY `idx_created` (`created_at`);

--
-- Indexes for table `crawler_stats`
--
ALTER TABLE `crawler_stats`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_date` (`date`,`hour`);

--
-- Indexes for table `crawl_metrics`
--
ALTER TABLE `crawl_metrics`
  ADD PRIMARY KEY (`metric_time`,`node_id`),
  ADD KEY `idx_node_time` (`node_id`,`metric_time`);

--
-- Indexes for table `crawl_queue_shard`
--
ALTER TABLE `crawl_queue_shard`
  ADD PRIMARY KEY (`shard_id`,`url_hash`),
  ADD KEY `idx_shard_schedule` (`shard_id`,`scheduled_time`,`priority` DESC),
  ADD KEY `idx_claimed` (`claimed_by`,`claimed_at`);

--
-- Indexes for table `domain_config`
--
ALTER TABLE `domain_config`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `host` (`host`),
  ADD KEY `idx_host` (`host`),
  ADD KEY `idx_is_enabled` (`is_enabled`);

--
-- Indexes for table `domain_index`
--
ALTER TABLE `domain_index`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_domain_feed` (`domain`,`feed_id`),
  ADD KEY `idx_domain` (`domain`);

--
-- Indexes for table `domain_policies`
--
ALTER TABLE `domain_policies`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `domain` (`domain`);

--
-- Indexes for table `favorites`
--
ALTER TABLE `favorites`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_favorites_feed_user` (`feed_id`,`user_id`),
  ADD KEY `idx_user_feed` (`user_id`,`feed_id`);

--
-- Indexes for table `feeds`
--
ALTER TABLE `feeds`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_created` (`user_id`,`created_at`),
  ADD KEY `idx_created_pinned` (`created_at`,`is_pinned`),
  ADD KEY `idx_is_deleted` (`is_deleted`);

--
-- Indexes for table `feed_comments`
--
ALTER TABLE `feed_comments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `feed_id` (`feed_id`),
  ADD KEY `parent_comment_id` (`parent_comment_id`),
  ADD KEY `username` (`username`);

--
-- Indexes for table `feed_comment_polls`
--
ALTER TABLE `feed_comment_polls`
  ADD PRIMARY KEY (`poll_id`),
  ADD KEY `comment_id` (`comment_id`);

--
-- Indexes for table `feed_comment_poll_options`
--
ALTER TABLE `feed_comment_poll_options`
  ADD PRIMARY KEY (`option_id`),
  ADD KEY `poll_id` (`poll_id`);

--
-- Indexes for table `feed_comment_poll_votes`
--
ALTER TABLE `feed_comment_poll_votes`
  ADD PRIMARY KEY (`vote_id`),
  ADD UNIQUE KEY `uniq_voter_poll` (`poll_id`,`voter_hash`),
  ADD KEY `poll_id` (`poll_id`),
  ADD KEY `option_id` (`option_id`);

--
-- Indexes for table `feed_data`
--
ALTER TABLE `feed_data`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_website_base` (`website_base`),
  ADD KEY `idx_main_category_id` (`main_category_id`),
  ADD KEY `idx_website_base` (`website_base`),
  ADD KEY `idx_is_active` (`is_active`);

--
-- Indexes for table `feed_hashtags`
--
ALTER TABLE `feed_hashtags`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_feed_hashtag` (`feed_id`,`hashtag`);

--
-- Indexes for table `feed_media`
--
ALTER TABLE `feed_media`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_feed_media` (`feed_id`,`sort_order`);

--
-- Indexes for table `feed_mentions`
--
ALTER TABLE `feed_mentions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_feed_mention` (`feed_id`,`mentioned_user_id`);

--
-- Indexes for table `feed_reactions`
--
ALTER TABLE `feed_reactions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_feed_reaction` (`feed_id`,`user_id`,`reaction_type`),
  ADD UNIQUE KEY `uq_feed_user` (`feed_id`,`user_id`),
  ADD KEY `idx_feed_reaction` (`feed_id`,`reaction_type`),
  ADD KEY `idx_user_reaction` (`user_id`,`reaction_type`),
  ADD KEY `ix_feed_reactions_feed` (`feed_id`);

--
-- Indexes for table `feed_reports`
--
ALTER TABLE `feed_reports`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_feed_report` (`feed_id`,`reporter_id`);

--
-- Indexes for table `feed_shares`
--
ALTER TABLE `feed_shares`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_feed_shared` (`feed_id`,`shared_at`),
  ADD KEY `idx_user_shared` (`user_id`,`shared_at`);

--
-- Indexes for table `feed_share_counters`
--
ALTER TABLE `feed_share_counters`
  ADD PRIMARY KEY (`feed_id`);

--
-- Indexes for table `feed_views`
--
ALTER TABLE `feed_views`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_feed_viewed` (`feed_id`,`viewed_at`),
  ADD KEY `idx_user_viewed` (`user_id`,`viewed_at`);

--
-- Indexes for table `fetch_log`
--
ALTER TABLE `fetch_log`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_fetch_url` (`url_id`);

--
-- Indexes for table `filter_rules`
--
ALTER TABLE `filter_rules`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_type_active` (`rule_type`,`is_active`);

--
-- Indexes for table `follows`
--
ALTER TABLE `follows`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_follow` (`user_id`,`follow_type`,`follow_value`),
  ADD KEY `idx_user_follow_type_value` (`user_id`,`follow_type`,`follow_value`);

--
-- Indexes for table `hashtags`
--
ALTER TABLE `hashtags`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_tag` (`tag`);

--
-- Indexes for table `hc_content`
--
ALTER TABLE `hc_content`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_url` (`url_id`),
  ADD KEY `idx_hash` (`content_hash`);
ALTER TABLE `hc_content` ADD FULLTEXT KEY `idx_fulltext` (`title`,`description`);

--
-- Indexes for table `hc_domains`
--
ALTER TABLE `hc_domains`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_domain` (`domain`),
  ADD KEY `idx_quality` (`quality_score`),
  ADD KEY `idx_blocked` (`blocked`);

--
-- Indexes for table `hc_imports`
--
ALTER TABLE `hc_imports`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_url` (`url_id`),
  ADD KEY `idx_status` (`status`);

--
-- Indexes for table `hc_patterns`
--
ALTER TABLE `hc_patterns`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_type_score` (`pattern_type`,`score`);

--
-- Indexes for table `hc_processes`
--
ALTER TABLE `hc_processes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_type` (`type`),
  ADD KEY `idx_parent` (`parent_id`);

--
-- Indexes for table `hc_stats`
--
ALTER TABLE `hc_stats`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_metric` (`metric_name`);

--
-- Indexes for table `hc_terms`
--
ALTER TABLE `hc_terms`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_term` (`term`),
  ADD KEY `idx_relevance` (`relevance_score`),
  ADD KEY `idx_frequency` (`frequency`);

--
-- Indexes for table `hc_trending`
--
ALTER TABLE `hc_trending`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_score` (`score`),
  ADD KEY `idx_discovered` (`discovered_at`);

--
-- Indexes for table `hc_urls`
--
ALTER TABLE `hc_urls`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_url_process` (`url_hash`,`process_id`),
  ADD KEY `idx_status_priority` (`status`,`priority`),
  ADD KEY `idx_process_status` (`process_id`,`status`),
  ADD KEY `idx_domain` (`domain`);

--
-- Indexes for table `likes_dislikes`
--
ALTER TABLE `likes_dislikes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `user_id` (`user_id`,`feed_id`),
  ADD KEY `idx_likes_dislikes_feed_user` (`feed_id`,`user_id`),
  ADD KEY `idx_user_feed` (`user_id`,`feed_id`),
  ADD KEY `idx_likes_dislikes_feed_action` (`feed_id`,`action`);

--
-- Indexes for table `link_graph`
--
ALTER TABLE `link_graph`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_edge` (`source_hash`,`target_hash`),
  ADD KEY `idx_source` (`source_hash`),
  ADD KEY `idx_target` (`target_hash`),
  ADD KEY `idx_type` (`link_type`);

--
-- Indexes for table `link_og_cache`
--
ALTER TABLE `link_og_cache`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `url_hash` (`url_hash`),
  ADD KEY `idx_fetched` (`fetched_at`);

--
-- Indexes for table `link_previews`
--
ALTER TABLE `link_previews`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_feed_link` (`feed_id`),
  ADD UNIQUE KEY `uq_url` (`url`(255));

--
-- Indexes for table `link_short`
--
ALTER TABLE `link_short`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `slug` (`slug`),
  ADD KEY `idx_slug` (`slug`);

--
-- Indexes for table `login_attempts`
--
ALTER TABLE `login_attempts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_identifier` (`identifier`),
  ADD KEY `idx_attempted_at` (`attempted_at`);

--
-- Indexes for table `mega_crawler_host_stats`
--
ALTER TABLE `mega_crawler_host_stats`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_proc_domain` (`process_id`,`domain`),
  ADD KEY `idx_updated` (`updated_at`);

--
-- Indexes for table `mega_crawler_queue`
--
ALTER TABLE `mega_crawler_queue`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_proc_url` (`process_id`,`url_hash`),
  ADD KEY `idx_status_phase` (`status`,`phase`,`priority`),
  ADD KEY `idx_domain_attempts` (`domain`,`attempts`),
  ADD KEY `idx_created` (`created_at`);

--
-- Indexes for table `mega_crawler_results`
--
ALTER TABLE `mega_crawler_results`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `idx_proc_url` (`process_id`,`url_hash`),
  ADD KEY `idx_quality` (`quality_score`),
  ADD KEY `idx_domain` (`domain`),
  ADD KEY `idx_crawled` (`crawled_at`);
ALTER TABLE `mega_crawler_results` ADD FULLTEXT KEY `idx_content` (`title`,`description`,`content`);

--
-- Indexes for table `messages`
--
ALTER TABLE `messages`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_sender_id` (`sender_id`),
  ADD KEY `idx_recipient_id` (`recipient_id`),
  ADD KEY `idx_created_at` (`created_at`),
  ADD KEY `idx_read_status` (`read_status`);

--
-- Indexes for table `notifications`
--
ALTER TABLE `notifications`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_read_created` (`user_id`,`is_read`,`created_at`),
  ADD KEY `idx_type_created` (`type`,`created_at`);

--
-- Indexes for table `notifications_x`
--
ALTER TABLE `notifications_x`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_notifications_user` (`user_id`,`created_at`),
  ADD KEY `idx_notifications_unread` (`user_id`,`read_at`);

--
-- Indexes for table `payments_x`
--
ALTER TABLE `payments_x`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `stripe_payment_intent_id` (`stripe_payment_intent_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `subscription_id` (`subscription_id`);

--
-- Indexes for table `pinfeeds`
--
ALTER TABLE `pinfeeds`
  ADD PRIMARY KEY (`id`),
  ADD KEY `category` (`category`),
  ADD KEY `slug` (`slug`),
  ADD KEY `idx_author` (`author`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_pinfeeds_id` (`id`),
  ADD KEY `idx_user_category_author` (`user_id`,`category`,`author`),
  ADD KEY `idx_pinfeeds_user_pubDate` (`user_id`,`pubDate`),
  ADD KEY `idx_main_category_pubdate` (`main_category_id`,`pubDate`),
  ADD KEY `idx_category_main_category` (`category`,`main_category_id`),
  ADD KEY `idx_link` (`link`(255)),
  ADD KEY `idx_source_domain` (`source_domain`),
  ADD KEY `idx_pubdate_id` (`pubDate` DESC,`id`),
  ADD KEY `idx_id_desc` (`id` DESC),
  ADD KEY `idx_source_domain_pubdate` (`source_domain`,`pubDate`),
  ADD KEY `idx_author_lower` ((lower(`author`)));
ALTER TABLE `pinfeeds` ADD FULLTEXT KEY `title` (`title`);
ALTER TABLE `pinfeeds` ADD FULLTEXT KEY `tags` (`tags`);
ALTER TABLE `pinfeeds` ADD FULLTEXT KEY `description` (`description`);

--
-- Indexes for table `pinfeeds_compatible`
--
ALTER TABLE `pinfeeds_compatible`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_url_hash` (`url_hash`),
  ADD KEY `idx_domain` (`domain`),
  ADD KEY `idx_crawled_date` (`crawled_date`),
  ADD KEY `idx_quality_score` (`content_quality_score`),
  ADD KEY `idx_category` (`category`),
  ADD KEY `idx_language` (`language`),
  ADD KEY `idx_duplicate_of` (`duplicate_of`);
ALTER TABLE `pinfeeds_compatible` ADD FULLTEXT KEY `ft_title_content` (`title`,`content`,`description`);

--
-- Indexes for table `polls`
--
ALTER TABLE `polls`
  ADD PRIMARY KEY (`poll_id`),
  ADD UNIQUE KEY `unique_feed_poll` (`feed_id`);

--
-- Indexes for table `poll_options`
--
ALTER TABLE `poll_options`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_poll_order` (`poll_id`,`option_order`);

--
-- Indexes for table `poll_votes`
--
ALTER TABLE `poll_votes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_option_vote` (`option_id`,`user_id`),
  ADD KEY `idx_user_created` (`user_id`,`created_at`),
  ADD KEY `idx_option_created` (`option_id`,`created_at`);

--
-- Indexes for table `post_hashtags`
--
ALTER TABLE `post_hashtags`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_post_hashtag` (`post_id`,`hashtag`),
  ADD KEY `idx_post_id` (`post_id`),
  ADD KEY `idx_hashtag` (`hashtag`);

--
-- Indexes for table `post_reports`
--
ALTER TABLE `post_reports`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_post_id` (`post_id`),
  ADD KEY `idx_reporter_id` (`reporter_id`),
  ADD KEY `idx_status` (`status`);

--
-- Indexes for table `post_views`
--
ALTER TABLE `post_views`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_post_user_view` (`post_id`,`user_id`),
  ADD KEY `idx_post_id` (`post_id`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_viewed_at` (`viewed_at`);

--
-- Indexes for table `professional_crawler_queue`
--
ALTER TABLE `professional_crawler_queue`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_url_hash` (`url_hash`),
  ADD KEY `idx_status_phase` (`status`,`phase`,`scheduled_for`),
  ADD KEY `idx_domain_status` (`domain`,`status`),
  ADD KEY `idx_priority_depth` (`priority`,`depth`),
  ADD KEY `idx_process_id` (`process_id`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `profile_views`
--
ALTER TABLE `profile_views`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_profile_view` (`profile_user_id`,`viewer_user_id`),
  ADD KEY `idx_profile_user_id` (`profile_user_id`),
  ADD KEY `idx_viewer_user_id` (`viewer_user_id`),
  ADD KEY `idx_viewed_at` (`viewed_at`);

--
-- Indexes for table `push_subscriptions`
--
ALTER TABLE `push_subscriptions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_endpoint` (`user_id`,`endpoint`(100)),
  ADD KEY `idx_user_active` (`user_id`,`is_active`);

--
-- Indexes for table `rate_limits_x`
--
ALTER TABLE `rate_limits_x`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_identifier_resource` (`identifier`,`resource`);

--
-- Indexes for table `reactions`
--
ALTER TABLE `reactions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_feed_reaction` (`user_id`,`feed_id`),
  ADD KEY `idx_feed_reaction` (`feed_id`,`reaction_type`),
  ADD KEY `idx_user_reactions` (`user_id`);

--
-- Indexes for table `relevant_links`
--
ALTER TABLE `relevant_links`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_rel_url_hash` (`url_hash`),
  ADD KEY `idx_domain` (`domain`),
  ADD KEY `fk_rel_url` (`url_id`);

--
-- Indexes for table `robots_cache`
--
ALTER TABLE `robots_cache`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_host_ua` (`host`,`user_agent`);

--
-- Indexes for table `search_analytics`
--
ALTER TABLE `search_analytics`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_engine_id` (`engine_id`),
  ADD KEY `idx_query` (`query`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `search_boards`
--
ALTER TABLE `search_boards`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_engine_board_slug` (`engine_id`,`board_slug`),
  ADD KEY `idx_engine_id` (`engine_id`),
  ADD KEY `idx_board_slug` (`board_slug`),
  ADD KEY `idx_board_type` (`board_type`),
  ADD KEY `idx_position` (`position`);

--
-- Indexes for table `search_index`
--
ALTER TABLE `search_index`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_engine_id` (`engine_id`),
  ADD KEY `idx_content_type_id` (`content_type`,`content_id`),
  ADD KEY `idx_relevance` (`relevance_score`),
  ADD KEY `idx_indexed_at` (`indexed_at`);
ALTER TABLE `search_index` ADD FULLTEXT KEY `ft_title_description` (`title`,`description`);

--
-- Indexes for table `search_queue`
--
ALTER TABLE `search_queue`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_status` (`status`,`priority`);

--
-- Indexes for table `security_logs`
--
ALTER TABLE `security_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_event` (`event`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_ip_address` (`ip_address`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `seeds`
--
ALTER TABLE `seeds`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_seed_url` (`url`(255));

--
-- Indexes for table `shares`
--
ALTER TABLE `shares`
  ADD PRIMARY KEY (`feed_id`);

--
-- Indexes for table `share_stats`
--
ALTER TABLE `share_stats`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_feed_channel` (`feed_id`,`channel`),
  ADD KEY `idx_feed` (`feed_id`);

--
-- Indexes for table `shortlinks`
--
ALTER TABLE `shortlinks`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `code` (`code`);

--
-- Indexes for table `simple_crawler_queue`
--
ALTER TABLE `simple_crawler_queue`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `stream_gifts`
--
ALTER TABLE `stream_gifts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_room_id` (`room_id`),
  ADD KEY `idx_from_user` (`from_user_id`),
  ADD KEY `idx_to_user` (`to_user_id`),
  ADD KEY `idx_created_at` (`created_at`);

--
-- Indexes for table `subscriptions_x`
--
ALTER TABLE `subscriptions_x`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `stripe_subscription_id` (`stripe_subscription_id`),
  ADD KEY `idx_subscriptions_user` (`user_id`),
  ADD KEY `idx_subscriptions_stripe` (`stripe_subscription_id`),
  ADD KEY `idx_subscriptions_status` (`status`);

--
-- Indexes for table `title_description_index`
--
ALTER TABLE `title_description_index`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_feed_word` (`feed_id`,`word`),
  ADD KEY `idx_word` (`word`),
  ADD KEY `idx_word_feed` (`word`,`feed_id`);
ALTER TABLE `title_description_index` ADD FULLTEXT KEY `word` (`word`);

--
-- Indexes for table `title_description_index_2`
--
ALTER TABLE `title_description_index_2`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_word_feed` (`word_id`,`feed_id`);

--
-- Indexes for table `ultra_crawler_domains`
--
ALTER TABLE `ultra_crawler_domains`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_domain` (`domain`),
  ADD KEY `idx_last_crawled` (`last_crawled`),
  ADD KEY `idx_status` (`status`);

--
-- Indexes for table `ultra_crawler_domain_configs`
--
ALTER TABLE `ultra_crawler_domain_configs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_domain` (`domain`);

--
-- Indexes for table `ultra_crawler_domain_stats`
--
ALTER TABLE `ultra_crawler_domain_stats`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_domain_date` (`domain`,`date_crawled`),
  ADD KEY `idx_domain` (`domain`),
  ADD KEY `idx_date` (`date_crawled`);

--
-- Indexes for table `ultra_crawler_errors`
--
ALTER TABLE `ultra_crawler_errors`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_url_hash` (`url_hash`),
  ADD KEY `idx_error_type` (`error_type`),
  ADD KEY `idx_occurred` (`occurred_at`);

--
-- Indexes for table `ultra_crawler_images`
--
ALTER TABLE `ultra_crawler_images`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_source` (`source_url_hash`),
  ADD KEY `idx_discovered` (`discovered_at`);

--
-- Indexes for table `ultra_crawler_links`
--
ALTER TABLE `ultra_crawler_links`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_source` (`source_url_hash`),
  ADD KEY `idx_target` (`target_url_hash`),
  ADD KEY `idx_discovered` (`discovered_at`);

--
-- Indexes for table `ultra_crawler_queue`
--
ALTER TABLE `ultra_crawler_queue`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_url_hash` (`url_hash`),
  ADD KEY `idx_status_priority` (`status`,`priority`),
  ADD KEY `idx_domain` (`domain`),
  ADD KEY `idx_created` (`created_at`);

--
-- Indexes for table `ultra_crawler_results`
--
ALTER TABLE `ultra_crawler_results`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_url_hash` (`url_hash`),
  ADD KEY `idx_domain_crawled` (`domain`,`crawled_at`),
  ADD KEY `idx_http_code` (`http_code`),
  ADD KEY `idx_crawled_at` (`crawled_at`);
ALTER TABLE `ultra_crawler_results` ADD FULLTEXT KEY `ft_title_content` (`title`,`content`);

--
-- Indexes for table `ultra_crawler_seeds`
--
ALTER TABLE `ultra_crawler_seeds`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_domain` (`domain`),
  ADD KEY `idx_status` (`status`),
  ADD KEY `idx_next_crawl` (`next_crawl`);

--
-- Indexes for table `ultra_crawler_settings`
--
ALTER TABLE `ultra_crawler_settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_setting_key` (`setting_key`);

--
-- Indexes for table `ultra_crawler_smart_queue`
--
ALTER TABLE `ultra_crawler_smart_queue`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_url_hash` (`url_hash`),
  ADD KEY `idx_status_priority` (`status`,`priority`,`scheduled_for`),
  ADD KEY `idx_domain_status` (`domain`,`status`),
  ADD KEY `idx_seed_id` (`seed_id`),
  ADD KEY `idx_scheduled` (`scheduled_for`);

--
-- Indexes for table `ultra_crawler_stats`
--
ALTER TABLE `ultra_crawler_stats`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_stat_name` (`stat_name`),
  ADD KEY `idx_updated` (`updated_at`);

--
-- Indexes for table `uploaded_media`
--
ALTER TABLE `uploaded_media`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_created` (`user_id`,`created_at`);

--
-- Indexes for table `urls`
--
ALTER TABLE `urls`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_url_hash` (`url_hash`),
  ADD KEY `idx_domain` (`domain`),
  ADD KEY `idx_status` (`crawl_status`),
  ADD KEY `idx_scheduled` (`scheduled_at`);

--
-- Indexes for table `urls_master`
--
ALTER TABLE `urls_master`
  ADD PRIMARY KEY (`url_hash`),
  ADD KEY `idx_domain` (`domain`,`subdomain`),
  ADD KEY `idx_status_priority` (`status`,`priority` DESC),
  ADD KEY `idx_parent` (`parent_hash`),
  ADD KEY `idx_node` (`node_id`),
  ADD KEY `idx_crawl_time` (`crawl_timestamp`);

--
-- Indexes for table `url_hashes`
--
ALTER TABLE `url_hashes`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `url_hash` (`url_hash`),
  ADD KEY `idx_hash` (`url_hash`);

--
-- Indexes for table `url_tags`
--
ALTER TABLE `url_tags`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_url_tag` (`url_hash`,`tag`),
  ADD KEY `idx_url` (`url_hash`),
  ADD KEY `idx_tag` (`tag`);

--
-- Indexes for table `user_badges`
--
ALTER TABLE `user_badges`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_badge` (`user_id`,`badge_type`),
  ADD KEY `idx_badge_type` (`badge_type`),
  ADD KEY `idx_awarded_at` (`awarded_at`),
  ADD KEY `awarded_by` (`awarded_by`);

--
-- Indexes for table `user_blocks`
--
ALTER TABLE `user_blocks`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_block` (`blocker_id`,`blocked_id`),
  ADD KEY `idx_blocker_id` (`blocker_id`),
  ADD KEY `idx_blocked_id` (`blocked_id`);

--
-- Indexes for table `user_collections`
--
ALTER TABLE `user_collections`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_collection` (`user_id`,`name`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_name` (`name`);

--
-- Indexes for table `user_follows`
--
ALTER TABLE `user_follows`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_follow` (`follower_id`,`following_id`),
  ADD UNIQUE KEY `uq_user_user` (`follower_id`,`following_id`),
  ADD KEY `ix_followers` (`following_id`),
  ADD KEY `ix_following` (`follower_id`);

--
-- Indexes for table `user_hidden_posts`
--
ALTER TABLE `user_hidden_posts`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_hidden_post` (`user_id`,`feed_id`);

--
-- Indexes for table `user_myhashtag`
--
ALTER TABLE `user_myhashtag`
  ADD PRIMARY KEY (`ID`),
  ADD UNIQUE KEY `email` (`email`),
  ADD UNIQUE KEY `username` (`username`),
  ADD KEY `idx_user_myhashtag_ID` (`ID`);

--
-- Indexes for table `user_points`
--
ALTER TABLE `user_points`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_reason` (`reason`);

--
-- Indexes for table `user_saves`
--
ALTER TABLE `user_saves`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_feed_save` (`user_id`,`feed_id`),
  ADD UNIQUE KEY `uq_user_feed` (`user_id`,`feed_id`),
  ADD KEY `idx_user_saved` (`user_id`,`saved_at`),
  ADD KEY `ix_saves_user` (`user_id`),
  ADD KEY `ix_saves_feed` (`feed_id`);

--
-- Indexes for table `user_search_engines`
--
ALTER TABLE `user_search_engines`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_engine_slug` (`engine_slug`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_anonymous_id` (`anonymous_id`),
  ADD KEY `idx_is_public` (`is_public`),
  ADD KEY `idx_popularity` (`popularity_score`);

--
-- Indexes for table `user_search_history`
--
ALTER TABLE `user_search_history`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_user_search` (`user_id`,`search_term`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_search_term` (`search_term`),
  ADD KEY `idx_last_searched` (`last_searched`);

--
-- Indexes for table `user_sessions`
--
ALTER TABLE `user_sessions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_user_id` (`user_id`),
  ADD KEY `idx_token` (`remember_token`),
  ADD KEY `idx_expires` (`expires_at`);

--
-- Indexes for table `user_sessions_x`
--
ALTER TABLE `user_sessions_x`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `session_token` (`session_token`),
  ADD KEY `idx_user_sessions_user` (`user_id`),
  ADD KEY `idx_user_sessions_token` (`session_token`),
  ADD KEY `idx_user_sessions_activity` (`last_activity`),
  ADD KEY `idx_user_sessions_expires` (`expires_at`);

--
-- Indexes for table `video_rooms`
--
ALTER TABLE `video_rooms`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `room_code` (`room_code`),
  ADD KEY `idx_room_code` (`room_code`),
  ADD KEY `idx_host_user_id` (`host_user_id`),
  ADD KEY `idx_room_type` (`room_type`),
  ADD KEY `idx_started_at` (`started_at`);

--
-- Indexes for table `words`
--
ALTER TABLE `words`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_phrase` (`phrase`(255));

--
-- Indexes for table `xwc_errors`
--
ALTER TABLE `xwc_errors`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `xwc_hosts`
--
ALTER TABLE `xwc_hosts`
  ADD PRIMARY KEY (`host`);

--
-- Indexes for table `xwc_pages`
--
ALTER TABLE `xwc_pages`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_pages_host` (`host`);

--
-- Indexes for table `xwc_queue`
--
ALTER TABLE `xwc_queue`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_hash` (`url_hash`),
  ADD KEY `idx_host_next` (`host`,`next_allowed_at`),
  ADD KEY `idx_priority` (`priority`,`enqueued_at`);

--
-- Indexes for table `xwc_relevant_links`
--
ALTER TABLE `xwc_relevant_links`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_rel_hash` (`url_hash`);
ALTER TABLE `xwc_relevant_links` ADD FULLTEXT KEY `ft_title_desc` (`title`,`description`);

--
-- Indexes for table `xwc_seeds`
--
ALTER TABLE `xwc_seeds`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `xwc_seen`
--
ALTER TABLE `xwc_seen`
  ADD PRIMARY KEY (`url_hash`);

--
-- Indexes for table `xwc_settings`
--
ALTER TABLE `xwc_settings`
  ADD PRIMARY KEY (`skey`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `activity_logs`
--
ALTER TABLE `activity_logs`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ai_recommendations_x`
--
ALTER TABLE `ai_recommendations_x`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `analytics_events_x`
--
ALTER TABLE `analytics_events_x`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `api_idempotency_x`
--
ALTER TABLE `api_idempotency_x`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `api_keys_x`
--
ALTER TABLE `api_keys_x`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `blocked_ips`
--
ALTER TABLE `blocked_ips`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `blocked_patterns`
--
ALTER TABLE `blocked_patterns`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `board_collaborators`
--
ALTER TABLE `board_collaborators`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `board_items`
--
ALTER TABLE `board_items`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `cache_keys_x`
--
ALTER TABLE `cache_keys_x`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `chat_messages`
--
ALTER TABLE `chat_messages`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `chat_participants`
--
ALTER TABLE `chat_participants`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `chat_rooms`
--
ALTER TABLE `chat_rooms`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `comments`
--
ALTER TABLE `comments`
  MODIFY `comment_id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `comments_polls`
--
ALTER TABLE `comments_polls`
  MODIFY `poll_id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `comments_poll_options`
--
ALTER TABLE `comments_poll_options`
  MODIFY `option_id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `comments_poll_votes`
--
ALTER TABLE `comments_poll_votes`
  MODIFY `vote_id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `comment_attachments`
--
ALTER TABLE `comment_attachments`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `comment_edit_history`
--
ALTER TABLE `comment_edit_history`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `comment_flags`
--
ALTER TABLE `comment_flags`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `comment_mentions`
--
ALTER TABLE `comment_mentions`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `comment_polls`
--
ALTER TABLE `comment_polls`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `comment_reactions`
--
ALTER TABLE `comment_reactions`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `comment_reports`
--
ALTER TABLE `comment_reports`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `content_categories`
--
ALTER TABLE `content_categories`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_cache`
--
ALTER TABLE `crawler_cache`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_domains`
--
ALTER TABLE `crawler_domains`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_domain_configs`
--
ALTER TABLE `crawler_domain_configs`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_domain_rules`
--
ALTER TABLE `crawler_domain_rules`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_domain_stats`
--
ALTER TABLE `crawler_domain_stats`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_errors`
--
ALTER TABLE `crawler_errors`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_error_log`
--
ALTER TABLE `crawler_error_log`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_error_logs`
--
ALTER TABLE `crawler_error_logs`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_logs`
--
ALTER TABLE `crawler_logs`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_metrics`
--
ALTER TABLE `crawler_metrics`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_performance`
--
ALTER TABLE `crawler_performance`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_processed`
--
ALTER TABLE `crawler_processed`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_processes`
--
ALTER TABLE `crawler_processes`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_queue`
--
ALTER TABLE `crawler_queue`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_robots_cache`
--
ALTER TABLE `crawler_robots_cache`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_search_engines`
--
ALTER TABLE `crawler_search_engines`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_seeds`
--
ALTER TABLE `crawler_seeds`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_seen_links`
--
ALTER TABLE `crawler_seen_links`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_statistics`
--
ALTER TABLE `crawler_statistics`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `crawler_stats`
--
ALTER TABLE `crawler_stats`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `domain_config`
--
ALTER TABLE `domain_config`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `domain_index`
--
ALTER TABLE `domain_index`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `domain_policies`
--
ALTER TABLE `domain_policies`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `favorites`
--
ALTER TABLE `favorites`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feeds`
--
ALTER TABLE `feeds`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feed_comments`
--
ALTER TABLE `feed_comments`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feed_comment_polls`
--
ALTER TABLE `feed_comment_polls`
  MODIFY `poll_id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feed_comment_poll_options`
--
ALTER TABLE `feed_comment_poll_options`
  MODIFY `option_id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feed_comment_poll_votes`
--
ALTER TABLE `feed_comment_poll_votes`
  MODIFY `vote_id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feed_data`
--
ALTER TABLE `feed_data`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feed_hashtags`
--
ALTER TABLE `feed_hashtags`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feed_media`
--
ALTER TABLE `feed_media`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feed_mentions`
--
ALTER TABLE `feed_mentions`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feed_reactions`
--
ALTER TABLE `feed_reactions`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feed_reports`
--
ALTER TABLE `feed_reports`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feed_shares`
--
ALTER TABLE `feed_shares`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feed_views`
--
ALTER TABLE `feed_views`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `fetch_log`
--
ALTER TABLE `fetch_log`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `filter_rules`
--
ALTER TABLE `filter_rules`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `follows`
--
ALTER TABLE `follows`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hashtags`
--
ALTER TABLE `hashtags`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hc_content`
--
ALTER TABLE `hc_content`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hc_domains`
--
ALTER TABLE `hc_domains`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hc_imports`
--
ALTER TABLE `hc_imports`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hc_patterns`
--
ALTER TABLE `hc_patterns`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hc_stats`
--
ALTER TABLE `hc_stats`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hc_terms`
--
ALTER TABLE `hc_terms`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hc_trending`
--
ALTER TABLE `hc_trending`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `hc_urls`
--
ALTER TABLE `hc_urls`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `likes_dislikes`
--
ALTER TABLE `likes_dislikes`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `link_graph`
--
ALTER TABLE `link_graph`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `link_og_cache`
--
ALTER TABLE `link_og_cache`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `link_previews`
--
ALTER TABLE `link_previews`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `link_short`
--
ALTER TABLE `link_short`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `login_attempts`
--
ALTER TABLE `login_attempts`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `mega_crawler_host_stats`
--
ALTER TABLE `mega_crawler_host_stats`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `mega_crawler_queue`
--
ALTER TABLE `mega_crawler_queue`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `mega_crawler_results`
--
ALTER TABLE `mega_crawler_results`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `messages`
--
ALTER TABLE `messages`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `notifications`
--
ALTER TABLE `notifications`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `notifications_x`
--
ALTER TABLE `notifications_x`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payments_x`
--
ALTER TABLE `payments_x`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `pinfeeds`
--
ALTER TABLE `pinfeeds`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `pinfeeds_compatible`
--
ALTER TABLE `pinfeeds_compatible`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `polls`
--
ALTER TABLE `polls`
  MODIFY `poll_id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `poll_options`
--
ALTER TABLE `poll_options`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `poll_votes`
--
ALTER TABLE `poll_votes`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `post_hashtags`
--
ALTER TABLE `post_hashtags`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `post_reports`
--
ALTER TABLE `post_reports`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `post_views`
--
ALTER TABLE `post_views`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `professional_crawler_queue`
--
ALTER TABLE `professional_crawler_queue`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `profile_views`
--
ALTER TABLE `profile_views`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `push_subscriptions`
--
ALTER TABLE `push_subscriptions`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `rate_limits_x`
--
ALTER TABLE `rate_limits_x`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `reactions`
--
ALTER TABLE `reactions`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `relevant_links`
--
ALTER TABLE `relevant_links`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `robots_cache`
--
ALTER TABLE `robots_cache`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `search_analytics`
--
ALTER TABLE `search_analytics`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `search_boards`
--
ALTER TABLE `search_boards`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `search_index`
--
ALTER TABLE `search_index`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `search_queue`
--
ALTER TABLE `search_queue`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `security_logs`
--
ALTER TABLE `security_logs`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `seeds`
--
ALTER TABLE `seeds`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `share_stats`
--
ALTER TABLE `share_stats`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `shortlinks`
--
ALTER TABLE `shortlinks`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `simple_crawler_queue`
--
ALTER TABLE `simple_crawler_queue`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `stream_gifts`
--
ALTER TABLE `stream_gifts`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `subscriptions_x`
--
ALTER TABLE `subscriptions_x`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `title_description_index`
--
ALTER TABLE `title_description_index`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `title_description_index_2`
--
ALTER TABLE `title_description_index_2`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ultra_crawler_domains`
--
ALTER TABLE `ultra_crawler_domains`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ultra_crawler_domain_configs`
--
ALTER TABLE `ultra_crawler_domain_configs`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ultra_crawler_domain_stats`
--
ALTER TABLE `ultra_crawler_domain_stats`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ultra_crawler_errors`
--
ALTER TABLE `ultra_crawler_errors`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ultra_crawler_images`
--
ALTER TABLE `ultra_crawler_images`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ultra_crawler_links`
--
ALTER TABLE `ultra_crawler_links`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ultra_crawler_queue`
--
ALTER TABLE `ultra_crawler_queue`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ultra_crawler_results`
--
ALTER TABLE `ultra_crawler_results`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ultra_crawler_seeds`
--
ALTER TABLE `ultra_crawler_seeds`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ultra_crawler_settings`
--
ALTER TABLE `ultra_crawler_settings`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ultra_crawler_smart_queue`
--
ALTER TABLE `ultra_crawler_smart_queue`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ultra_crawler_stats`
--
ALTER TABLE `ultra_crawler_stats`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `uploaded_media`
--
ALTER TABLE `uploaded_media`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `urls`
--
ALTER TABLE `urls`
  MODIFY `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `url_hashes`
--
ALTER TABLE `url_hashes`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `url_tags`
--
ALTER TABLE `url_tags`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_badges`
--
ALTER TABLE `user_badges`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_blocks`
--
ALTER TABLE `user_blocks`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_collections`
--
ALTER TABLE `user_collections`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_follows`
--
ALTER TABLE `user_follows`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_hidden_posts`
--
ALTER TABLE `user_hidden_posts`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_myhashtag`
--
ALTER TABLE `user_myhashtag`
  MODIFY `ID` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_points`
--
ALTER TABLE `user_points`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_saves`
--
ALTER TABLE `user_saves`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_search_engines`
--
ALTER TABLE `user_search_engines`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_search_history`
--
ALTER TABLE `user_search_history`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_sessions`
--
ALTER TABLE `user_sessions`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `user_sessions_x`
--
ALTER TABLE `user_sessions_x`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `video_rooms`
--
ALTER TABLE `video_rooms`
  MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `words`
--
ALTER TABLE `words`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `xwc_errors`
--
ALTER TABLE `xwc_errors`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `xwc_pages`
--
ALTER TABLE `xwc_pages`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `xwc_queue`
--
ALTER TABLE `xwc_queue`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `xwc_relevant_links`
--
ALTER TABLE `xwc_relevant_links`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `xwc_seeds`
--
ALTER TABLE `xwc_seeds`
  MODIFY `id` bigint NOT NULL AUTO_INCREMENT;

-- --------------------------------------------------------

--
-- Structure for view `comment_stats`
--
DROP TABLE IF EXISTS `comment_stats`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `comment_stats`  AS SELECT `c`.`comment_id` AS `comment_id`, `c`.`feed_id` AS `feed_id`, `c`.`user_id` AS `user_id`, coalesce(`likes`.`count`,0) AS `likes_count`, coalesce(`dislikes`.`count`,0) AS `dislikes_count`, coalesce(`replies`.`count`,0) AS `replies_count`, coalesce(`reactions`.`count`,0) AS `total_reactions` FROM ((((`comments` `c` left join (select `comment_reactions`.`comment_id` AS `comment_id`,count(0) AS `count` from `comment_reactions` where (`comment_reactions`.`reaction` = 'like') group by `comment_reactions`.`comment_id`) `likes` on((`likes`.`comment_id` = `c`.`comment_id`))) left join (select `comment_reactions`.`comment_id` AS `comment_id`,count(0) AS `count` from `comment_reactions` where (`comment_reactions`.`reaction` = 'dislike') group by `comment_reactions`.`comment_id`) `dislikes` on((`dislikes`.`comment_id` = `c`.`comment_id`))) left join (select `comments`.`parent_comment_id` AS `parent_comment_id`,count(0) AS `count` from `comments` where ((`comments`.`parent_comment_id` is not null) and (`comments`.`is_deleted` = 0)) group by `comments`.`parent_comment_id`) `replies` on((`replies`.`parent_comment_id` = `c`.`comment_id`))) left join (select `comment_reactions`.`comment_id` AS `comment_id`,count(0) AS `count` from `comment_reactions` group by `comment_reactions`.`comment_id`) `reactions` on((`reactions`.`comment_id` = `c`.`comment_id`))) ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `ai_recommendations_x`
--
ALTER TABLE `ai_recommendations_x`
  ADD CONSTRAINT `ai_recommendations_x_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `ai_recommendations_x_ibfk_2` FOREIGN KEY (`feed_id`) REFERENCES `pinfeeds` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `analytics_events_x`
--
ALTER TABLE `analytics_events_x`
  ADD CONSTRAINT `analytics_events_x_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE SET NULL;

--
-- Constraints for table `api_keys_x`
--
ALTER TABLE `api_keys_x`
  ADD CONSTRAINT `api_keys_x_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE;

--
-- Constraints for table `board_collaborators`
--
ALTER TABLE `board_collaborators`
  ADD CONSTRAINT `fk_collab_board` FOREIGN KEY (`board_id`) REFERENCES `search_boards` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `board_items`
--
ALTER TABLE `board_items`
  ADD CONSTRAINT `fk_items_board` FOREIGN KEY (`board_id`) REFERENCES `search_boards` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_items_feed` FOREIGN KEY (`feed_id`) REFERENCES `pinfeeds` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `chat_messages`
--
ALTER TABLE `chat_messages`
  ADD CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`room_id`) REFERENCES `chat_rooms` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `chat_messages_ibfk_3` FOREIGN KEY (`reply_to`) REFERENCES `chat_messages` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `chat_participants`
--
ALTER TABLE `chat_participants`
  ADD CONSTRAINT `chat_participants_ibfk_1` FOREIGN KEY (`room_id`) REFERENCES `chat_rooms` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `chat_participants_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `chat_participants_ibfk_3` FOREIGN KEY (`last_read_message_id`) REFERENCES `chat_messages` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `chat_rooms`
--
ALTER TABLE `chat_rooms`
  ADD CONSTRAINT `chat_rooms_ibfk_1` FOREIGN KEY (`feed_id`) REFERENCES `pinfeeds` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `chat_rooms_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE;

--
-- Constraints for table `comments`
--
ALTER TABLE `comments`
  ADD CONSTRAINT `comments_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`);

--
-- Constraints for table `comments_polls`
--
ALTER TABLE `comments_polls`
  ADD CONSTRAINT `fk_cp_comment` FOREIGN KEY (`comment_id`) REFERENCES `comments` (`comment_id`) ON DELETE CASCADE;

--
-- Constraints for table `comments_poll_options`
--
ALTER TABLE `comments_poll_options`
  ADD CONSTRAINT `fk_cpo_poll` FOREIGN KEY (`poll_id`) REFERENCES `comments_polls` (`poll_id`) ON DELETE CASCADE;

--
-- Constraints for table `comments_poll_votes`
--
ALTER TABLE `comments_poll_votes`
  ADD CONSTRAINT `fk_cpv_option` FOREIGN KEY (`option_id`) REFERENCES `comments_poll_options` (`option_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_cpv_poll` FOREIGN KEY (`poll_id`) REFERENCES `comments_polls` (`poll_id`) ON DELETE CASCADE;

--
-- Constraints for table `comment_attachments`
--
ALTER TABLE `comment_attachments`
  ADD CONSTRAINT `comment_attachments_ibfk_1` FOREIGN KEY (`comment_id`) REFERENCES `comments` (`comment_id`) ON DELETE CASCADE;

--
-- Constraints for table `comment_edit_history`
--
ALTER TABLE `comment_edit_history`
  ADD CONSTRAINT `comment_edit_history_ibfk_1` FOREIGN KEY (`comment_id`) REFERENCES `comments` (`comment_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `comment_edit_history_ibfk_2` FOREIGN KEY (`edited_by`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE;

--
-- Constraints for table `comment_flags`
--
ALTER TABLE `comment_flags`
  ADD CONSTRAINT `fk_cf_comment` FOREIGN KEY (`comment_id`) REFERENCES `comments` (`comment_id`) ON DELETE CASCADE;

--
-- Constraints for table `comment_mentions`
--
ALTER TABLE `comment_mentions`
  ADD CONSTRAINT `comment_mentions_ibfk_1` FOREIGN KEY (`comment_id`) REFERENCES `comments` (`comment_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `comment_mentions_ibfk_2` FOREIGN KEY (`mentioned_user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `comment_mentions_ibfk_3` FOREIGN KEY (`mentioned_by`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE;

--
-- Constraints for table `comment_polls`
--
ALTER TABLE `comment_polls`
  ADD CONSTRAINT `comment_polls_ibfk_1` FOREIGN KEY (`comment_id`) REFERENCES `comments` (`comment_id`) ON DELETE CASCADE;

--
-- Constraints for table `comment_reactions`
--
ALTER TABLE `comment_reactions`
  ADD CONSTRAINT `comment_reactions_ibfk_1` FOREIGN KEY (`comment_id`) REFERENCES `comments` (`comment_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `comment_reactions_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE;

--
-- Constraints for table `comment_reports`
--
ALTER TABLE `comment_reports`
  ADD CONSTRAINT `comment_reports_ibfk_1` FOREIGN KEY (`comment_id`) REFERENCES `comments` (`comment_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `comment_reports_ibfk_2` FOREIGN KEY (`reporter_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `comment_reports_ibfk_3` FOREIGN KEY (`reviewed_by`) REFERENCES `user_myhashtag` (`ID`) ON DELETE SET NULL;

--
-- Constraints for table `favorites`
--
ALTER TABLE `favorites`
  ADD CONSTRAINT `favorites_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`),
  ADD CONSTRAINT `favorites_ibfk_2` FOREIGN KEY (`feed_id`) REFERENCES `pinfeeds` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT;

--
-- Constraints for table `feed_comment_polls`
--
ALTER TABLE `feed_comment_polls`
  ADD CONSTRAINT `fk_poll_comment` FOREIGN KEY (`comment_id`) REFERENCES `feed_comments` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `feed_comment_poll_options`
--
ALTER TABLE `feed_comment_poll_options`
  ADD CONSTRAINT `fk_poll_option` FOREIGN KEY (`poll_id`) REFERENCES `feed_comment_polls` (`poll_id`) ON DELETE CASCADE;

--
-- Constraints for table `feed_comment_poll_votes`
--
ALTER TABLE `feed_comment_poll_votes`
  ADD CONSTRAINT `fk_vote_opt` FOREIGN KEY (`option_id`) REFERENCES `feed_comment_poll_options` (`option_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_vote_poll` FOREIGN KEY (`poll_id`) REFERENCES `feed_comment_polls` (`poll_id`) ON DELETE CASCADE;

--
-- Constraints for table `fetch_log`
--
ALTER TABLE `fetch_log`
  ADD CONSTRAINT `fk_fetch_url` FOREIGN KEY (`url_id`) REFERENCES `urls` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `notifications`
--
ALTER TABLE `notifications`
  ADD CONSTRAINT `notifications_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE;

--
-- Constraints for table `notifications_x`
--
ALTER TABLE `notifications_x`
  ADD CONSTRAINT `notifications_x_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE;

--
-- Constraints for table `payments_x`
--
ALTER TABLE `payments_x`
  ADD CONSTRAINT `payments_x_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `payments_x_ibfk_2` FOREIGN KEY (`subscription_id`) REFERENCES `subscriptions_x` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `poll_options`
--
ALTER TABLE `poll_options`
  ADD CONSTRAINT `poll_options_ibfk_1` FOREIGN KEY (`poll_id`) REFERENCES `comment_polls` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `poll_votes`
--
ALTER TABLE `poll_votes`
  ADD CONSTRAINT `poll_votes_ibfk_1` FOREIGN KEY (`option_id`) REFERENCES `poll_options` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `poll_votes_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE;

--
-- Constraints for table `push_subscriptions`
--
ALTER TABLE `push_subscriptions`
  ADD CONSTRAINT `push_subscriptions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE;

--
-- Constraints for table `reactions`
--
ALTER TABLE `reactions`
  ADD CONSTRAINT `reactions_ibfk_1` FOREIGN KEY (`feed_id`) REFERENCES `pinfeeds` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `relevant_links`
--
ALTER TABLE `relevant_links`
  ADD CONSTRAINT `fk_rel_url` FOREIGN KEY (`url_id`) REFERENCES `urls` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `search_analytics`
--
ALTER TABLE `search_analytics`
  ADD CONSTRAINT `fk_analytics_engine` FOREIGN KEY (`engine_id`) REFERENCES `user_search_engines` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `search_boards`
--
ALTER TABLE `search_boards`
  ADD CONSTRAINT `fk_boards_engine` FOREIGN KEY (`engine_id`) REFERENCES `user_search_engines` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `search_index`
--
ALTER TABLE `search_index`
  ADD CONSTRAINT `fk_index_engine` FOREIGN KEY (`engine_id`) REFERENCES `user_search_engines` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `stream_gifts`
--
ALTER TABLE `stream_gifts`
  ADD CONSTRAINT `fk_gifts_room` FOREIGN KEY (`room_id`) REFERENCES `video_rooms` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `subscriptions_x`
--
ALTER TABLE `subscriptions_x`
  ADD CONSTRAINT `subscriptions_x_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE;

--
-- Constraints for table `title_description_index_2`
--
ALTER TABLE `title_description_index_2`
  ADD CONSTRAINT `title_description_index_2_ibfk_1` FOREIGN KEY (`word_id`) REFERENCES `words` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `user_badges`
--
ALTER TABLE `user_badges`
  ADD CONSTRAINT `user_badges_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE,
  ADD CONSTRAINT `user_badges_ibfk_2` FOREIGN KEY (`awarded_by`) REFERENCES `user_myhashtag` (`ID`) ON DELETE SET NULL;

--
-- Constraints for table `user_sessions_x`
--
ALTER TABLE `user_sessions_x`
  ADD CONSTRAINT `user_sessions_x_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `user_myhashtag` (`ID`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
