<?php
// Conexão com o Banco de Dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}

function cleanTitle($title) {
    // Substitui caracteres não alfanuméricos por espaços
    $title = preg_replace('/[^a-zA-Z0-9]/', ' ', $title);
    // Substitui múltiplos espaços seguidos por um único espaço
    $title = preg_replace('/\s+/', ' ', $title);
    return strtolower($title);
}


function generateTagsFile($conn) {
    $query = "SELECT title FROM pinfeeds";
    $result = $conn->query($query);
    $uniqueTags = [];

$stopwords = [
    // Português
    'e', 'o', 'em', 'de', 'da', 'do', 'para', 'um', 'uma', 'com', 'na', 'no', 'dos', 'das', 'aos', 'pelo', 'pela', 'mas', 'como', 'por', 'seu', 'sua', 'ou',
    // Inglês
    'and', 'or', 'but', 'not', 'on', 'in', 'with', 'for', 'at', 'from', 'by', 'this', 'that', 'these', 'those', 'to', 'of', 'a', 'an', 'the', 'is', 'are',
    // Espanhol
    'y', 'o', 'pero', 'no', 'en', 'con', 'para', 'por', 'de', 'del', 'al', 'el', 'la', 'los', 'las', 'un', 'una', 'unos', 'unas', 'es', 'son',
    // Francês
    'et', 'ou', 'mais', 'pas', 'dans', 'sur', 'avec', 'pour', 'par', 'de', 'du', 'au', 'le', 'la', 'les', 'un', 'une', 'des', 'est', 'sont',
    // Alemão
    'und', 'oder', 'aber', 'nicht', 'auf', 'in', 'mit', 'für', 'bei', 'von', 'durch', 'das', 'die', 'der', 'ein', 'eine', 'einer', 'eines', 'ist', 'sind'
];


     while ($row = $result->fetch_assoc()) {
        $title = cleanTitle($row['title']);
        $tags = explode(' ', $title);
        foreach ($tags as $tag) {
            if (!in_array($tag, $stopwords) && strlen($tag) > 2 && ctype_alpha($tag)) { 
                $uniqueTags[$tag] = ($uniqueTags[$tag] ?? 0) + 1;
            }
        }
    }

    // Ordenar as tags pela frequência (do maior para o menor)
    arsort($uniqueTags);

    // Selecionar as top N tags mais frequentes
    $topN = 2500; // Você pode ajustar esse número
    $topTags = array_slice(array_keys($uniqueTags), 0, $topN, true);

    file_put_contents('tags.json', json_encode($topTags));
}

generateTagsFile($conn);
$conn->close();

generateTagsFile($conn);
$conn->close();
?>
