<?php
require_once __DIR__ . '/bootstrap.php';

$action = route_action();
if ($action === 'get_boards') handle_get_boards();
if ($action === 'board_add_item') handle_add_item();

json_fail('UNKNOWN_ACTION', 'No such boards action: ' . $action, 404);

function handle_get_boards() {
    $pdo = pdo();
    if (!table_exists('search_boards')) json_fail('UNAVAILABLE','boards table not present', 503, ['available'=>false]);
    $limit = min(200, max(1, (int)param('limit', 50)));
    $rows = $pdo->query("SELECT id, board_name, board_slug, description, items_count, views_count, shares_count, created_at FROM search_boards ORDER BY created_at DESC LIMIT $limit")->fetchAll();
    json_ok(['boards'=>$rows, 'available'=>true]);
}

function handle_add_item() {
    $user = require_user();
    $pdo = pdo();
    if (!table_exists('board_items')) json_fail('UNAVAILABLE','board_items not present', 503, ['available'=>false]);
    $board_id = (int)param('board_id', 0);
    $feed_id = (int)param('feed_id', 0);
    if ($board_id<=0 || $feed_id<=0) json_fail('BAD_REQUEST','board_id and feed_id required', 422);
    $sql = "INSERT INTO board_items (board_id, feed_id, position, is_pinned, added_at, updated_at) 
            VALUES (:b,:f,0,0,NOW(),NOW())
            ON DUPLICATE KEY UPDATE updated_at = NOW()";
    $pdo->prepare($sql)->execute([':b'=>$board_id, ':f'=>$feed_id]);
    json_ok(['added'=>true]);
}
