<?php
require_once __DIR__ . '/bootstrap.php';

$action = route_action();
if ($action === 'favorite_toggle') handle_toggle();
if ($action === 'get_user_favorites') handle_get_favs();

json_fail('UNKNOWN_ACTION', 'No such favorites action: ' . $action, 404);

function handle_toggle() {
    $user = require_user();
    $pdo = pdo();
    $feed_id = (int)param('feed_id', 0);
    if ($feed_id <= 0) json_fail('BAD_REQUEST','feed_id required', 422);

    $stmt = $pdo->prepare("SELECT id FROM favorites WHERE user_id = :u AND feed_id = :f LIMIT 1");
    $stmt->execute([':u'=>$user['ID'], ':f'=>$feed_id]);
    $row = $stmt->fetch();
    if ($row) {
        $pdo->prepare("DELETE FROM favorites WHERE id = :id")->execute([':id'=>$row['id']]);
        json_ok(['favorited'=>false]);
    } else {
        $pdo->prepare("INSERT INTO favorites (user_id, feed_id, created_at) VALUES (:u,:f,NOW())")->execute([':u'=>$user['ID'], ':f'=>$feed_id]);
        json_ok(['favorited'=>true]);
    }
}

function handle_get_favs() {
    $user = require_user();
    $pdo = pdo();
    $sql = "
    SELECT p.id, p.title, p.link, p.thumbnail, p.description, p.pubDate, p.author, p.source_domain, p.likes, p.dislikes
    FROM favorites fa
    JOIN pinfeeds p ON p.id = fa.feed_id
    WHERE fa.user_id = :u
    ORDER BY fa.created_at DESC
    LIMIT 1000";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':u'=>$user['ID']]);
    $rows = $stmt->fetchAll();
    json_ok(['items'=>$rows]);
}
