<?php
require_once __DIR__ . '/bootstrap.php';

$action = route_action();
if ($action === 'follow_user') handle_follow();

json_fail('UNKNOWN_ACTION', 'No such follows action: ' . $action, 404);

function handle_follow() {
    $user = require_user();
    $target = (int)param('target_user_id', 0);
    if ($target <= 0) json_fail('BAD_REQUEST','target_user_id required', 422);
    if ($target === (int)$user['ID']) json_fail('BAD_REQUEST','cannot follow yourself', 422);
    $pdo = pdo();

    $stmt = $pdo->prepare("SELECT id FROM user_follows WHERE follower_id = :f AND following_id = :t LIMIT 1");
    $stmt->execute([':f'=>$user['ID'], ':t'=>$target]);
    $row = $stmt->fetch();
    if ($row) {
        $pdo->prepare("DELETE FROM user_follows WHERE id = :id")->execute([':id'=>$row['id']]);
        json_ok(['following'=>false]);
    } else {
        $pdo->prepare("INSERT INTO user_follows (follower_id, following_id, created_at) VALUES (:f,:t,NOW())")->execute([':f'=>$user['ID'], ':t'=>$target]);
        json_ok(['following'=>true]);
    }
}
