<?php
require_once __DIR__ . '/bootstrap.php';

$action = route_action();
if ($action === 'get_user_profile') handle_profile();

json_fail('UNKNOWN_ACTION', 'No such profile action: ' . $action, 404);

function handle_profile() {
    $pdo = pdo();
    $me = get_user();
    $uid = param('user_id', null);
    if ($uid === 'me' || $uid === null) {
        if (!$me) json_fail('AUTH_REQUIRED','login required or pass user_id', 401);
        $uid = (int)$me['ID'];
    } else {
        $uid = (int)$uid;
    }
    if ($uid <= 0) json_fail('BAD_REQUEST','invalid user_id', 422);

    $u = $pdo->prepare("SELECT ID, username, email, created_at, profile_picture, bio FROM user_myhashtag WHERE ID = :id LIMIT 1");
    $u->execute([':id'=>$uid]);
    $ud = $u->fetch();
    if (!$ud) json_fail('NOT_FOUND','User not found', 404);

    $counts = [
        'feeds' => 0,
        'favorites' => 0,
        'comments' => 0,
        'followers' => 0,
        'following' => 0,
    ];
    try {
        $counts['feeds'] = (int)$pdo->query("SELECT COUNT(*) FROM pinfeeds WHERE user_id = " . (int)$uid)->fetchColumn();
    } catch (Throwable $e) {}
    try {
        $counts['favorites'] = (int)$pdo->query("SELECT COUNT(*) FROM favorites WHERE user_id = " . (int)$uid)->fetchColumn();
    } catch (Throwable $e) {}
    try {
        $counts['comments'] = (int)$pdo->query("SELECT COUNT(*) FROM comments WHERE user_id = " . (int)$uid)->fetchColumn();
    } catch (Throwable $e) {}
    try {
        $counts['followers'] = (int)$pdo->query("SELECT COUNT(*) FROM user_follows WHERE following_id = " . (int)$uid)->fetchColumn();
        $counts['following'] = (int)$pdo->query("SELECT COUNT(*) FROM user_follows WHERE follower_id = " . (int)$uid)->fetchColumn();
    } catch (Throwable $e) {}

    json_ok(['user'=>$ud, 'stats'=>$counts]);
}
