<?php
require_once __DIR__ . '/bootstrap.php';

$action = route_action();
if ($action === 'post_reaction') handle_react();

json_fail('UNKNOWN_ACTION', 'No such reactions action: ' . $action, 404);

function handle_react() {
    $user = require_user();
    $pdo = pdo();
    $feed_id = (int)param('feed_id', 0);
    $reaction = strtolower(trim((string)param('reaction','like')));
    if ($feed_id <= 0 || !in_array($reaction, ['like','dislike'], true)) {
        json_fail('BAD_REQUEST','feed_id and reaction=[like|dislike] required',422);
    }

    $use_reactions = table_exists('reactions');
    $use_feed_reactions = table_exists('feed_reactions');

    if (!$use_reactions && !$use_feed_reactions) {
        json_fail('UNAVAILABLE','No reactions table found on this DB', 503);
    }

    if ($use_reactions) {
        $sql = "INSERT INTO reactions (user_id, feed_id, reaction_type, created_at, updated_at) 
                VALUES (:u,:f,:r,NOW(),NOW())
                ON DUPLICATE KEY UPDATE reaction_type=VALUES(reaction_type), updated_at=NOW()";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([':u'=>$user['ID'], ':f'=>$feed_id, ':r'=>$reaction]);
    } else {
        // feed_reactions fallback
        $sql = "INSERT INTO feed_reactions (feed_id, user_id, reaction_type, created_at)
                VALUES (:f,:u,:r,NOW())
                ON DUPLICATE KEY UPDATE reaction_type=VALUES(reaction_type)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([':u'=>$user['ID'], ':f'=>$feed_id, ':r'=>$reaction]);
    }

    // Recompute counters into pinfeeds.likes/dislikes (if columns exist)
    try {
        $stmt = $pdo->prepare("SELECT 
            SUM(CASE WHEN reaction_type='like' THEN 1 ELSE 0 END) as likes_count,
            SUM(CASE WHEN reaction_type='dislike' THEN 1 ELSE 0 END) as dislikes_count
            FROM " . ($use_reactions ? "reactions" : "feed_reactions") . " WHERE feed_id = :f");
        $stmt->execute([':f'=>$feed_id]);
        $c = $stmt->fetch();
        if ($c && isset($c['likes_count'])) {
            $up = $pdo->prepare("UPDATE pinfeeds SET likes = :l, dislikes = :d WHERE id = :f");
            $up->execute([':l'=>(int)$c['likes_count'], ':d'=>(int)$c['dislikes_count'], ':f'=>$feed_id]);
        }
    } catch (Throwable $e) {}

    json_ok(['feed_id'=>$feed_id, 'reaction'=>$reaction]);
}
