<?php
// Home – Masonry layout with filters + infinite load
$base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '')), '/.');
if ($base) $base .= '/';
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>DigUpDog Masonry – Home</title>
  <link rel="stylesheet" href="<?php echo $base; ?>public/css/styles.css">
</head>
<body data-page="home">
<header>
  <div class="container">
    <div class="brand"><span class="logo"></span> <span>DigUpDog Masonry</span></div>
    <nav>
      <a class="active" href="<?php echo $base; ?>index.php">Home</a>
      <a href="<?php echo $base; ?>trending.php">Trending</a>
      <a href="<?php echo $base; ?>sources.php">Sources</a>
      <a href="<?php echo $base; ?>profile.php">Profile</a>
      <a href="<?php echo $base; ?>login.php">Login</a>
    </nav>
  </div>
</header>

<main class="container">
  <div class="controls">
    <input id="q" type="text" placeholder="Search title/description/tags" style="flex:2;min-width:240px">
    <input id="domain" type="text" placeholder="Domain (e.g., youtube.com)" style="flex:1">
    <input id="author" type="text" placeholder="Author" style="flex:1">
    <input id="tags" type="text" placeholder="Tags (comma separated)" style="flex:1">
    <select id="order">
      <option value="latest" selected>Latest</option>
      <option value="popular">Popular</option>
      <option value="trending">Trending</option>
    </select>
    <select id="per_page">
      <option>12</option><option selected>24</option><option>36</option><option>48</option>
    </select>
    <button class="primary" id="searchBtn">Search</button>
  </div>

  <section class="grid" id="grid"></section>
  <div style="text-align:center;margin:10px 0 30px">
    <button id="loadMore" class="ghost" data-page="2" data-hasnext="0" style="display:none">Load more</button>
  </div>
</main>

<footer>
  <div class="container small">API endpoint root: <code>api/router.php</code> • Upload this folder anywhere – relative paths only.</div>
</footer>

<script src="<?php echo $base; ?>public/js/app.js"></script>
</body>
</html>
