<?php
$base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '')), '/.');
if ($base) $base .= '/';
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login – DigUpDog Masonry</title>
  <link rel="stylesheet" href="<?php echo $base; ?>public/css/styles.css">
</head>
<body>
<header>
  <div class="container">
    <div class="brand"><span class="logo"></span> <span>DigUpDog Masonry</span></div>
    <nav>
      <a href="<?php echo $base; ?>index.php">Home</a>
      <a href="<?php echo $base; ?>trending.php">Trending</a>
      <a href="<?php echo $base; ?>sources.php">Sources</a>
      <a href="<?php echo $base; ?>profile.php">Profile</a>
      <a class="active" href="<?php echo $base; ?>login.php">Login</a>
    </nav>
  </div>
</header>

<main class="container">
  <div class="card" style="max-width:480px;margin:30px auto 0;">
    <div class="content">
      <h2>Login</h2>
      <div class="controls">
        <input id="identifier" placeholder="Email or Username" style="width:100%">
        <input id="password" type="password" placeholder="Password" style="width:100%">
        <button id="loginBtn" class="primary">Login</button>
      </div>
      <div class="small">No account? <a href="<?php echo $base; ?>register.php">Register</a></div>
    </div>
  </div>
</main>

<script>
document.getElementById('loginBtn').addEventListener('click', async () => {
  const identifier = document.getElementById('identifier').value.trim();
  const password = document.getElementById('password').value;
  const r = await fetch('api/router.php?action=auth_login', {method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body:new URLSearchParams({identifier, password})});
  const j = await r.json();
  if (!j.ok) { alert(j.message||j.error); return; }
  location.href = 'index.php';
});
</script>
</body>
</html>
