<?php
$base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '')), '/.');
if ($base) $base .= '/';
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Register – DigUpDog Masonry</title>
  <link rel="stylesheet" href="<?php echo $base; ?>public/css/styles.css">
</head>
<body>
<header>
  <div class="container">
    <div class="brand"><span class="logo"></span> <span>DigUpDog Masonry</span></div>
    <nav>
      <a href="<?php echo $base; ?>index.php">Home</a>
      <a href="<?php echo $base; ?>trending.php">Trending</a>
      <a href="<?php echo $base; ?>sources.php">Sources</a>
      <a href="<?php echo $base; ?>profile.php">Profile</a>
      <a class="active" href="<?php echo $base; ?>register.php">Register</a>
    </nav>
  </div>
</header>

<main class="container">
  <div class="card" style="max-width:480px;margin:30px auto 0;">
    <div class="content">
      <h2>Create account</h2>
      <div class="controls">
        <input id="username" placeholder="Username" style="width:100%">
        <input id="email" placeholder="Email" style="width:100%">
        <input id="password" type="password" placeholder="Password" style="width:100%">
        <button id="registerBtn" class="primary">Register</button>
      </div>
      <div class="small">Already have an account? <a href="<?php echo $base; ?>login.php">Login</a></div>
    </div>
  </div>
</main>

<script>
document.getElementById('registerBtn').addEventListener('click', async () => {
  const username = document.getElementById('username').value.trim();
  const email = document.getElementById('email').value.trim();
  const password = document.getElementById('password').value;
  const r = await fetch('api/router.php?action=auth_register', {method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body:new URLSearchParams({username, email, password})});
  const j = await r.json();
  if (!j.ok) { alert(j.message||j.error); return; }
  location.href = 'index.php';
});
</script>
</body>
</html>
