<?php
$base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '')), '/.');
if ($base) $base .= '/';
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Sources – DigUpDog Masonry</title>
  <link rel="stylesheet" href="<?php echo $base; ?>public/css/styles.css">
</head>
<body>
<header>
  <div class="container">
    <div class="brand"><span class="logo"></span> <span>DigUpDog Masonry</span></div>
    <nav>
      <a href="<?php echo $base; ?>index.php">Home</a>
      <a href="<?php echo $base; ?>trending.php">Trending</a>
      <a class="active" href="<?php echo $base; ?>sources.php">Sources</a>
      <a href="<?php echo $base; ?>profile.php">Profile</a>
      <a href="<?php echo $base; ?>login.php">Login</a>
    </nav>
  </div>
</header>

<main class="container">
  <h2>Top sources</h2>
  <div id="tableWrap" class="notice">Loading…</div>
</main>
<footer><div class="container small">Domains with the most items.</div></footer>

<script>
async function loadSources(){
  const resp = await fetch('api/router.php?action=get_sources');
  const j = await resp.json();
  if (!j.ok) { document.getElementById('tableWrap').innerHTML = '<div class="empty">Failed to load</div>'; return; }
  const rows = j.sources || [];
  if (!rows.length) { document.getElementById('tableWrap').innerHTML = '<div class="empty">No sources found</div>'; return; }
  let html = '<table><thead><tr><th>#</th><th>Domain</th><th>Items</th></tr></thead><tbody>';
  rows.forEach((r, i)=>{
    const d = r.source_domain || '(unknown)';
    html += `<tr><td>${i+1}</td><td>${d}</td><td>${r.count}</td></tr>`;
  });
  html += '</tbody></table>';
  document.getElementById('tableWrap').innerHTML = html;
}
document.addEventListener('DOMContentLoaded', loadSources);
</script>
</body>
</html>
