<?php
// Configurações do banco de dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

// DSN (Data Source Name)
$dsn = "mysql:host=$host;dbname=$db;charset=$charset";

// Opções PDO
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    // Conexão com o banco de dados usando PDO
    $pdo = new PDO($dsn, $user, $pass, $options);

    // Verificar se a tabela 'links' existe
    $checkLinksTable = $pdo->query("SHOW TABLES LIKE 'links'")->rowCount();
    if ($checkLinksTable == 0) {
        throw new Exception("A tabela 'links' não existe no banco de dados.");
    }

    // SQL para criar a tabela link_categories
    $sql = "CREATE TABLE IF NOT EXISTS link_categories (
        id INT AUTO_INCREMENT PRIMARY KEY,
        link_id INT NOT NULL,
        category_type ENUM('member', 'author', 'tag', 'domain', 'description', 'title') NOT NULL,
        category_name VARCHAR(255) NOT NULL,
        FOREIGN KEY (link_id) REFERENCES links(id) ON DELETE CASCADE
    ) ENGINE=InnoDB CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;";

    // Executa o SQL
    $pdo->exec($sql);
    echo "Tabela 'link_categories' criada com sucesso.";

} catch (PDOException $e) {
    echo "Erro ao criar tabela: " . $e->getMessage();
} catch (Exception $e) {
    echo "Erro: " . $e->getMessage();
}
?>
