<?php
session_start();

// Verificar se o usuário está logado
if (!isset($_SESSION['user_id'])) {
    die(json_encode(['status' => 'error', 'message' => 'Usuário não logado.']));
}

$user_id = $_SESSION['user_id'];

// Conexão com o Banco de Dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die(json_encode(['status' => 'error', 'message' => 'Erro na conexão com o banco de dados: ' . $conn->connect_error]));
}

// Consulta para buscar feeds e verificar se foram favoritados pelo usuário logado
$sql = "
    SELECT f.*, 
           CASE WHEN fa.feed_id IS NOT NULL THEN 1 ELSE 0 END AS is_favorited 
    FROM pinfeeds f 
    LEFT JOIN favorites fa ON f.id = fa.feed_id AND fa.user_id = ?
";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$feeds = [];
while ($feed = $result->fetch_assoc()) {
    $feeds[] = $feed;
}

$stmt->close();
$conn->close();

// Retorna os feeds como JSON
echo json_encode(['status' => 'success', 'feeds' => $feeds]);
?>
