<?php
session_start();

// Configurações do banco de dados e controle de execução
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';
$resultsPerPage = 21;
$batchSize = 1000;
$progressFile = 'progress_index_domain.txt';
$maxExecutionTime = 120;

// Configuração de exibição de erros e memória
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
set_time_limit(0);
ini_set('memory_limit', '3G');
ob_start();

// Função para reiniciar o script automaticamente
$startTime = time();
function shouldRestart($startTime, $maxExecutionTime) {
    return (time() - $startTime) > $maxExecutionTime;
}

// Conexão com o banco de dados
try {
    $conn = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die('Erro na conexão com o banco de dados: ' . $e->getMessage());
}

// Função para extrair o domínio de uma URL
function extractDomain($url) {
    $parsedUrl = parse_url($url);
    return isset($parsedUrl['host']) ? $parsedUrl['host'] : null;
}

// Indexar domínios para cada link, evitando duplicações
function indexDomain($conn, $feedId, $link) {
    $domain = extractDomain($link);
    if ($domain) {
        $insertDomainQuery = "INSERT IGNORE INTO domain_index (domain, feed_id) VALUES (:domain, :feed_id)";
        $stmt = $conn->prepare($insertDomainQuery);
        $stmt->execute([':domain' => $domain, ':feed_id' => $feedId]);
    }
}

// Processamento por lotes para garantir a indexação eficiente
$offset = file_exists($progressFile) ? (int)file_get_contents($progressFile) : 0;
$totalStmt = $conn->query("SELECT COUNT(*) FROM pinfeeds");
$totalRecords = $totalStmt->fetchColumn();

while ($offset < $totalRecords) {
    if (shouldRestart($startTime, $maxExecutionTime)) {
        file_put_contents($progressFile, $offset);
        echo "Reiniciando o script para evitar timeout...\n";
        echo "<script>window.location.reload();</script>";
        exit;
    }

    // Busca lote de registros
    $stmt = $conn->prepare("SELECT id, link FROM pinfeeds LIMIT :offset, :batchSize");
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->bindValue(':batchSize', $batchSize, PDO::PARAM_INT);
    $stmt->execute();
    $feeds = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Indexa os domínios dos links
    foreach ($feeds as $feed) {
        indexDomain($conn, $feed['id'], $feed['link']);
    }

    // Atualiza o progresso
    $offset += $batchSize;
    file_put_contents($progressFile, $offset);

    echo sprintf("Processando lote: %d de %d\n", $offset, $totalRecords);
    ob_flush();
    flush();
}

// Remover arquivo de progresso ao concluir
if (file_exists($progressFile)) {
    unlink($progressFile);
}

echo "Processamento de indexação de domínios concluído.\n";

?>
