<?php
header('Content-Type: application/json');

$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    throw new \PDOException($e->getMessage(), (int)$e->getCode());
}

$authorName = $_GET['author'] ?? '';

$response = [
    'totalFeeds' => 0,
    'feeds' => []
];

if ($authorName) {
    $stmt = $pdo->prepare("SELECT * FROM pinfeeds WHERE author = :authorName ORDER BY id DESC LIMIT :offset, :limit");
    
    $currentPage = $_GET['page'] ?? 1;
    $feedsPerPage = 50;
    $offset = ($currentPage - 1) * $feedsPerPage;

    $stmt->bindParam(':authorName', $authorName, PDO::PARAM_STR);
    $stmt->bindParam(':offset', $offset, PDO::PARAM_INT);
    $stmt->bindParam(':limit', $feedsPerPage, PDO::PARAM_INT);

    $stmt->execute();

    $feeds = $stmt->fetchAll();

    foreach ($feeds as &$feed) {
        // Adicione esta linha para depuração
        error_log("Thumbnail URL for feed ID {$feed['id']}: {$feed['thumbnail_url']}");
    }

    $response['totalFeeds'] = count($feeds);
    $response['feeds'] = $feeds;
}

echo json_encode($response);
?>