<?php
session_start();

// Configuração do banco de dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

// Configuração do DSN
$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Falha ao conectar ao banco de dados']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($_GET['feed_id']) && !empty($_GET['feed_id'])) {
        $feed_id = intval($_GET['feed_id']);
        
        // Implementação de paginação (opcional)
        $limit = isset($_GET['limit']) ? intval($_GET['limit']) : 10;  // Define o limite padrão para 10 comentários
        $offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0; // Define o offset padrão para 0

        // Consulta para obter os comentários com paginação
        $stmt = $pdo->prepare("
            SELECT c.comment_text, c.created_at, u.username AS author, u.id as user_id,
                COALESCE(
                    (SELECT pf.thumbnail FROM pinfeeds pf WHERE pf.author = u.username ORDER BY pf.id DESC LIMIT 1),
                    'default-avatar.png'
                ) AS author_thumbnail
            FROM comments c
            JOIN users u ON c.user_id = u.id
            WHERE c.feed_id = ?
            ORDER BY c.created_at ASC
            LIMIT ? OFFSET ?
        ");

        try {
            $stmt->execute([$feed_id, $limit, $offset]);
            $comments = $stmt->fetchAll();

            echo json_encode(['success' => true, 'comments' => $comments]);
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'message' => 'Erro ao buscar comentários']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Parâmetro feed_id não foi fornecido.']);
        exit;
    }
}
?>