<?php

$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

$resultsPerPage = 21;

try {
    $conn = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die('Erro na conexão com o banco de dados: ' . $e->getMessage());
}

$keyword = isset($_GET['search']) ? trim($_GET['search']) : '';
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$offset = ($page - 1) * $resultsPerPage;
$domainName = null;

// Verifica se a keyword contém "source:"
if (strpos($keyword, 'source:') !== false) {
    list($sourcePrefix, $domainKeyword) = explode(':', $keyword, 2);
    $domainName = $domainKeyword;
    $keyword = ''; // Limpa a keyword para busca textual quando focando em domain
}

$query = "SELECT * FROM feeds WHERE 1=1 ";

if (!empty($keyword)) {
    // Adiciona busca de texto completo se uma keyword for fornecida
    $query .= "AND MATCH(title) AGAINST(:keyword IN NATURAL LANGUAGE MODE) ";
}

if (!is_null($domainName) && empty($keyword)) {
    // Adiciona filtro por domínio se domainName for fornecido e não estiver buscando por keyword
    $query .= "AND link LIKE :domainName ";
}

$query .= "ORDER BY id DESC LIMIT :offset, :limit";

$stmt = $conn->prepare($query);

if (!empty($keyword)) {
    $stmt->bindValue(':keyword', $keyword, PDO::PARAM_STR);
}

if (!is_null($domainName) && empty($keyword)) {
    $stmt->bindValue(':domainName', '%' . $domainName . '%', PDO::PARAM_STR);
}

$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->bindValue(':limit', $resultsPerPage, PDO::PARAM_INT);

try {
    $stmt->execute();
    $feeds = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($feeds);
} catch (PDOException $e) {
    die('Erro na consulta ao banco de dados: ' . $e->getMessage());
}

?>