<?php
if (isset($_POST['url'])) {
    $url = $_POST['url'];

    // Use cURL para buscar o conteúdo da URL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $html = curl_exec($ch);
    curl_close($ch);

    // Procura por título, descrição e imagem no conteúdo HTML usando expressões regulares
    preg_match('/<title>(.*?)<\/title>/', $html, $titleMatches);
    preg_match('/<meta name="description" content="(.*?)"/', $html, $descMatches);
    preg_match('/<meta property="og:image" content="(.*?)"/', $html, $imageMatches);

    $title = $titleMatches[1] ?? 'No title found';
    $description = $descMatches[1] ?? 'No description available';
    $thumbnail = $imageMatches[1] ?? 'default-thumbnail.png'; // Use uma imagem padrão se nenhuma for encontrada

    // Retorna a resposta em JSON
    echo json_encode([
        'success' => true,
        'title' => $title,
        'description' => $description,
        'thumbnail' => $thumbnail
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'No URL provided.']);
}
?>
