<?php
session_start();

// Verifique se o usuário está logado e defina o user_id ou deixe como null
$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;

if (!$user_id) {
    echo json_encode(['status' => 'error', 'message' => 'Usuário não autenticado']);
    exit;
}

// Verifique se a requisição POST contém os dados necessários
if (!isset($_POST['reaction']) || !isset($_POST['feed_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Dados insuficientes']);
    exit;
}

$reaction = $_POST['reaction'];
$feed_id = (int)$_POST['feed_id']; // Certifique-se de que o feed_id seja um inteiro

$validReactions = ['love', 'haha', 'wow', 'sad']; // Tipos de reações permitidas

// Verifique se a reação é válida
if (!in_array($reaction, $validReactions)) {
    echo json_encode(['status' => 'error', 'message' => 'Tipo de reação inválido']);
    exit;
}

// Conexão com o banco de dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Erro ao conectar ao banco de dados']);
    exit;
}

// Verifique se o usuário já reagiu a esse feed
$sqlCheckReaction = "SELECT reaction FROM feed_reactions WHERE user_id = ? AND feed_id = ?";
$stmtCheck = $pdo->prepare($sqlCheckReaction);
$stmtCheck->execute([$user_id, $feed_id]);
$userReaction = $stmtCheck->fetchColumn();

if ($userReaction) {
    // Se o usuário já reagiu e a nova reação é a mesma, remova a reação
    if ($userReaction === $reaction) {
        $sqlRemoveReaction = "DELETE FROM feed_reactions WHERE user_id = ? AND feed_id = ?";
        $stmtRemove = $pdo->prepare($sqlRemoveReaction);
        $stmtRemove->execute([$user_id, $feed_id]);
        echo json_encode(['status' => 'success', 'message' => 'Reação removida', 'newCount' => getReactionCount($pdo, $feed_id, $reaction)]);
        exit;
    } else {
        // Atualize a reação do usuário
        $sqlUpdateReaction = "UPDATE feed_reactions SET reaction = ? WHERE user_id = ? AND feed_id = ?";
        $stmtUpdate = $pdo->prepare($sqlUpdateReaction);
        $stmtUpdate->execute([$reaction, $user_id, $feed_id]);
    }
} else {
    // Insira a nova reação se o usuário ainda não reagiu
    $sqlInsertReaction = "INSERT INTO feed_reactions (user_id, feed_id, reaction) VALUES (?, ?, ?)";
    $stmtInsert = $pdo->prepare($sqlInsertReaction);
    $stmtInsert->execute([$user_id, $feed_id, $reaction]);
}

// Retorne a nova contagem de reações
echo json_encode(['status' => 'success', 'newCount' => getReactionCount($pdo, $feed_id, $reaction)]);

// Função para obter a contagem de reações
function getReactionCount($pdo, $feed_id, $reaction) {
    $sqlCount = "SELECT COUNT(*) FROM feed_reactions WHERE feed_id = ? AND reaction = ?";
    $stmtCount = $pdo->prepare($sqlCount);
    $stmtCount->execute([$feed_id, $reaction]);
    return $stmtCount->fetchColumn();
}
