<?php
session_start();

// Verifica se o usurio est logado
if (!isset($_SESSION['user_id'])) {
    // Retorna um JSON com um erro e uma indicao para redirecionar
    echo json_encode(['status' => 'error', 'message' => 'User not logged in', 'redirect' => 'https://digupdog.com/login.html']);
    exit();
}

$user_id = $_SESSION['user_id'];
$feed_id = isset($_POST['feed_id']) ? intval($_POST['feed_id']) : null;
$action = isset($_POST['action']) ? $_POST['action'] : '';

$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    // Conexo com o banco de dados usando PDO
    $conn = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    if ($action === 'save') {
        // Insere o feed como favorito
        $stmt = $conn->prepare("INSERT INTO favorites (user_id, feed_id) VALUES (:user_id, :feed_id)");
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
        $stmt->bindParam(':feed_id', $feed_id, PDO::PARAM_INT);
        $stmt->execute();
        echo json_encode(['status' => 'success']);
    } elseif ($action === 'unsave') {
        // Remove o feed dos favoritos
        $stmt = $conn->prepare("DELETE FROM favorites WHERE user_id = :user_id AND feed_id = :feed_id");
        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
        $stmt->bindParam(':feed_id', $feed_id, PDO::PARAM_INT);
        $stmt->execute();
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
    }

} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
