<?php
session_start();

// Configuração da conexão com o banco de dados
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    throw new \PDOException($e->getMessage(), (int)$e->getCode());
}

$results = [];
$message = "";

// Definindo as colunas para a tabela 'feed_data'
$columns = ["id", "website_base", "website_feed", "main_category_id", "subcategory_id", "subcategory_name", "subsubcategory_id", "subsubcategory_name", "date_added", "last_updated", "is_active"];
$displayColumns = ["ID", "Website Base", "Website Feed", "Main Category ID", "Subcategory ID", "Subcategory Name", "Subsubcategory ID", "Subsubcategory Name", "Date Added", "Last Updated", "Is Active"];
$selectedColumns = $columns;
$limit = isset($_POST['resultsCount']) ? $_POST['resultsCount'] : 10;

if (isset($_POST['edit_single'])) {
    $_SESSION['selected_ids'] = [$_POST['edit_single']]; // Armazena o único ID em uma array
    header('Location: shortcut_manager_edit.php');
    exit();
}

// Tratamento do limite personalizado
if (isset($_POST['customLimit']) && is_numeric($_POST['customLimit']) && intval($_POST['customLimit']) > 0) {
    $limit = intval($_POST['customLimit']);
}

// Edição múltipla de registros
if (isset($_POST['edit']) && isset($_POST['selected_ids'])) {
    $_SESSION['selected_ids'] = $_POST['selected_ids']; // Armazena múltiplos IDs selecionados
    header('Location: shortcut_manager_edit.php');
    exit();
}

// Exclusão de múltiplos registros
if (isset($_POST['delete']) && isset($_POST['selected_ids'])) {
    $placeholders = implode(',', array_fill(0, count($_POST['selected_ids']), '?'));
    $stmt = $pdo->prepare("DELETE FROM feed_data WHERE id IN ($placeholders)");
    $stmt->execute($_POST['selected_ids']);
    $message = "Registros deletados com sucesso!";
}

// Processo de busca
if (isset($_POST['search']) && isset($_POST['searchTerm'])) {
    $searchTerm = $_POST['searchTerm'];
    $searchColumn = $_POST['searchColumn'];
    $customLimit = $_POST['customLimit'];
    $selectedColumns = isset($_POST['displayColumns']) ? $_POST['displayColumns'] : $columns;

    // Trata o limite de resultados
    if ($customLimit) {
        $limit = intval($customLimit);
    } elseif ($limit == "all") {
        $limit = 9999999; // Número arbitrariamente grande para exibir todos os registros
    }

    // Verifica se a coluna de busca é válida
    if (in_array($searchColumn, $columns)) {
        // Verifica se o termo de busca é um número
        if (is_numeric($searchTerm)) {
            // Se for um número, faz uma busca exata
            $stmt = $pdo->prepare("SELECT " . implode(", ", $selectedColumns) . " FROM feed_data WHERE $searchColumn = ? LIMIT $limit");
            $stmt->execute([$searchTerm]);
        } else {
            // Se for uma string, faz uma busca parcial usando LIKE
            $stmt = $pdo->prepare("SELECT " . implode(", ", $selectedColumns) . " FROM feed_data WHERE $searchColumn LIKE ? LIMIT $limit");
            $stmt->execute(["%$searchTerm%"]);
        }

        // Armazena os resultados
        $results = $stmt->fetchAll();

        if (empty($results)) {
            $message = "Nenhum registro encontrado.";
        }
    } else {
        $message = "Coluna inválida.";
    }
} else if (isset($_POST['search']) && empty($_POST['searchTerm'])) {
    $message = "Por favor, insira um termo de busca.";
}


// Exclusão de registro único
if (isset($_GET['delete_id'])) {
    $idToDelete = intval($_GET['delete_id']);
    $stmt = $pdo->prepare("DELETE FROM feed_data WHERE id = ?");
    $stmt->execute([$idToDelete]);
    $message = "Registro deletado com sucesso!";
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shortcut Manager Website</title>
    <!-- Bootstrap 4 CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        /* Container geral */
        .container {
            width: 95%;
            max-width: 95%;
            margin-left: auto;
            margin-right: auto;
            padding: 20px 0;
        }

        /* Estilos modernizados para os cards de resultado */
        .result-card {
            border: 1px solid #e1e1e1;
            border-radius: 8px;
            margin-bottom: 10px;
            padding: 25px;
            background-color: #f9f9f9;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
            width: 100%;
        }

        .result-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        /* Cabeçalho do card */
        .result-card .card-header {
            font-weight: 600;
            font-size: 18px;
            background-color: #e0e0e0;
            padding: 12px 15px;
            margin-bottom: 5px;
            border-radius: 8px;
            color: #333;
            border-bottom: 2px solid #d1d1d1;
        }

        .result-card .card-body {
            padding: 0;
            margin-top: 10px;
        }

 /* Colunas */
        .result-card .col-container {
            padding: 5px;
            border-radius: 6px;
            margin: 5px;
            background-color: #e9ecef;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            transition: background-color 0.2s ease-in-out;
            flex: 1 1 200px; /* Ajuste flexível para telas menores */
        }

        .result-card .row {
            display: flex;
            flex-wrap: wrap;
            gap: 5px; /* Espaço de 5px entre as colunas */
        }

        @media (max-width: 768px) {
            .result-card .col-container {
                width: 100%; /* Em telas menores, as colunas ocupam 100% da largura */
                max-width: 100%; /* Remover a limitação de 280px em telas menores */
                margin-right: 0; /* Remover o espaçamento lateral */
            }
        }

        /* Estilo para truncar o texto e mostrar o link completo no tooltip */
        .result-card .col-container a {
            white-space: nowrap; /* Impede quebra de linha */
            overflow: hidden; /* Esconde o que ultrapassa a largura */
            text-overflow: ellipsis; /* Adiciona reticências no final */
            display: block; /* Mantém o comportamento do link */
            max-width: 100%; /* Limita a largura máxima ao container */
            color: #007bff; /* Cor do link */
            text-decoration: none;
            transition: color 0.3s ease;
        }

/* Efeito aprimorado ao passar o mouse nas colunas */
.result-card .col-container:hover {
    background-color: #dee2e6; /* Cor de fundo ainda mais clara ao passar o mouse */
    box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2), 0 2px 4px rgba(0, 0, 0, 0.05); /* Sombra mais profunda e realista */
    transform: translateY(-8px) scale(1.02); /* Elevação mais perceptível e leve aumento de tamanho */
    transition: background-color 0.3s ease, box-shadow 0.3s ease, transform 0.3s ease; /* Transições suaves para todos os efeitos */
}

/* Suavizando as transições */
.result-card .col-container {
    transition: background-color 0.3s ease, box-shadow 0.3s ease, transform 0.3s ease;
}



        .result-card .col-container a.break {
            white-space: normal; /* Permite quebra de linha */
            word-wrap: break-word; /* Quebra a palavra em várias linhas */
            overflow-wrap: break-word; /* Suporte adicional para navegadores */
        }


        /* Botões */
        .result-card .btn {
            padding: 10px;
            border-radius: 6px;
            margin: 2px;
            background-color: #e9ecef;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            transition: background-color 0.2s ease-in-out;
            flex: 1 1 200px; /* Ajuste flexível para telas menores */
        }

        .result-card .btn-warning {
            background-color: #ffc107;
            color: #fff;
            border: none;
        }

        .result-card .btn-warning:hover {
            background-color: #e0a800;
            transform: scale(1.05);
        }

        .result-card .btn-danger {
            background-color: #dc3545;
            color: #fff;
            border: none;
        }

        .result-card .btn-danger:hover {
            background-color: #c82333;
            transform: scale(1.05);
        }

        .btn-info {
            background-color: #17a2b8;
            color: #fff;
            border: none;
        }

        .btn-info:hover {
            background-color: #138496;
            transform: scale(1.05);
        }

        /* Estilos para a caixa de seleção "Select All" */
        #selectAll {
            margin-bottom: 20px;
            cursor: pointer;
            font-weight: bold;
        }

        /* Estilização do formulário */
        .form-row {
            margin-bottom: 5px;
            display: flex;
            flex-wrap: wrap;
        }

        .form-label {
            font-weight: bold;
            margin-bottom: 5px;
        }

        .form-control {
            border-radius: 5px;
            border: 1px solid #ced4da;
            transition: border-color 0.2s ease-in-out;
        }

        .form-control:focus {
            border-color: #17a2b8;
            box-shadow: none;
        }

        /* Melhorias visuais no formulário */
        .form-group {
            background-color: #f8f9fa;
            padding: 5px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
            padding: 10px 20px;
            border-radius: 5px;
            transition: background-color 0.3s ease;
        }

        .btn-primary:hover {
            background-color: #0056b3;
            border-color: #004085;
        }

/* Estilos para os checkboxes das colunas para exibir */
.column-checkbox {
    padding: 15px;
    border-radius: 12px;
    margin: 8px;
    background-color: #f8f9fa;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    transition: background-color 0.4s ease, box-shadow 0.4s ease, transform 0.3s ease;
    flex: 1 1 240px;
    display: flex;
    align-items: center;
    justify-content: space-between;
    cursor: pointer;
    position: relative;
    font-size: 1.1em; /* Destaque maior no texto */
    color: #343a40; /* Texto mais escuro para contraste */
    font-weight: bold; /* Mais peso no texto para maior destaque */
}

.column-checkbox:hover {
    background-color: #dfe3e6; /* Cor mais clara ao passar o mouse */
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2); /* Sombra mais dramática */
    transform: scale(1.05);
}

.column-checkbox:focus-within {
    outline: none;
    background-color: #cfd4d8;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.25);
    transform: scale(1.06);
}

.column-checkbox input[type="checkbox"] {
    margin-right: 12px;
    transform: scale(1.5);
}

.column-checkbox input[type="checkbox"]:checked + label::before {
    content: '\2714'; /* Símbolo de check */
    position: absolute;
    right: 15px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 1.8em; /* Ícone de check maior */
    color: #28a745; /* Cor verde para o check */
    animation: checkBounce 0.4s ease-in-out; /* Efeito bounce ao aparecer */
}

@keyframes checkBounce {
    0% {
        opacity: 0;
        transform: scale(0.5) translateY(-50%);
    }
    60% {
        transform: scale(1.2) translateY(-50%);
    }
    100% {
        opacity: 1;
        transform: scale(1) translateY(-50%);
    }
}

/* Animação de destaque ao passar o mouse no texto */
.column-checkbox:hover span {
    color: #495057;
    text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.1); /* Sombra leve no texto */
    transition: color 0.4s ease, text-shadow 0.4s ease;
}

/* Animação suave para quando o checkbox for focado */
.column-checkbox:focus-within span {
    color: #343a40;
    text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.2); /* Sombra de texto mais dramática */
}

/* Efeitos responsivos */
@media (max-width: 768px) {
    .column-checkbox {
        width: 100%;
        flex-basis: 100%;
        margin: 8px 0;
    }
}

@media (max-width: 576px) {
    .column-checkbox {
        padding: 15px;
        font-size: 1em; /* Ajuste de tamanho de texto para telas menores */
    }

    .column-checkbox input[type="checkbox"] {
        transform: scale(1.3); /* Ajuste de escala para checkboxes menores */
    }

    .column-checkbox input[type="checkbox"]:checked + label::before {
        font-size: 1.5em;
    }
}

@media (max-width: 576px) {
    .result-card .col-container {
        font-size: 1.2em; /* Ajusta o tamanho do texto para telas menores */
    }

    .btn {
        font-size: 1.2em; /* Botões menores em telas pequenas */
        padding: 8px;
    }
}


    </style>
</head>
<body>

<div class="container mt-5">
    <form method="post" action="shortcut_manager.php" class="form-group">
        <!-- Grupo de busca -->
        <div class="form-row">
            <div class="col-md-4 mb-3">
                <label class="form-label" for="searchColumn">Buscar por Coluna</label>
                <select name="searchColumn" id="searchColumn" class="form-control">
                    <?php foreach ($columns as $key => $column): ?>
                        <option value="<?= htmlspecialchars($column) ?>"><?= $displayColumns[$key] ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-5 mb-3">
                <label class="form-label" for="searchTerm">Termo de Busca</label>
                <input type="text" name="searchTerm" id="searchTerm" class="form-control" placeholder="Digite o termo de busca...">
            </div>
            <div class="col-md-2 mb-3">
                <label class="form-label" for="resultsCount">Resultados por Página</label>
                <select name="resultsCount" id="resultsCount" class="form-control">
                    <option value="10">10</option>
                    <option value="20">20</option>
                    <option value="40">40</option>
                    <option value="100">100</option>
                    <option value="all">Todos</option>
                </select>
            </div>
            <div class="col-md-2 mb-3">
                <label class="form-label" for="customLimit">Limite Personalizado</label>
                <input type="number" name="customLimit" id="customLimit" class="form-control" placeholder="Limite...">
            </div>
        </div>

        <!-- Grupo de colunas -->
        <div class="form-row">
            <div class="col-md-12 mb-3">
                <label class="form-label">Colunas para Exibir:</label>
                <div class="d-flex flex-wrap">
                    <?php foreach ($columns as $key => $column): ?>
                        <div class="column-checkbox">
                            <label class="form-check-label">
                                <input type="checkbox" class="form-check-input" name="displayColumns[]" value="<?= htmlspecialchars($column) ?>" <?= in_array($column, $selectedColumns) ? 'checked' : '' ?>> <?= $displayColumns[$key] ?>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <!-- Botão de submissão -->
        <div class="form-row text-right">
            <div class="col-md-12">
                <button type="submit" name="search" class="btn btn-primary btn-lg">
                    <i class="fas fa-search"></i> Buscar
                </button>
            </div>
        </div>
    </form>

<!-- Exibição de resultados -->
<?php if (!empty($results)): ?>
    <div class="alert alert-info mt-4">Total de resultados: <?= count($results) ?></div>

    <form method='post' action='shortcut_manager.php' class="mt-4">
        <input type="checkbox" id="selectAll"> Selecionar Todos
        <?php foreach ($results as $row): ?>
            <div class="result-card">
                <div class="card-header">
                    <input type="checkbox" class="selectItem" name='selected_ids[]' value='<?= $row['id'] ?>'> Registro ID: <?= $row['id'] ?>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php foreach ($selectedColumns as $key => $selected): ?>
                            <div class="col-md-4 col-container">
                                <strong><?= $displayColumns[array_search($selected, $columns)] ?>:</strong> 
                                <span>
                                    <?php
                                    // Corrigir URL sem protocolo
                                    $url = htmlspecialchars($row[$selected]);
                                    if ($selected == 'website_base' || $selected == 'website_feed') {
                                        if (!preg_match("~^(?:f|ht)tps?://~i", $url)) {
                                            $url = "https://" . $url; // Adiciona 'https://' se não existir
                                        }
                                    ?>
                                        <a href="<?= $url ?>" target="_blank" class="break">
                                            <?= htmlspecialchars($row[$selected]) ?>
                                        </a>
                                    <?php } else { ?>
                                        <?= htmlspecialchars($row[$selected]) ?>
                                    <?php } ?>
                                </span>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="mt-3">
                        <button type="submit" name="edit_single" value="<?= $row['id'] ?>" class="btn btn-warning btn-sm" formtarget="_blank">Edit</button> <!-- Botão de edição individual abre em nova aba -->
                        <a href="shortcut_manager.php?delete_id=<?= $row['id'] ?>" onclick="return confirm('Are you sure?')" class="btn btn-danger btn-sm">Delete</a>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        <input type='submit' name='edit' value='Edit Selected' formtarget="_blank" class="btn btn-warning">
        <input type='submit' name='delete' value='Delete Selected' class="btn btn-danger">
    </form>
<?php endif; ?>


<!-- JS para a funcionalidade "Select All" -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    document.getElementById("selectAll").addEventListener("click", function() {
        let checkboxes = document.querySelectorAll('.selectItem');
        for (let checkbox of checkboxes) {
            checkbox.checked = this.checked;
        }
    });
});
</script>

<!-- Optional JavaScript -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</body>
</html>