<?php
// show_exact_change.php - Mostra EXATAMENTE o que mudar
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Mudança Exata para Resolver o Problema</title>
    <style>
        body { font-family: Arial; margin: 20px; line-height: 1.6; }
        .before { background: #ffebee; padding: 20px; border-left: 5px solid #f44336; }
        .after { background: #e8f5e9; padding: 20px; border-left: 5px solid #4caf50; }
        code { background: #f5f5f5; padding: 2px 5px; }
        pre { background: #263238; color: #aed581; padding: 15px; overflow-x: auto; }
        .highlight { background: yellow; font-weight: bold; }
    </style>
</head>
<body>

<h1>🔧 Mudança EXATA para Resolver a Lentidão</h1>

<h2>📍 Localize esta parte no seu arquivo get_pinfeeds.php (aproximadamente linha 55-65):</h2>

<div class="before">
<h3>❌ ANTES (Lento - consulta 787 milhões de registros):</h3>
<pre>
if (!empty($keyword)) {
    $query = $baseQuery . " 
              <span class="highlight">JOIN title_description_index tdi ON f.id = tdi.feed_id</span>
              <span class="highlight">WHERE tdi.word = :keyword</span>
              GROUP BY f.id
              ORDER BY f.id DESC LIMIT :offset, :limit";
    $bindings[':keyword'] = ['value' => <span class="highlight">$keyword</span>, 'type' => PDO::PARAM_STR];
</pre>
</div>

<div class="after">
<h3>✅ DEPOIS (Rápido - evita a tabela gigante):</h3>
<pre>
if (!empty($keyword)) {
    $query = $baseQuery . " 
              <span class="highlight">WHERE (f.title LIKE :keyword OR f.description LIKE :keyword)</span>
              GROUP BY f.id
              ORDER BY f.id DESC LIMIT :offset, :limit";
    $bindings[':keyword'] = ['value' => <span class="highlight">'%' . $keyword . '%'</span>, 'type' => PDO::PARAM_STR];
</pre>
</div>

<h2>📋 Resumo das mudanças:</h2>
<ol>
    <li><strong>Removeu:</strong> A linha com JOIN title_description_index</li>
    <li><strong>Mudou:</strong> WHERE tdi.word = :keyword</li>
    <li><strong>Para:</strong> WHERE (f.title LIKE :keyword OR f.description LIKE :keyword)</li>
    <li><strong>Adicionou %:</strong> No binding, mudou $keyword para '%' . $keyword . '%'</li>
</ol>

<h2>🚀 Por que isso resolve:</h2>
<ul>
    <li>A tabela <code>title_description_index</code> tem <strong>787 MILHÕES</strong> de registros</li>
    <li>O JOIN com essa tabela torna qualquer busca extremamente lenta</li>
    <li>Usar LIKE direto nas colunas é MUITO mais rápido</li>
    <li>Seus testes mostraram: 0.39ms vs 2.49ms (e isso é só o começo)</li>
</ul>

<h2>✅ É só isso! Uma mudança simples que resolve tudo!</h2>

<div style="background: #fff3cd; padding: 20px; margin-top: 20px; border-radius: 5px;">
    <strong>⚠️ IMPORTANTE:</strong> Não mude mais nada! Mantenha todo o resto do arquivo original igual.
    A conexão com o banco, as outras queries, tudo continua funcionando normalmente.
</div>

</body>
</html>