<table class="table table-hover table-striped table-bordered">
    <thead class="thead-dark">
        <tr>
            <th><input type="checkbox" id="selectAll"></th>
            <th>ID</th>
            <th>Website Base</th>
            <th>Website Feed</th>
            <th>Main Category ID</th>
            <th>Subcategory ID</th>
            <th>Subcategory Name</th>
            <th>Subsubcategory ID</th>
            <th>Subsubcategory Name</th>
            <th>Date Added</th>
            <th>Last Updated</th>
            <th>Is Active</th>
            <th>Ação</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($records as $row): ?>
            <tr>
                <td><input type="checkbox" name="selected_ids[]" value="<?php echo $row['id']; ?>"></td>
                <td><?php echo htmlspecialchars($row['id']); ?><input type="hidden" name="ids[]" value="<?php echo $row['id']; ?>"></td>
                <td>
                    <div class="input-group">
                        <input type="text" name="website_bases[]" value="<?php echo htmlspecialchars($row['website_base']); ?>" class="form-control input-wide">
                        <div class="input-group-append">
                            <?php 
                            $websiteBaseLink = (preg_match('/^http[s]?:\/\//', $row['website_base']) ? $row['website_base'] : 'https://' . $row['website_base']); 
                            ?>
                            <a href="<?php echo htmlspecialchars($websiteBaseLink); ?>" target="_blank" class="btn btn-outline-primary"><i class="fas fa-external-link-alt"></i></a>
                        </div>
                    </div>
                </td>
                <td>
                    <div class="input-group">
                        <input type="text" name="website_feeds[]" value="<?php echo htmlspecialchars($row['website_feed']); ?>" class="form-control input-wide">
                        <div class="input-group-append">
                            <a href="<?php echo htmlspecialchars($row['website_feed']); ?>" target="_blank" class="btn btn-outline-primary"><i class="fas fa-external-link-alt"></i></a>
                        </div>
                    </div>
                </td>
                <td><input type="text" name="main_category_ids[]" value="<?php echo htmlspecialchars($row['main_category_id']); ?>" class="form-control input-wide"></td>
                <td><input type="text" name="subcategory_ids[]" value="<?php echo htmlspecialchars($row['subcategory_id']); ?>" class="form-control input-wide"></td>
                <td><input type="text" name="subcategory_names[]" value="<?php echo htmlspecialchars($row['subcategory_name']); ?>" class="form-control input-wide"></td>
                <td><input type="text" name="subsubcategory_ids[]" value="<?php echo htmlspecialchars($row['subsubcategory_id']); ?>" class="form-control input-wide"></td>
                <td><input type="text" name="subsubcategory_names[]" value="<?php echo htmlspecialchars($row['subsubcategory_name']); ?>" class="form-control input-wide"></td>
                <td><input type="datetime-local" name="date_addeds[]" value="<?php echo htmlspecialchars($row['date_added']); ?>" class="form-control input-wide"></td>
                <td><input type="datetime-local" name="last_updateds[]" value="<?php echo htmlspecialchars($row['last_updated']); ?>" class="form-control input-wide"></td>
                <td><input type="checkbox" name="is_actives[]" value="1" <?php echo $row['is_active'] ? 'checked' : ''; ?>></td>
                <td>
                    <button type="submit" name="delete_single" value="<?php echo $row['id']; ?>" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i> Delete</button>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>
<button type="submit" name="update" value="Save Changes" class="btn btn-success"><i class="fas fa-save"></i> Save Changes</button>
<button type="submit" name="delete_selected" value="Delete Selected" class="btn btn-danger"><i class="fas fa-trash"></i> Delete Selected</button>
