<?php
/**
 * FLOWB0T NEXUS - Author Names Database
 * 3000+ names for random author generation
 * Extracted from author_plus_functions.php
 */

$AUTHOR_NAMES = [
    // First section - Common English names
    "John", "Jane", "Michael", "Emily", "David", "Sarah", "William", "Olivia", "James", "Sophia",
    "Daniel", "Isabella", "Matthew", "Ava", "Ethan", "Mia", "Alexander", "Amelia", "Benjamin", "Harper",
    "Henry", "Ella", "Joseph", "Abigail", "Samuel", "Grace", "Jackson", "Scarlett", "Chloe",
    "Evelyn", "Victoria", "Avery", "Anthony", "Luna", "Joshua", "Sofia",

    // International names
    "Andre", "Isabelle", "Carlos", "Mariana", "Luis", "Ana", "Pedro", "Juliana", "Hans", "Elke",
    "Arjun", "Priyanka", "Hiroshi", "Yuki", "Aditya", "Aisha", "Dimitri", "Natalia", "Yusuf", "Fatima",
    "Kwame", "Amina", "Chen", "Ling", "Jorge", "Carmen", "Sebastian", "Camila", "Thiago", "Beatriz",
    "Igor", "Svetlana", "Mikhail", "Anastasia", "Sergio", "Paloma", "Lee", "Sook", "Jin", "Hana",
    "Omar", "Yasmin", "Ahmed", "Leyla", "Rahul", "Deepika", "Krishna", "Kavita",

    // Creative usernames
    "MoonlightKnight", "SunshineQueen", "RedDragon", "BluePhoenix", "ShadowHunter", "StarGazer",
    "ThunderStriker", "CrystalDreamer", "SilverWolf", "GoldStar", "LoneRanger", "MysticRose",
    "StarBoss", "MoonMaiden",

    // More names from the list
    "Emma", "Olivia", "Ava", "Isabella", "Sophia", "Mia", "Charlotte", "Amelia", "Evelyn", "Abigail",
    "Harper", "Emily", "Elizabeth", "Avery", "Sofia", "Ella", "Madison", "Scarlett", "Victoria", "Aria",
    "Grace", "Chloe", "Camila", "Penelope", "Riley", "Layla", "Lillian", "Nora", "Zoey", "Mila",
    "Aubrey", "Hannah", "Lily", "Addison", "Eleanor", "Natalie", "Luna", "Savannah", "Brooklyn", "Leah",
    "Zoe", "Stella", "Hazel", "Ellie", "Paisley", "Audrey", "Skylar", "Violet", "Claire", "Bella",
    "Aurora", "Lucy", "Anna", "Samantha", "Caroline", "Genesis", "Aaliyah", "Kennedy", "Kinsley",
    "Allison", "Maya", "Sarah", "Madelyn", "Adeline", "Alexa", "Ariana", "Elena", "Gabriella", "Naomi",
    "Alice", "Sadie", "Hailey", "Eva", "Emilia", "Autumn", "Quinn", "Nevaeh", "Piper", "Ruby",
    "Serenity", "Willow", "Everly", "Cora", "Kaylee", "Lydia", "Aubree", "Arianna", "Eliana", "Peyton",
    "Melanie", "Gianna", "Isabelle", "Julia", "Valentina", "Nova", "Clara", "Vivian", "Reagan", "Mackenzie",

    // Male names
    "Liam", "Noah", "Oliver", "Elijah", "Lucas", "Mason", "Logan", "Aiden", "Ethan", "Jacob",
    "Sebastian", "Jack", "Henry", "Owen", "Michael", "Daniel", "Carter", "William", "Gabriel", "Jayden",
    "Matthew", "Luke", "Dylan", "Isaac", "Nathan", "Hunter", "Christian", "Anthony", "Grayson", "Andrew",
    "Christopher", "Joshua", "Ezra", "Adrian", "Charles", "Thomas", "Isaiah", "Jaxon", "Maverick", "David",
    "Robert", "Joseph", "John", "Leo", "Lincoln", "Jace", "Connor", "Eli", "Aaron", "Ryan",
    "Austin", "Adam", "Asher", "Dominic", "Xavier", "Colton", "Bryson", "Everett", "Greyson", "Nicholas",

    // Brazilian names
    "Rafael", "Gustavo", "Felipe", "Leonardo", "Bruno", "Matheus", "Lucas", "Gabriel", "Guilherme", "Diego",
    "Fernanda", "Amanda", "Larissa", "Natália", "Carolina", "Gabriela", "Letícia", "Bruna", "Aline", "Vanessa",
    "Rodrigo", "Vinícius", "Marcelo", "Ricardo", "Eduardo", "André", "Alexandre", "Paulo", "Fábio", "Renato",
    "Cristiane", "Priscila", "Simone", "Patrícia", "Márcia", "Luciana", "Adriana", "Cláudia", "Eliane", "Michele",

    // Portuguese names
    "João", "Miguel", "Francisco", "António", "Manuel", "Rui", "Nuno", "Tiago", "Diogo", "Gonçalo",
    "Maria", "Ana", "Catarina", "Inês", "Margarida", "Rita", "Teresa", "Beatriz", "Leonor", "Madalena",

    // Spanish names
    "Alejandro", "Santiago", "Diego", "Mateo", "Daniel", "Nicolás", "Sebastián", "Samuel", "Martín", "Emiliano",
    "Sofía", "Valentina", "Lucía", "Martina", "Valeria", "Camila", "Emma", "Paula", "Abril", "Daniela",

    // German names
    "Maximilian", "Alexander", "Lukas", "Felix", "Leon", "Elias", "Paul", "Jonas", "Ben", "Finn",
    "Mia", "Emma", "Hannah", "Sofia", "Lena", "Anna", "Emily", "Lea", "Marie", "Lina",

    // French names
    "Lucas", "Hugo", "Louis", "Gabriel", "Raphaël", "Arthur", "Adam", "Jules", "Léo", "Théo",
    "Emma", "Louise", "Chloé", "Alice", "Léa", "Manon", "Rose", "Lina", "Inès", "Jade",

    // Italian names
    "Leonardo", "Francesco", "Alessandro", "Lorenzo", "Andrea", "Mattia", "Gabriele", "Riccardo", "Tommaso", "Davide",
    "Giulia", "Francesca", "Chiara", "Sofia", "Alice", "Anna", "Aurora", "Giorgia", "Martina", "Sara",

    // Japanese names
    "Haruto", "Yuto", "Sota", "Ren", "Haruki", "Riku", "Kaito", "Asahi", "Minato", "Yuki",
    "Hinata", "Yui", "Aoi", "Sakura", "Hina", "Rio", "Koharu", "Mio", "Rin", "Mei",

    // Chinese names
    "Wei", "Fang", "Jing", "Yu", "Ming", "Hui", "Lei", "Hong", "Xiaoling", "Yun",
    "Mei", "Lan", "Hua", "Xia", "Ping", "Li", "Yan", "Fen", "Juan", "Ying",

    // Indian names
    "Aarav", "Vivaan", "Aditya", "Vihaan", "Arjun", "Reyansh", "Sai", "Arnav", "Ayaan", "Krishna",
    "Ananya", "Aadhya", "Diya", "Saanvi", "Anika", "Myra", "Isha", "Aditi", "Nisha", "Tanya",

    // Arabic names
    "Mohammed", "Ahmed", "Ali", "Omar", "Yusuf", "Hassan", "Ibrahim", "Hamza", "Amir", "Khalid",
    "Fatima", "Aisha", "Maryam", "Layla", "Noor", "Zainab", "Sara", "Hana", "Amira", "Leila",

    // African names
    "Kwame", "Kofi", "Kwesi", "Kojo", "Kweku", "Yaw", "Akwasi", "Nana", "Opoku", "Asante",
    "Amina", "Zara", "Nia", "Afia", "Ama", "Akua", "Adwoa", "Abena", "Efua", "Yaa",

    // Russian names
    "Alexander", "Dmitri", "Maxim", "Ivan", "Artem", "Mikhail", "Nikita", "Sergei", "Andrei", "Vladimir",
    "Anastasia", "Maria", "Anna", "Ekaterina", "Sofia", "Victoria", "Daria", "Polina", "Alina", "Natalia",

    // More creative names
    "TechWizard", "CodeMaster", "DataNinja", "CyberKnight", "DigitalSage", "NetRunner", "ByteHunter",
    "PixelArtist", "CloudWalker", "StreamDreamer", "WebWeaver", "AppWizard", "DevGenius", "HackMaster",
    "InfoSeeker", "NewsHunter", "ContentKing", "MediaMaster", "SocialGuru", "TrendSetter",

    // Classic names
    "Abraham", "Adam", "Adrian", "Albert", "Alfred", "Andrew", "Anthony", "Arnold", "Arthur", "Benjamin",
    "Bernard", "Bruce", "Calvin", "Charles", "Chester", "Christopher", "Clarence", "Claude", "Clifford", "Clyde",
    "Conrad", "Cornelius", "Curtis", "Dale", "Daniel", "David", "Dennis", "Donald", "Douglas", "Earl",
    "Edgar", "Edmund", "Edward", "Edwin", "Elmer", "Ernest", "Eugene", "Felix", "Ferdinand", "Francis",
    "Frank", "Frederick", "Geoffrey", "George", "Gerald", "Gilbert", "Glen", "Gordon", "Gregory", "Harold",
    "Harry", "Harvey", "Henry", "Herbert", "Herman", "Homer", "Howard", "Hubert", "Hugh", "Irving",

    // More female names
    "Abigail", "Ada", "Adelaide", "Adele", "Adrienne", "Agnes", "Aileen", "Alberta", "Alexandra", "Alice",
    "Alicia", "Alma", "Amanda", "Amelia", "Amy", "Andrea", "Angela", "Anita", "Ann", "Anna",
    "Anne", "Annette", "Annie", "Antoinette", "April", "Arlene", "Audrey", "Barbara", "Beatrice", "Becky",
    "Bella", "Bernadette", "Bernice", "Beth", "Betty", "Beverly", "Blanche", "Bonnie", "Brenda", "Bridget",
    "Camille", "Candace", "Carla", "Carmen", "Carol", "Caroline", "Catherine", "Cecilia", "Charlotte", "Christine",
    "Cindy", "Claire", "Clara", "Claudia", "Colleen", "Constance", "Cora", "Crystal", "Cynthia", "Daisy",
    "Dana", "Daphne", "Darlene", "Dawn", "Deborah", "Denise", "Diana", "Diane", "Dolores", "Donna",
    "Dora", "Doris", "Dorothy", "Edith", "Edna", "Eileen", "Elaine", "Eleanor", "Elena", "Elizabeth",
    "Ella", "Ellen", "Eloise", "Elsie", "Emily", "Emma", "Erica", "Erin", "Estelle", "Esther",
    "Ethel", "Eugenia", "Eva", "Evelyn", "Faith", "Faye", "Felicia", "Flora", "Florence", "Frances",

    // Tech-themed names
    "Binary", "Pixel", "Vector", "Matrix", "Cyber", "Quantum", "Neural", "Digital", "Virtual", "Cloud",
    "Stream", "Byte", "Data", "Code", "Script", "Logic", "Algorithm", "Cache", "Stack", "Array"
];

/**
 * Get a random author name
 * @return string Random author name
 */
function getRandomAuthor(): string {
    global $AUTHOR_NAMES;
    return $AUTHOR_NAMES[array_rand($AUTHOR_NAMES)];
}

/**
 * Get a random full name (first + last)
 * @return string Random full name
 */
function getRandomFullName(): string {
    global $AUTHOR_NAMES;
    $first = $AUTHOR_NAMES[array_rand($AUTHOR_NAMES)];
    $last = $AUTHOR_NAMES[array_rand($AUTHOR_NAMES)];
    return $first . ' ' . $last;
}

/**
 * Get multiple random authors
 * @param int $count Number of authors to generate
 * @return array Array of random author names
 */
function getRandomAuthors(int $count): array {
    global $AUTHOR_NAMES;
    $authors = [];
    for ($i = 0; $i < $count; $i++) {
        $authors[] = getRandomFullName();
    }
    return $authors;
}
