<?php
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    $result = $pdo->query("SHOW COLUMNS FROM feedsplus LIKE 'user_id'");
    $columnExists = $result->rowCount() > 0;

    if (!$columnExists) {
        $sql_add_column = "ALTER TABLE feedsplus ADD COLUMN user_id INT NULL";
        $pdo->exec($sql_add_column);
        echo "Coluna 'user_id' adicionada com sucesso à tabela 'feedsplus'.\n";
    } else {
        echo "Coluna 'user_id' já existe na tabela 'feedsplus'.\n";
    }

    $batchSize = 200;  // Tamanho do lote menor para evitar timeouts
    $offset = 0;
    $totalProcessed = 0;
    $startTime = time();

    $totalRecords = $pdo->query("SELECT COUNT(*) FROM feedsplus WHERE user_id IS NULL")->fetchColumn();

    while (true) {
        // Checar tempo de execução e pausar se necessário
        if (time() - $startTime > ini_get('max_execution_time') - 10) {
            echo "Pausando para evitar timeout. Execute novamente para continuar. Processados até agora: $totalProcessed\n";
            exit; // Termina o script para evitar timeout
        }

        // Inicia uma transação para cada lote
        $pdo->beginTransaction();
        $sql_update_batch = "UPDATE feedsplus SET user_id = NULL WHERE user_id IS NULL LIMIT $batchSize OFFSET $offset";
        $affectedRows = $pdo->exec($sql_update_batch);
        $pdo->commit();

        $totalProcessed += $affectedRows;
        $offset += $batchSize;

        $elapsedTime = time() - $startTime;

        if (($offset / $batchSize) % 10 == 0) {
            echo "Total de registros processados: $totalProcessed / $totalRecords. Tempo decorrido: " . gmdate("H:i:s", $elapsedTime) . "\n";
        }

        if ($affectedRows == 0) break;

        usleep(100000);  // Pausa de 0.1 segundo entre os lotes

        ob_flush();
        flush(); // Para atualização em tempo real do progresso
    }

    if ($totalProcessed == $totalRecords) {
        $sql_add_index = "ALTER TABLE feedsplus ADD INDEX idx_user_id (user_id)";
        $pdo->exec($sql_add_index);
        echo "Índice 'idx_user_id' adicionado com sucesso à coluna 'user_id'.\n";
    }

} catch (PDOException $e) {
    echo "Erro ao modificar a tabela: " . $e->getMessage() . "\n";
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
}
?>
