function loadFeeds() {
    if (!loading) {
        console.log("Iniciando o carregamento dos feeds..."); // Log de debug
        loading = true;
        var searchTerm = $('#search-query').val();
        var timestamp = new Date().getTime();

        $.getJSON('get_feeds.php', { page: page, search: searchTerm, t: timestamp }, function(data) {
            console.log("Dados recebidos:", data); // Verifique os dados recebidos
            feeds = {};
            var allTags = [];

            $.each(data, function(index, feed) {
                feeds[feed.link] = feed;
                var tags = extractTagsFromTitle(feed.title);
                allTags = allTags.concat(tags);
            });

            loading = false;
            if (searchTerm === '') {
                displayFeedsOnlyWithImage();
            } else {
                displayFeeds();
            }
            checkAndLoadMore();

            displayRandomTags(allTags);
        }).fail(function(jqXHR, textStatus, errorThrown) {
            console.error("Erro ao carregar feeds:", textStatus, errorThrown); // Log de erro
            alert('Não foi possível carregar os feeds. Por favor, tente novamente.');
            loading = false;
        });
    }
}