<?php

$xxx_cat = include 'xxx_cat.php';  // Incluindo o arquivo xxx_cat.php
$hardcore_cat = include 'hardcore_cat.php';  // Incluindo o arquivo hardcore_cat.php

// categoryMap.php
$categoryMap = [
'politics' => [
    'title_id' => 1,
    'words' => [
        'election', 'government', 'policy', 'senator', 'campaign', 'vote', 'democracy', 'republican', 'democrat',
        'legislation', 'congress', 'parliament', 'president', 'governor', 'mayor', 'diplomacy', 'lobbying', 
        'referendum', 'minister', 'legislature', 'judiciary', 'bureaucracy', 'council', 'coalition', 'constituency',
        'autonomy', 'federalism', 'monarchy', 'socialism', 'capitalism', 'nationalism', 'communism', 'liberalism',
        'conservatism', 'fascism', 'anarchy', 'ideology', 'constitution', 'cabinet', 'mandate', 'protest', 'ballot',
        'impeachment', 'justice', 'assembly', 'senate', 'house', 'judicial', 'executive', 'sanctions', 'treaty',
        'civil', 'rights', 'equality', 'freedom', 'citizen', 'welfare', 'security', 'immigration', 'reform', 
        'taxation', 'budget', 'spending', 'defense', 'foreign', 'affairs', 'trade', 'sanction', 'subsidy', 'tarriff', 
        'supreme', 'court', 'representation', 'lawmaker', 'dictatorship', 'totalitarianism', 'autocracy', 'plutocracy', 
        'oligarchy', 'populism', 'policy', 'lobbyist', 'resolution', 'embassy', 'international', 'relations', 'war', 
        'détente', 'globalization', 'civil', 'service', 'delegation', 'grassroots', 'majority', 'minority', 'quorum', 
        'recession', 'subcommittee', 'resolution', 'unilateral', 'multilateral', 'peace', 'treaty', 'electioneering', 
        'platform', 'pluralism', 'primaries', 'caucus', 'electorate', 'incumbent', 'swing', 'state', 'electoral', 
        'college', 'bipartisan', 'gerrymandering', 'district', 'policy-making', 'nonpartisan', 'neutrality', 'campaign', 
        'finance', 'lobby', 'pac', 'public', 'opinion', 'polls', 'incumbency', 'term', 'limits', 'executive', 'order', 
        'veto', 'whip', 'majority', 'leader', 'minority', 'leader', 'filibuster', 'immunity', 'seniority', 'committees', 
        'appropriation', 'jurisdiction', 'cloture', 'hearing', 'bipartisanship', 'voter', 'turnout', 'mandate', 'press', 
        'conference', 'grassroots', 'agenda', 'policymaker', 'lawmaking', 'politburo', 'shadow', 'cabinet', 'subsidies',
        'economic', 'policy', 'statecraft', 'realpolitik', 'foreign', 'affairs', 'expansionism', 'imperialism', 
        'militarism', 'national', 'security', 'secretary', 'cabinet', 'minister', 'coalition', 'alliance', 'diplomat',
        'ambassador', 'peacekeeping', 'international', 'law', 'humanitarian', 'aid', 'global', 'governance', 'sovereignty',
        'self-determination', 'veto', 'power', 'sanction', 'embargo', 'foreign', 'policy', 'united', 'nations', 'NATO', 
        'G20', 'G7', 'economic', 'sanctions', 'isolationism', 'military', 'coup', 'war', 'terrorism', 'cybersecurity',
        'strategic', 'alliance', 'covert', 'operations', 'state', 'secrets', 'intelligence', 'agency', 'homeland', 'security', 
        'drone', 'surveillance', 'whistleblower', 'freedom', 'speech', 'freedom', 'assembly', 'civil', 'disobedience',
        'martial', 'law', 'censorship', 'state-owned', 'media', 'propaganda', 'dictatorship', 'regime', 'authoritarian',
        'liberal', 'democracy', 'totalitarian', 'regime', 'opposition', 'dissident', 'amnesty', 'political', 'prisoner',
        'sanctions', 'rebellion', 'civil', 'war', 'revolution', 'insurgency', 'ceasefire', 'arms', 'control', 'missile',
        'launch', 'deterrence', 'proxy', 'war', 'counterinsurgency', 'secession', 'separatism', 'genocide', 'ethnic', 
        'cleansing', 'refugee', 'crisis', 'political', 'asylum', 'international', 'aid', 'human', 'rights', 'NGO', 
        'diplomatic', 'immunity', 'peace', 'accords', 'neutrality', 'defense', 'treaty', 'political', 'neutrality', 
        'foreign', 'intervention', 'peacekeeping', 'international', 'tribunal', 'war', 'crimes', 'humanitarian', 
        'intervention', 'environmental', 'policy', 'climate', 'change', 'sustainability', 'green', 'new', 'deal', 
        'emissions', 'carbon', 'footprint', 'renewable', 'energy', 'paris', 'agreement', 'biodiversity', 'conservation',
        'natural', 'resources', 'environmental', 'justice', 'energy', 'policy', 'fossil', 'fuels', 'oil', 'gas', 'nuclear', 
        'power', 'clean', 'energy', 'wind', 'solar', 'geothermal', 'environmental', 'regulations', 'pollution', 'clean', 
        'air', 'water', 'conservation', 'greenhouse', 'gases', 'wildlife', 'sanctuary', 'urban', 'planning', 'sustainability',
        'environmental', 'impact', 'assessments', 'public', 'transport', 'political', 'philosophy', 'political', 'science', 
        'public', 'administration', 'governance', 'policy', 'analysis', 'comparative', 'politics', 'political', 'theory', 
        'social', 'justice', 'economic', 'theory', 'social', 'science', 'policy', 'implementation', 'international', 
        'relations', 'development', 'studies', 'national', 'development', 'global', 'politics', 'urban', 'development', 
        'human', 'rights', 'global', 'governance'
    ]],
    

'economy' => [
    'title_id' => 2,
    'words' => [
        'growth', 'inflation', 'trade', 'investment', 'industry', 'market', 'revenue', 'taxes', 'jobs',
        'GDP', 'unemployment', 'deficit', 'surplus', 'fiscal', 'policy', 'monetary', 'policy', 'capital', 'budget',
        'debt', 'credit', 'interest', 'rates', 'stock', 'exchange', 'currency', 'foreign', 'exchange', 'bonds', 'commodities',
        'subsidies', 'tariffs', 'import', 'export', 'balance', 'of', 'payments', 'economic', 'growth', 'recession', 'boom',
        'bust', 'consumer', 'spending', 'savings', 'wages', 'income', 'disparity', 'wealth', 'inequality', 'labor', 
        'force', 'participation', 'employment', 'underemployment', 'outsourcing', 'automation', 'productivity', 
        'supply', 'demand', 'aggregate', 'demand', 'aggregate', 'supply', 'cost', 'of', 'living', 'standard', 'of', 'living',
        'purchasing', 'power', 'parity', 'exchange', 'rate', 'financial', 'markets', 'banking', 'system', 'central', 
        'bank', 'federal', 'reserve', 'ECB', 'inflation', 'rate', 'deflation', 'stagflation', 'hyperinflation', 
        'quantitative', 'easing', 'stimulus', 'package', 'fiscal', 'consolidation', 'austerity', 'measures', 'bailout', 
        'sovereign', 'debt', 'debt', 'ceiling', 'trade', 'deficit', 'trade', 'surplus', 'current', 'account', 'balance', 
        'capital', 'account', 'exchange', 'controls', 'capital', 'flight', 'foreign', 'direct', 'investment', 'portfolio', 
        'investment', 'venture', 'capital', 'private', 'equity', 'derivatives', 'hedge', 'funds', 'mutual', 'funds', 
        'pension', 'funds', 'sovereign', 'wealth', 'fund', 'credit', 'default', 'swaps', 'options', 'futures', 'securities',
        'stock', 'market', 'crash', 'bubble', 'asset', 'prices', 'real', 'estate', 'housing', 'market', 'foreclosure', 
        'mortgage', 'interest', 'rates', 'subprime', 'loans', 'lending', 'practices', 'consumer', 'credit', 'bankruptcy', 
        'corporate', 'bankruptcy', 'economic', 'recovery', 'economic', 'downturn', 'business', 'cycle', 'inflation', 'expectations', 
        'disposable', 'income', 'cost-push', 'inflation', 'demand-pull', 'inflation', 'economic', 'planning', 'free', 
        'market', 'economy', 'mixed', 'economy', 'command', 'economy', 'market', 'liberalization', 'privatization', 
        'nationalization', 'public', 'sector', 'private', 'sector', 'informal', 'economy', 'gig', 'economy', 'sharing', 
        'economy', 'shadow', 'economy', 'economic', 'reform', 'tax', 'reform', 'labor', 'market', 'reform', 'financial', 
        'regulation', 'deregulation', 'global', 'economy', 'globalization', 'international', 'trade', 'trade', 'barriers', 
        'WTO', 'free', 'trade', 'agreements', 'NAFTA', 'TPP', 'import', 'quotas', 'export', 'restrictions', 'protectionism', 
        'economic', 'sanctions', 'embargo', 'tariff', 'escalation', 'trade', 'wars', 'competitive', 'devaluation', 
        'currency', 'manipulation', 'exchange', 'rate', 'fluctuations', 'balance', 'of', 'payments', 'trade', 'balance', 
        'terms', 'of', 'trade', 'cross-border', 'capital', 'flows', 'financial', 'globalization', 'international', 
        'capital', 'mobility', 'currency', 'crisis', 'balance', 'of', 'trade', 'global', 'supply', 'chains', 'outsourcing', 
        'offshoring', 'industrial', 'policy', 'state-owned', 'enterprises', 'economic', 'development', 'industrialization', 
        'modernization', 'urbanization', 'rural', 'economy', 'agrarian', 'economy', 'primary', 'sector', 'secondary', 
        'sector', 'tertiary', 'sector', 'quaternary', 'sector', 'service', 'sector', 'manufacturing', 'sector', 'industrial', 
        'production', 'value-added', 'production', 'distribution', 'logistics', 'supply', 'chain', 'management', 'inventory', 
        'management', 'just-in-time', 'production', 'lean', 'production', 'automation', 'robotics', 'AI', 'artificial', 
        'intelligence', 'blockchain', 'cryptocurrency', 'bitcoin', 'ethereum', 'smart', 'contracts', 'digital', 'currency', 
        'fintech', 'financial', 'technology', 'online', 'banking', 'mobile', 'banking', 'peer-to-peer', 'lending', 'crowdfunding', 
        'cryptocurrency', 'exchanges', 'financial', 'services', 'insurance', 'industry', 'actuarial', 'science', 'life', 
        'insurance', 'property', 'and', 'casualty', 'insurance', 'health', 'insurance', 'pension', 'plans', 'retirement', 
        'savings', 'social', 'security', 'pension', 'funds', 'welfare', 'state', 'universal', 'basic', 'income', 'minimum', 
        'wage', 'living', 'wage', 'income', 'inequality', 'wealth', 'distribution', 'progressive', 'taxation', 'regressive', 
        'taxation', 'capital', 'gains', 'tax', 'corporate', 'tax', 'VAT', 'sales', 'tax', 'consumption', 'taxes', 'property', 
        'taxes', 'inheritance', 'tax', 'estate', 'tax', 'tax', 'incentives', 'tax', 'breaks', 'tax', 'havens', 'offshore', 
        'banking', 'tax', 'evasion', 'tax', 'avoidance', 'wealth', 'management', 'financial', 'planning', 'asset', 'allocation', 
        'retirement', 'planning', 'estate', 'planning', 'investment', 'banking', 'retail', 'banking', 'commercial', 'banking', 
        'international', 'banking', 'bank', 'reserves', 'money', 'supply', 'credit', 'creation', 'fractional', 'reserve', 
        'banking', 'deposit', 'insurance', 'interest', 'rate', 'risk', 'credit', 'risk', 'sovereign', 'risk', 'country', 'risk', 
        'hedging', 'risk', 'management', 'portfolio', 'management', 'diversification', 'asset', 'classes', 'fixed', 'income', 
        'equity', 'investments', 'alternative', 'investments', 'venture', 'capital', 'private', 'equity', 'real', 'estate', 
        'investment', 'trusts', 'REITs', 'investment', 'trusts', 'hedge', 'funds', 'mutual', 'funds', 'index', 'funds', 
        'exchange-traded', 'funds', 'ETFs', 'commodities', 'precious', 'metals', 'gold', 'silver', 'oil', 'natural', 'gas', 
        'agriculture', 'futures', 'options', 'derivatives', 'forward', 'contracts', 'swaps', 'credit', 'default', 'swaps', 
        'interest', 'rate', 'swaps', 'currency', 'swaps', 'futures', 'contracts', 'options', 'contracts', 'put', 'option', 
        'call', 'option', 'financial', 'engineering', 'structured', 'finance', 'securitization', 'collateralized', 'debt', 
        'obligations', 'mortgage-backed', 'securities', 'credit-linked', 'notes', 'financial', 'innovations', 'fintech', 
        'peer-to-peer', 'lending', 'crowdfunding', 'blockchain', 'technology', 'decentralized', 'finance', 'DeFi', 'initial', 
        'coin', 'offerings', 'ICOs', 'regulation', 'compliance', 'financial', 'institutions', 'banking', 'regulations', 
        'Basel', 'III', 'capital', 'requirements', 'liquidity', 'ratios', 'stress', 'testing', 'anti-money', 'laundering', 
        'AML', 'know', 'your', 'customer', 'KYC', 'regulations', 'central', 'banks', 'interest', 'rates', 'open', 'market', 
        'operations', 'quantitative', 'easing', 'currency', 'reserves', 'exchange', 'rates', 'devaluation', 'inflation', 
        'control', 'price', 'stability', 'financial', 'stability'
    ]],
    

'education' => [
    'title_id' => 3,
    'words' => [
        'school', 'teacher', 'university', 'curriculum', 'student', 'learning', 'classroom', 'degree', 'knowledge',
        'education', 'system', 'academic', 'achievement', 'lesson', 'syllabus', 'pedagogy', 'instruction', 'assessment', 
        'homework', 'assignment', 'exam', 'test', 'lecture', 'tutorial', 'seminar', 'workshop', 'faculty', 'professor', 
        'lecturer', 'principal', 'dean', 'administrator', 'school', 'board', 'education', 'ministry', 'department', 
        'education', 'policy', 'reform', 'educational', 'standards', 'common', 'core', 'curriculum', 'national', 
        'curriculum', 'teaching', 'methodology', 'child', 'development', 'cognitive', 'development', 'constructivism', 
        'experiential', 'learning', 'early', 'childhood', 'education', 'preschool', 'kindergarten', 'primary', 'school', 
        'secondary', 'school', 'middle', 'school', 'high', 'school', 'post-secondary', 'education', 'higher', 'education', 
        'tertiary', 'education', 'undergraduate', 'graduate', 'postgraduate', 'doctoral', 'education', 'PhD', 'research', 
        'thesis', 'dissertation', 'internship', 'vocational', 'training', 'technical', 'school', 'trade', 'school', 'apprenticeship', 
        'distance', 'learning', 'e-learning', 'online', 'courses', 'MOOC', 'blended', 'learning', 'virtual', 'classroom', 
        'digital', 'literacy', 'STEM', 'science', 'technology', 'engineering', 'mathematics', 'arts', 'humanities', 
        'social', 'sciences', 'physical', 'education', 'sports', 'music', 'art', 'foreign', 'languages', 'second', 
        'language', 'bilingual', 'education', 'multilingual', 'education', 'special', 'education', 'inclusive', 'education', 
        'gifted', 'education', 'learning', 'disabilities', 'dyslexia', 'autism', 'individualized', 'education', 'plan', 
        'IEP', 'standardized', 'testing', 'SAT', 'ACT', 'GRE', 'GMAT', 'entrance', 'exam', 'admissions', 'scholarship', 
        'grant', 'financial', 'aid', 'tuition', 'fees', 'student', 'loans', 'fellowship', 'internships', 'extracurricular', 
        'activities', 'sports', 'clubs', 'student', 'council', 'debate', 'team', 'graduation', 'commencement', 'diploma', 
        'certificate', 'degree', 'transcript', 'alumni', 'honors', 'distinction', 'valedictorian', 'scholarly', 'journals', 
        'peer-reviewed', 'publications', 'research', 'funding', 'academic', 'integrity', 'plagiarism', 'intellectual', 'property', 
        'educational', 'technology', 'smart', 'boards', 'tablets', 'laptops', 'learning', 'management', 'system', 'LMS', 
        'educational', 'software', 'apps', 'adaptive', 'learning', 'gamification', 'interactive', 'learning', 'digital', 
        'textbooks', 'e-books', 'open', 'educational', 'resources', 'OER', 'flipped', 'classroom', 'collaborative', 
        'learning', 'peer', 'learning', 'experiential', 'learning', 'project-based', 'learning', 'problem-based', 'learning', 
        'critical', 'thinking', 'creativity', 'innovation', 'entrepreneurship', 'lifelong', 'learning', 'professional', 
        'development', 'teacher', 'training', 'certification', 'education', 'leadership', 'school', 'management', 
        'educational', 'administration', 'educational', 'psychology', 'child', 'psychology', 'counseling', 'guidance', 
        'counselor', 'mental', 'health', 'in', 'schools', 'bullying', 'prevention', 'anti-bullying', 'measures', 
        'behavioral', 'management', 'classroom', 'management', 'student', 'engagement', 'active', 'learning', 'formative', 
        'assessment', 'summative', 'assessment', 'peer', 'assessment', 'self-assessment', 'feedback', 'continuous', 
        'improvement', 'curriculum', 'development', 'curriculum', 'design', 'educational', 'philosophy', 'Montessori', 
        'Waldorf', 'Reggio', 'Emilia', 'Progressive', 'Education', 'traditional', 'education', 'discipline', 'in', 
        'schools', 'school', 'safety', 'school', 'violence', 'safe', 'school', 'environment', 'anti-discrimination', 
        'policies', 'inclusive', 'education', 'equity', 'in', 'education', 'gender', 'equality', 'cultural', 'competence', 
        'global', 'citizenship', 'education', 'sustainability', 'education', 'environmental', 'education', 'social', 
        'justice', 'education', 'civic', 'education', 'moral', 'education', 'character', 'education', 'sex', 'education', 
        'health', 'education', 'school', 'nutrition', 'school', 'meals', 'physical', 'fitness', 'mental', 'health', 
        'initiatives', 'drug', 'prevention', 'programs', 'literacy', 'reading', 'writing', 'numeracy', 'financial', 
        'literacy', 'media', 'literacy', 'digital', 'literacy', 'scientific', 'literacy', 'critical', 'thinking', 
        'skills', '21st', 'century', 'skills', 'collaboration', 'problem-solving', 'communication', 'empathy', 
        'emotional', 'intelligence', 'self-regulation', 'resilience', 'growth', 'mindset', 'educational', 'research', 
        'educational', 'statistics', 'data', 'analytics', 'in', 'education', 'evidence-based', 'practices', 'pedagogical', 
        'theories', 'learning', 'theories', 'constructivism', 'behaviorism', 'cognitivism', 'socio-cultural', 'theory', 
        'multiple', 'intelligences', 'differentiated', 'instruction', 'personalized', 'learning', 'inclusive', 'teaching', 
        'methods', 'multi-tiered', 'systems', 'of', 'support', 'MTSS', 'response', 'to', 'intervention', 'RTI', 'universal', 
        'design', 'for', 'learning', 'UDL', 'scaffolding', 'zone', 'of', 'proximal', 'development', 'experiential', 
        'learning', 'peer', 'tutoring', 'mentoring', 'cooperative', 'learning', 'independent', 'study', 'project-based', 
        'learning', 'flipped', 'classroom', 'service', 'learning', 'internships', 'study', 'abroad', 'cultural', 'exchange', 
        'programs', 'exchange', 'students', 'Erasmus', 'scholarships', 'global', 'education', 'education', 'for', 
        'sustainable', 'development', 'lifelong', 'learning', 'adult', 'education', 'continuing', 'education', 'professional', 
        'education', 'skills', 'training', 'vocational', 'education', 'technical', 'education', 'work-based', 'learning', 
        'career', 'and', 'technical', 'education', 'CTE', 'STEM', 'education', 'STEAM', 'education', 'arts', 'in', 
        'education', 'arts', 'integration', 'creative', 'thinking', 'design', 'thinking', 'entrepreneurship', 'education', 
        'digital', 'transformation', 'in', 'education', 'remote', 'learning', 'virtual', 'classrooms', 'blended', 
        'learning', 'inclusive', 'pedagogy', 'educational', 'equity', 'social', 'justice', 'in', 'education'
    ]],
    
    
'health' => [
    'title_id' => 4,
    'words' => [
        'hospital', 'doctor', 'medicine', 'disease', 'vaccine', 'treatment', 'healthcare', 'nurse', 'clinic',
        'diagnosis', 'symptoms', 'prevention', 'surgery', 'pharmacy', 'therapist', 'emergency', 'care', 'intensive', 
        'care', 'ICU', 'pediatrics', 'geriatrics', 'primary', 'care', 'specialist', 'general', 'practitioner', 'GP', 
        'medical', 'records', 'patient', 'history', 'check-up', 'blood', 'pressure', 'heart', 'rate', 'cholesterol', 
        'diabetes', 'hypertension', 'cardiology', 'oncology', 'dermatology', 'neurology', 'gastroenterology', 'psychiatry', 
        'psychology', 'mental', 'health', 'physical', 'therapy', 'rehabilitation', 'occupational', 'therapy', 'speech', 
        'therapy', 'orthopedics', 'radiology', 'imaging', 'MRI', 'CT', 'scan', 'X-ray', 'ultrasound', 'biopsy', 'chemotherapy', 
        'radiation', 'therapy', 'immunotherapy', 'hormone', 'therapy', 'clinical', 'trial', 'genetics', 'genetic', 
        'testing', 'family', 'history', 'immunization', 'public', 'health', 'pandemic', 'epidemic', 'infection', 
        'contagion', 'pathogen', 'virus', 'bacteria', 'fungus', 'parasite', 'antibiotic', 'antiviral', 'antifungal', 
        'antiparasitic', 'resistance', 'immune', 'system', 'autoimmune', 'disorder', 'allergy', 'anaphylaxis', 'chronic', 
        'illness', 'acute', 'care', 'palliative', 'care', 'end-of-life', 'care', 'hospice', 'pain', 'management', 'anesthesia', 
        'analgesic', 'sedation', 'surgical', 'procedure', 'minimally', 'invasive', 'laparoscopy', 'robotic', 'surgery', 
        'transplant', 'organ', 'donation', 'dialysis', 'renal', 'failure', 'cardiac', 'arrest', 'stroke', 'heart', 'attack', 
        'respiratory', 'failure', 'pulmonary', 'disease', 'asthma', 'bronchitis', 'COPD', 'lung', 'cancer', 'pneumonia', 
        'tuberculosis', 'hepatitis', 'liver', 'cirrhosis', 'jaundice', 'kidney', 'stones', 'urinary', 'tract', 'infection', 
        'UTI', 'bladder', 'infection', 'prostate', 'cancer', 'testicular', 'cancer', 'breast', 'cancer', 'mammogram', 
        'mastectomy', 'lumpectomy', 'biopsy', 'cervical', 'cancer', 'ovarian', 'cancer', 'uterine', 'fibroids', 'pregnancy', 
        'prenatal', 'care', 'labor', 'delivery', 'cesarean', 'section', 'C-section', 'miscarriage', 'abortion', 'birth', 
        'control', 'contraception', 'fertility', 'IVF', 'in', 'vitro', 'fertilization', 'infertility', 'menstruation', 
        'menopause', 'gynecology', 'obstetrics', 'midwife', 'pediatrician', 'childbirth', 'newborn', 'infant', 'immunizations', 
        'well-baby', 'check', 'growth', 'charts', 'developmental', 'milestones', 'vaccination', 'booster', 'shots', 
        'herd', 'immunity', 'infectious', 'disease', 'immunology', 'epidemiology', 'health', 'insurance', 'medicare', 
        'medicaid', 'affordable', 'care', 'act', 'ACA', 'universal', 'healthcare', 'single-payer', 'system', 'private', 
        'insurance', 'deductibles', 'copay', 'premium', 'out-of-pocket', 'expenses', 'prescription', 'drugs', 'medication', 
        'side', 'effects', 'drug', 'interaction', 'overdose', 'substance', 'abuse', 'opioid', 'addiction', 'rehabilitation', 
        'support', 'group', 'counseling', 'psychotherapy', 'cognitive', 'behavioral', 'therapy', 'CBT', 'dialectical', 
        'behavior', 'therapy', 'DBT', 'group', 'therapy', 'family', 'therapy', 'marriage', 'counseling', 'meditation', 
        'mindfulness', 'relaxation', 'techniques', 'stress', 'management', 'nutrition', 'dietitian', 'obesity', 'weight', 
        'loss', 'bariatric', 'surgery', 'gastric', 'bypass', 'lap', 'band', 'sleep', 'apnea', 'insomnia', 'narcolepsy', 
        'sleep', 'disorders', 'circadian', 'rhythm', 'melatonin', 'vitamin', 'deficiency', 'supplements', 'nutrition', 
        'exercise', 'physical', 'fitness', 'cardio', 'strength', 'training', 'flexibility', 'yoga', 'pilates', 'aerobics', 
        'personal', 'trainer', 'sports', 'medicine', 'sports', 'injuries', 'ACL', 'tear', 'meniscus', 'tear', 'tendonitis', 
        'sprain', 'strain', 'fracture', 'dislocation', 'concussion', 'brain', 'injury', 'rehabilitation', 'neurological', 
        'disorders', 'Alzheimer’s', 'disease', 'Parkinson’s', 'disease', 'multiple', 'sclerosis', 'ALS', 'Lou', 'Gehrig’s', 
        'disease', 'dementia', 'memory', 'loss', 'cognitive', 'decline', 'brain', 'tumor', 'seizures', 'epilepsy', 
        'cerebral', 'palsy', 'autism', 'spectrum', 'disorder', 'Down', 'syndrome', 'developmental', 'disabilities', 
        'ADHD', 'attention', 'deficit', 'disorder', 'learning', 'disabilities', 'mental', 'illness', 'bipolar', 'disorder', 
        'schizophrenia', 'anxiety', 'disorders', 'depression', 'seasonal', 'affective', 'disorder', 'post-traumatic', 
        'stress', 'disorder', 'PTSD', 'phobias', 'panic', 'attacks', 'obsessive-compulsive', 'disorder', 'OCD', 
        'self-harm', 'suicidal', 'thoughts', 'suicide', 'prevention', 'crisis', 'hotline', 'support', 'groups', 'hospice', 
        'care', 'grief', 'counseling', 'bereavement', 'end-of-life', 'care', 'advanced', 'directives', 'living', 'will', 
        'medical', 'power', 'of', 'attorney', 'organ', 'donation', 'tissue', 'donation', 'blood', 'transfusion', 'plasma', 
        'therapy', 'stem', 'cell', 'therapy', 'gene', 'therapy', 'regenerative', 'medicine', 'prosthetics', 'assistive', 
        'devices', 'wheelchairs', 'hearing', 'aids', 'glasses', 'contacts', 'vision', 'correction', 'surgery', 'LASIK', 
        'cataracts', 'glaucoma', 'macular', 'degeneration', 'retinal', 'detachment', 'hearing', 'loss', 'cochlear', 'implants', 
        'speech', 'therapy', 'sign', 'language', 'deaf', 'community', 'accessible', 'healthcare', 'telemedicine', 'remote', 
        'monitoring', 'wearable', 'devices', 'smartwatches', 'heart', 'monitors', 'fitness', 'trackers', 'electronic', 
        'health', 'records', 'EHR', 'telehealth', 'virtual', 'care', 'home', 'care', 'long-term', 'care', 'assisted', 'living', 
        'nursing', 'home', 'geriatric', 'care', 'pediatric', 'care', 'women’s', 'health', 'men’s', 'health', 'sexual', 
        'health', 'reproductive', 'health', 'family', 'planning', 'STD', 'prevention', 'HIV', 'AIDS', 'hepatitis', 'vaccination', 
        'HPV', 'screening', 'tests', 'Pap', 'smear', 'mammogram', 'prostate', 'exam', 'colonoscopy', 'preventive', 
        'care', 'annual', 'checkup', 'wellness', 'programs', 'holistic', 'health', 'alternative', 'medicine', 'acupuncture', 
        'chiropractic', 'care', 'herbal', 'supplements', 'aromatherapy', 'mind-body', 'medicine', 'integrative', 'medicine'
    ]],
    
    
'technology' => [
    'title_id' => 5,
    'words' => [
        'AI', 'blockchain', 'cybersecurity', 'innovation', 'robotics', 'software', 'hardware', 'cloud', 'data',
        'machine', 'learning', 'deep', 'learning', 'neural', 'networks', 'automation', 'artificial', 'intelligence', 
        'algorithms', 'data', 'science', 'big', 'data', 'IoT', 'internet', 'of', 'things', 'augmented', 'reality', 
        'virtual', 'reality', 'mixed', 'reality', 'wearables', 'smart', 'devices', '5G', 'wireless', 'networks', 
        'mobile', 'technology', 'smartphones', 'tablets', 'laptops', 'PCs', 'servers', 'data', 'centers', 'virtualization', 
        'edge', 'computing', 'quantum', 'computing', 'quantum', 'processors', 'distributed', 'systems', 'cryptocurrency', 
        'bitcoin', 'ethereum', 'smart', 'contracts', 'NFTs', 'non-fungible', 'tokens', 'digital', 'currencies', 
        'decentralized', 'finance', 'DeFi', 'encryption', 'public', 'key', 'private', 'key', 'firewalls', 'antivirus', 
        'malware', 'ransomware', 'phishing', 'hacking', 'ethical', 'hacking', 'penetration', 'testing', 'vulnerability', 
        'assessment', 'threat', 'detection', 'incident', 'response', 'data', 'breaches', 'zero-day', 'exploits', 
        'DDoS', 'attacks', 'botnets', 'endpoint', 'security', 'SIEM', 'security', 'information', 'and', 'event', 
        'management', 'forensics', 'encryption', 'blockchain', 'nodes', 'mining', 'hashing', 'tokens', 'smart', 'contracts', 
        'consensus', 'protocol', 'proof', 'of', 'work', 'proof', 'of', 'stake', 'validators', 'decentralized', 'applications', 
        'dApps', 'cloud', 'computing', 'SaaS', 'PaaS', 'IaaS', 'public', 'cloud', 'private', 'cloud', 'hybrid', 'cloud', 
        'multicloud', 'containers', 'Kubernetes', 'Docker', 'CI/CD', 'DevOps', 'serverless', 'architecture', 'microservices', 
        'API', 'integrations', 'REST', 'APIs', 'GraphQL', 'web', 'development', 'frontend', 'backend', 'full-stack', 
        'HTML', 'CSS', 'JavaScript', 'React', 'Angular', 'Vue.js', 'Node.js', 'PHP', 'Python', 'Ruby', 'Java', 'C++', 
        'C#', 'Swift', 'Kotlin', 'Go', 'Rust', 'TypeScript', 'SQL', 'NoSQL', 'databases', 'relational', 'databases', 
        'MySQL', 'PostgreSQL', 'SQLite', 'Oracle', 'MongoDB', 'Cassandra', 'Redis', 'memcached', 'data', 'warehousing', 
        'ETL', 'data', 'pipelines', 'data', 'lakes', 'data', 'migration', 'APIs', 'RESTful', 'services', 'SOAP', 'XML', 
        'JSON', 'AJAX', 'WebSockets', 'HTTP', 'HTTPS', 'OAuth', 'SAML', 'authentication', 'authorization', 'SSL', 'TLS', 
        'cryptography', 'hash', 'functions', 'block', 'cipher', 'symmetric', 'encryption', 'asymmetric', 'encryption', 
        'digital', 'certificates', 'PKI', 'public', 'key', 'infrastructure', 'SSL', 'certificates', 'TLS', 'handshake', 
        'password', 'management', 'multi-factor', 'authentication', 'MFA', 'single', 'sign-on', 'SSO', 'biometrics', 
        'fingerprint', 'scanners', 'facial', 'recognition', 'voice', 'recognition', 'speech', 'processing', 'NLP', 
        'natural', 'language', 'processing', 'chatbots', 'virtual', 'assistants', 'conversational', 'AI', 'voice', 
        'assistants', 'Amazon', 'Alexa', 'Google', 'Assistant', 'Apple', 'Siri', 'home', 'automation', 'smart', 
        'homes', 'smart', 'thermostats', 'smart', 'lighting', 'smart', 'appliances', 'smart', 'speakers', 'voice-activated', 
        'controls', 'wearable', 'tech', 'smartwatches', 'fitness', 'trackers', 'health', 'monitoring', 'sensors', 
        'biometric', 'sensors', 'motion', 'tracking', 'GPS', 'location-based', 'services', 'mapping', 'technologies', 
        'GIS', 'geospatial', 'analysis', 'drones', 'unmanned', 'aerial', 'vehicles', 'UAVs', 'autonomous', 'vehicles', 
        'self-driving', 'cars', 'autonomous', 'robots', 'robotic', 'process', 'automation', 'RPA', 'machine', 'vision', 
        'image', 'recognition', 'facial', 'recognition', 'object', 'detection', '3D', 'printing', 'additive', 'manufacturing', 
        'CNC', 'machining', 'industrial', 'automation', 'IoT', 'sensors', 'smart', 'factories', 'smart', 'manufacturing', 
        'predictive', 'maintenance', 'supply', 'chain', 'management', 'logistics', 'tracking', 'blockchain', 'traceability', 
        'digital', 'twins', 'augmented', 'reality', 'AR', 'virtual', 'reality', 'VR', 'mixed', 'reality', 'MR', 'holograms', 
        '3D', 'modelling', '3D', 'scanning', 'computer-aided', 'design', 'CAD', 'computer-aided', 'manufacturing', 'CAM', 
        'engineering', 'design', 'prototyping', 'simulation', 'high-performance', 'computing', 'supercomputers', 'cloud', 
        'gaming', 'game', 'development', 'game', 'engines', 'Unity', 'Unreal', 'Engine', 'VR', 'games', 'AR', 'games', 
        'mobile', 'games', 'indie', 'games', 'AI', 'in', 'gaming', 'procedural', 'generation', 'game', 'AI', 'character', 
        'animation', 'physics', 'engines', 'ray', 'tracing', 'real-time', 'rendering', 'digital', 'effects', 'VFX', 
        'post-production', 'video', 'editing', 'audio', 'editing', 'sound', 'design', 'motion', 'capture', 'digital', 
        'art', 'concept', 'art', '3D', 'animation', '2D', 'animation', 'game', 'graphics', 'GPU', 'graphics', 'processing', 
        'units', 'NVIDIA', 'AMD', 'ray', 'tracing', 'real-time', 'rendering', 'simulation', 'cloud-based', 'rendering', 
        'distributed', 'computing', 'grid', 'computing', 'high-performance', 'computing', 'HPC', 'quantum', 'algorithms', 
        'quantum', 'supremacy', 'quantum', 'encryption', 'quantum', 'key', 'distribution', 'QKD', 'quantum', 'computing', 
        'for', 'AI', 'biotechnology', 'bioinformatics', 'genomics', 'DNA', 'sequencing', 'CRISPR', 'gene', 'editing', 
        'biopharmaceuticals', 'personalized', 'medicine', 'biomedical', 'engineering', 'prosthetics', 'biomaterials', 
        'nanotechnology', 'nanorobots', 'biodevices', 'biosensors', 'synthetic', 'biology', 'genetic', 'engineering', 
        'biomanufacturing', 'pharmaceutical', 'innovation', 'drug', 'discovery', 'AI-powered', 'drug', 'development', 
        'biomedical', 'data', 'analysis', 'precision', 'medicine', 'bioinformatics', 'genomic', 'data', 'AI', 'in', 
        'healthcare', 'AI', 'diagnosis', 'machine', 'learning', 'for', 'drug', 'development', 'AI', 'in', 'surgery', 
        'robot-assisted', 'surgery', 'telemedicine', 'virtual', 'healthcare', 'AI-powered', 'medical', 'devices', 'wearable', 
        'medical', 'technology', 'biometric', 'sensors', 'remote', 'patient', 'monitoring', 'digital', 'healthcare', 
        'apps', 'healthcare', 'analytics', 'big', 'data', 'in', 'medicine', 'AI-powered', 'healthcare', 'AI', 'diagnosis', 
        'biotech', 'startups', 'medical', 'innovation', 'robotic', 'surgery'
    ]],
    
    
'sports' => [
    'title_id' => 6,
    'words' => [
        'soccer', 'basketball', 'tennis', 'athlete', 'team', 'tournament', 'coach', 'goal', 'victory',
        'football', 'baseball', 'hockey', 'golf', 'swimming', 'running', 'track', 'field', 'marathon', 'triathlon',
        'cycling', 'rugby', 'cricket', 'volleyball', 'badminton', 'squash', 'ping', 'pong', 'wrestling', 'boxing',
        'MMA', 'mixed', 'martial', 'arts', 'karate', 'judo', 'taekwondo', 'kickboxing', 'weightlifting', 'bodybuilding',
        'gymnastics', 'cheerleading', 'rowing', 'canoeing', 'kayaking', 'surfing', 'sailing', 'fishing', 'diving',
        'archery', 'shooting', 'fencing', 'billiards', 'snooker', 'chess', 'eSports', 'video', 'games', 'skiing', 'snowboarding',
        'ice', 'skating', 'figure', 'skating', 'speed', 'skating', 'hiking', 'mountaineering', 'rock', 'climbing', 'bouldering',
        'parkour', 'freerunning', 'motorsports', 'Formula', 'One', 'NASCAR', 'MotoGP', 'endurance', 'racing', 'karting',
        'drag', 'racing', 'rally', 'drifting', 'off-road', 'cycling', 'mountain', 'biking', 'BMX', 'skateboarding', 'rollerblading',
        'ice', 'hockey', 'field', 'hockey', 'lacrosse', 'softball', 'water', 'polo', 'diving', 'synchronized', 'swimming',
        'water', 'skiing', 'wakeboarding', 'windsurfing', 'kitesurfing', 'paragliding', 'skydiving', 'bungee', 'jumping',
        'parasailing', 'hang', 'gliding', 'free', 'diving', 'scuba', 'diving', 'spearfishing', 'underwater', 'hockey', 'jet', 'skiing',
        'snowmobile', 'sledding', 'luge', 'bobsledding', 'skeleton', 'curling', 'biathlon', 'cross-country', 'skiing', 'nordic', 'combined',
        'athletics', 'pole', 'vault', 'high', 'jump', 'long', 'jump', 'triple', 'jump', 'discus', 'throw', 'javelin', 'hammer', 'throw',
        'shot', 'put', 'decathlon', 'heptathlon', 'pentathlon', 'steeplechase', 'relay', 'race', 'sprint', 'hurdles', 'middle', 'distance',
        'long', 'distance', 'ultramarathon', 'trail', 'running', 'cross-country', 'running', 'racewalking', 'powerlifting', 'strongman',
        'CrossFit', 'functional', 'fitness', 'highland', 'games', 'sumo', 'wrestling', 'Muay', 'Thai', 'Brazilian', 'Jiu-Jitsu', 'futsal',
        'street', 'soccer', 'beach', 'soccer', 'beach', 'volleyball', 'ultimate', 'frisbee', 'dodgeball', 'handball', 'footgolf', 'teqball',
        'paddle', 'tennis', 'padel', 'pickleball', 'racquetball', 'squash', 'table', 'tennis', 'floorball', 'bandy', 'speedball', 'shinty',
        'gaelic', 'football', 'hurling', 'camogie', 'rounders', 'bocce', 'pétanque', 'lawn', 'bowls', 'boules', 'croquet', 'horseback', 'riding',
        'equestrian', 'dressage', 'show', 'jumping', 'eventing', 'rodeo', 'barrel', 'racing', 'bull', 'riding', 'calf', 'roping', 'steer', 'wrestling',
        'polo', 'polo', 'cross', 'gymkhana', 'endurance', 'riding', 'chariot', 'racing', 'draft', 'horse', 'competitions', 'dog', 'sports', 'agility',
        'obedience', 'flyball', 'dog', 'sledding', 'field', 'trials', 'herding', 'competitions', 'greyhound', 'racing', 'canicross', 'disc', 'dog',
        'sports', 'powerboating', 'offshore', 'racing', 'rowing', 'canoe', 'sprint', 'canoe', 'slalom', 'rowing', 'crew', 'rowing', 'regatta',
        'ergo', 'rowing', 'rowing', 'machines', 'Dragon', 'boat', 'racing', 'outrigger', 'canoeing', 'rafting', 'whitewater', 'kayaking', 'canoeing',
        'flatwater', 'kayaking', 'surf', 'skiing', 'sailing', 'yachting', 'windsurfing', 'kitesurfing', 'paragliding', 'flying', 'disc', 'ultimate',
        'disc', 'golf', 'frisbee', 'golf', 'fly', 'casting', 'competitive', 'fishing', 'bass', 'fishing', 'sport', 'fishing', 'deep', 'sea', 'fishing',
        'kite', 'flying', 'kite', 'boarding', 'sandboarding', 'snowkiting', 'air', 'sports', 'wingsuit', 'flying', 'parachuting', 'skydiving', 'base', 'jumping',
        'hot', 'air', 'ballooning', 'parascending', 'paragliding', 'hang', 'gliding', 'model', 'airplane', 'competitions', 'drone', 'racing', 'drone',
        'competitions', 'eSports', 'video', 'gaming', 'tournaments', 'live', 'streaming', 'competitive', 'gaming', 'fighting', 'games', 'first-person',
        'shooter', 'MOBA', 'multiplayer', 'online', 'battle', 'arena', 'strategy', 'games', 'racing', 'games', 'sports', 'games', 'football', 'manager',
        'simulators', 'pro', 'wrestling', 'WWE', 'AEW', 'kickball', 'rounders', 'kabaddi', 'Sepak', 'Takraw', 'pelota', 'vasca', 'jai', 'alai', 'padel'
    ]],
    
    
'entertainment' => [
    'title_id' => 7,
    'words' => [
        'movie', 'music', 'festival', 'celebrity', 'director', 'actor', 'show', 'drama', 'award',
        'comedy', 'musical', 'documentary', 'thriller', 'horror', 'animation', 'sitcom', 'reality', 'TV', 
        'game', 'show', 'variety', 'talk', 'show', 'soap', 'opera', 'series', 'mini-series', 'episode', 
        'season', 'pilot', 'finale', 'screenwriter', 'producer', 'cinematographer', 'editor', 'costume', 
        'designer', 'set', 'designer', 'makeup', 'artist', 'stunt', 'double', 'casting', 'crew', 'cinematography', 
        'screenplay', 'script', 'adaptation', 'pre-production', 'post-production', 'soundtrack', 'score', 
        'theme', 'song', 'composer', 'conductor', 'orchestra', 'choreography', 'dance', 'performer', 
        'Broadway', 'off-Broadway', 'theater', 'play', 'stage', 'musical', 'opera', 'ballet', 'concert', 
        'live', 'performance', 'tour', 'gig', 'album', 'single', 'hit', 'chart', 'Billboard', 'top', '100', 
        'Grammy', 'Oscars', 'Academy', 'Awards', 'Golden', 'Globes', 'Emmy', 'Tony', 'MTV', 'VMA', 'Cannes', 
        'Film', 'Festival', 'Sundance', 'Film', 'Festival', 'Venice', 'Film', 'Festival', 'Berlin', 'Film', 'Festival', 
        'Tribeca', 'Film', 'Festival', 'screening', 'premiere', 'red', 'carpet', 'box', 'office', 'blockbuster', 
        'independent', 'film', 'indie', 'film', 'short', 'film', 'feature', 'film', 'film', 'studio', 'Hollywood', 
        'Bollywood', 'cinema', 'motion', 'pictures', 'visual', 'effects', 'special', 'effects', 'CGI', '3D', 'IMAX', 
        'digital', 'animation', 'stop-motion', 'claymation', 'voice', 'acting', 'dub', 'subtitles', 'foreign', 
        'language', 'film', 'classic', 'film', 'silent', 'film', 'black-and-white', 'film', 'cult', 'classic', 'streaming', 
        'service', 'Netflix', 'Hulu', 'Amazon', 'Prime', 'Video', 'Disney+', 'HBO', 'Max', 'Peacock', 'Paramount+', 
        'YouTube', 'Vimeo', 'live', 'stream', 'web', 'series', 'vlogger', 'influencer', 'social', 'media', 
        'TikTok', 'Instagram', 'Snapchat', 'Twitter', 'Facebook', 'content', 'creator', 'viral', 'video', 'memes', 
        'fan', 'culture', 'fandom', 'comic', 'books', 'graphic', 'novels', 'superheroes', 'Marvel', 'DC', 'Cosplay', 
        'conventions', 'Comic-Con', 'fan', 'fiction', 'fan', 'art', 'remake', 'reboot', 'sequel', 'prequel', 'spin-off', 
        'franchise', 'binge-watch', 'cliffhanger', 'plot', 'twist', 'character', 'development', 'ensemble', 'cast', 
        'leading', 'role', 'supporting', 'actor', 'cameo', 'guest', 'appearance', 'award', 'show', 'red', 'carpet', 
        'paparazzi', 'interview', 'talk', 'show', 'late', 'night', 'talk', 'show', 'variety', 'show', 'game', 'show', 
        'quiz', 'show', 'reality', 'competition', 'talent', 'show', 'singing', 'competition', 'dance', 'competition', 
        'cooking', 'show', 'celebrity', 'chef', 'judges', 'panel', 'host', 'presenter', 'co-host', 'voiceover', 'narrator', 
        'trailer', 'teaser', 'behind-the-scenes', 'bonus', 'features', 'director’s', 'cut', 'extended', 'edition', 
        'deleted', 'scenes', 'bloopers', 'gag', 'reel', 'merchandise', 'collectibles', 'fan', 'merch', 'autographs', 
        'meet-and-greet', 'comic', 'conventions', 'fan', 'events', 'Q&A', 'session', 'backstage', 'pass', 'VIP', 
        'ticket', 'ticket', 'scalping', 'box', 'office', 'sales', 'opening', 'weekend', 'cinematic', 'universe', 
        'character', 'arc', 'origin', 'story', 'hero', 'villain', 'anti-hero', 'sidekick', 'love', 'interest', 'mentor', 
        'antagonist', 'protagonist', 'plot', 'subplot', 'storyline', 'narrative', 'setting', 'theme', 'genre', 'action', 
        'adventure', 'romance', 'mystery', 'crime', 'noir', 'suspense', 'spy', 'film', 'war', 'film', 'epic', 'fantasy', 
        'sci-fi', 'science', 'fiction', 'dystopian', 'post-apocalyptic', 'steampunk', 'cyberpunk', 'fairy', 'tale', 
        'historical', 'fiction', 'biographical', 'film', 'biopic', 'documentary', 'docuseries', 'mockumentary', 
        'satire', 'parody', 'spoof', 'musical', 'theater', 'Broadway', 'West', 'End', 'stage', 'production', 'cast', 
        'ensemble', 'solo', 'performance', 'chorus', 'ensemble', 'musicians', 'orchestra', 'band', 'concert', 'tour', 
        'music', 'festival', 'headliner', 'opening', 'act', 'encore', 'set', 'list', 'album', 'release', 'recording', 
        'studio', 'live', 'album', 'EP', 'single', 'music', 'video', 'chart', 'toppers', 'pop', 'rock', 'hip-hop', 'rap', 
        'jazz', 'classical', 'EDM', 'electronic', 'dance', 'music', 'dubstep', 'techno', 'house', 'indie', 'alternative', 
        'folk', 'country', 'blues', 'reggae', 'metal', 'punk', 'R&B', 'soul', 'opera', 'orchestra', 'conductor', 'composer', 
        'lyrics', 'lyricist', 'songwriter', 'producer', 'record', 'label', 'Grammy', 'Awards', 'Billboard', 'Music', 
        'Awards', 'MTV', 'Video', 'Music', 'Awards', 'live', 'streaming', 'platform', 'music', 'festivals', 'Coachella', 
        'Glastonbury', 'SXSW', 'Bonnaroo', 'Burning', 'Man', 'Lollapalooza', 'Ultra', 'Music', 'Festival', 'iHeartRadio', 
        'Jingle', 'Ball', 'awards', 'show', 'red', 'carpet', 'interviews', 'press', 'junket', 'entertainment', 'news'
    ]],
    
    
'environment' => [
    'title_id' => 8,
    'words' => [
        'climate', 'sustainability', 'energy', 'pollution', 'recycling', 'green', 'wildlife', 'conservation', 'biodiversity',
        'global', 'warming', 'climate', 'change', 'carbon', 'footprint', 'carbon', 'emissions', 'fossil', 'fuels', 
        'renewable', 'energy', 'solar', 'power', 'wind', 'power', 'hydropower', 'geothermal', 'biomass', 'energy', 
        'electric', 'vehicles', 'EVs', 'energy', 'efficiency', 'clean', 'energy', 'low-carbon', 'technologies', 
        'carbon', 'capture', 'carbon', 'offsets', 'carbon', 'neutrality', 'net-zero', 'emissions', 'deforestation', 
        'reforestation', 'afforestation', 'forest', 'management', 'ecosystem', 'restoration', 'habitat', 'destruction', 
        'land', 'degradation', 'desertification', 'soil', 'erosion', 'wetlands', 'preservation', 'ocean', 'acidification', 
        'sea', 'level', 'rise', 'glacier', 'melting', 'Arctic', 'ice', 'loss', 'marine', 'ecosystems', 'coral', 'reefs', 
        'marine', 'protected', 'areas', 'MPAs', 'overfishing', 'bycatch', 'sustainable', 'fishing', 'aquaculture', 
        'fish', 'farming', 'ocean', 'pollution', 'plastic', 'waste', 'microplastics', 'water', 'pollution', 'air', 
        'pollution', 'smog', 'acid', 'rain', 'ozone', 'depletion', 'greenhouse', 'gases', 'methane', 'emissions', 
        'nitrous', 'oxide', 'emissions', 'industrial', 'pollution', 'toxic', 'waste', 'hazardous', 'waste', 'e-waste', 
        'electronic', 'waste', 'chemical', 'spills', 'oil', 'spills', 'pesticides', 'herbicides', 'deforestation', 
        'illegal', 'logging', 'wildfires', 'forest', 'fires', 'fire', 'prevention', 'water', 'scarcity', 'drought', 
        'desalination', 'rainwater', 'harvesting', 'water', 'conservation', 'sustainable', 'agriculture', 'organic', 
        'farming', 'permaculture', 'crop', 'rotation', 'cover', 'crops', 'composting', 'soil', 'health', 'agroforestry', 
        'urban', 'farming', 'food', 'security', 'food', 'waste', 'sustainable', 'food', 'systems', 'farm-to-table', 
        'local', 'food', 'movements', 'sustainable', 'forestry', 'wildlife', 'conservation', 'endangered', 'species', 
        'poaching', 'illegal', 'wildlife', 'trade', 'habitat', 'fragmentation', 'invasive', 'species', 'biodiversity', 
        'hotspots', 'genetic', 'diversity', 'species', 'extinction', 'wildlife', 'rescue', 'wildlife', 'rehabilitation', 
        'natural', 'disasters', 'disaster', 'resilience', 'disaster', 'preparedness', 'flood', 'management', 'flood', 
        'prevention', 'stormwater', 'management', 'hurricane', 'mitigation', 'earthquake', 'preparedness', 'tsunami', 
        'preparedness', 'drought', 'mitigation', 'heat', 'waves', 'climate', 'resilience', 'climate', 'adaptation', 
        'climate', 'mitigation', 'climate', 'justice', 'environmental', 'justice', 'environmental', 'racism', 'environmental', 
        'equity', 'fair', 'trade', 'certifications', 'LEED', 'certification', 'green', 'building', 'sustainable', 
        'architecture', 'eco-friendly', 'materials', 'energy-efficient', 'homes', 'zero', 'energy', 'buildings', 
        'passive', 'houses', 'urban', 'planning', 'smart', 'cities', 'green', 'infrastructure', 'urban', 'forestry', 
        'green', 'spaces', 'public', 'parks', 'urban', 'biodiversity', 'green', 'transportation', 'public', 'transit', 
        'electric', 'bikes', 'bike-sharing', 'electric', 'scooters', 'car-sharing', 'sustainable', 'mobility', 
        'ride-sharing', 'autonomous', 'vehicles', 'electric', 'charging', 'infrastructure', 'battery', 'storage', 
        'lithium', 'batteries', 'recycling', 'circular', 'economy', 'zero', 'waste', 'reduce', 'reuse', 'recycle', 
        'composting', 'biodegradable', 'materials', 'bioplastics', 'plastic', 'alternatives', 'waste', 'management', 
        'landfills', 'incineration', 'waste-to-energy', 'upcycling', 'downcycling', 'waste', 'audit', 'environmental', 
        'impact', 'assessment', 'life', 'cycle', 'assessment', 'LCA', 'eco-labeling', 'environmental', 'footprint', 
        'product', 'carbon', 'footprint', 'corporate', 'sustainability', 'corporate', 'social', 'responsibility', 
        'CSR', 'greenwashing', 'sustainable', 'business', 'practices', 'renewable', 'energy', 'credits', 'RECs', 
        'environmental', 'policy', 'international', 'agreements', 'Paris', 'Agreement', 'Kyoto', 'Protocol', 'UNFCCC', 
        'UN', 'climate', 'summit', 'COP', 'conferences', 'climate', 'negotiations', 'environmental', 'activism', 
        'climate', 'protests', 'Fridays', 'for', 'Future', 'Extinction', 'Rebellion', 'Greta', 'Thunberg', 'climate', 
        'strike', 'youth', 'climate', 'movement', 'grassroots', 'movements', 'non-governmental', 'organizations', 
        'NGOs', 'environmental', 'education', 'environmental', 'stewardship', 'nature', 'conservation', 'ecotourism', 
        'eco-friendly', 'travel', 'responsible', 'tourism', 'wildlife', 'sanctuaries', 'national', 'parks', 'protected', 
        'areas', 'wilderness', 'preservation', 'ecosystem', 'services', 'pollination', 'carbon', 'sequestration', 
        'watershed', 'management', 'wetland', 'restoration', 'river', 'conservation', 'wildlife', 'corridors', 
        'marine', 'conservation', 'ocean', 'conservation', 'deep-sea', 'mining', 'coral', 'reef', 'protection', 
        'plastic-free', 'oceans', 'ocean', 'cleanup', 'sustainable', 'fisheries', 'marine', 'biodiversity', 'species', 
        'protection', 'animal', 'rights', 'animal', 'welfare', 'sustainable', 'development', 'goals', 'SDGs', 'United', 
        'Nations', 'environmental', 'policy', 'environmental', 'governance', 'biodiversity', 'treaties', 'environmental', 
        'monitoring', 'environmental', 'compliance', 'ecological', 'footprint', 'environmental', 'science', 'ecology', 
        'environmental', 'engineering', 'natural', 'resources', 'management', 'environmental', 'law', 'environmental', 
        'economics', 'sustainable', 'finance', 'green', 'investments', 'climate', 'finance', 'green', 'bonds', 'carbon', 
        'markets', 'carbon', 'trading', 'emissions', 'trading', 'schemes', 'ETS', 'environmental', 'sustainability', 
        'reporting', 'energy', 'transition', 'clean', 'energy', 'technology', 'renewable', 'energy', 'startups'
    ]],
    
    
'finance' => [
    'title_id' => 9,
    'words' => [
        'stocks', 'investment', 'banking', 'cryptocurrency', 'portfolio', 'dividends', 'bonds', 'insurance', 'capital',
        'mutual', 'funds', 'hedge', 'funds', 'private', 'equity', 'venture', 'capital', 'asset', 'management', 'wealth', 
        'management', 'financial', 'planning', 'retirement', 'planning', 'pension', 'funds', '401(k)', 'IRA', 'Roth', 
        'IRA', 'tax-deferred', 'accounts', 'taxable', 'accounts', 'risk', 'management', 'liquidity', 'cash', 'flow', 
        'budgeting', 'financial', 'statements', 'balance', 'sheet', 'income', 'statement', 'cash', 'flow', 'statement', 
        'profit', 'and', 'loss', 'P&L', 'accounting', 'assets', 'liabilities', 'equity', 'debt', 'debt', 'financing', 
        'equity', 'financing', 'venture', 'capital', 'seed', 'funding', 'angel', 'investors', 'crowdfunding', 'IPO', 
        'initial', 'public', 'offering', 'stock', 'market', 'exchange', 'NASDAQ', 'NYSE', 'commodities', 'gold', 'silver', 
        'oil', 'natural', 'gas', 'futures', 'options', 'derivatives', 'hedging', 'leverage', 'margin', 'calls', 'short', 
        'selling', 'buying', 'the', 'dip', 'bull', 'market', 'bear', 'market', 'corrections', 'market', 'crashes', 
        'volatility', 'index', 'VIX', 'exchange-traded', 'funds', 'ETFs', 'index', 'funds', 'sector', 'funds', 'actively', 
        'managed', 'funds', 'passive', 'investment', 'strategies', 'growth', 'investing', 'value', 'investing', 'diversification', 
        'asset', 'allocation', 'risk', 'tolerance', 'risk-adjusted', 'returns', 'alpha', 'beta', 'Sharpe', 'ratio', 'capital', 
        'gains', 'dividend', 'yields', 'interest', 'rates', 'federal', 'reserve', 'monetary', 'policy', 'inflation', 'deflation', 
        'quantitative', 'easing', 'bond', 'yields', 'yield', 'curve', 'corporate', 'bonds', 'municipal', 'bonds', 'sovereign', 
        'bonds', 'treasury', 'bonds', 'T-bills', 'junk', 'bonds', 'high-yield', 'bonds', 'investment', 'grade', 'bonds', 
        'credit', 'rating', 'agencies', 'Moody’s', 'Fitch', 'S&P', 'credit', 'risk', 'default', 'risk', 'bankruptcy', 
        'insolvency', 'credit', 'derivatives', 'credit', 'default', 'swaps', 'CDS', 'options', 'futures', 'contract', 
        'forward', 'contracts', 'swaps', 'currency', 'trading', 'foreign', 'exchange', 'Forex', 'FX', 'currency', 
        'hedging', 'exchange', 'rates', 'interest', 'rate', 'parity', 'purchasing', 'power', 'parity', 'capital', 
        'controls', 'global', 'trade', 'tariffs', 'sanctions', 'trade', 'wars', 'international', 'trade', 'WTO', 
        'balance', 'of', 'payments', 'current', 'account', 'deficit', 'surplus', 'capital', 'account', 'foreign', 
        'direct', 'investment', 'FDI', 'portfolio', 'investment', 'cross-border', 'capital', 'flows', 'offshore', 
        'banking', 'tax', 'havens', 'tax', 'evasion', 'tax', 'avoidance', 'capital', 'gains', 'tax', 'corporate', 
        'tax', 'tax', 'brackets', 'progressive', 'taxation', 'flat', 'tax', 'regressive', 'taxation', 'VAT', 'sales', 
        'tax', 'property', 'tax', 'estate', 'tax', 'inheritance', 'tax', 'gift', 'tax', 'tax', 'incentives', 'tax', 
        'credits', 'tax', 'deductions', 'tax', 'planning', 'tax', 'returns', 'audit', 'financial', 'audit', 'compliance', 
        'regulatory', 'compliance', 'SEC', 'regulations', 'FINRA', 'FCA', 'Dodd-Frank', 'Act', 'Sarbanes-Oxley', 'Act', 
        'corporate', 'governance', 'corporate', 'social', 'responsibility', 'CSR', 'ESG', 'environmental', 'social', 
        'governance', 'impact', 'investing', 'socially', 'responsible', 'investing', 'SRI', 'green', 'bonds', 'climate', 
        'finance', 'carbon', 'markets', 'carbon', 'trading', 'emissions', 'trading', 'schemes', 'cap-and-trade', 
        'environmental', 'sustainability', 'renewable', 'energy', 'investment', 'clean', 'energy', 'funds', 'sustainable', 
        'development', 'goals', 'SDGs', 'greenwashing', 'corporate', 'ethics', 'financial', 'ethics', 'insider', 'trading', 
        'market', 'manipulation', 'securities', 'fraud', 'Ponzi', 'scheme', 'pyramid', 'schemes', 'identity', 'theft', 
        'financial', 'fraud', 'anti-money', 'laundering', 'AML', 'know', 'your', 'customer', 'KYC', 'cybersecurity', 
        'data', 'breaches', 'fintech', 'financial', 'technology', 'peer-to-peer', 'lending', 'crowdfunding', 'blockchain', 
        'distributed', 'ledger', 'technology', 'cryptocurrency', 'bitcoin', 'ethereum', 'smart', 'contracts', 'DeFi', 
        'decentralized', 'finance', 'crypto', 'wallets', 'stablecoins', 'crypto', 'mining', 'initial', 'coin', 'offering', 
        'ICO', 'initial', 'exchange', 'offering', 'IEO', 'security', 'token', 'offerings', 'STO', 'tokens', 'NFTs', 
        'non-fungible', 'tokens', 'digital', 'assets', 'crypto', 'exchanges', 'centralized', 'exchanges', 'decentralized', 
        'exchanges', 'DEX', 'yield', 'farming', 'staking', 'liquidity', 'pools', 'crypto', 'lending', 'crypto', 
        'borrowing', 'crypto', 'derivatives', 'financial', 'innovation', 'disruptive', 'technology', 'open', 'banking', 
        'API', 'banking', 'digital', 'payments', 'mobile', 'payments', 'e-wallets', 'remittances', 'payment', 'processors', 
        'point', 'of', 'sale', 'systems', 'POS', 'contactless', 'payments', 'QR', 'code', 'payments', 'smart', 'contracts', 
        'blockchain', 'audits', 'digital', 'identity', 'regtech', 'compliance', 'solutions', 'AI', 'in', 'finance', 
        'robo-advisors', 'algorithmic', 'trading', 'high-frequency', 'trading', 'quantitative', 'finance', 'machine', 
        'learning', 'in', 'finance', 'predictive', 'analytics', 'risk', 'analytics', 'AI-powered', 'credit', 'scoring', 
        'alternative', 'credit', 'scoring', 'peer-to-peer', 'lending', 'crowdfunding', 'investment', 'platforms', 'microfinance', 
        'social', 'lending', 'impact', 'investing', 'green', 'investments', 'renewable', 'energy', 'startups', 'blockchain', 
        'in', 'finance', 'decentralized', 'finance', 'DeFi', 'crypto', 'regulation', 'financial', 'stability', 'board', 
        'international', 'monetary', 'fund', 'IMF', 'world', 'bank', 'federal', 'reserve', 'ECB', 'central', 'banks', 
        'monetary', 'policy', 'interest', 'rates', 'quantitative', 'easing', 'stimulus', 'packages', 'fiscal', 'policy', 
        'government', 'spending', 'budget', 'deficit', 'national', 'debt', 'sovereign', 'wealth', 'funds', 'international', 
        'finance', 'cross-border', 'transactions', 'global', 'trade', 'exchange', 'rates', 'currency', 'wars', 'capital', 
        'markets', 'financial', 'markets', 'capital', 'controls', 'currency', 'controls', 'economic', 'sanctions', 'trade', 
        'barriers', 'financial', 'globalization', 'world', 'trade', 'organization', 'WTO', 'trade', 'agreements', 'NAFTA', 
        'regional', 'trade', 'blocs', 'European', 'Union', 'EU', 'ASEAN', 'Mercosur', 'Africa', 'Free', 'Trade', 'Area'
    ]],
    
    
'travel' => [
    'title_id' => 10,
    'words' => [
        'destination', 'tourism', 'adventure', 'beach', 'cruise', 'hotel', 'flight', 'passport', 'explore',
        'vacation', 'holiday', 'itinerary', 'tour', 'resort', 'backpacking', 'road', 'trip', 'excursion', 'getaway', 
        'staycation', 'journey', 'trek', 'expedition', 'safari', 'island', 'hopping', 'cultural', 'tourism', 'heritage', 
        'sites', 'landmarks', 'sightseeing', 'guided', 'tour', 'self-guided', 'tour', 'city', 'break', 'weekend', 
        'retreat', 'mountains', 'lakes', 'national', 'parks', 'world', 'heritage', 'sites', 'eco-tourism', 'wildlife', 
        'sanctuaries', 'marine', 'reserves', 'sustainable', 'travel', 'responsible', 'tourism', 'adventure', 'sports', 
        'hiking', 'camping', 'rock', 'climbing', 'mountaineering', 'skiing', 'snowboarding', 'rafting', 'kayaking', 
        'snorkeling', 'scuba', 'diving', 'parasailing', 'skydiving', 'bungee', 'jumping', 'paragliding', 'hot', 'air', 
        'balloon', 'ride', 'zip-lining', 'surfing', 'windsurfing', 'kitesurfing', 'sailing', 'yacht', 'charter', 
        'luxury', 'travel', 'boutique', 'hotels', 'glamping', 'vineyard', 'tours', 'gastronomy', 'tourism', 'food', 
        'tours', 'culinary', 'experiences', 'street', 'food', 'wine', 'tasting', 'brewery', 'tours', 'farm-to-table', 
        'experiences', 'wellness', 'retreats', 'yoga', 'retreats', 'spa', 'resorts', 'relaxation', 'health', 'retreats', 
        'meditation', 'retreats', 'pilgrimage', 'religious', 'tourism', 'sacred', 'sites', 'spiritual', 'journeys', 
        'volunteer', 'travel', 'voluntourism', 'mission', 'trips', 'study', 'abroad', 'exchange', 'programs', 'student', 
        'travel', 'solo', 'travel', 'group', 'travel', 'family', 'vacations', 'honeymoon', 'destination', 'weddings', 
        'luxury', 'cruises', 'river', 'cruises', 'ocean', 'cruises', 'yachting', 'sailing', 'expedition', 'cruises', 
        'small', 'ship', 'cruises', 'adventure', 'cruises', 'island', 'resorts', 'overwater', 'bungalows', 'all-inclusive', 
        'resorts', 'adults-only', 'resorts', 'family-friendly', 'resorts', 'theme', 'parks', 'amusement', 'parks', 'water', 
        'parks', 'ski', 'resorts', 'golf', 'resorts', 'beachfront', 'resorts', 'snow', 'lodges', 'vacation', 'rentals', 
        'Airbnb', 'home', 'stays', 'bed', 'and', 'breakfast', 'hostels', 'boutique', 'hotels', 'five-star', 'hotels', 
        'business', 'travel', 'conference', 'centers', 'airport', 'hotels', 'airport', 'lounges', 'airline', 'miles', 
        'frequent', 'flyer', 'programs', 'budget', 'airlines', 'low-cost', 'carriers', 'premium', 'class', 'business', 
        'class', 'first', 'class', 'in-flight', 'entertainment', 'in-flight', 'dining', 'duty-free', 'shopping', 
        'connecting', 'flights', 'direct', 'flights', 'non-stop', 'flights', 'red-eye', 'flights', 'long-haul', 
        'flights', 'short-haul', 'flights', 'layover', 'transit', 'hubs', 'customs', 'immigration', 'security', 
        'checkpoints', 'visa', 'requirements', 'electronic', 'visa', 'ESTA', 'Schengen', 'visa', 'border', 'control', 
        'passport', 'renewal', 'passport', 'control', 'travel', 'insurance', 'cancellation', 'coverage', 'medical', 
        'evacuation', 'coverage', 'lost', 'luggage', 'insurance', 'trip', 'delay', 'insurance', 'credit', 'card', 
        'travel', 'benefits', 'car', 'rental', 'insurance', 'international', 'driver’s', 'license', 'rental', 'cars', 
        'self-drive', 'tours', 'car', 'hire', 'roadside', 'assistance', 'electric', 'car', 'rentals', 'RV', 'rentals', 
        'campervan', 'rentals', 'bike', 'rentals', 'bicycle', 'tours', 'motorcycle', 'tours', 'segway', 'tours', 'walking', 
        'tours', 'sightseeing', 'bus', 'tours', 'hop-on', 'hop-off', 'buses', 'guided', 'tours', 'private', 'tours', 
        'luxury', 'tours', 'small', 'group', 'tours', 'sustainable', 'tourism', 'eco-friendly', 'accommodations', 
        'green', 'hotels', 'carbon-neutral', 'travel', 'offsetting', 'carbon', 'emissions', 'responsible', 'tourism', 
        'conservation', 'travel', 'wildlife', 'conservation', 'marine', 'conservation', 'national', 'parks', 'protected', 
        'areas', 'world', 'heritage', 'sites', 'trekking', 'safaris', 'wildlife', 'viewing', 'birdwatching', 'nature', 
        'reserves', 'rainforests', 'jungle', 'trekking', 'desert', 'safaris', 'savanna', 'safaris', 'polar', 'expeditions', 
        'Antarctic', 'cruises', 'Arctic', 'expeditions', 'ice', 'fishing', 'dog', 'sledding', 'northern', 'lights', 
        'aurora', 'borealis', 'volcano', 'tours', 'geothermal', 'pools', 'hot', 'springs', 'thermal', 'baths', 'spa', 
        'retreats', 'wellness', 'retreats', 'yoga', 'retreats', 'meditation', 'retreats', 'detox', 'retreats', 'cruise', 
        'ports', 'embarkation', 'disembarkation', 'shore', 'excursions', 'island', 'hopping', 'luxury', 'yachts', 'catamaran', 
        'charters', 'expedition', 'ships', 'river', 'cruises', 'ocean', 'cruises', 'transatlantic', 'cruises', 'Caribbean', 
        'cruises', 'Mediterranean', 'cruises', 'Arctic', 'cruises', 'expedition', 'cruises', 'tropical', 'island', 'resorts', 
        'luxury', 'resorts', 'overwater', 'bungalows', 'private', 'island', 'resorts', 'beachfront', 'villas', 'secluded', 
        'resorts', 'adults-only', 'resorts', 'family-friendly', 'resorts', 'honeymoon', 'packages', 'destination', 
        'weddings', 'travel', 'agents', 'online', 'booking', 'platforms', 'trip', 'advisors', 'travel', 'reviews', 'travel', 
        'blogs', 'travel', 'influencers', 'social', 'media', 'influencers', 'travel', 'vlogs', 'virtual', 'tours', 
        '360-degree', 'videos', 'virtual', 'reality', 'travel', 'augmented', 'reality', 'tourism', 'solo', 'travel', 
        'backpacking', 'budget', 'travel', 'luxury', 'travel', 'group', 'travel', 'gap', 'year', 'travel', 'study', 
        'abroad', 'exchange', 'programs', 'digital', 'nomads', 'remote', 'working', 'travel', 'tours', 'nomadic', 'lifestyle'
    ]],
    
    
'food' => [
    'title_id' => 11,
    'words' => [
        'restaurant', 'cuisine', 'recipe', 'chef', 'ingredients', 'cooking', 'menu', 'dish', 'flavor',
        'gourmet', 'fine', 'dining', 'street', 'food', 'comfort', 'food', 'fast', 'food', 'takeout', 
        'delivery', 'bistro', 'café', 'brunch', 'buffet', 'food', 'truck', 'snacks', 'appetizers', 'starters', 
        'main', 'course', 'desserts', 'beverages', 'drinks', 'mocktails', 'cocktails', 'wine', 'pairing', 
        'beer', 'craft', 'beer', 'spirits', 'liquor', 'bartender', 'mixology', 'sommelier', 'barista', 'tea', 
        'coffee', 'espresso', 'latte', 'cappuccino', 'mocha', 'iced', 'coffee', 'green', 'tea', 'herbal', 
        'infusions', 'juices', 'smoothies', 'milkshakes', 'bubble', 'tea', 'soda', 'sparkling', 'water', 
        'mineral', 'water', 'kombucha', 'fermented', 'drinks', 'wine', 'tasting', 'vineyards', 'vine', 
        'harvest', 'winemaking', 'grape', 'varieties', 'cheese', 'platter', 'charcuterie', 'board', 'sauces', 
        'condiments', 'spices', 'herbs', 'seasoning', 'marinades', 'grilling', 'roasting', 'baking', 'frying', 
        'steaming', 'boiling', 'poaching', 'blanching', 'braising', 'simmering', 'sautéing', 'stir-frying', 
        'deep-frying', 'broiling', 'barbecue', 'smoking', 'slow', 'cooking', 'pressure', 'cooking', 'instant', 
        'pot', 'air', 'fryer', 'wood-fired', 'oven', 'brick', 'oven', 'culinary', 'techniques', 'mise', 'en', 
        'place', 'prep', 'work', 'knife', 'skills', 'chopping', 'slicing', 'dicing', 'mincing', 'julienne', 
        'batonnet', 'brunoise', 'mandoline', 'grater', 'zester', 'peeler', 'mortar', 'and', 'pestle', 'whisk', 
        'spatula', 'ladle', 'tongs', 'rolling', 'pin', 'cutting', 'board', 'measuring', 'cups', 'measuring', 
        'spoons', 'thermometer', 'sous', 'vide', 'cooking', 'techniques', 'food', 'presentation', 'plating', 
        'garnishing', 'food', 'styling', 'edible', 'flowers', 'microgreens', 'fusion', 'cuisine', 'molecular', 
        'gastronomy', 'avant-garde', 'cooking', 'deconstruction', 'experimental', 'cuisine', 'local', 'produce', 
        'seasonal', 'ingredients', 'farm-to-table', 'organic', 'food', 'sustainable', 'farming', 'fair', 'trade', 
        'food', 'ethical', 'eating', 'plant-based', 'vegan', 'vegetarian', 'pescatarian', 'gluten-free', 'dairy-free', 
        'keto', 'paleo', 'low-carb', 'high-protein', 'superfoods', 'health', 'food', 'nutritional', 'value', 'calories', 
        'macronutrients', 'protein', 'carbohydrates', 'fats', 'micronutrients', 'vitamins', 'minerals', 'fiber', 
        'probiotics', 'antioxidants', 'omega-3', 'fatty', 'acids', 'whole', 'foods', 'organic', 'farming', 'urban', 
        'farming', 'hydroponics', 'vertical', 'farming', 'greenhouse', 'gardening', 'farmers', 'markets', 'artisanal', 
        'producers', 'small', 'batch', 'craft', 'foods', 'locally', 'sourced', 'ingredients', 'preserving', 'canning', 
        'pickling', 'fermenting', 'drying', 'salting', 'curing', 'jerky', 'smoked', 'foods', 'aged', 'cheese', 'cured', 
        'meats', 'deli', 'meats', 'salami', 'prosciutto', 'chorizo', 'sourdough', 'bread', 'artisan', 'bread', 
        'pastries', 'croissants', 'danishes', 'brioche', 'baguette', 'bagels', 'pretzels', 'muffins', 'cupcakes', 
        'cakes', 'cookies', 'biscuits', 'macarons', 'eclairs', 'tarts', 'pies', 'chocolates', 'confections', 'candy', 
        'truffles', 'fudge', 'caramels', 'toffee', 'gelato', 'sorbet', 'ice', 'cream', 'frozen', 'yogurt', 'pudding', 
        'custard', 'soufflé', 'crepes', 'waffles', 'pancakes', 'syrup', 'maple', 'syrup', 'honey', 'jams', 'preserves', 
        'marmalade', 'chutney', 'relish', 'spreads', 'peanut', 'butter', 'almond', 'butter', 'cashew', 'butter', 'hummus', 
        'tahini', 'avocado', 'toast', 'quinoa', 'bowls', 'grain', 'bowls', 'poke', 'bowls', 'smoothie', 'bowls', 'acai', 
        'bowls', 'tapas', 'meze', 'dim', 'sum', 'dumplings', 'sushi', 'nigiri', 'sashimi', 'tempura', 'teriyaki', 'ramen', 
        'udon', 'pho', 'bento', 'box', 'hot', 'pot', 'fondue', 'raclette', 'charcoal', 'grilling', 'skewers', 'satay', 
        'kebabs', 'shawarma', 'falafel', 'gyro', 'naan', 'pita', 'bread', 'flatbread', 'tacos', 'burritos', 'quesadillas', 
        'nachos', 'salsa', 'guacamole', 'chips', 'corn', 'tortillas', 'enchiladas', 'fajitas', 'tamales', 'ceviche', 
        'empanadas', 'paella', 'ratatouille', 'bouillabaisse', 'moussaka', 'spanakopita', 'tzatziki', 'baklava', 'hummus', 
        'tabbouleh', 'pasta', 'spaghetti', 'lasagna', 'fettuccine', 'ravioli', 'gnocchi', 'pizza', 'margherita', 'risotto', 
        'bruschetta', 'antipasto', 'tiramisu', 'gelato', 'cannoli', 'prosciutto', 'mozzarella', 'parmigiana', 'grana', 
        'padano', 'gorgonzola', 'parmesan', 'ricotta', 'burrata', 'caprese', 'salad', 'caesar', 'salad', 'coleslaw', 
        'potato', 'salad', 'quiche', 'frittata', 'omelette', 'scrambled', 'eggs', 'poached', 'eggs', 'bacon', 'sausage', 
        'hash', 'browns', 'breakfast', 'burrito', 'pancakes', 'french', 'toast', 'waffles', 'smoothies', 'juices', 'granola', 
        'yogurt', 'parfait', 'fruit', 'salad', 'berries', 'bananas', 'apples', 'oranges', 'melons', 'grapes', 'pineapple', 
        'mango', 'kiwi', 'dragonfruit', 'papaya', 'peaches', 'nectarines', 'apricots', 'plums', 'figs', 'dates', 'raisins'
    ]],
    
    
'fashion' => [
    'title_id' => 12,
    'words' => [
        'designer', 'runway', 'model', 'outfit', 'style', 'clothing', 'trend', 'brand', 'couture',
        'fashion', 'week', 'haute', 'couture', 'ready-to-wear', 'prêt-à-porter', 'luxury', 'streetwear', 
        'vintage', 'retro', 'bohemian', 'chic', 'minimalist', 'maximalist', 'avant-garde', 'grunge', 'punk', 
        'gothic', 'athleisure', 'casual', 'formal', 'business', 'attire', 'smart', 'casual', 'evening', 
        'wear', 'cocktail', 'dress', 'black-tie', 'white-tie', 'gala', 'ball', 'red', 'carpet', 'celebrity', 
        'fashion', 'wardrobe', 'capsule', 'wardrobe', 'sustainable', 'fashion', 'ethical', 'fashion', 
        'eco-friendly', 'upcycling', 'recycling', 'secondhand', 'thrift', 'slow', 'fashion', 'fast', 'fashion', 
        'fashion', 'industry', 'garment', 'textiles', 'fabrics', 'organic', 'cotton', 'linen', 'wool', 'silk', 
        'cashmere', 'alpaca', 'leather', 'vegan', 'leather', 'faux', 'fur', 'denim', 'jeans', 'knitwear', 'outerwear', 
        'jackets', 'coats', 'blazers', 'suits', 'tailoring', 'tailor-made', 'custom', 'fitting', 'bespoke', 
        'ready-to-wear', 'seasonal', 'collections', 'spring', 'summer', 'autumn', 'fall', 'winter', 'fashion', 
        'collection', 'fashion', 'house', 'atelier', 'fashion', 'line', 'collaborations', 'designer', 'capsule', 
        'collection', 'runway', 'shows', 'catwalk', 'presentation', 'fashion', 'photography', 'editorial', 'shoot', 
        'fashion', 'magazine', 'vogue', 'harper’s', 'bazaar', 'elle', 'glamour', 'cosmopolitan', 'street', 'style', 
        'fashion', 'blogger', 'influencer', 'social', 'media', 'style', 'icon', 'trendsetter', 'fashionista', 
        'personal', 'stylist', 'fashion', 'consultant', 'fashion', 'editor', 'fashion', 'critic', 'fashion', 
        'journalist', 'fashion', 'reporter', 'fashion', 'columnist', 'fashion', 'commentary', 'fashion', 'forecasting', 
        'fashion', 'trends', 'trend', 'analysis', 'color', 'palette', 'Pantone', 'fashion', 'illustration', 
        'fashion', 'design', 'fashion', 'sketches', 'patterns', 'draping', 'sewing', 'cutting', 'patternmaking', 
        'tailoring', 'fittings', 'prototypes', 'samples', 'garment', 'construction', 'textile', 'design', 
        'fabric', 'printing', 'embroidery', 'embellishments', 'beading', 'sequins', 'rhinestones', 'patchwork', 
        'appliqué', 'lace', 'crochet', 'knitting', 'looming', 'handmade', 'craftsmanship', 'artisan', 'designs', 
        'handcrafted', 'clothing', 'couture', 'houses', 'high', 'fashion', 'luxury', 'brands', 'designer', 'labels', 
        'mass', 'market', 'fashion', 'fast', 'fashion', 'affordable', 'fashion', 'fashion', 'retail', 'boutiques', 
        'concept', 'stores', 'flagship', 'stores', 'online', 'shopping', 'e-commerce', 'fashion', 'platforms', 
        'fashion', 'apps', 'fashion', 'technology', 'wearable', 'technology', 'smart', 'clothing', 'smart', 
        'watches', 'fit', 'technology', 'virtual', 'fitting', 'rooms', 'AI-powered', 'fashion', 'recommendations', 
        'sustainable', 'fabrics', 'recycled', 'materials', 'eco-friendly', 'dyes', 'zero-waste', 'production', 
        'fair', 'trade', 'ethical', 'labor', 'practices', 'transparent', 'supply', 'chain', 'fashion', 'activism', 
        'cultural', 'appropriation', 'gender-neutral', 'fashion', 'inclusive', 'fashion', 'plus-size', 'fashion', 
        'petite', 'fashion', 'adaptive', 'fashion', 'maternity', 'wear', 'bridal', 'wear', 'evening', 'gowns', 
        'cocktail', 'dresses', 'prom', 'dresses', 'ball', 'gowns', 'bridal', 'gowns', 'suits', 'and', 'tuxedos', 
        'formal', 'wear', 'workwear', 'uniforms', 'athleisure', 'sportswear', 'activewear', 'yoga', 'clothes', 
        'gym', 'wear', 'sneakers', 'footwear', 'heels', 'flats', 'boots', 'sandals', 'slides', 'loafers', 'oxfords', 
        'wedge', 'heels', 'ballet', 'flats', 'espadrilles', 'mules', 'slingbacks', 'chunky', 'heels', 'platforms', 
        'stilettos', 'kitten', 'heels', 'combat', 'boots', 'cowboy', 'boots', 'ankle', 'boots', 'knee-high', 
        'boots', 'thigh-high', 'boots', 'rain', 'boots', 'slippers', 'flip-flops', 'accessories', 'hats', 'caps', 
        'scarves', 'shawls', 'gloves', 'belts', 'bags', 'clutches', 'crossbody', 'bags', 'totes', 'satchels', 
        'backpacks', 'messenger', 'bags', 'duffel', 'bags', 'wallets', 'purses', 'jewelry', 'rings', 'necklaces', 
        'bracelets', 'bangles', 'earrings', 'hoops', 'studs', 'chokers', 'cufflinks', 'brooches', 'hair', 'accessories', 
        'hairbands', 'hair', 'clips', 'barrettes', 'sunglasses', 'eyewear', 'glasses', 'frames', 'aviators', 'cat-eye', 
        'round', 'frames', 'rectangular', 'frames', 'oval', 'frames', 'mirrored', 'lenses', 'tinted', 'lenses', 
        'sunglass', 'chains', 'timepieces', 'watches', 'bracelet', 'watches', 'leather', 'strap', 'watches', 'sports', 
        'watches', 'smartwatches', 'fitness', 'trackers', 'rings', 'with', 'smart', 'features', 'fashion', 'shows', 
        'runway', 'models', 'supermodels', 'fashion', 'photographers', 'fashion', 'films', 'fashion', 'documentaries', 
        'fashion', 'campaigns', 'advertising', 'campaigns', 'fashion', 'marketing', 'digital', 'fashion', 'influencers', 
        'fashion', 'collaborations', 'brand', 'ambassadors', 'celebrity', 'endorsements', 'luxury', 'fashion', 'brand', 
        'campaigns', 'runway', 'shows', 'Paris', 'fashion', 'week', 'New', 'York', 'fashion', 'week', 'Milan', 'fashion', 
        'week', 'London', 'fashion', 'week', 'Tokyo', 'fashion', 'week', 'Shanghai', 'fashion', 'week'
    ]],
    
    
'science' => [
    'title_id' => 13,
    'words' => [
        'research', 'physics', 'biology', 'astronomy', 'experiment', 'theory', 'space', 'lab', 'discovery',
        'chemistry', 'geology', 'mathematics', 'genetics', 'neuroscience', 'ecology', 'paleontology', 'zoology', 
        'botany', 'meteorology', 'oceanography', 'biochemistry', 'molecular', 'biology', 'quantum', 'mechanics', 
        'relativity', 'evolution', 'cell', 'biology', 'immunology', 'microbiology', 'astrophysics', 'cosmology', 
        'particle', 'physics', 'nuclear', 'physics', 'thermodynamics', 'electromagnetism', 'fluid', 'dynamics', 
        'quantum', 'field', 'theory', 'string', 'theory', 'black', 'holes', 'dark', 'matter', 'dark', 'energy', 
        'big', 'bang', 'cosmic', 'inflation', 'gravitational', 'waves', 'stellar', 'formation', 'galaxies', 
        'exoplanets', 'habitable', 'zones', 'SETI', 'extraterrestrial', 'life', 'astrobiology', 'genomics', 'proteomics', 
        'CRISPR', 'gene', 'editing', 'DNA', 'RNA', 'nucleotides', 'protein', 'synthesis', 'enzyme', 'function', 
        'genetic', 'mutations', 'inheritance', 'genetic', 'variation', 'natural', 'selection', 'mutation', 'adaptation', 
        'evolutionary', 'biology', 'species', 'extinction', 'biodiversity', 'ecosystems', 'food', 'chains', 'trophic', 
        'levels', 'energy', 'transfer', 'carbon', 'cycle', 'water', 'cycle', 'nitrogen', 'cycle', 'biomes', 'ecological', 
        'niches', 'climate', 'change', 'global', 'warming', 'environmental', 'science', 'pollution', 'deforestation', 
        'conservation', 'sustainability', 'renewable', 'energy', 'solar', 'energy', 'wind', 'energy', 'geothermal', 
        'energy', 'hydroelectric', 'power', 'nuclear', 'energy', 'fusion', 'fission', 'radioactivity', 'radiation', 
        'half-life', 'isotopes', 'radioisotopes', 'carbon', 'dating', 'fossils', 'archaeology', 'paleoecology', 'prehistoric', 
        'life', 'dinosaurs', 'fossil', 'record', 'evolutionary', 'tree', 'natural', 'history', 'ice', 'ages', 'extinction', 
        'events', 'mass', 'extinctions', 'climate', 'models', 'weather', 'forecasting', 'hurricanes', 'tornadoes', 
        'earthquakes', 'volcanoes', 'tectonic', 'plates', 'continental', 'drift', 'seismology', 'earthquake', 'prediction', 
        'tsunamis', 'volcanology', 'geophysics', 'mineralogy', 'petrology', 'rock', 'formations', 'fossil', 'fuels', 
        'oil', 'natural', 'gas', 'coal', 'earth’s', 'core', 'mantle', 'crust', 'earth’s', 'magnetic', 'field', 'gravity', 
        'planetary', 'formation', 'solar', 'system', 'asteroids', 'comets', 'meteors', 'space', 'exploration', 'spacecraft', 
        'satellites', 'telescopes', 'Hubble', 'telescope', 'James', 'Webb', 'telescope', 'space', 'probes', 'Mars', 
        'rovers', 'international', 'space', 'station', 'ISS', 'human', 'spaceflight', 'space', 'colonization', 'lunar', 
        'base', 'Mars', 'missions', 'interstellar', 'travel', 'space-time', 'wormholes', 'time', 'travel', 'multiverse', 
        'parallel', 'universes', 'quantum', 'entanglement', 'superposition', 'wave-particle', 'duality', 'uncertainty', 
        'principle', 'Schrodinger’s', 'cat', 'double-slit', 'experiment', 'atomic', 'structure', 'subatomic', 'particles', 
        'protons', 'neutrons', 'electrons', 'quarks', 'leptons', 'bosons', 'Higgs', 'boson', 'CERN', 'particle', 'accelerator', 
        'large', 'hadron', 'collider', 'standard', 'model', 'physics', 'grand', 'unified', 'theory', 'string', 'theory', 
        'loop', 'quantum', 'gravity', 'supergravity', 'M-theory', 'extra', 'dimensions', 'quantum', 'computing', 'quantum', 
        'algorithms', 'quantum', 'cryptography', 'artificial', 'intelligence', 'machine', 'learning', 'deep', 'learning', 
        'neural', 'networks', 'natural', 'language', 'processing', 'NLP', 'robotics', 'autonomous', 'systems', 'drone', 
        'technology', 'biotechnology', 'bioengineering', 'genetic', 'engineering', 'biomedical', 'research', 'stem', 
        'cells', 'regenerative', 'medicine', 'tissue', 'engineering', 'prosthetics', 'bionics', 'nanotechnology', 
        'nanomaterials', 'nanorobots', 'biophysics', 'quantum', 'biology', 'biomechanics', 'human', 'anatomy', 'physiology', 
        'neuroscience', 'brain', 'function', 'cognitive', 'science', 'psychology', 'behavioral', 'science', 'consciousness', 
        'perception', 'memory', 'learning', 'intelligence', 'artificial', 'intelligence', 'AI', 'biotechnology', 'genomics', 
        'proteomics', 'metabolomics', 'biomedical', 'engineering', 'drug', 'discovery', 'clinical', 'trials', 'epidemiology', 
        'public', 'health', 'vaccines', 'antibiotics', 'antivirals', 'pandemics', 'infectious', 'diseases', 'pathogens', 
        'virus', 'bacteria', 'fungi', 'parasites', 'immunology', 'immune', 'system', 'autoimmune', 'diseases', 'cancer', 
        'research', 'oncology', 'therapeutics', 'chemotherapy', 'radiation', 'therapy', 'immunotherapy', 'gene', 'therapy', 
        'CRISPR', 'gene', 'editing', 'biopharmaceuticals', 'drug', 'development', 'clinical', 'trials', 'medical', 'devices', 
        'diagnostics', 'biosensors', 'lab-on-a-chip', '3D', 'printing', 'organ', 'transplants', 'bionics', 'prosthetics', 
        'biomaterials', 'synthetic', 'biology', 'microbiome', 'human', 'genome', 'project', 'synthetic', 'biology', 
        'bioethics', 'ethics', 'in', 'science', 'scientific', 'method', 'hypothesis', 'data', 'collection', 'data', 
        'analysis', 'statistical', 'significance', 'peer', 'review', 'scientific', 'journals', 'research', 'papers', 
        'academic', 'conferences', 'scientific', 'collaboration', 'open', 'science', 'citizen', 'science', 'science', 
        'communication', 'science', 'education', 'STEM', 'outreach', 'popular', 'science', 'science', 'documentaries', 
        'science', 'museums', 'scientific', 'curiosity', 'innovation', 'technological', 'advancement', 'scientific', 
        'discovery'
    ]],
    
    
'automotive' => [
    'title_id' => 14,
    'words' => [
        'car', 'engine', 'vehicle', 'race', 'fuel', 'speed', 'design', 'manufacturer', 'technology',
        'automobile', 'SUV', 'sedan', 'coupe', 'convertible', 'hatchback', 'station', 'wagon', 'minivan', 
        'pickup', 'truck', 'electric', 'vehicle', 'EV', 'hybrid', 'plug-in', 'hybrid', 'fuel', 'cell', 'hydrogen', 
        'diesel', 'gasoline', 'petrol', 'turbocharged', 'supercharged', 'naturally', 'aspirated', 'V6', 'V8', 'V12', 
        'inline', 'four', 'rotary', 'engine', 'internal', 'combustion', 'engine', 'transmission', 'automatic', 'manual', 
        'CVT', 'dual-clutch', 'gearbox', 'drivetrain', 'all-wheel', 'drive', 'four-wheel', 'drive', 'front-wheel', 
        'drive', 'rear-wheel', 'drive', 'differential', 'limited-slip', 'torque', 'converter', 'clutch', 'gear', 'ratios', 
        'acceleration', 'torque', 'horsepower', 'RPM', 'miles', 'per', 'gallon', 'MPG', 'kilometers', 'per', 'liter', 
        'fuel', 'efficiency', 'CO2', 'emissions', 'aerodynamics', 'drag', 'coefficient', 'downforce', 'spoiler', 
        'splitter', 'diffuser', 'air', 'intake', 'turbo', 'boost', 'intercooler', 'exhaust', 'muffler', 'catalytic', 
        'converter', 'suspension', 'shock', 'absorbers', 'struts', 'coil', 'springs', 'leaf', 'springs', 'anti-roll', 
        'bars', 'chassis', 'frame', 'monocoque', 'body-on-frame', 'unibody', 'crumple', 'zones', 'safety', 'features', 
        'airbags', 'seatbelts', 'ABS', 'anti-lock', 'brakes', 'traction', 'control', 'stability', 'control', 'adaptive', 
        'cruise', 'control', 'lane', 'assist', 'collision', 'warning', 'automatic', 'emergency', 'braking', 'blind-spot', 
        'monitoring', 'backup', 'camera', 'parking', 'sensors', 'autonomous', 'driving', 'self-driving', 'cars', 
        'autopilot', 'driver-assistance', 'systems', 'ADAS', 'navigation', 'GPS', 'infotainment', 'touchscreen', 
        'Bluetooth', 'connectivity', 'Apple', 'CarPlay', 'Android', 'Auto', 'voice', 'commands', 'wireless', 'charging', 
        'climate', 'control', 'dual-zone', 'air', 'conditioning', 'heated', 'seats', 'ventilated', 'seats', 'leather', 
        'interior', 'sunroof', 'panoramic', 'roof', 'LED', 'headlights', 'HID', 'headlights', 'halogen', 'bulbs', 
        'fog', 'lights', 'brake', 'lights', 'taillights', 'turn', 'signals', 'wipers', 'rain-sensing', 'wipers', 
        'alloy', 'wheels', 'performance', 'tires', 'run-flat', 'tires', 'summer', 'tires', 'winter', 'tires', 'all-season', 
        'tires', 'tire', 'pressure', 'monitoring', 'system', 'TPMS', 'brakes', 'disc', 'brakes', 'drum', 'brakes', 
        'carbon-ceramic', 'brakes', 'brake', 'calipers', 'pads', 'rotors', 'steering', 'power', 'steering', 'rack-and-pinion', 
        'steering', 'electric', 'power', 'steering', 'EPS', 'hydraulic', 'steering', 'wheel', 'alignment', 'steering', 
        'column', 'steering', 'ratio', 'handling', 'cornering', 'g-force', 'weight', 'distribution', 'center', 'of', 
        'gravity', 'driving', 'modes', 'eco', 'mode', 'sport', 'mode', 'comfort', 'mode', 'launch', 'control', 'towing', 
        'capacity', 'payload', 'capacity', 'off-road', 'capability', 'ground', 'clearance', 'skid', 'plates', 'tow', 
        'hooks', 'winch', 'all-terrain', 'tires', 'locking', 'differentials', 'hill', 'descent', 'control', 'hill', 
        'start', 'assist', 'roof', 'rack', 'cargo', 'space', 'trunk', 'capacity', 'folding', 'seats', 'flat', 'floor', 
        'rear', 'seat', 'legroom', 'headroom', 'cargo', 'net', 'storage', 'compartments', 'cupholders', 'wireless', 
        'charging', 'ports', 'USB', 'ports', '12-volt', 'outlets', 'auxiliary', 'inputs', 'premium', 'sound', 'system', 
        'Bose', 'Harman', 'Kardon', 'Bang', 'Olufsen', 'tweeters', 'subwoofers', 'equalizer', 'sound', 'modes', 
        'automatic', 'transmissions', 'paddle', 'shifters', 'sequential', 'manual', 'transmission', 'robotized', 
        'gearbox', 'drivetrain', 'AWD', '4WD', 'RWD', 'FWD', 'limited', 'slip', 'differential', 'center', 'locking', 
        'differential', 'torque', 'vectoring', 'dual', 'clutch', 'transmissions', 'adaptive', 'suspension', 'active', 
        'suspension', 'air', 'suspension', 'adjustable', 'ride', 'height', 'performance', 'exhaust', 'ceramic', 
        'coating', 'turbo', 'lag', 'twin-turbo', 'V12', 'naturally', 'aspirated', 'rotary', 'engine', 'mid-engine', 
        'supercar', 'hypercar', 'track', 'day', 'motorsports', 'racing', 'circuit', 'drag', 'racing', 'Formula', 'One', 
        'NASCAR', 'IndyCar', 'Le', 'Mans', 'endurance', 'racing', 'GT', 'racing', 'drifting', 'karting', 'rally', 
        'racing', 'off-road', 'racing', 'drag', 'strip', 'quarter-mile', 'time', 'lap', 'times', 'top', 'speed', 
        '0-60', 'mph', 'acceleration', 'drag', 'coefficient', 'aerodynamics', 'wind', 'tunnel', 'testing', 'motorsport', 
        'engine', 'mapping', 'ECU', 'tuning', 'performance', 'tuning', 'chip', 'tuning', 'aftermarket', 'parts', 
        'upgrades', 'customization', 'body', 'kits', 'spoilers', 'splitters', 'skirts', 'widebody', 'kits', 'carbon', 
        'fiber', 'parts', 'lightweight', 'materials', 'weight', 'reduction', 'roll', 'cage', 'bucket', 'seats', 
        'harness', 'seatbelts', 'track', 'ready', 'cars', 'racing', 'licenses', 'racing', 'schools', 'motorsports', 
        'enthusiasts', 'car', 'clubs', 'car', 'meets', 'classic', 'cars', 'vintage', 'cars', 'muscle', 'cars', 'hot', 
        'rods', 'tuner', 'cars', 'modded', 'cars', 'car', 'shows', 'car', 'detailing', 'ceramic', 'coating', 'paint', 
        'protection', 'PPF', 'vinyl', 'wraps', 'chrome', 'delete', 'window', 'tinting', 'alloy', 'wheel', 'restoration', 
        'engine', 'rebuilding', 'engine', 'swaps', 'manual', 'conversion', 'custom', 'exhaust', 'systems', 'performance', 
        'brakes', 'big', 'brake', 'kit', 'Brembo', 'brakes', 'slotted', 'rotors', 'vented', 'rotors', 'performance', 
        'tires', 'drag', 'radials', 'slicks', 'track', 'tires', 'aftermarket', 'wheels', 'lightweight', 'wheels', 
        'racing', 'suspension', 'coilovers', 'strut', 'bars', 'anti-roll', 'bars', 'sway', 'bars', 'lowering', 
        'springs', 'chassis', 'reinforcement', 'roll', 'cages', 'racing', 'seats', 'harness', 'racing', 'helmets', 
        'race', 'suits'
    ]],
    
    
'real_estate' => [
    'title_id' => 15,
    'words' => [
        'property', 'house', 'investment', 'market', 'agent', 'buyer', 'sale', 'mortgage', 'rental',
        'real', 'estate', 'broker', 'listing', 'home', 'apartment', 'condominium', 'townhouse', 'duplex', 
        'multi-family', 'unit', 'commercial', 'property', 'residential', 'property', 'vacant', 'land', 'lot', 
        'foreclosure', 'short', 'sale', 'auction', 'open', 'house', 'inspection', 'closing', 'escrow', 'title', 
        'deed', 'liens', 'appraisal', 'valuation', 'real', 'estate', 'appraiser', 'comparative', 'market', 
        'analysis', 'CMA', 'property', 'valuation', 'market', 'value', 'fair', 'market', 'value', 'list', 
        'price', 'offer', 'counteroffer', 'purchase', 'agreement', 'contract', 'closing', 'costs', 'earnest', 
        'money', 'deposit', 'contingencies', 'due', 'diligence', 'home', 'inspection', 'property', 'taxes', 
        'property', 'assessment', 'homeowners', 'insurance', 'flood', 'insurance', 'title', 'insurance', 
        'home', 'warranty', 'down', 'payment', 'equity', 'loan', 'officer', 'lender', 'pre-approval', 'pre-qualification', 
        'credit', 'score', 'interest', 'rate', 'fixed-rate', 'mortgage', 'adjustable-rate', 'mortgage', 'ARM', 'loan', 
        'amortization', 'balloon', 'payment', 'principal', 'interest', 'taxes', 'insurance', 'PITI', 'escrow', 
        'account', 'points', 'origination', 'fee', 'closing', 'disclosure', 'refinance', 'home', 'equity', 'line', 
        'of', 'credit', 'HELOC', 'reverse', 'mortgage', 'FHA', 'loan', 'VA', 'loan', 'conventional', 'loan', 'jumbo', 
        'loan', 'adjustable-rate', 'mortgage', 'ARMs', 'interest-only', 'mortgage', 'debt-to-income', 'ratio', 
        'DTI', 'underwriting', 'applicant', 'credit', 'report', 'real', 'estate', 'developer', 'new', 'construction', 
        'building', 'permits', 'zoning', 'regulations', 'building', 'codes', 'land', 'use', 'planning', 'landlord', 
        'tenant', 'lease', 'agreement', 'rent', 'security', 'deposit', 'rental', 'income', 'rental', 'yield', 
        'cash', 'flow', 'passive', 'income', 'investment', 'property', 'real', 'estate', 'portfolio', 'property', 
        'management', 'property', 'manager', 'tenant', 'screening', 'vacancy', 'rate', 'maintenance', 'repairs', 
        'upkeep', 'homeowners', 'association', 'HOA', 'fees', 'community', 'amenities', 'gated', 'community', 
        'condominium', 'fees', 'landscaping', 'pest', 'control', 'utilities', 'water', 'sewage', 'electricity', 
        'natural', 'gas', 'solar', 'panels', 'energy-efficient', 'homes', 'smart', 'homes', 'green', 'building', 
        'certifications', 'LEED', 'certified', 'real', 'estate', 'tax', 'deductions', 'capital', 'gains', 'tax', 
        '1031', 'exchange', 'depreciation', 'real', 'estate', 'investor', 'rental', 'property', 'flipping', 
        'houses', 'buy-and-hold', 'strategy', 'fix-and-flip', 'strategy', 'BRRRR', 'strategy', 'real', 'estate', 
        'crowdfunding', 'syndication', 'real', 'estate', 'investment', 'trust', 'REIT', 'income', 'property', 
        'vacation', 'rental', 'Airbnb', 'short-term', 'rental', 'long-term', 'rental', 'rental', 'yield', 'return', 
        'on', 'investment', 'ROI', 'cash-on-cash', 'return', 'appreciation', 'depreciation', 'tax', 'benefits', 
        'rental', 'market', 'vacancy', 'rate', 'occupancy', 'rate', 'gross', 'rental', 'income', 'net', 'operating', 
        'income', 'NOI', 'cap', 'rate', 'capitalization', 'rate', 'net', 'cash', 'flow', 'property', 'management', 
        'fees', 'property', 'maintenance', 'costs', 'repairs', 'capital', 'expenditures', 'tenant', 'improvements', 
        'real', 'estate', 'investment', 'analysis', 'rental', 'comparables', 'rental', 'comps', 'property', 
        'management', 'software', 'real', 'estate', 'analytics', 'home', 'automation', 'smart', 'locks', 'video', 
        'surveillance', 'home', 'security', 'systems', 'home', 'improvements', 'remodeling', 'renovation', 
        'remodel', 'kitchen', 'renovation', 'bathroom', 'renovation', 'roof', 'replacement', 'flooring', 
        'replacement', 'paint', 'interior', 'design', 'landscaping', 'curb', 'appeal', 'home', 'staging', 
        'open', 'house', 'virtual', 'tours', '3D', 'home', 'tours', 'virtual', 'reality', 'home', 'tours', 
        'real', 'estate', 'technology', 'proptech', 'blockchain', 'real', 'estate', 'transactions', 'smart', 
        'contracts', 'deeds', 'on', 'blockchain', 'property', 'data', 'real', 'estate', 'big', 'data', 'AI-powered', 
        'property', 'valuations', 'automated', 'valuations', 'AVMs', 'real', 'estate', 'development', 'real', 
        'estate', 'funding', 'real', 'estate', 'law', 'zoning', 'laws', 'property', 'disclosures', 'flood', 
        'zones', 'earthquake', 'zones', 'natural', 'disaster', 'insurance', 'fire', 'insurance', 'hazard', 
        'insurance', 'flood', 'insurance', 'windstorm', 'insurance', 'earthquake', 'insurance', 'property', 
        'tax', 'assessments', 'HOA', 'rules', 'HOA', 'fees', 'landlord-tenant', 'law', 'evictions', 'tenant', 
        'rights', 'fair', 'housing', 'laws', 'rental', 'agreements', 'lease', 'negotiations', 'move-in', 
        'inspections', 'move-out', 'inspections', 'tenant', 'screening', 'background', 'checks', 'credit', 
        'checks', 'rental', 'history', 'references'
    ]],
    
    
'business' => [
    'title_id' => 16,
    'words' => [
        'startup', 'entrepreneur', 'strategy', 'market', 'client', 'sales', 'marketing', 'growth', 'business',
        'enterprise', 'corporation', 'small', 'business', 'SMEs', 'innovation', 'disruption', 'scaling', 
        'bootstrapping', 'venture', 'capital', 'angel', 'investor', 'fundraising', 'pitch', 'deck', 'business', 
        'plan', 'profit', 'revenue', 'expenses', 'cash', 'flow', 'balance', 'sheet', 'income', 'statement', 
        'financial', 'projections', 'profit', 'and', 'loss', 'P&L', 'gross', 'margin', 'net', 'income', 'return', 
        'on', 'investment', 'ROI', 'break-even', 'analysis', 'operating', 'costs', 'overhead', 'costs', 'capital', 
        'expenditures', 'CAPEX', 'assets', 'liabilities', 'equity', 'shareholders', 'board', 'of', 'directors', 
        'CEO', 'CFO', 'COO', 'founder', 'co-founder', 'managing', 'partner', 'executive', 'team', 'leadership', 
        'management', 'team', 'organizational', 'structure', 'corporate', 'governance', 'business', 'ethics', 
        'corporate', 'social', 'responsibility', 'CSR', 'sustainability', 'supply', 'chain', 'management', 'logistics', 
        'procurement', 'inventory', 'management', 'warehouse', 'distribution', 'vendor', 'management', 'supplier', 
        'relations', 'wholesale', 'retail', 'e-commerce', 'online', 'marketplaces', 'dropshipping', 'B2B', 'B2C', 
        'customer', 'relationship', 'management', 'CRM', 'customer', 'retention', 'customer', 'acquisition', 'customer', 
        'service', 'client', 'onboarding', 'user', 'experience', 'UX', 'user', 'interface', 'UI', 'feedback', 
        'customer', 'reviews', 'loyalty', 'programs', 'referral', 'programs', 'word-of-mouth', 'branding', 
        'brand', 'identity', 'brand', 'awareness', 'brand', 'equity', 'rebranding', 'brand', 'positioning', 
        'brand', 'loyalty', 'public', 'relations', 'PR', 'media', 'coverage', 'press', 'releases', 'corporate', 
        'communications', 'crisis', 'management', 'reputation', 'management', 'sales', 'funnel', 'lead', 'generation', 
        'lead', 'nurturing', 'prospecting', 'sales', 'pipeline', 'closing', 'deals', 'conversion', 'rate', 'upselling', 
        'cross-selling', 'account', 'management', 'key', 'accounts', 'sales', 'territories', 'quota', 'incentives', 
        'commission', 'structure', 'performance', 'bonuses', 'target', 'markets', 'niche', 'markets', 'market', 
        'segmentation', 'product', 'market', 'fit', 'pricing', 'strategy', 'value', 'proposition', 'competitive', 
        'advantage', 'differentiation', 'barriers', 'to', 'entry', 'business', 'model', 'business', 'canvas', 'pivot', 
        'market', 'research', 'competitive', 'analysis', 'industry', 'trends', 'SWOT', 'analysis', 'strengths', 'weaknesses', 
        'opportunities', 'threats', 'PESTLE', 'analysis', 'macro', 'environment', 'micro', 'environment', 'economies', 
        'of', 'scale', 'economies', 'of', 'scope', 'monopoly', 'oligopoly', 'perfect', 'competition', 'competitive', 
        'landscape', 'joint', 'ventures', 'mergers', 'and', 'acquisitions', 'M&A', 'due', 'diligence', 'synergies', 
        'leveraged', 'buyout', 'LBO', 'initial', 'public', 'offering', 'IPO', 'stock', 'market', 'valuation', 
        'market', 'capitalization', 'share', 'price', 'dividends', 'shareholders', 'equity', 'private', 'equity', 
        'growth', 'equity', 'venture', 'capital', 'funds', 'investment', 'rounds', 'seed', 'funding', 'series', 'A', 
        'funding', 'series', 'B', 'C', 'funding', 'exit', 'strategy', 'acquisition', 'IPO', 'startup', 'accelerator', 
        'business', 'incubator', 'mentorship', 'entrepreneurship', 'entrepreneurial', 'ecosystem', 'innovation', 
        'hub', 'Silicon', 'Valley', 'disruptive', 'innovation', 'scaling', 'operations', 'lean', 'startup', 'minimum', 
        'viable', 'product', 'MVP', 'growth', 'hacking', 'customer', 'retention', 'lifetime', 'value', 'CLV', 'customer', 
        'acquisition', 'cost', 'CAC', 'viral', 'marketing', 'content', 'marketing', 'social', 'media', 'marketing', 
        'influencer', 'marketing', 'search', 'engine', 'optimization', 'SEO', 'pay-per-click', 'PPC', 'advertising', 
        'ad', 'spend', 'return', 'on', 'ad', 'spend', 'ROAS', 'affiliate', 'marketing', 'email', 'campaigns', 'digital', 
        'marketing', 'content', 'strategy', 'webinars', 'podcasts', 'blogging', 'video', 'marketing', 'viral', 'videos', 
        'marketing', 'automation', 'chatbots', 'artificial', 'intelligence', 'AI', 'machine', 'learning', 'data', 
        'analytics', 'big', 'data', 'business', 'intelligence', 'BI', 'dashboards', 'KPI', 'key', 'performance', 
        'indicators', 'ROI', 'return', 'on', 'investment', 'financial', 'ratios', 'debt-to-equity', 'ratio', 'liquidity', 
        'ratios', 'profit', 'margins', 'gross', 'profit', 'margin', 'operating', 'profit', 'margin', 'net', 'profit', 
        'margin', 'EBITDA', 'earnings', 'before', 'interest', 'taxes', 'depreciation', 'and', 'amortization', 'working', 
        'capital', 'cash', 'conversion', 'cycle', 'inventory', 'turnover', 'days', 'payables', 'days', 'receivables', 
        'accounts', 'receivable', 'accounts', 'payable', 'business', 'loans', 'term', 'loans', 'lines', 'of', 'credit', 
        'commercial', 'real', 'estate', 'loans', 'SBA', 'loans', 'debt', 'financing', 'equity', 'financing', 'angel', 
        'investors', 'venture', 'capitalists', 'crowdfunding', 'platforms', 'syndication', 'equity', 'crowdfunding', 
        'reward-based', 'crowdfunding', 'peer-to-peer', 'lending', 'P2P', 'lending', 'blockchain', 'fintech', 'cryptocurrency', 
        'smart', 'contracts', 'decentralized', 'finance', 'DeFi', 'digital', 'payments', 'e-wallets', 'cybersecurity', 
        'data', 'breaches', 'GDPR', 'data', 'privacy', 'regulations', 'compliance', 'audit', 'internal', 'audit', 
        'external', 'audit', 'regulatory', 'compliance', 'business', 'law', 'employment', 'law', 'labor', 'relations', 
        'workplace', 'diversity', 'HR', 'human', 'resources', 'talent', 'management', 'recruiting', 'employee', 
        'retention', 'employee', 'onboarding', 'workplace', 'culture', 'leadership', 'development', 'team', 'building', 
        'employee', 'engagement', 'remote', 'working', 'flexible', 'working', 'hours', 'work-from-home', 'hybrid', 
        'work', 'model', 'employee', 'benefits', 'health', 'insurance', 'retirement', 'plans', 'stock', 'options', 
        'equity', 'incentives', 'diversity', 'and', 'inclusion', 'D&I'
    ]],
    
    
'art' => [
    'title_id' => 17,
    'words' => [
        'painting', 'sculpture', 'gallery', 'artist', 'exhibition', 'creative', 'canvas', 'masterpiece', 'visual',
        'fine', 'arts', 'contemporary', 'art', 'modern', 'art', 'classical', 'art', 'abstract', 'art', 'impressionism', 
        'expressionism', 'cubism', 'surrealism', 'realism', 'figurative', 'art', 'minimalism', 'pop', 'art', 'installation', 
        'art', 'performance', 'art', 'digital', 'art', 'new', 'media', 'art', 'conceptual', 'art', 'street', 'art', 'graffiti', 
        'public', 'art', 'mural', 'portrait', 'landscape', 'still', 'life', 'sketch', 'drawing', 'charcoal', 'pastels', 
        'watercolor', 'oil', 'paint', 'acrylic', 'paint', 'mixed', 'media', 'collage', 'printmaking', 'lithography', 
        'etching', 'engraving', 'screenprinting', 'monotype', 'intaglio', 'relief', 'art', 'ceramics', 'pottery', 'clay', 
        'hand-building', 'wheel', 'throwing', 'kiln', 'firing', 'glazing', 'mosaic', 'stained', 'glass', 'metalwork', 
        'bronze', 'casting', 'lost-wax', 'method', 'stone', 'carving', 'wood', 'carving', 'ivory', 'crafts', 'fiber', 
        'arts', 'textile', 'art', 'weaving', 'tapestry', 'quilting', 'embroidery', 'crochet', 'knitting', 'fashion', 
        'design', 'jewelry', 'design', 'metal', 'art', 'goldsmithing', 'silversmithing', 'ceramic', 'design', 'industrial', 
        'design', 'product', 'design', 'graphic', 'design', 'illustration', 'typography', 'calligraphy', 'animation', 
        'motion', 'graphics', 'film', 'photography', 'portrait', 'photography', 'landscape', 'photography', 'still', 
        'life', 'photography', 'black-and-white', 'photography', 'digital', 'photography', 'darkroom', 'development', 
        'film', 'development', 'photo', 'manipulation', 'retouching', 'fine', 'art', 'photography', 'documentary', 
        'photography', 'photojournalism', 'art', 'criticism', 'art', 'history', 'art', 'theory', 'aesthetics', 
        'color', 'theory', 'composition', 'perspective', 'light', 'and', 'shadow', 'form', 'proportion', 'balance', 
        'contrast', 'texture', 'pattern', 'rhythm', 'unity', 'harmony', 'art', 'movements', 'Renaissance', 'Baroque', 
        'Rococo', 'Neoclassicism', 'Romanticism', 'Impressionism', 'Post-Impressionism', 'Symbolism', 'Fauvism', 
        'Dada', 'Surrealism', 'Bauhaus', 'Abstract', 'Expressionism', 'Color', 'Field', 'Painting', 'Op', 'Art', 
        'Kinetic', 'Art', 'Minimal', 'Art', 'Postmodern', 'Art', 'Futurism', 'Constructivism', 'De', 'Stijl', 
        'Art', 'Nouveau', 'Art', 'Deco', 'outsider', 'art', 'folk', 'art', 'naive', 'art', 'art', 'brut', 'avant-garde', 
        'art', 'alternative', 'art', 'art', 'education', 'art', 'therapy', 'artistic', 'expression', 'self-expression', 
        'creativity', 'imagination', 'inspiration', 'artistic', 'process', 'sketchbook', 'draft', 'composition', 
        'studio', 'space', 'art', 'studio', 'workshop', 'atelier', 'open', 'studio', 'art', 'residency', 'artist-in-residence', 
        'public', 'art', 'community', 'art', 'collaborative', 'art', 'art', 'installation', 'sculptural', 'installation', 
        'immersive', 'art', 'virtual', 'reality', 'art', 'augmented', 'reality', 'art', '3D', 'art', 'projection', 
        'mapping', 'interactive', 'art', 'kinetic', 'sculpture', 'light', 'art', 'sound', 'art', 'video', 'art', 
        'performance', 'art', 'happening', 'art', 'festival', 'art', 'market', 'art', 'fair', 'biennale', 'art', 
        'auction', 'gallery', 'opening', 'art', 'dealer', 'art', 'curator', 'museum', 'curator', 'art', 'museum', 
        'art', 'collector', 'art', 'patron', 'art', 'funding', 'grants', 'fellowships', 'art', 'prizes', 'commissioned', 
        'art', 'public', 'commissions', 'public', 'sculpture', 'street', 'art', 'graffiti', 'murals', 'urban', 
        'art', 'conservation', 'art', 'restoration', 'preservation', 'art', 'documentation', 'art', 'catalog', 
        'art', 'archiving', 'art', 'institutions', 'art', 'exhibitions', 'retrospective', 'solo', 'exhibition', 
        'group', 'exhibition', 'thematic', 'exhibition', 'interactive', 'exhibition', 'immersive', 'exhibition', 
        'online', 'exhibition', 'virtual', 'exhibition', 'digital', 'art', 'market', 'NFTs', 'non-fungible', 
        'tokens', 'blockchain', 'art', 'crypto', 'art', 'digital', 'collectibles', 'augmented', 'reality', 'galleries', 
        'virtual', 'reality', 'artworks', '3D', 'printing', 'in', 'art', 'artificial', 'intelligence', 'in', 'art', 
        'AI-generated', 'art', 'robotics', 'in', 'art', 'biotechnology', 'in', 'art', 'bioart', 'genetic', 'art', 
        'art', 'and', 'science', 'scientific', 'illustration', 'medical', 'illustration', 'space', 'art', 'environmental', 
        'art', 'eco-art', 'land', 'art', 'earthworks', 'site-specific', 'art', 'ephemeral', 'art', 'temporary', 
        'installations', 'digital', 'sculpture', 'interactive', 'design', 'immersive', 'media', 'new', 'media', 
        'artistic', 'expression', 'virtual', 'museum', 'digital', 'curation'
    ]],
    
    
'music' => [
    'title_id' => 18,
    'words' => [
        'concert', 'band', 'album', 'songwriter', 'stage', 'performance', 'instrument', 'genre', 'lyrics',
        'melody', 'harmony', 'rhythm', 'tempo', 'beat', 'chords', 'key', 'scale', 'octave', 'pitch', 'tune', 
        'bass', 'treble', 'acoustic', 'electric', 'live', 'session', 'recording', 'studio', 'mixing', 'mastering', 
        'producer', 'DJ', 'singer', 'vocalist', 'chorus', 'choir', 'orchestra', 'conductor', 'composer', 'arranger', 
        'conservatory', 'music', 'theory', 'notation', 'sheet', 'music', 'tablature', 'clef', 'sharp', 'flat', 
        'natural', 'dynamics', 'forte', 'piano', 'crescendo', 'decrescendo', 'legato', 'staccato', 'time', 'signature', 
        '4/4', '3/4', 'syncopation', 'counterpoint', 'polyphony', 'monophony', 'instrumental', 'vocal', 'solo', 'duet', 
        'ensemble', 'quartet', 'trio', 'orchestration', 'score', 'arrangement', 'refrain', 'bridge', 'hook', 'verse', 
        'chorus', 'outro', 'intro', 'riff', 'motif', 'symphony', 'sonata', 'concerto', 'opera', 'ballet', 'musical', 
        'theatre', 'jazz', 'blues', 'rock', 'pop', 'hip-hop', 'rap', 'country', 'folk', 'reggae', 'punk', 'metal', 
        'hard', 'rock', 'alternative', 'indie', 'grunge', 'EDM', 'electronic', 'dance', 'techno', 'house', 'dubstep', 
        'trap', 'R&B', 'soul', 'funk', 'gospel', 'classical', 'baroque', 'romantic', 'modern', 'avant-garde', 
        'experimental', 'minimalist', 'new', 'age', 'ambient', 'soundtrack', 'film', 'score', 'musical', 'score', 
        'theme', 'song', 'sound', 'design', 'sound', 'effects', 'foley', 'audio', 'engineering', 'microphone', 
        'amplifier', 'speaker', 'monitors', 'headphones', 'mixing', 'console', 'equalizer', 'reverb', 'delay', 
        'compression', 'synthesizer', 'sampler', 'drum', 'machine', 'sequencer', 'loop', 'MIDI', 'controller', 
        'turntable', 'vinyl', 'LP', 'EP', 'single', 'track', 'playlist', 'streaming', 'service', 'Spotify', 'Apple', 
        'Music', 'Tidal', 'YouTube', 'music', 'videos', 'MTV', 'Vevo', 'radio', 'station', 'broadcast', 'podcast', 
        'playlist', 'DJ', 'set', 'remix', 'mashup', 'sampling', 'cover', 'version', 'original', 'composition', 
        'jam', 'session', 'improvisation', 'looping', 'beatboxing', 'freestyle', 'battle', 'rap', 'cipher', 'beat', 
        'maker', 'producer', 'music', 'business', 'record', 'label', 'independent', 'label', 'major', 'label', 'A&R', 
        'manager', 'talent', 'scout', 'booking', 'agent', 'tour', 'manager', 'road', 'crew', 'soundcheck', 'setlist', 
        'lighting', 'technician', 'pyrotechnics', 'stage', 'design', 'stage', 'presence', 'crowd', 'interaction', 
        'encore', 'backstage', 'green', 'room', 'merchandise', 't-shirts', 'posters', 'vinyl', 'records', 'autographs', 
        'meet-and-greet', 'music', 'festival', 'open', 'mic', 'gig', 'battle', 'of', 'the', 'bands', 'karaoke', 'busking', 
        'music', 'education', 'music', 'lessons', 'instrument', 'tuning', 'guitar', 'piano', 'drums', 'bass', 'violin', 
        'cello', 'saxophone', 'trumpet', 'trombone', 'clarinet', 'flute', 'oboe', 'bassoon', 'harp', 'accordion', 'banjo', 
        'mandolin', 'ukulele', 'harmonica', 'bagpipes', 'didgeridoo', 'percussion', 'xylophone', 'marimba', 'glockenspiel', 
        'tambourine', 'triangle', 'congas', 'bongos', 'cajón', 'djembe', 'timpani', 'steel', 'drums', 'tabla', 'sitar', 
        'harpsichord', 'organ', 'synthesizer', 'modular', 'synth', 'loop', 'pedal', 'distortion', 'pedal', 'effects', 
        'pedals', 'wah', 'pedal', 'chorus', 'pedal', 'phaser', 'pedal', 'flanger', 'pedal', 'delay', 'pedal', 'reverb', 
        'pedal', 'tuner', 'pedal', 'volume', 'pedal', 'foot', 'controller', 'amp', 'stacks', 'combo', 'amps', 'practice', 
        'amps', 'tube', 'amps', 'solid', 'state', 'amps', 'acoustic', 'amps', 'electric', 'guitar', 'amps', 'bass', 
        'guitar', 'amps', 'recording', 'studio', 'home', 'studio', 'portable', 'studio', 'DAW', 'digital', 'audio', 
        'workstation', 'Pro', 'Tools', 'Logic', 'Pro', 'FL', 'Studio', 'Ableton', 'Live', 'Cubase', 'GarageBand', 
        'Reason', 'sampling', 'plugins', 'VSTs', 'synth', 'plugins', 'drum', 'machines', 'virtual', 'instruments', 
        'beat', 'sequencers', 'looping', 'software', 'midi', 'controllers', 'keyboard', 'controllers', 'MIDI', 'pads', 
        'beat', 'making', 'sampling', 'editing', 'mixing', 'mastering', 'multi-track', 'recording', 'track', 'bouncing', 
        'virtual', 'instruments', 'sound', 'banks', 'audio', 'effects', 'virtual', 'FX', 'reverb', 'plugins', 'compressor', 
        'plugins', 'delay', 'plugins', 'automation', 'in', 'music', 'production', 'timestretching', 'pitch', 'shifting', 
        'sound', 'design', 'soundscapes', 'foley', 'art', 'game', 'sound', 'design', 'film', 'scoring', 'cinematic', 
        'music', 'underscore', 'motifs', 'leitmotif', 'soundtrack', 'album', 'symphonic', 'score', 'ambient', 'soundtracks', 
        'interactive', 'music', 'in', 'games', 'dynamic', 'music', 'scoring', 'AI-generated', 'music', 'music', 'and', 
        'AI', 'artificial', 'intelligence', 'in', 'music', 'composition', 'music', 'therapy', 'music', 'and', 'health', 
        'music', 'cognition', 'effects', 'of', 'music', 'on', 'the', 'brain'
    ]],
    
    
'literature' => [
    'title_id' => 19,
    'words' => [
        'novel', 'poetry', 'author', 'publishing', 'manuscript', 'genre', 'bookstore', 'fiction', 'classic',
        'literary', 'non-fiction', 'biography', 'autobiography', 'memoir', 'short', 'story', 'novella', 'epic', 
        'saga', 'narrative', 'prose', 'verse', 'stanza', 'rhyme', 'free', 'verse', 'sonnet', 'haiku', 'limerick', 
        'ballad', 'elegy', 'ode', 'lyric', 'poem', 'metaphor', 'simile', 'allegory', 'fable', 'parable', 'myth', 
        'legend', 'folklore', 'fairy', 'tale', 'fantasy', 'science', 'fiction', 'historical', 'fiction', 'thriller', 
        'mystery', 'detective', 'fiction', 'crime', 'fiction', 'romance', 'literary', 'fiction', 'magical', 
        'realism', 'dystopian', 'utopian', 'speculative', 'fiction', 'young', 'adult', 'YA', 'children’s', 'literature', 
        'graphic', 'novel', 'comic', 'book', 'manga', 'light', 'novel', 'flash', 'fiction', 'microfiction', 'stream', 
        'of', 'consciousness', 'first-person', 'narrative', 'third-person', 'narrative', 'omniscient', 'narrator', 
        'unreliable', 'narrator', 'dialogue', 'monologue', 'soliloquy', 'plot', 'subplot', 'climax', 'resolution', 
        'denouement', 'character', 'protagonist', 'antagonist', 'round', 'character', 'flat', 'character', 'dynamic', 
        'character', 'static', 'character', 'character', 'development', 'theme', 'symbolism', 'motif', 'foreshadowing', 
        'flashback', 'tone', 'mood', 'setting', 'world-building', 'point', 'of', 'view', 'POV', 'narrative', 'voice', 
        'authorial', 'voice', 'writing', 'style', 'literary', 'devices', 'metaphor', 'irony', 'alliteration', 
        'personification', 'onomatopoeia', 'hyperbole', 'understatement', 'satire', 'parody', 'pastoral', 'tragedy', 
        'comedy', 'tragicomedy', 'bildungsroman', 'picaresque', 'epistolary', 'genre', 'fiction', 'literary', 'criticism', 
        'literary', 'analysis', 'textual', 'analysis', 'close', 'reading', 'literary', 'theory', 'structuralism', 
        'post-structuralism', 'deconstruction', 'feminist', 'criticism', 'Marxist', 'criticism', 'psychoanalytic', 
        'criticism', 'postcolonial', 'criticism', 'reader-response', 'theory', 'new', 'criticism', 'narratology', 
        'semiotics', 'hermeneutics', 'intertextuality', 'interdisciplinary', 'literature', 'comparative', 'literature', 
        'world', 'literature', 'classical', 'literature', 'Renaissance', 'literature', 'Enlightenment', 'literature', 
        'Romantic', 'literature', 'Victorian', 'literature', 'Modernist', 'literature', 'Postmodern', 'literature', 
        'contemporary', 'literature', 'avant-garde', 'literature', 'experimental', 'fiction', 'transgressive', 
        'fiction', 'pulp', 'fiction', 'noir', 'literature', 'absurdist', 'literature', 'existentialist', 'literature', 
        'satirical', 'literature', 'gothic', 'literature', 'Southern', 'gothic', 'American', 'literature', 'British', 
        'literature', 'European', 'literature', 'Latin', 'American', 'literature', 'Asian', 'literature', 'African', 
        'literature', 'Middle', 'Eastern', 'literature', 'Indigenous', 'literature', 'oral', 'traditions', 'storytelling', 
        'spoken', 'word', 'slam', 'poetry', 'performance', 'poetry', 'beat', 'generation', 'literary', 'movements', 
        'literary', 'periods', 'golden', 'age', 'literature', 'mythology', 'classics', 'Homer', 'Shakespeare', 'Dante', 
        'Milton', 'Tolstoy', 'Dickens', 'Austen', 'Woolf', 'Joyce', 'Faulkner', 'Hemingway', 'Fitzgerald', 'Orwell', 
        'Kafka', 'Proust', 'Camus', 'Nabokov', 'Dostoevsky', 'Chekhov', 'Tolkien', 'Rowling', 'King', 'Atwood', 'Morrison', 
        'Rushdie', 'Murakami', 'Nobel', 'Prize', 'Pulitzer', 'Prize', 'Booker', 'Prize', 'National', 'Book', 'Award', 
        'literary', 'festivals', 'book', 'clubs', 'reading', 'groups', 'author', 'interviews', 'book', 'signings', 
        'literary', 'agents', 'publishers', 'independent', 'publishing', 'self-publishing', 'editor', 'proofreading', 
        'copyediting', 'developmental', 'editing', 'manuscript', 'submission', 'query', 'letter', 'advance', 'royalties', 
        'book', 'deal', 'book', 'launch', 'book', 'tour', 'book', 'awards', 'bestseller', 'lists', 'literary', 'adaptations', 
        'book-to-film', 'adaptations', 'literature', 'and', 'film', 'literature', 'and', 'music', 'literature', 'and', 
        'art', 'graphic', 'novels', 'illustrated', 'books', 'children’s', 'books', 'young', 'adult', 'fiction', 
        'YA', 'crossover', 'fiction', 'fan', 'fiction', 'genre', 'fiction', 'science', 'fiction', 'fantasy', 'horror', 
        'mystery', 'thrillers', 'crime', 'fiction', 'romantic', 'fiction', 'historical', 'fiction', 'literary', 'prizes', 
        'translation', 'literature', 'world', 'literature', 'digital', 'literature', 'e-books', 'audiobooks', 'book', 
        'reviews', 'literary', 'magazines', 'journals', 'critical', 'essays', 'academic', 'writing', 'scholarly', 
        'articles', 'creative', 'writing', 'writing', 'workshops', 'writing', 'residencies', 'writing', 'prompts', 
        'writer’s', 'block', 'inspiration', 'character', 'development', 'plot', 'structure', 'narrative', 'arc', 
        'conflict', 'resolution', 'setting', 'dialogue', 'world-building', 'literary', 'style', 'voice', 'point', 
        'of', 'view', 'first-person', 'third-person', 'omniscient', 'narrative', 'experimental', 'narrative', 
        'nonlinear', 'narrative', 'flashbacks', 'flash', 'fiction', 'drabble', 'epistolary', 'novels'
    ]],
    
    
'philosophy' => [
    'title_id' => 20,
    'words' => [
        'ethics', 'morality', 'logic', 'reason', 'existentialism', 'metaphysics', 'theory', 'knowledge', 'thought',
        'epistemology', 'ontology', 'aesthetics', 'phenomenology', 'dualism', 'monism', 'idealism', 'materialism',
        'rationalism', 'empiricism', 'skepticism', 'nihilism', 'utilitarianism', 'deontology', 'virtue', 
        'moral', 'relativism', 'free', 'will', 'determinism', 'causality', 'consciousness', 'identity', 'subjectivity',
        'objectivity', 'dialectics', 'synthesis', 'hedonism', 'stoicism', 'pragmatism', 'positivism', 'structuralism',
        'hermeneutics', 'semiotics', 'analytic', 'language', 'science', 'metaphysical', 'realism', 'nominalism', 
        'constructivism', 'objectivism', 'subjectivism', 'truth', 'coherence', 'belief', 'Gettier', 'problem', 
        'skepticism', 'evidence', 'priori', 'posteriori', 'paradox', 'Ship', 'Theseus', 'mind-body', 'transhumanism',
        'biotechnology', 'robotics', 'AI', 'digital', 'simulation', 'hypothesis', 'agnosticism', 'atheism', 'deism', 
        'pantheism', 'problem', 'evil', 'cosmological', 'argument', 'Pascal’s', 'wager', 'naturalism', 'idealism',
        'phenomenalism', 'scientific', 'instrumentalism', 'epistemic', 'relativism', 'falsifiability', 'paradigm', 
        'shifts', 'Frankfurt', 'School', 'dialectical', 'materialism', 'queer', 'theory', 'dilemma', 'blame', 'praise', 
        'culpability', 'liberalism', 'conservatism', 'anarchism', 'feminism', 'autonomy', 'deontological', 'consequentialism',
        'natural', 'rights', 'sovereignty', 'capitalism', 'socialism', 'communism', 'egoism', 'altruism', 'teleology',
        'cosmology', 'ontology', 'epistemology', 'naturalism', 'dualism', 'fatalism', 'chance', 'probability', 'indeterminism',
        'responsibility', 'freedom', 'individualism', 'collectivism', 'dialectic', 'abstract', 'empiricism', 'rationality',
        'consciousness', 'experience', 'essence', 'existence', 'imperative', 'liberty', 'justice', 'wisdom', 'holism', 
        'law', 'libertarianism', 'positivism', 'realism', 'normative', 'patriotism', 'freedom', 'mind', 'political', 
        'theism', 'theology', 'thought', 'experiment', 'value'
    ]],
    
    
'history' => [
    'title_id' => 21,
    'words' => [
        'ancient', 'empire', 'civilization', 'war', 'revolution', 'medieval', 'monarchy', 'historical', 'archive',
        'dynasty', 'kingdom', 'feudalism', 'colonization', 'renaissance', 'industrial', 'age', 'enlightenment', 
        'imperialism', 'crusades', 'renaissance', 'enlightenment', 'reformation', 'colonialism', 'dark', 'ages', 
        'golden', 'age', 'exploration', 'conquest', 'settlement', 'archaeology', 'artifact', 'chronology', 
        'timeline', 'primary', 'sources', 'secondary', 'sources', 'historian', 'oral', 'tradition', 'manuscript', 
        'scroll', 'papyrus', 'tablet', 'hieroglyphics', 'cuneiform', 'pictographs', 'codex', 'chronicle', 'annals', 
        'genealogy', 'lineage', 'heritage', 'ancestry', 'historical', 'method', 'historical', 'materialism', 'oral', 
        'history', 'documentary', 'evidence', 'census', 'records', 'genealogical', 'records', 'imperial', 'dynasties', 
        'political', 'history', 'cultural', 'history', 'social', 'history', 'economic', 'history', 'military', 
        'history', 'intellectual', 'history', 'urban', 'history', 'legal', 'history', 'ecclesiastical', 'history', 
        'maritime', 'history', 'scientific', 'revolution', 'scientific', 'discovery', 'invention', 'treaty', 'manifesto', 
        'declaration', 'constitution', 'parliament', 'empire', 'kingdom', 'city-state', 'vassal', 'colony', 'protectorate', 
        'sovereignty', 'nation-state', 'confederation', 'federation', 'unification', 'imperial', 'expansion', 'collapse', 
        'downfall', 'rebellion', 'uprising', 'insurrection', 'siege', 'conquest', 'treaty', 'armistice', 'ceasefire', 
        'annexation', 'occupation', 'liberation', 'independence', 'decolonization', 'settler', 'colonialism', 'migration', 
        'diaspora', 'trade', 'route', 'silk', 'road', 'spice', 'trade', 'triangular', 'trade', 'slave', 'trade', 'indentured', 
        'servitude', 'abolition', 'abolitionism', 'emancipation', 'civil', 'rights', 'movements', 'social', 'movements', 
        'suffrage', 'women’s', 'rights', 'labor', 'unions', 'industrialization', 'urbanization', 'capitalism', 
        'socialism', 'communism', 'fascism', 'feudalism', 'mercantilism', 'liberalism', 'republic', 'democracy', 
        'aristocracy', 'oligarchy', 'tyranny', 'totalitarianism', 'dictatorship', 'autocracy', 'constitutional', 
        'monarchy', 'theocracy', 'nation-building', 'reformation', 'counter-reformation', 'humanism', 'secularism', 
        'religious', 'wars', 'iconoclasm', 'heresy', 'inquisition', 'crusades', 'holy', 'war', 'reconquista', 
        'schism', 'monasticism', 'chivalry', 'knighthood', 'samurai', 'bushido', 'vikings', 'mongols', 'huns', 
        'ottoman', 'empire', 'roman', 'empire', 'byzantine', 'empire', 'persian', 'empire', 'alexander', 'the', 
        'great', 'hammurabi', 'code', 'napoleon', 'bonaparte', 'julius', 'caesar', 'genghis', 'khan', 'cleopatra', 
        'queen', 'elizabeth', 'king', 'henry', 'viii', 'abraham', 'lincoln', 'george', 'washington', 'mohandas', 
        'gandhi', 'nelson', 'mandela', 'martin', 'luther', 'king', 'jr', 'winston', 'churchill', 'franklin', 
        'roosevelt', 'john', 'f', 'kennedy', 'cultural', 'revolutions', 'artistic', 'movements', 'renaissance', 
        'romanticism', 'realism', 'modernism', 'postmodernism', 'baroque', 'rococo', 'neoclassicism', 'historical', 
        'novels', 'historical', 'biographies', 'memoirs', 'oral', 'history', 'world', 'war', 'i', 'world', 'war', 
        'ii', 'cold', 'war', 'korean', 'war', 'vietnam', 'war', 'gulf', 'war', 'civil', 'war', 'american', 
        'revolution', 'french', 'revolution', 'russian', 'revolution', 'haitian', 'revolution', 'industrial', 
        'revolution', 'scientific', 'revolution', 'information', 'age', 'digital', 'revolution', 'stone', 'age', 
        'bronze', 'age', 'iron', 'age', 'middle', 'ages', 'renaissance', 'enlightenment', 'age', 'of', 'exploration', 
        'industrial', 'era', 'post-industrial', 'era', 'world', 'wars', 'cold', 'war', 'modern', 'history', 
        'postmodern', 'history', 'decolonization', 'globalization', 'postcolonial', 'era', 'historical', 'revisionism', 
        'historical', 'memory', 'historiography', 'nationalism', 'imperialism', 'colonialism', 'international', 
        'relations', 'geopolitics', 'power', 'struggles', 'civil', 'rights', 'movements', 'global', 'conflicts', 
        'international', 'trade', 'economic', 'crises', 'great', 'depression', 'financial', 'crashes', 'market', 
        'economies', 'world', 'leaders', 'alliances', 'treaties', 'pacts'
    ]],
    
    
'psychology' => [
    'title_id' => 22,
    'words' => [
        'behavior', 'mind', 'cognition', 'therapy', 'emotion', 'mental', 'memory', 'motivation', 'perception',
        'development', 'learning', 'personality', 'psychotherapy', 'counseling', 'psychoanalysis', 'behaviorism', 
        'cognitive', 'behavioral', 'therapy', 'CBT', 'emotional', 'intelligence', 'stress', 'anxiety', 'depression', 
        'mental', 'disorders', 'diagnosis', 'treatment', 'clinical', 'psychology', 'social', 'psychology', 'developmental', 
        'psychology', 'child', 'development', 'adolescent', 'psychology', 'adult', 'development', 'aging', 'neuropsychology', 
        'psychopathology', 'psychometrics', 'psychological', 'assessment', 'intelligence', 'testing', 'IQ', 'emotional', 
        'regulation', 'self-esteem', 'self-concept', 'self-actualization', 'Maslow', 'hierarchy', 'of', 'needs', 'self-awareness', 
        'ego', 'id', 'superego', 'unconscious', 'conscious', 'Freudian', 'theory', 'Jungian', 'archetypes', 'dream', 'analysis', 
        'defense', 'mechanisms', 'projection', 'displacement', 'sublimation', 'denial', 'rationalization', 'regression', 
        'repression', 'attachment', 'theory', 'secure', 'attachment', 'insecure', 'attachment', 'anxious', 'attachment', 
        'avoidant', 'attachment', 'ambivalent', 'attachment', 'parenting', 'styles', 'authoritative', 'authoritarian', 
        'permissive', 'neglectful', 'personality', 'disorders', 'borderline', 'personality', 'disorder', 'narcissistic', 
        'personality', 'disorder', 'antisocial', 'personality', 'disorder', 'histrionic', 'personality', 'disorder', 
        'schizophrenia', 'bipolar', 'disorder', 'obsessive-compulsive', 'disorder', 'OCD', 'post-traumatic', 'stress', 
        'disorder', 'PTSD', 'eating', 'disorders', 'anorexia', 'nervosa', 'bulimia', 'nervosa', 'binge-eating', 'disorder', 
        'attention-deficit', 'hyperactivity', 'disorder', 'ADHD', 'autism', 'spectrum', 'disorder', 'ASD', 'neurodevelopmental', 
        'disorders', 'neuroplasticity', 'brain', 'function', 'neural', 'pathways', 'synaptic', 'connections', 'dopamine', 
        'serotonin', 'neurotransmitters', 'endocrine', 'system', 'hormones', 'cortisol', 'adrenaline', 'fight-or-flight', 
        'response', 'rest-and-digest', 'nervous', 'system', 'sympathetic', 'nervous', 'system', 'parasympathetic', 'nervous', 
        'system', 'meditation', 'mindfulness', 'relaxation', 'techniques', 'biofeedback', 'positive', 'psychology', 'gratitude', 
        'resilience', 'optimism', 'mindset', 'growth', 'mindset', 'fixed', 'mindset', 'behavioral', 'psychology', 'operant', 
        'conditioning', 'classical', 'conditioning', 'reinforcement', 'positive', 'reinforcement', 'negative', 'reinforcement', 
        'punishment', 'behavior', 'modification', 'extinction', 'habituation', 'sensitization', 'cognitive', 'development', 
        'Piaget', 'stages', 'of', 'development', 'sensorimotor', 'preoperational', 'concrete', 'operational', 'formal', 
        'operational', 'Vygotsky', 'zone', 'of', 'proximal', 'development', 'ZPD', 'scaffolding', 'language', 'acquisition', 
        'theory', 'Chomsky', 'innate', 'language', 'hypothesis', 'LAD', 'language', 'acquisition', 'device', 'critical', 
        'period', 'theory', 'empathy', 'sympathy', 'prosocial', 'behavior', 'altruism', 'prosocial', 'behavior', 'groupthink', 
        'social', 'influence', 'obedience', 'to', 'authority', 'Milgram', 'experiment', 'Stanford', 'prison', 'experiment', 
        'Zimbardo', 'bystander', 'effect', 'diffusion', 'of', 'responsibility', 'social', 'loafing', 'conformity', 
        'Asch', 'conformity', 'experiments', 'peer', 'pressure', 'social', 'identity', 'theory', 'ingroup', 'outgroup', 
        'prejudice', 'stereotypes', 'discrimination', 'implicit', 'bias', 'explicit', 'bias', 'attitude', 'change', 
        'cognitive', 'dissonance', 'theory', 'Festinger', 'attribution', 'theory', 'internal', 'attribution', 'external', 
        'attribution', 'fundamental', 'attribution', 'error', 'self-serving', 'bias', 'halo', 'effect', 'reciprocity', 
        'social', 'exchange', 'theory', 'reciprocal', 'determinism', 'Bandura', 'social', 'learning', 'theory', 
        'observational', 'learning', 'modeling', 'self-efficacy', 'intrinsic', 'motivation', 'extrinsic', 'motivation', 
        'goal-setting', 'theory', 'drive', 'theory', 'self-determination', 'theory', 'SDT', 'autonomy', 'competence', 
        'relatedness', 'emotional', 'regulation', 'frustration', 'aggression', 'catharsis', 'theory', 'frustration-aggression', 
        'hypothesis', 'interpersonal', 'relationships', 'attachment', 'styles', 'love', 'triangular', 'theory', 'of', 'love', 
        'Sternberg', 'intimacy', 'passion', 'commitment', 'group', 'dynamics', 'leadership', 'styles', 'authoritative', 
        'democratic', 'laissez-faire', 'leadership', 'burnout', 'workplace', 'psychology', 'industrial-organizational', 
        'psychology', 'job', 'satisfaction', 'employee', 'engagement', 'teamwork', 'conflict', 'resolution', 'emotional', 
        'labor', 'empathy', 'in', 'the', 'workplace'
    ]],
    
    
'architecture' => [
    'title_id' => 23,
    'words' => [
        'building', 'structure', 'design', 'modernism', 'urban', 'construction', 'landscape', 'skyscraper', 'home',
        'blueprint', 'foundation', 'facade', 'elevation', 'floor', 'plan', 'drafting', 'CAD', 'BIM', 'zoning', 
        'regulations', 'building', 'codes', 'site', 'planning', 'urbanism', 'sustainable', 'architecture', 'green', 
        'architecture', 'LEED', 'certification', 'energy', 'efficiency', 'passive', 'design', 'solar', 'panels', 
        'geothermal', 'heating', 'ventilation', 'air', 'conditioning', 'HVAC', 'thermal', 'insulation', 'natural', 
        'lighting', 'daylighting', 'ventilation', 'circulation', 'acoustics', 'noise', 'control', 'soundproofing', 
        'spatial', 'design', 'aesthetic', 'proportion', 'symmetry', 'form', 'function', 'ornamentation', 'minimalism', 
        'brutalism', 'postmodernism', 'deconstructivism', 'high-tech', 'architecture', 'parametric', 'design', 
        'biomimicry', 'organic', 'architecture', 'art', 'deco', 'international', 'style', 'vernacular', 'architecture', 
        'gothic', 'architecture', 'baroque', 'rococo', 'neoclassical', 'classical', 'revival', 'renaissance', 'architecture', 
        'colonial', 'architecture', 'Victorian', 'architecture', 'arts', 'and', 'crafts', 'movement', 'prairie', 
        'school', 'Frank', 'Lloyd', 'Wright', 'Bauhaus', 'modern', 'architecture', 'skyscrapers', 'urban', 'planning', 
        'city', 'grid', 'street', 'layout', 'public', 'spaces', 'parks', 'plazas', 'urban', 'infrastructure', 'transit', 
        'systems', 'pedestrian', 'friendly', 'design', 'bike', 'lanes', 'smart', 'cities', 'urban', 'renewal', 'historic', 
        'preservation', 'adaptive', 'reuse', 'renovation', 'retrofitting', 'prefabrication', 'modular', 'construction', 
        'tiny', 'homes', 'container', 'architecture', 'shipping', 'containers', 'housing', 'low-income', 'housing', 
        'affordable', 'housing', 'urban', 'density', 'mixed-use', 'developments', 'residential', 'commercial', 'industrial', 
        'retail', 'mixed-use', 'buildings', 'community', 'centers', 'cultural', 'buildings', 'libraries', 'museums', 
        'schools', 'universities', 'sports', 'stadiums', 'arenas', 'performance', 'halls', 'concert', 'halls', 'theaters', 
        'auditoriums', 'exhibition', 'halls', 'conference', 'centers', 'airports', 'train', 'stations', 'bus', 'terminals', 
        'transportation', 'hubs', 'bridges', 'tunnels', 'highways', 'expressways', 'interchanges', 'pedestrian', 'bridges', 
        'railways', 'stations', 'urban', 'sprawl', 'suburban', 'development', 'rural', 'architecture', 'farms', 'barns', 
        'silos', 'agrarian', 'design', 'agricultural', 'buildings', 'greenhouses', 'water', 'management', 'irrigation', 
        'systems', 'rainwater', 'harvesting', 'stormwater', 'management', 'flood', 'control', 'dam', 'design', 'hydraulic', 
        'structures', 'coastal', 'defenses', 'seawalls', 'piers', 'docks', 'marinas', 'offshore', 'structures', 'lighthouses', 
        'wind', 'farms', 'wind', 'turbines', 'solar', 'farms', 'power', 'plants', 'industrial', 'parks', 'factories', 
        'warehouses', 'logistics', 'centers', 'distribution', 'centers', 'office', 'buildings', 'corporate', 'campuses', 
        'headquarters', 'skylines', 'iconic', 'buildings', 'landmark', 'architecture', 'monuments', 'towers', 'spires', 
        'domes', 'arches', 'columns', 'vaults', 'cantilevers', 'pavilions', 'glass', 'curtain', 'walls', 'steel', 
        'frames', 'reinforced', 'concrete', 'foundations', 'structural', 'engineering', 'mechanical', 'engineering', 
        'electrical', 'engineering', 'civil', 'engineering', 'materials', 'brick', 'stone', 'concrete', 'timber', 
        'steel', 'glass', 'aluminum', 'composite', 'materials', 'carbon', 'fiber', '3D', 'printing', 'architecture', 
        'parametric', 'design', 'software', 'sustainability', 'energy-efficient', 'buildings', 'carbon', 'footprint', 
        'life-cycle', 'assessment', 'building', 'envelope', 'green', 'roofs', 'living', 'walls', 'biophilic', 'design', 
        'urban', 'gardens', 'public', 'art', 'landscape', 'architecture', 'hardscape', 'softscape', 'water', 'features', 
        'fountains', 'ponds', 'sustainable', 'landscaping', 'xeriscaping', 'urban', 'forests', 'tree-lined', 'streets', 
        'shade', 'structures', 'gazebos', 'pergolas', 'outdoor', 'living', 'spaces', 'plazas', 'courtyards', 'squares', 
        'urban', 'furniture', 'benches', 'bicycle', 'racks', 'public', 'transportation', 'shelters', 'lighting', 
        'fixtures', 'wayfinding', 'signage', 'urban', 'fabric', 'civic', 'architecture', 'public', 'infrastructure', 
        'smart', 'buildings', 'net-zero', 'energy', 'homes', 'carbon-neutral', 'buildings', 'adaptive', 'reuse'
    ]],
    
    
'design' => [
    'title_id' => 24,
    'words' => [
        'creativity', 'graphic', 'interface', 'layout', 'branding', 'product', 'visual', 'interaction', 'aesthetics',
        'typography', 'color', 'composition', 'prototyping', 'wireframe', 'usability', 'UX', 'UI', 'responsive', 
        'grid', 'symmetry', 'contrast', 'hierarchy', 'alignment', 'proportion', 'balance', 'scale', 'depth', 
        'minimalism', 'realism', 'illustration', 'logo', 'icon', 'palette', 'storyboard', 'persona', 'user', 
        'research', 'content', 'mapping', 'affordance', 'feedback', 'modularity', 'iterative', 'prototype', 
        'design', 'system', 'motion', 'animation', 'inclusive', 'accessible', 'universal', 'eco-friendly', 
        'ergonomics', 'sketching', 'mockups', 'flowchart', 'drafting', 'ideation', 'creativity', 'innovation', 
        'interaction', 'information', 'architecture', 'wireframes', 'motion', 'grid', 'display', 'fonts', 
        'brochure', 'packaging', 'label', 'cover', 'branding', 'digital', 'editorial', 'magazine', 'print', 
        'banner', 'infographics', 'presentation', 'collaterals', 'email', 'advertising', 'multimedia', 'animation', 
        'cinematography', 'motion', 'microinteractions', 'iconography', 'interactive', 'UX', 'journey', 'testing', 
        'Figma', 'Sketch', 'Adobe', 'prototyping', 'high-fidelity', 'low-fidelity', 'web', 'responsive', 'flexbox', 
        'bootstrap', 'media', 'query', 'legibility', 'readability', 'grid', 'systems', 'flexible', 'responsive', 
        'typographic', 'scales', 'guidelines', 'style', 'guides', 'variables', 'usability', 'mockup', 'user', 
        'flows', 'interaction', 'patterns'
    ]],
    
    
'photography' => [
    'title_id' => 25,
    'words' => [
        'camera', 'lens', 'exposure', 'composition', 'portrait', 'landscape', 'digital', 'studio', 'light',
        'shutter', 'aperture', 'ISO', 'depth', 'focus', 'macro', 'telephoto', 'wide-angle', 'prime', 'zoom',
        'bokeh', 'manual', 'autofocus', 'tripod', 'filter', 'flash', 'lighting', 'natural', 'contrast', 
        'high-key', 'low-key', 'shadows', 'highlights', 'RAW', 'JPEG', 'post-processing', 'editing', 'retouching',
        'white', 'balance', 'exposure', 'bracketing', 'HDR', 'composition', 'rule', 'of', 'thirds', 'leading', 
        'lines', 'framing', 'negative', 'space', 'symmetry', 'patterns', 'textures', 'panorama', 'time-lapse', 
        'long-exposure', 'motion', 'blur', 'freeze', 'action', 'studio', 'setup', 'modeling', 'backdrop', 'props',
        'shoot', 'session', 'film', 'analog', 'grain', 'darkroom', 'developing', 'enlarger', 'print', 'black-and-white',
        'color', 'balance', 'contrast', 'sharpness', 'image', 'quality', 'megapixel', 'sensor', 'DSLR', 'mirrorless', 
        'full-frame', 'crop', 'sensor', 'aspect', 'ratio', 'framing', 'wide', 'shot', 'close-up', 'zoom', 'telephoto',
        'macro', 'exposure', 'meter', 'histogram', 'light', 'meter', 'softbox', 'diffuser', 'reflector', 'lens', 
        'flare', 'vignette', 'contrast', 'saturation', 'sharpness', 'grain', 'clarity', 'cropping', 'perspective',
        'composition', 'panorama', 'framing', 'motion', 'freeze', 'action', 'burst', 'mode'
    ]],
    
    
'media' => [
    'title_id' => 26,
    'words' => [
        'journalism', 'broadcast', 'news', 'television', 'documentary', 'press', 'radio', 'magazine', 'internet',
        'newspaper', 'reporting', 'editorial', 'article', 'headline', 'interview', 'media', 'coverage', 'live', 
        'stream', 'podcast', 'social', 'media', 'viral', 'content', 'public', 'relations', 'media', 'outlets', 
        'press', 'release', 'newsroom', 'anchor', 'correspondent', 'reporter', 'media', 'bias', 'censorship', 
        'freedom', 'of', 'press', 'investigative', 'journalism', 'fact-checking', 'opinion', 'piece', 'feature', 
        'story', 'breaking', 'news', '24-hour', 'news', 'cycle', 'ratings', 'advertising', 'sponsorship', 
        'commercial', 'broadcasting', 'syndication', 'airtime', 'primetime', 'morning', 'show', 'talk', 'show', 
        'game', 'show', 'entertainment', 'news', 'weather', 'forecast', 'public', 'service', 'announcement', 
        'PSA', 'infotainment', 'documentary', 'film', 'independent', 'media', 'alternative', 'media', 'digital', 
        'media', 'streaming', 'service', 'online', 'platform', 'subscription', 'paywall', 'content', 'moderation', 
        'comment', 'section', 'user-generated', 'content', 'UGC', 'interactive', 'media', 'multimedia', 'cross-platform',
        'engagement', 'clickbait', 'sensationalism', 'infographic', 'multimedia', 'presentation', 'fact-check', 
        'satire', 'parody', 'infomercial', 'script', 'writing', 'producer', 'director', 'camera', 'operator', 
        'sound', 'engineer', 'editor', 'broadcast', 'rights', 'media', 'ethics', 'media', 'law', 'intellectual', 
        'property', 'fair', 'use', 'libel', 'defamation', 'privacy', 'copyright', 'trademark', 'digital', 
        'rights', 'advertising', 'sponsorship', 'revenue', 'brand', 'placement', 'product', 'integration', 
        'native', 'advertising', 'audience', 'targeting', 'demographics', 'viewer', 'ratings', 'audience', 
        'engagement', 'public', 'access', 'media', 'cable', 'network', 'satellite', 'distribution', 'news', 
        'agency', 'media', 'relations', 'press', 'conference', 'media', 'advisory', 'press', 'corps', 'content', 
        'distribution', 'breaking', 'news', 'coverage', 'influencer', 'media', 'landscape', 'media', 'conglomerate',
        'cross-media', 'partnerships'
    ]],
    
    
'marketing' => [
    'title_id' => 27,
    'words' => [
        'branding', 'strategy', 'advertising', 'promotion', 'campaign', 'customer', 'market', 'content', 'lead',
        'target', 'audience', 'segmentation', 'positioning', 'brand', 'awareness', 'demand', 'generation', 'inbound', 
        'outbound', 'B2B', 'B2C', 'digital', 'marketing', 'social', 'media', 'SEO', 'SEM', 'PPC', 'email', 
        'marketing', 'automation', 'analytics', 'ROI', 'CPC', 'CTR', 'conversion', 'rate', 'lead', 'nurturing', 
        'customer', 'retention', 'customer', 'acquisition', 'customer', 'journey', 'sales', 'funnel', 'A/B', 
        'testing', 'split', 'testing', 'personalization', 'influencer', 'marketing', 'affiliate', 'marketing', 
        'referral', 'programs', 'growth', 'hacking', 'viral', 'marketing', 'content', 'creation', 'content', 
        'distribution', 'blogging', 'vlogging', 'podcasting', 'video', 'marketing', 'visual', 'content', 'webinars', 
        'e-books', 'white', 'papers', 'case', 'studies', 'landing', 'pages', 'call-to-action', 'CTA', 'lead', 
        'generation', 'CRM', 'customer', 'relationship', 'management', 'loyalty', 'programs', 'engagement', 
        'metrics', 'KPI', 'key', 'performance', 'indicators', 'branding', 'guidelines', 'brand', 'equity', 
        'brand', 'identity', 'brand', 'loyalty', 'brand', 'advocacy', 'reputation', 'management', 'PR', 'public', 
        'relations', 'press', 'release', 'earned', 'media', 'paid', 'media', 'owned', 'media', 'sponsorship', 
        'event', 'marketing', 'trade', 'shows', 'webinars', 'workshops', 'networking', 'inbound', 'content', 
        'strategy', 'copywriting', 'ad', 'copy', 'influencer', 'collaborations', 'social', 'proof', 'testimonials', 
        'user-generated', 'content', 'UGC', 'organic', 'reach', 'paid', 'reach', 'cost-per-click', 'CPC', 'cost-per-lead', 
        'CPL', 'return', 'on', 'investment', 'ROI', 'lead', 'score', 'sales', 'enablement', 'lifetime', 'value', 
        'LTV', 'customer', 'experience', 'CX', 'market', 'research', 'competitive', 'analysis', 'SWOT', 'analysis', 
        'strengths', 'weaknesses', 'opportunities', 'threats', 'product', 'market', 'fit', 'go-to-market', 'plan', 
        'pricing', 'strategy', 'value', 'proposition', 'USP', 'unique', 'selling', 'proposition', 'marketing', 
        'channels', 'distribution', 'channels', 'multichannel', 'omnichannel', 'campaign', 'tracking', 'data', 
        'driven', 'marketing', 'customer', 'insights', 'behavioral', 'targeting', 'demographic', 'targeting', 
        'geographic', 'targeting', 'psychographic', 'targeting', 'retargeting', 'remarketing', 'programmatic', 
        'advertising', 'native', 'advertising', 'sponsored', 'content', 'dynamic', 'content', 'interactive', 'content', 
        'marketing', 'ROI', 'customer', 'satisfaction', 'brand', 'positioning', 'direct', 'marketing', 'telemarketing', 
        'SMS', 'marketing', 'messenger', 'marketing', 'chatbot', 'engagement', 'loyalty', 'programs', 'product', 
        'launch', 'roadmap', 'PR', 'strategy'
    ]],
    
    
'advertising' => [
    'title_id' => 28,
    'words' => [
        'campaign', 'promotion', 'brand', 'consumer', 'media', 'billboard', 'creative', 'strategy', 'client',
        'advertisement', 'ad', 'copy', 'slogan', 'headline', 'tagline', 'target', 'audience', 'reach', 
        'frequency', 'impressions', 'engagement', 'click-through', 'rate', 'CTR', 'cost-per-click', 'CPC', 
        'cost-per-thousand', 'CPM', 'cost-per-lead', 'CPL', 'call-to-action', 'CTA', 'conversion', 'rate', 
        'banner', 'ads', 'pop-up', 'ads', 'native', 'advertising', 'display', 'ads', 'search', 'ads', 'social', 
        'media', 'ads', 'video', 'ads', 'radio', 'commercials', 'TV', 'commercials', 'online', 'advertising', 
        'programmatic', 'advertising', 'sponsored', 'content', 'advertising', 'platforms', 'Google', 'Ads', 
        'Facebook', 'Ads', 'Instagram', 'Ads', 'YouTube', 'Ads', 'LinkedIn', 'Ads', 'paid', 'search', 'SEO', 
        'search', 'engine', 'marketing', 'SEM', 'display', 'network', 'ad', 'placement', 'ad', 'inventory', 
        'programmatic', 'bidding', 'real-time', 'bidding', 'RTB', 'geotargeting', 'retargeting', 'remarketing', 
        'behavioral', 'targeting', 'demographic', 'targeting', 'psychographic', 'targeting', 'contextual', 
        'advertising', 'influencer', 'marketing', 'affiliate', 'marketing', 'brand', 'ambassadors', 'celebrity', 
        'endorsements', 'sponsorships', 'product', 'placement', 'branded', 'content', 'advertorial', 'infomercial', 
        'direct', 'response', 'advertising', 'print', 'ads', 'magazine', 'ads', 'newspaper', 'ads', 'out-of-home', 
        'advertising', 'OOH', 'transit', 'advertising', 'bus', 'wraps', 'digital', 'billboards', 'point-of-sale', 
        'advertising', 'POS', 'guerrilla', 'marketing', 'experiential', 'marketing', 'interactive', 'advertising', 
        'engagement', 'metrics', 'ad', 'spend', 'return', 'on', 'ad', 'spend', 'ROAS', 'advertising', 'budget', 
        'media', 'planning', 'media', 'buying', 'ad', 'agencies', 'creative', 'brief', 'advertising', 'campaigns', 
        'client', 'pitch', 'storyboard', 'creative', 'director', 'art', 'director', 'copywriter', 'media', 
        'planner', 'media', 'buyer', 'account', 'executive', 'brand', 'manager', 'ad', 'testing', 'focus', 'groups', 
        'audience', 'research', 'market', 'research', 'split', 'testing', 'A/B', 'testing', 'ad', 'optimization', 
        'personalization', 'ad', 'tracking', 'conversion', 'tracking', 'impression', 'share', 'ad', 'analytics', 
        'advertising', 'technology', 'ad', 'networks', 'ad', 'exchanges', 'demand-side', 'platforms', 'DSP', 
        'supply-side', 'platforms', 'SSP', 'ad', 'fraud', 'click', 'fraud', 'viewability', 'ad', 'view', 'advertising', 
        'standards', 'Interactive', 'Advertising', 'Bureau', 'IAB', 'privacy', 'compliance', 'GDPR', 'CCPA', 
        'cookie', 'consent', 'advertising', 'ethics', 'false', 'advertising', 'misleading', 'claims', 'advertising', 
        'laws', 'advertising', 'regulations', 'ad', 'campaign', 'management', 'multichannel', 'campaigns'
    ]],
    
    
'fitness' => [
    'title_id' => 29,
    'words' => [
        'exercise', 'workout', 'gym', 'training', 'nutrition', 'strength', 'conditioning', 'endurance', 'health',
        'cardio', 'aerobics', 'HIIT', 'interval', 'training', 'weightlifting', 'bodybuilding', 'crossfit', 'calisthenics', 
        'yoga', 'pilates', 'flexibility', 'mobility', 'balance', 'core', 'stability', 'agility', 'speed', 'power', 
        'resistance', 'training', 'free', 'weights', 'dumbbells', 'barbells', 'kettlebells', 'machines', 'circuit', 
        'training', 'bodyweight', 'exercises', 'squats', 'lunges', 'push-ups', 'pull-ups', 'planks', 'deadlifts', 
        'bench', 'press', 'shoulder', 'press', 'bicep', 'curls', 'tricep', 'dips', 'leg', 'press', 'leg', 'curls', 
        'row', 'machine', 'treadmill', 'elliptical', 'stationary', 'bike', 'rowing', 'machine', 'jump', 'rope', 
        'cool-down', 'warm-up', 'stretching', 'foam', 'rolling', 'recovery', 'hydration', 'supplements', 'protein', 
        'carbohydrates', 'fats', 'macronutrients', 'micronutrients', 'calories', 'meal', 'prep', 'diet', 'balance', 
        'portion', 'control', 'clean', 'eating', 'caloric', 'deficit', 'caloric', 'surplus', 'metabolism', 
        'basal', 'metabolic', 'rate', 'BMR', 'body', 'mass', 'index', 'BMI', 'body', 'fat', 'percentage', 
        'muscle', 'mass', 'lean', 'body', 'mass', 'fitness', 'goals', 'personal', 'trainer', 'fitness', 'coach', 
        'workout', 'plan', 'training', 'program', 'periodization', 'overtraining', 'progressive', 'overload', 
        'rest', 'days', 'active', 'recovery', 'injury', 'prevention', 'strength', 'training', 'muscle', 'hypertrophy', 
        'cardiovascular', 'fitness', 'VO2', 'max', 'heart', 'rate', 'monitor', 'target', 'heart', 'rate', 'zone', 
        'fitness', 'assessment', 'fitness', 'app', 'wearable', 'technology', 'smartwatch', 'step', 'tracker', 
        'fitness', 'community', 'group', 'workouts', 'bootcamp', 'classes', 'spin', 'class', 'Zumba', 'dance', 
        'class', 'kickboxing', 'martial', 'arts', 'self-defense', 'training', 'outdoor', 'fitness', 'hiking', 
        'running', 'cycling', 'swimming', 'triathlon', 'marathon', 'half-marathon', 'sprints', 'intervals', 
        'resting', 'heart', 'rate', 'high-intensity', 'interval', 'training', 'HIIT', 'low-intensity', 'steady', 
        'state', 'LISS', 'sleep', 'recovery', 'stress', 'management', 'mindfulness', 'mental', 'health', 
        'fitness', 'motivation', 'accountability', 'goal-setting', 'discipline', 'consistency', 'progress', 
        'fitness', 'tracking', 'before-and-after', 'photos', 'fitness', 'journal', 'fitness', 'challenges'
    ]],
    
    
'wellness' => [
    'title_id' => 30,
    'words' => [
        'mindfulness', 'self-care', 'meditation', 'balance', 'nutrition', 'stress', 'relaxation', 'holistic', 'mental',
        'emotional', 'physical', 'well-being', 'spiritual', 'healing', 'resilience', 'mental', 'health', 'positive', 
        'thinking', 'self-awareness', 'self-compassion', 'gratitude', 'journaling', 'empathy', 'mind-body', 'connection', 
        'inner', 'peace', 'wellness', 'routine', 'rituals', 'healthy', 'habits', 'life', 'balance', 'work-life', 'balance', 
        'detox', 'cleansing', 'hydration', 'sleep', 'quality', 'rest', 'herbal', 'remedies', 'alternative', 'medicine', 
        'yoga', 'breathing', 'exercises', 'guided', 'meditation', 'visualization', 'sound', 'therapy', 'aromatherapy', 
        'essential', 'oils', 'acupuncture', 'massage', 'therapy', 'reiki', 'energy', 'healing', 'emotional', 
        'well-being', 'chakra', 'alignment', 'wellness', 'retreats', 'spa', 'therapy', 'sauna', 'hot', 'stone', 
        'therapy', 'herbal', 'teas', 'healthy', 'diet', 'superfoods', 'plant-based', 'diet', 'organic', 'foods', 
        'clean', 'eating', 'whole', 'foods', 'balanced', 'diet', 'immune', 'system', 'support', 'vitamins', 
        'supplements', 'antioxidants', 'probiotics', 'mental', 'clarity', 'focus', 'productivity', 'stress', 
        'management', 'emotional', 'resilience', 'positive', 'affirmations', 'body', 'awareness', 'detoxification', 
        'mindful', 'eating', 'meditative', 'practices', 'nature', 'connection', 'outdoor', 'activities', 'wellness', 
        'coaching', 'holistic', 'health', 'integrative', 'medicine', 'functional', 'medicine', 'longevity', 'anti-aging', 
        'self-improvement', 'personal', 'growth', 'inner', 'strength', 'meditation', 'apps', 'guided', 'imagery', 
        'chakra', 'balancing', 'tai', 'chi', 'qi', 'gong', 'wellness', 'tracking', 'mindful', 'living', 'digital', 
        'detox', 'emotional', 'intelligence', 'forgiveness', 'letting', 'go', 'positive', 'vibes', 'well-being', 
        'resilience', 'empowerment', 'stress-free', 'environment', 'social', 'connections', 'support', 'system', 
        'community', 'well-being', 'financial', 'wellness', 'personal', 'boundaries', 'self-acceptance', 'positive', 
        'self-talk', 'holistic', 'lifestyle', 'mindful', 'breathing', 'wellness', 'goals', 'life', 'satisfaction', 
        'mind', 'and', 'body', 'connection', 'emotional', 'healing', 'mental', 'clarity'
    ]],
    
    
'cosmetics' => [
    'title_id' => 31,
    'words' => [
        'makeup', 'skincare', 'beauty', 'fragrance', 'hair', 'lipstick', 'eyeshadow', 'moisturizer', 'salon',
        'foundation', 'concealer', 'blush', 'highlighter', 'contour', 'primer', 'powder', 'mascara', 'eyeliner', 
        'brow', 'pencil', 'lip', 'gloss', 'lip', 'liner', 'setting', 'spray', 'setting', 'powder', 'makeup', 
        'brushes', 'makeup', 'sponges', 'compact', 'mirror', 'palette', 'bronzer', 'brow', 'gel', 'tinted', 
        'moisturizer', 'BB', 'cream', 'CC', 'cream', 'serum', 'toner', 'cleanser', 'exfoliator', 'facial', 
        'mask', 'face', 'scrub', 'peel', 'sunscreen', 'SPF', 'hydration', 'anti-aging', 'serum', 'eye', 'cream', 
        'night', 'cream', 'day', 'cream', 'face', 'oil', 'beauty', 'balm', 'body', 'lotion', 'body', 'butter', 
        'hand', 'cream', 'foot', 'cream', 'cuticle', 'oil', 'nail', 'polish', 'nail', 'file', 'nail', 'buffer', 
        'base', 'coat', 'top', 'coat', 'manicure', 'pedicure', 'acrylic', 'nails', 'gel', 'nails', 'nail', 'art', 
        'hair', 'care', 'shampoo', 'conditioner', 'leave-in', 'conditioner', 'hair', 'mask', 'hair', 'serum', 
        'heat', 'protectant', 'dry', 'shampoo', 'hairspray', 'hair', 'mousse', 'hair', 'gel', 'hair', 'wax', 
        'hair', 'color', 'hair', 'dye', 'highlights', 'balayage', 'ombre', 'hair', 'extensions', 'wig', 'hair', 
        'clip', 'blow', 'dryer', 'flat', 'iron', 'curling', 'iron', 'hot', 'rollers', 'hair', 'brush', 'hair', 
        'comb', 'scalp', 'treatment', 'frizz', 'control', 'volumizing', 'mousse', 'shine', 'spray', 'beard', 
        'oil', 'beard', 'balm', 'shaving', 'cream', 'aftershave', 'razor', 'body', 'wash', 'scrub', 'loofah', 
        'pumice', 'stone', 'bath', 'bombs', 'bath', 'salts', 'perfume', 'cologne', 'eau', 'de', 'parfum', 'eau', 
        'de', 'toilette', 'fragrance', 'mist', 'deodorant', 'antiperspirant', 'body', 'spray', 'beauty', 'tools', 
        'tweezers', 'eyelash', 'curler', 'makeup', 'remover', 'cotton', 'pads', 'q-tips', 'face', 'rollers', 
        'gua', 'sha', 'jade', 'roller', 'microneedling', 'facial', 'steamer', 'exfoliating', 'brush', 'beauty', 
        'blender', 'spatula', 'applicator', 'waxing', 'kit', 'hair', 'removal', 'laser', 'hair', 'removal', 'threading', 
        'facial', 'toning', 'devices', 'LED', 'light', 'therapy', 'skincare', 'routine', 'double', 'cleansing'
    ]],
    
    
'gaming' => [
    'title_id' => 32,
    'words' => [
        'console', 'esports', 'virtual', 'multiplayer', 'strategy', 'gamer', 'tournament', 'controller', 'arcade',
        'PC', 'gaming', 'RPG', 'MMORPG', 'FPS', 'shooter', 'MOBA', 'battle', 'royale', 'open-world', 'sandbox', 
        'adventure', 'action', 'simulation', 'puzzle', 'platformer', 'racing', 'sports', 'real-time', 'strategy', 
        'turn-based', 'indie', 'game', 'AAA', 'title', 'game', 'development', 'game', 'engine', 'Unity', 'Unreal', 
        'Engine', 'graphics', 'rendering', '3D', '2D', 'VR', 'AR', 'augmented', 'reality', 'virtual', 'reality', 
        'gameplay', 'mechanics', 'AI', 'artificial', 'intelligence', 'NPC', 'non-playable', 'character', 'quest', 
        'missions', 'side-quests', 'loot', 'leveling', 'progression', 'skill', 'tree', 'leaderboard', 'ranking', 
        'matchmaking', 'PvP', 'PvE', 'guilds', 'clans', 'achievements', 'trophies', 'skins', 'customization', 
        'DLC', 'downloadable', 'content', 'expansion', 'packs', 'season', 'pass', 'microtransactions', 'loot', 
        'boxes', 'in-game', 'currency', 'coins', 'gems', 'gold', 'XP', 'experience', 'points', 'grinding', 'farming', 
        'boss', 'battles', 'co-op', 'competitive', 'LAN', 'party', 'voice', 'chat', 'headset', 'streaming', 'Twitch', 
        'YouTube', 'gameplay', 'streamer', 'livestream', 'broadcast', 'speedrun', 'modding', 'mods', 'custom', 'maps', 
        'game', 'servers', 'dedicated', 'servers', 'patch', 'update', 'hotfix', 'beta', 'testing', 'early', 'access', 
        'gaming', 'community', 'forums', 'discord', 'esports', 'league', 'team', 'player', 'coaching', 'sponsorships', 
        'prize', 'pool', 'shoutcaster', 'observer', 'replay', 'analysis', 'meta', 'game', 'balancing', 'patch', 
        'notes', 'LAN', 'events', 'global', 'rankings', 'online', 'tournaments', 'leaderboards', 'cross-platform', 
        'compatibility', 'cloud', 'gaming', 'game', 'store', 'Steam', 'Epic', 'Games', 'Store', 'Origin', 'Battle.net', 
        'Xbox', 'Live', 'PlayStation', 'Network', 'Nintendo', 'Switch', 'controller', 'joystick', 'gamepad', 
        'haptic', 'feedback', 'rumble', 'vibration', 'motion', 'controls', 'VR', 'headset', 'motion', 'tracking', 
        'eSports', 'broadcasting', 'team', 'management', 'tournament', 'organizers', 'player', 'contracts', 
        'sponsorship', 'endorsement', 'gaming', 'chair', 'gaming', 'setup', 'RGB', 'lighting', 'cooling', 
        'system', 'gaming', 'laptop', 'gaming', 'desktop', 'build', 'overclocking', 'graphics', 'card', 
        'GPU', 'frame', 'rate', 'FPS', 'resolution', 'lag', 'latency', 'ping', 'controller', 'sensitivity', 
        'game', 'console', 'next-gen', 'consoles', 'backward', 'compatibility', 'gaming', 'franchises', 'retro', 
        'gaming', 'arcade', 'machines', 'pinball', 'coin-operated', 'games', 'independent', 'developers', 
        'game', 'jams', 'game', 'demos'
    ]],
    
    
'parenting' => [
    'title_id' => 33,
    'words' => [
        'child', 'family', 'education', 'development', 'care', 'support', 'motherhood', 'fatherhood', 'discipline',
        'nurturing', 'parenthood', 'parental', 'guidance', 'attachment', 'bonding', 'parenting', 'styles', 'authoritative', 
        'authoritarian', 'permissive', 'unconditional', 'love', 'empathy', 'communication', 'boundaries', 'routine', 
        'positive', 'reinforcement', 'patience', 'behavior', 'management', 'childcare', 'babysitting', 'daycare', 
        'preschool', 'education', 'early', 'childhood', 'learning', 'milestones', 'emotional', 'development', 
        'cognitive', 'development', 'social', 'skills', 'playtime', 'childproofing', 'safety', 'health', 'nutrition', 
        'vaccinations', 'immunizations', 'pediatrician', 'well-child', 'visits', 'breastfeeding', 'formula', 'feeding', 
        'diapers', 'potty', 'training', 'sleep', 'training', 'bedtime', 'routine', 'screen', 'time', 'siblings', 
        'birth', 'order', 'single', 'parenting', 'blended', 'families', 'step-parenting', 'co-parenting', 'adoption', 
        'foster', 'care', 'teen', 'parenting', 'parenting', 'advice', 'discipline', 'strategies', 'positive', 
        'discipline', 'timeouts', 'reward', 'charts', 'emotional', 'regulation', 'tantrums', 'patience', 'self-regulation', 
        'role', 'modeling', 'parent-child', 'relationship', 'parental', 'involvement', 'school', 'engagement', 
        'homework', 'help', 'parent-teacher', 'meetings', 'extracurricular', 'activities', 'sports', 'music', 
        'art', 'parental', 'expectations', 'family', 'traditions', 'vacations', 'holidays', 'work-life', 'balance', 
        'self-care', 'for', 'parents', 'parenting', 'stress', 'coping', 'with', 'parental', 'fatigue', 'parenting', 
        'books', 'parenting', 'blogs', 'parenting', 'podcasts', 'parenting', 'workshops', 'support', 'groups', 
        'parenting', 'classes', 'discipline', 'and', 'behavior', 'management', 'child', 'psychology', 'attachment', 
        'theory', 'resilience', 'building', 'confidence', 'in', 'children', 'respectful', 'parenting', 'autonomy', 
        'child-led', 'play', 'developmental', 'delays', 'special', 'needs', 'parenting', 'support', 'education', 
        'IEP', 'individualized', 'education', 'plan', 'advocacy', 'for', 'children', 'parenting', 'teens', 
        'independence', 'boundaries', 'screen', 'time', 'management', 'social', 'media', 'parenting', 'digital', 
        'safety', 'online', 'safety', 'peer', 'pressure', 'bullying', 'family', 'meals', 'healthy', 'eating', 
        'sleep', 'schedules', 'parental', 'leave', 'maternity', 'leave', 'paternity', 'leave', 'work-from-home', 
        'parenting', 'childhood', 'memories', 'parent-child', 'communication', 'talking', 'about', 'feelings', 
        'encouragement', 'and', 'praise', 'positive', 'parenting', 'growth', 'mindset', 'parenting', 'parenting', 
        'challenges', 'infancy', 'toddler', 'years', 'school-age', 'parenting', 'adolescence', 'teenager'
    ]],
    
    
'relationships' => [
    'title_id' => 34,
    'words' => [
        'love', 'marriage', 'dating', 'friendship', 'bond', 'communication', 'support', 'affection', 'trust',
        'commitment', 'intimacy', 'empathy', 'understanding', 'partnership', 'connection', 'loyalty', 'respect', 
        'honesty', 'compatibility', 'romance', 'courtship', 'engagement', 'wedding', 'honeymoon', 'companionship', 
        'relationship', 'goals', 'conflict', 'resolution', 'compromise', 'boundaries', 'emotional', 'intelligence', 
        'vulnerability', 'forgiveness', 'reconciliation', 'chemistry', 'passion', 'support', 'system', 'jealousy', 
        'infidelity', 'trustworthiness', 'communication', 'skills', 'active', 'listening', 'non-verbal', 'cues', 
        'body', 'language', 'healthy', 'relationships', 'mutual', 'respect', 'shared', 'values', 'cooperation', 
        'negotiation', 'problem-solving', 'disagreements', 'teamwork', 'collaboration', 'emotional', 'support', 
        'mental', 'health', 'boundaries', 'self-love', 'self-esteem', 'attachment', 'styles', 'secure', 'attachment', 
        'anxious', 'attachment', 'avoidant', 'attachment', 'relationship', 'dynamics', 'power', 'balance', 'interdependence', 
        'codependence', 'individuality', 'space', 'growth', 'together', 'life', 'partner', 'spouse', 'boyfriend', 
        'girlfriend', 'platonic', 'relationships', 'family', 'relationships', 'parent-child', 'sibling', 'relationships', 
        'long-distance', 'relationships', 'trust-building', 'relationship', 'maintenance', 'breakup', 'divorce', 
        'separation', 'rebuilding', 'relationships', 'forgiveness', 'healing', 'closure', 'moving', 'on', 'second', 
        'chances', 'reconnection', 'support', 'networks', 'emotional', 'availability', 'love', 'languages', 'quality', 
        'time', 'acts', 'of', 'service', 'gifts', 'words', 'of', 'affirmation', 'physical', 'touch', 'relationship', 
        'counseling', 'therapy', 'couples', 'therapy', 'family', 'therapy', 'relationship', 'advice', 'dating', 
        'apps', 'online', 'dating', 'matchmaking', 'blind', 'date', 'first', 'date', 'speed', 'dating', 'long-term', 
        'relationships', 'commitment', 'rings', 'anniversary', 'celebration', 'renewal', 'of', 'vows', 'family', 
        'planning', 'shared', 'finances', 'cohabitation', 'home', 'life', 'living', 'together', 'relationship', 
        'expectations', 'sacrifice', 'partnership', 'life', 'balance', 'personal', 'space', 'jealousy', 'trust', 
        'long-term', 'success', 'shared', 'goals', 'parenting', 'roles', 'emotional', 'connection', 'conflict', 
        'management', 'open', 'communication', 'relationship', 'milestones', 'trust', 'after', 'conflict'
    ]],
    
    
'pets' => [
    'title_id' => 35,
    'words' => [
        'dog', 'cat', 'veterinarian', 'grooming', 'care', 'adoption', 'pet', 'training', 'nutrition',
        'animal', 'rescue', 'shelter', 'puppy', 'kitten', 'pet', 'store', 'vaccination', 'spaying', 'neutering', 
        'microchipping', 'collar', 'leash', 'harness', 'crate', 'litter', 'box', 'pet', 'bed', 'toys', 'pet', 
        'food', 'treats', 'feeding', 'schedule', 'water', 'bowl', 'brushing', 'fur', 'claws', 'nail', 'trimming', 
        'bath', 'flea', 'treatment', 'tick', 'prevention', 'heartworm', 'medication', 'dental', 'care', 'exercise', 
        'walks', 'dog', 'park', 'obedience', 'training', 'behavior', 'modification', 'commands', 'sit', 'stay', 
        'come', 'fetch', 'housebreaking', 'litter', 'training', 'crate', 'training', 'socialization', 'playtime', 
        'indoor', 'cats', 'outdoor', 'pets', 'foster', 'care', 'pet', 'insurance', 'emergency', 'vet', 'care', 
        'allergies', 'pet-friendly', 'housing', 'traveling', 'with', 'pets', 'pet', 'carrier', 'airline', 'regulations', 
        'boarding', 'kennel', 'dog', 'walker', 'pet', 'sitter', 'pet', 'health', 'checkups', 'vaccines', 'deworming', 
        'pet', 'license', 'service', 'animals', 'emotional', 'support', 'animals', 'therapy', 'animals', 'exotic', 
        'pets', 'reptiles', 'birds', 'hamsters', 'guinea', 'pigs', 'rabbits', 'fish', 'aquarium', 'tanks', 'bedding', 
        'cage', 'cleaning', 'pet', 'groomer', 'coat', 'care', 'shedding', 'pet', 'hair', 'pet', 'odor', 'stain', 
        'removal', 'behavioral', 'issues', 'aggression', 'separation', 'anxiety', 'barking', 'chewing', 'scratching', 
        'pet', 'safety', 'pet-proofing', 'home', 'indoor', 'plants', 'toxic', 'to', 'pets', 'flea', 'collars', 
        'wellness', 'exams', 'pet', 'supplements', 'joint', 'health', 'senior', 'pets', 'special', 'needs', 'pets', 
        'blind', 'pets', 'deaf', 'pets', 'dietary', 'restrictions', 'raw', 'food', 'grain-free', 'diet', 'pet', 
        'exercise', 'enrichment', 'mental', 'stimulation', 'interactive', 'toys', 'chew', 'toys', 'scratch', 
        'posts', 'pet', 'adoption', 'events', 'pet', 'fairs', 'responsible', 'pet', 'ownership', 'animal', 'rights'
    ]],
    
    
'spirituality' => [
    'title_id' => 36,
    'words' => [
        'faith', 'religion', 'meditation', 'soul', 'prayer', 'spirit', 'inner peace', 'wisdom', 'belief',
        'enlightenment', 'consciousness', 'transcendence', 'awakening', 'karma', 'reincarnation', 'afterlife', 
        'nirvana', 'mantra', 'chanting', 'mindfulness', 'presence', 'divinity', 'sacred', 'sacrifice', 'pilgrimage', 
        'ritual', 'ceremony', 'blessing', 'spiritual', 'practice', 'forgiveness', 'compassion', 'gratitude', 
        'humility', 'spiritual', 'guidance', 'higher', 'self', 'divine', 'connection', 'sacred', 'texts', 'scriptures', 
        'Bible', 'Quran', 'Torah', 'Vedas', 'sutras', 'holy', 'books', 'mysticism', 'metaphysical', 'energy', 
        'aura', 'chakra', 'balance', 'third', 'eye', 'intuition', 'prophecy', 'spiritual', 'journey', 'pilgrimage', 
        'self-realization', 'self-awareness', 'purpose', 'meaning', 'existence', 'life', 'death', 'rebirth', 
        'surrender', 'trust', 'cosmos', 'universe', 'oneness', 'holiness', 'sacred', 'spaces', 'temple', 'church', 
        'mosque', 'synagogue', 'monastery', 'shrine', 'altar', 'spiritual', 'leaders', 'guru', 'shaman', 'priest', 
        'monk', 'nun', 'rabbi', 'imam', 'pastor', 'minister', 'spiritual', 'community', 'congregation', 'worship', 
        'devotion', 'offering', 'meditative', 'state', 'trance', 'altered', 'consciousness', 'fasting', 'asceticism', 
        'celibacy', 'holy', 'days', 'festivals', 'spiritual', 'symbols', 'cross', 'star', 'of', 'David', 'crescent', 
        'moon', 'om', 'lotus', 'flower', 'tree', 'of', 'life', 'yin', 'yang', 'divine', 'feminine', 'sacred', 
        'masculine', 'soulmate', 'twin', 'flame', 'guardian', 'angels', 'archangels', 'deities', 'pantheon', 
        'mythology', 'creation', 'stories', 'prophets', 'vision', 'quest', 'sacred', 'geometry', 'spiritual', 
        'healing', 'reiki', 'energy', 'work', 'crystals', 'chakras', 'balance', 'aromatherapy', 'essential', 
        'oils', 'healing', 'herbs', 'sound', 'healing', 'vibration', 'spiritual', 'awakening', 'ascension', 
        'universal', 'truths', 'life', 'purpose', 'spiritual', 'evolution', 'soul', 'growth', 'spiritual', 
        'teacher', 'mentor', 'divine', 'love', 'service', 'to', 'others', 'charity', 'kindness', 'purity', 
        'simplicity', 'spiritual', 'transformation', 'healing', 'journey', 'alignment', 'inner', 'truth'
    ]],
    
    
'charity' => [
    'title_id' => 37,
    'words' => [
        'donation', 'volunteer', 'fundraising', 'nonprofit', 'support', 'community', 'cause', 'event', 'philanthropy',
        'charitable', 'giving', 'non-governmental', 'organization', 'NGO', 'aid', 'relief', 'campaign', 'crowdfunding', 
        'pledge', 'charitable', 'trust', 'endowment', 'foundation', 'humanitarian', 'service', 'altruism', 'social', 
        'impact', 'grant', 'funding', 'scholarship', 'charity', 'drive', 'awareness', 'advocacy', 'mission', 'goals', 
        'outreach', 'beneficiary', 'donor', 'sponsor', 'corporate', 'social', 'responsibility', 'CSR', 'social', 
        'enterprise', 'matching', 'gifts', 'in-kind', 'donations', 'charity', 'auction', 'silent', 'auction', 
        'raffle', 'charity', 'walk', 'charity', 'run', 'marathon', 'telethon', 'charity', 'gala', 'benefit', 'concert', 
        'awareness', 'campaign', 'grassroots', 'movement', 'volunteerism', 'community', 'service', 'impact', 'measurement', 
        'capacity', 'building', 'programs', 'partnerships', 'collaborations', 'donor', 'engagement', 'sustainability', 
        'ethical', 'fundraising', 'capital', 'campaign', 'social', 'change', 'giving', 'back', 'compassion', 
        'humanitarianism', 'generosity', 'benevolence', 'charitable', 'organizations', 'local', 'charities', 
        'international', 'aid', 'emergency', 'relief', 'disaster', 'relief', 'health', 'initiatives', 'education', 
        'support', 'youth', 'development', 'elderly', 'care', 'animal', 'welfare', 'environmental', 'conservation', 
        'poverty', 'alleviation', 'hunger', 'relief', 'homelessness', 'shelters', 'food', 'banks', 'clean', 'water', 
        'sanitation', 'hygiene', 'medical', 'aid', 'immunization', 'disease', 'prevention', 'mental', 'health', 
        'support', 'refugee', 'assistance', 'advocacy', 'campaigns', 'disability', 'rights', 'gender', 'equality', 
        'LGBTQ+', 'support', 'racial', 'justice', 'human', 'rights', 'economic', 'empowerment', 'microfinance', 
        'livelihoods', 'job', 'training', 'scholarships', 'educational', 'grants', 'mentorship', 'programs', 
        'arts', 'and', 'culture', 'initiatives', 'sports', 'development', 'capacity', 'building', 'donor', 
        'recognition', 'thank-you', 'letters', 'annual', 'reports', 'financial', 'transparency', 'ethical', 
        'stewardship', 'board', 'of', 'directors', 'fundraising', 'events', 'digital', 'fundraising', 'online', 
        'donations', 'peer-to-peer', 'fundraising', 'legacy', 'giving', 'planned', 'gifts', 'estate', 'planning', 
        'impact', 'investment'
    ]],
    
    
'law' => [
    'title_id' => 38,
    'words' => [
        'justice', 'court', 'legal', 'defense', 'judge', 'rights', 'case', 'lawsuit', 'trial',
        'attorney', 'lawyer', 'prosecution', 'plaintiff', 'defendant', 'jury', 'verdict', 'appeal', 'sentence',
        'criminal', 'law', 'civil', 'law', 'constitutional', 'law', 'family', 'law', 'contract', 'law', 'property', 
        'law', 'corporate', 'law', 'intellectual', 'property', 'IP', 'patent', 'trademark', 'copyright', 'litigation', 
        'arbitration', 'mediation', 'settlement', 'negotiation', 'evidence', 'witness', 'testimony', 'cross-examination', 
        'hearing', 'subpoena', 'warrant', 'bail', 'indictment', 'felony', 'misdemeanor', 'penalty', 'imprisonment', 
        'probation', 'parole', 'legal', 'advice', 'consultation', 'law', 'firm', 'legal', 'aid', 'public', 'defender', 
        'private', 'attorney', 'pro', 'bono', 'representation', 'statute', 'regulation', 'ordinance', 'precedent', 
        'case', 'law', 'jurisdiction', 'venue', 'federal', 'law', 'state', 'law', 'local', 'law', 'international', 
        'law', 'human', 'rights', 'civil', 'rights', 'employment', 'law', 'labor', 'law', 'tax', 'law', 'environmental', 
        'law', 'immigration', 'law', 'bankruptcy', 'law', 'personal', 'injury', 'law', 'estate', 'planning', 'real', 
        'estate', 'law', 'torts', 'negligence', 'breach', 'of', 'contract', 'damages', 'liability', 'compensation', 
        'fiduciary', 'duty', 'malpractice', 'intoxication', 'insanity', 'plea', 'self-defense', 'entrapment', 
        'double', 'jeopardy', 'statute', 'of', 'limitations', 'burden', 'of', 'proof', 'preponderance', 'of', 'evidence', 
        'beyond', 'reasonable', 'doubt', 'constitutional', 'rights', 'due', 'process', 'equal', 'protection', 'habeas', 
        'corpus', 'search', 'and', 'seizure', 'Miranda', 'rights', 'right', 'to', 'counsel', 'free', 'speech', 
        'freedom', 'of', 'religion', 'privacy', 'protection', 'against', 'self-incrimination', 'right', 'to', 'a', 
        'fair', 'trial', 'speedy', 'trial', 'impartial', 'jury', 'writ', 'of', 'mandamus', 'injunction', 'restraining', 
        'order', 'contempt', 'of', 'court', 'perjury', 'obstruction', 'of', 'justice', 'fraud', 'embezzlement', 'theft', 
        'assault', 'battery', 'murder', 'manslaughter', 'domestic', 'violence', 'juvenile', 'justice', 'cyber', 'law', 
        'data', 'protection', 'intellectual', 'property', 'dispute', 'resolution', 'class', 'action', 'lawsuit', 
        'punitive', 'damages', 'compensatory', 'damages', 'injunctive', 'relief', 'statutory', 'damages', 'equity', 
        'common', 'law', 'legal', 'precedent'
    ]],
    
    
'military' => [
    'title_id' => 39,
    'words' => [
        'soldier', 'defense', 'war', 'army', 'navy', 'air force', 'strategy', 'combat', 'training',
        'marine', 'infantry', 'artillery', 'tank', 'armor', 'reconnaissance', 'sniper', 'special', 'forces', 'commando', 
        'paratrooper', 'pilot', 'fighter', 'jet', 'battleship', 'submarine', 'drone', 'missile', 'rocket', 'nuclear', 
        'deterrence', 'cyber', 'warfare', 'electronic', 'warfare', 'intelligence', 'counterintelligence', 'surveillance', 
        'espionage', 'tactics', 'maneuver', 'logistics', 'supply', 'chain', 'medical', 'corps', 'engineering', 
        'communications', 'signal', 'corps', 'medic', 'field', 'hospital', 'peacekeeping', 'mission', 'deployment', 
        'reserve', 'national', 'guard', 'veteran', 'military', 'service', 'enlistment', 'boot', 'camp', 'basic', 
        'training', 'officer', 'cadet', 'non-commissioned', 'officer', 'NCO', 'platoon', 'company', 'battalion', 
        'brigade', 'division', 'regiment', 'corps', 'fleet', 'squadron', 'task', 'force', 'airstrike', 'bombing', 
        'raid', 'siege', 'occupation', 'blockade', 'amphibious', 'assault', 'counterinsurgency', 'counterterrorism', 
        'guerrilla', 'warfare', 'urban', 'warfare', 'biological', 'warfare', 'chemical', 'weapons', 'conventional', 
        'forces', 'unconventional', 'warfare', 'psychological', 'operations', 'PSYOPS', 'rules', 'of', 'engagement', 
        'martial', 'law', 'military', 'tribunal', 'court-martial', 'prisoner', 'of', 'war', 'POW', 'ceasefire', 
        'armistice', 'treaty', 'disarmament', 'demilitarized', 'zone', 'DMZ', 'alliance', 'coalition', 'peacekeeping', 
        'NATO', 'military', 'occupation', 'foreign', 'aid', 'military', 'advisors', 'diplomacy', 'humanitarian', 
        'aid', 'security', 'clearance', 'classified', 'information', 'chain', 'of', 'command', 'general', 'admiral', 
        'colonel', 'major', 'captain', 'lieutenant', 'sergeant', 'private', 'military', 'rank', 'promotion', 'medal', 
        'honor', 'service', 'cross', 'valor', 'heroism', 'courage', 'duty', 'patriotism', 'sacrifice', 'military', 
        'base', 'barracks', 'fort', 'outpost', 'forward', 'operating', 'base', 'FOB', 'airbase', 'naval', 'base', 
        'deployment', 'rotation', 'combat', 'zone', 'theater', 'of', 'operations', 'rules', 'of', 'war', 'military', 
        'history', 'veterans', 'benefits', 'GI', 'Bill', 'honorable', 'discharge', 'veterans', 'affairs', 'VA'
    ]],
    
    
'luxury' => [
    'title_id' => 41,
    'words' => [
        'premium', 'exclusive', 'designer', 'opulence', 'wealth', 'lifestyle', 'affluent', 'elegance', 'extravagant',
        'lavish', 'indulgence', 'upscale', 'high-end', 'prestige', 'boutique', 'refined', 'gourmet', 'luxurious', 
        'amenities', 'first-class', 'bespoke', 'tailored', 'custom', 'rare', 'collectible', 'artisanal', 
        'fine', 'dining', 'couture', 'fashion', 'jewelry', 'accessories', 'luxury', 'goods', 'lifestyle', 
        'management', 'concierge', 'service', 'hospitality', 'experience', 'suites', 'spas', 'wellness', 
        'retreats', 'exotic', 'destinations', 'vacations', 'getaways', 'private', 'jets', 'yachts', 
        'charter', 'villas', 'mansions', 'real', 'estate', 'gardens', 'landscaping', 'art', 'collection', 
        'masterpieces', 'heirlooms', 'heritage', 'timeless', 'investment', 'luxury', 'brands', 'iconic', 
        'status', 'symbols', 'designer', 'labels', 'limited', 'edition', 'luxury', 'automobiles', 
        'classics', 'sports', 'cars', 'high-performance', 'motors', 'performance', 'tuning', 
        'opulent', 'homes', 'decor', 'furnishings', 'high-quality', 'materials', 'marble', 'granite', 
        'custom', 'finishes', 'upholstery', 'textiles', 'handcrafted', 'tailored', 'interior', 'design', 
        'gardening', 'unique', 'signature', 'style', 'luxury', 'events', 'galas', 'celebrations', 
        'launches', 'brand', 'experiences', 'elite', 'networking', 'connections', 'social', 'circle', 
        'prestige', 'exclusive', 'memberships', 'lifestyle', 'clubs', 'high-society', 'philanthropy', 
        'charitable', 'donations', 'sponsorships', 'luxury', 'gifts', 'one-of-a-kind', 'experiences', 
        'unforgettable', 'moments', 'luxury', 'travel', 'adventures', 'gourmet', 'food', 'wine', 
        'cellars', 'collections', 'fine', 'cigars', 'exclusive', 'clubs', 'luxury', 'boutiques', 
        'access', 'invitation', 'only', 'events', 'luxury', 'retail', 'special', 'collections', 
        'luxury', 'experiences', 'personalized', 'services', 'customer', 'relations', 'white-glove', 
        'service', 'complimentary', 'upgrades', 'concierge', 'dinners', 'wine', 'tastings', 'high-end', 
        'brands', 'limited', 'time', 'offers', 'exclusive', 'access'
    ]],
    
    
'space' => [
    'title_id' => 43,
    'words' => [
        'astronomy', 'rocket', 'planet', 'orbit', 'moon', 'exploration', 'satellite', 'cosmos', 'telescope',
        'universe', 'galaxy', 'star', 'constellation', 'asteroid', 'comet', 'black hole', 'gravity', 
        'light year', 'spacecraft', 'launch', 'pad', 'mission', 'crew', 'extraterrestrial', 'life', 
        'habitable', 'zone', 'interstellar', 'travel', 'solar', 'system', 'Milky Way', 'nebulas', 
        'quasar', 'redshift', 'expansion', 'dark matter', 'dark energy', 'observatory', 'celestial', 
        'phenomena', 'space station', 'International Space Station', 'ISS', 'Mars', 'Venus', 'Jupiter', 
        'Saturn', 'Uranus', 'Neptune', 'Pluto', 'exoplanet', 'astrophysics', 'cosmology', 'astrobiology', 
        'rocket science', 'launch vehicle', 'payload', 'orbital mechanics', 'space debris', 'propulsion', 
        'thrust', 'mission control', 'ground station', 'space shuttle', 'lander', 'rover', 'scientific', 
        'instruments', 'research', 'satellite', 'imaging', 'remote sensing', 'data collection', 
        'space weather', 'solar flares', 'magnetosphere', 'radiation', 'suit', 'astronaut', 'spacewalk', 
        'gravity', 'assist', 'thermal', 'protection', 'life', 'support', 'system', 'interplanetary', 
        'intergalactic', 'space elevator', 'wormhole', 'theory', 'space-time', 'Einstein', 'relativity', 
        'quantum', 'mechanics', 'stellar', 'formation', 'nebula', 'supernova', 'star', 'cluster', 
        'red giant', 'white dwarf', 'black dwarf', 'neutron star', 'pulsar', 'brown dwarf', 'light pollution', 
        'stellar', 'nucleosynthesis', 'Hubble', 'telescope', 'James Webb', 'telescope', 'space', 'probe', 
        'Voyager', 'Pioneer', 'New Horizons', 'deep space', 'mission', 'space race', 'NASA', 'ESA', 'JAXA', 
        'Roscosmos', 'aerospace', 'engineering', 'astroengineering', 'technology', 'satellite', 'communications', 
        'navigation', 'GPS', 'weather', 'forecasting', 'geostationary', 'satellite', 'polar', 'orbit', 
        'low', 'Earth', 'orbit', 'LEO', 'high', 'Earth', 'orbit', 'HEO', 'Medium', 'Earth', 'Orbit', 
        'MEO', 'near-Earth', 'objects', 'NEO', 'space tourism', 'commercial', 'spaceflight', 'SpaceX', 
        'Blue Origin', 'Virgin Galactic', 'Terraforming', 'Mars', 'colonization', 'settlements'
    ]],
    
    
'anthropology' => [
    'title_id' => 44,
    'words' => [
        'culture', 'society', 'evolution', 'human', 'archaeology', 'tradition', 'community', 'ritual', 'heritage',
        'ethnography', 'ethnology', 'social', 'structure', 'norms', 'values', 'beliefs', 'language', 
        'symbols', 'identity', 'kinship', 'family', 'group', 'migration', 'adaptation', 'cultural', 
        'diversity', 'globalization', 'cross-cultural', 'comparative', 'anthropology', 'biological', 
        'anthropology', 'forensic', 'anthropology', 'primatology', 'paleoanthropology', 'hominid', 
        'fossil', 'artifacts', 'excavation', 'fieldwork', 'participant', 'observation', 'interviewing', 
        'data', 'analysis', 'cultural', 'relativism', 'socialization', 'social', 'change', 'power', 
        'inequality', 'race', 'ethnicity', 'gender', 'roles', 'sex', 'sexuality', 'indigenous', 
        'peoples', 'subculture', 'counterculture', 'cultural', 'heritage', 'cultural', 'preservation', 
        'sustainability', 'material', 'culture', 'symbolic', 'interaction', 'cognitive', 'anthropology', 
        'affordances', 'socioeconomic', 'status', 'cultural', 'capital', 'economic', 'systems', 
        'subsistence', 'strategies', 'hunter-gatherer', 'pastoralism', 'agriculture', 'industrialization', 
        'urbanization', 'cultural', 'transmission', 'cultural', 'diffusion', 'enculturation', 
        'acculturation', 'emergent', 'behaviors', 'moral', 'economy', 'political', 'systems', 
        'legal', 'systems', 'theories', 'post-colonial', 'anthropology', 'human', 'rights', 
        'social', 'justice', 'cultural', 'heritage', 'monuments', 'landmarks', 'traditions', 
        'folklore', 'mythology', 'storytelling', 'performative', 'arts', 'dance', 'music', 
        'cultural', 'psychology', 'cognitive', 'science', 'cultural', 'evolution', 'cognitive', 
        'anthropology', 'neuroscience', 'archaeological', 'theories', 'field', 'schools', 
        'symbolic', 'interactionism', 'functionalism', 'structuralism', 'postmodernism', 
        'pragmatism', 'cultural', 'constructivism', 'applied', 'anthropology', 'visual', 
        'anthropology', 'medical', 'anthropology', 'anthropological', 'theories'
    ]],
    
    
'cryptocurrency' => [
    'title_id' => 45,
    'words' => [
        'bitcoin', 'blockchain', 'crypto', 'wallet', 'ethereum', 'decentralized', 'trading', 'mining', 'token',
        'altcoin', 'ledger', 'smart contracts', 'decentralized finance', 'DeFi', 'exchange', 'cryptographic', 
        'security', 'hash', 'hashrate', 'proof of work', 'proof of stake', 'staking', 'validator', 
        'consensus', 'algorithm', 'cryptocurrency', 'market', 'capitalization', 'volatile', 'ICO', 
        'initial coin offering', 'IEO', 'initial exchange offering', 'airdrop', 'fork', 'hard fork', 
        'soft fork', 'FOMO', 'fear of missing out', 'FUD', 'fear, uncertainty, and doubt', 'HODL', 
        'trading pair', 'liquidity', 'market maker', 'market order', 'limit order', 'stop-loss', 
        'portfolio', 'asset', 'diversification', 'bull market', 'bear market', 'technical analysis', 
        'fundamental analysis', 'charts', 'indicators', 'RSI', 'moving average', 'volume', 
        'exchange rate', 'peer-to-peer', 'P2P', 'DApp', 'decentralized application', 'NFT', 
        'non-fungible token', 'ERC-20', 'smart contract', 'Ethereum Classic', 'Ripple', 'XRP', 
        'Litecoin', 'Cardano', 'Polkadot', 'Chainlink', 'Solana', 'MATIC', 'Polygon', 
        'cryptocurrency', 'taxation', 'regulations', 'compliance', 'KYC', 'know your customer', 
        'AML', 'anti-money laundering', 'wallet', 'address', 'private key', 'public key', 
        'seed phrase', 'cold storage', 'hot wallet', 'hardware wallet', 'software wallet', 
        'crypto', 'exchange', 'decentralized exchange', 'DEX', 'centralized exchange', 'CEX', 
        'liquidity pool', 'yield farming', 'market cap', 'whale', 'pump and dump', 
        'scalping', 'arbitrage', 'bearish', 'bullish', 'trader', 'investor', 'speculator', 
        'block reward', 'transaction', 'fees', 'satoshi', 'gas', 'Ethereum', 'mainnet', 
        'testnet', 'hard cap', 'soft cap', 'utility token', 'security token', 'stablecoin', 
        'Tether', 'USDC', 'Fiat', 'on-ramp', 'off-ramp', 'cryptocurrency', 'wallets', 
        'trading', 'strategies', 'asset', 'management', 'blockchain', 'technology', 
        'cryptographic', 'hash', 'algorithms', 'decentralization'
    ]],
    
    
'robotics' => [
    'title_id' => 46,
    'words' => [
        'robot', 'automation', 'AI', 'machine', 'drone', 'mechanical', 'sensor', 'autonomous', 'programming',
        'artificial intelligence', 'robotics', 'engineering', 'control systems', 'actuator', 'robotic', 
        'arm', 'manipulator', 'cobot', 'collaborative robot', 'humanoid', 'robot', 'kinematics', 
        'dynamic', 'motion', 'planning', 'path', 'navigation', 'obstacle', 'avoidance', 'feedback', 
        'loop', 'machine learning', 'computer vision', 'image processing', 'neural networks', 'deep learning', 
        'reinforcement learning', 'data', 'input', 'output', 'programming', 'languages', 'Python', 
        'C++', 'ROS', 'Robot Operating System', 'simulation', 'virtual', 'environment', 'hardware', 
        'software', 'integration', 'sensors', 'LIDAR', 'camera', 'ultrasonic', 'infrared', 'GPS', 
        'accelerometer', 'gyroscope', 'robot', 'perception', 'mapping', 'localization', 'teleoperation', 
        'remote', 'control', 'swarm', 'robotics', 'bio-inspired', 'robots', 'industrial', 
        'robots', 'service', 'robots', 'agricultural', 'robots', 'military', 'robots', 
        'underwater', 'robots', 'space', 'robots', 'home', 'automation', 'smart', 'homes', 
        'AI', 'assistants', 'voice', 'recognition', 'natural', 'language', 'processing', 
        'robotics', 'competitions', 'FIRST', 'Robotics', 'VEX', 'robot', 'design', 
        'challenges', 'robot', 'safety', 'standards', 'ethics', 'robot', 'deployment', 
        'prototyping', 'testing', 'iterative', 'development', 'systems', 'engineering', 
        'research', 'and', 'development', 'R&D', 'applications', 'surgery', 'surgical', 
        'robots', 'exploration', 'drones', 'delivery', 'robots', 'transportation', 
        'autonomous', 'vehicles', 'mobile', 'robots', 'warehouse', 'automation', 
        'logistics', 'supply', 'chain', 'AI', 'integration', 'future', 'trends', 
        'advancements', 'human-robot', 'interaction', 'social', 'robots', 
        'ethical', 'implications', 'job', 'displacement', 'future', 'of', 
        'work', 'collaborative', 'robots', 'market', 'growth', 'projections', 
        'investment', 'opportunities', 'robotics', 'technologies'
    ]],
    
    
'climate_change' => [
    'title_id' => 47,
    'words' => [
        'global warming', 'carbon', 'emission', 'environment', 'sustainability', 'renewable', 'climate', 'greenhouse',
        'gas', 'greenhouse gases', 'climate crisis', 'climate action', 'adaptation', 'mitigation', 'fossil fuels',
        'biodiversity', 'ecosystems', 'climate justice', 'carbon footprint', 'climate policy', 'international agreements',
        'Paris Agreement', 'COP', 'climate science', 'temperature rise', 'sea level', 'extreme weather', 
        'drought', 'flooding', 'heatwaves', 'hurricanes', 'wildfires', 'ocean acidification', 'deforestation', 
        'sustainable', 'energy', 'solar power', 'wind power', 'bioenergy', 'hydropower', 'geothermal', 
        'climate change', 'impacts', 'resilience', 'climate adaptation', 'climate mitigation', 'carbon trading', 
        'carbon offsetting', 'climate models', 'emissions reductions', 'green technology', 'low-carbon', 
        'infrastructure', 'climate solutions', 'sustainable development', 'circular economy', 'renewable energy', 
        'clean energy', 'energy efficiency', 'public transport', 'sustainable agriculture', 'food security', 
        'water scarcity', 'climate awareness', 'environmental education', 'grassroots movements', 'climate activism', 
        'climate refugees', 'climate-related displacement', 'intergenerational equity', 'climate finance', 
        'adaptation strategies', 'global temperatures', 'ice caps', 'glaciers', 'polar regions', 'permafrost', 
        'climate feedback', 'albedo effect', 'carbon cycle', 'natural resources', 'sustainable practices', 
        'environmental policy', 'ecological footprint', 'environmental degradation', 'urbanization', 'land use', 
        'climate resilience', 'green infrastructure', 'smart cities', 'environmental stewardship', 
        'carbon neutrality', 'renewable resources', 'energy transition', 'climate accountability', 'sustainable living'
    ]],
    
    
'cybersecurity' => [
    'title_id' => 48,
    'words' => [
        'hack', 'firewall', 'encryption', 'phishing', 'malware', 'data', 'breach', 'security', 
        'virus', 'authentication', 'spyware', 'trojan', 'ransomware', 'vulnerability', 'penetration', 
        'testing', 'network', 'intrusion', 'detection', 'system', 'protection', 'backup', 'threat', 
        'intelligence', 'incident', 'response', 'security', 'policy', 'risk', 'management', 'data', 
        'loss', 'cyberattack', 'forensics', 'cybercrime', 'endpoint', 'security', 'access', 'control', 
        'two-factor', 'authentication', 'social', 'engineering', 'credential', 'stealing', 'anonymity', 
        'privacy', 'digital', 'footprint', 'compliance', 'GDPR', 'firewall', 'rules', 'update', 
        'patch', 'malicious', 'code', 'botnet', 'phishing', 'scam', 'website', 'monitoring', 'encryption', 
        'protocols', 'SSL', 'TLS', 'PKI', 'public', 'key', 'infrastructure', 'data', 'security', 
        'cyber', 'defense', 'cybersecurity', 'awareness', 'training', 'cybersecurity', 'framework', 
        'incident', 'management', 'security', 'audits', 'security', 'incident', 'analysis', 
        'enforcement', 'law', 'cyber', 'security', 'breach', 'notification', 'cyber', 'insurance', 
        'threat', 'landscape', 'information', 'technology', 'IT', 'security', 'protocols', 'insider', 
        'threat', 'cybersecurity', 'mesh', 'cloud', 'security', 'internet', 'of', 'things', 
        'IoT', 'virtual', 'private', 'network', 'VPN', 'data', 'encryption', 'key', 'management', 
        'security', 'operations', 'SIEM', 'log', 'management', 'remote', 'access', 'trojan', 
        'horse', 'network', 'security', 'assessment'
    ]],
    
    
'genetics' => [
    'title_id' => 49,
    'words' => [
        'DNA', 'genome', 'mutation', 'gene', 'heredity', 'chromosome', 'genetics', 'CRISPR', 
        'inheritance', 'allele', 'phenotype', 'genotype', 'genetic', 'marker', 'sequencing', 
        'biotechnology', 'genetic engineering', 'transgene', 'cloning', 'stem', 'cells', 
        'recombinant', 'DNA', 'expression', 'plasmid', 'RNA', 'transcription', 'translation', 
        'genetic variation', 'genetic disorder', 'genetic therapy', 'polygenic', 'traits', 
        'mendelian', 'inheritance', 'genetic predisposition', 'genomic', 'medicine', 'gene editing', 
        'epigenetics', 'gene mapping', 'bioinformatics', 'genome-wide', 'association', 'study', 
        'genetic testing', 'hereditary', 'cancer', 'pathogenomics', 'genetic counseling', 
        'single nucleotide', 'polymorphism', 'SNP', 'intron', 'exon', 'codon', 'genetic diversity', 
        'population genetics', 'conservation genetics', 'genetic drift', 'natural selection', 
        'fitness', 'adaptive', 'radiation', 'gene flow', 'horizontal', 'gene transfer', 
        'genetic screening', 'pharmacogenomics', 'functional', 'genomics', 'transcriptomics', 
        'proteomics', 'metabolomics', 'genetic research', 'plant genetics', 'animal genetics', 
        'microbial genetics', 'quantitative genetics', 'human genetics', 'forensic genetics', 
        'genome editing', 'biopharmaceuticals', 'genetic markers', 'clinical genetics', 
        'agricultural genetics', 'genetic modification', 'gene therapy', 'therapeutic', 'cloning', 
        'somatic', 'cell', 'gene', 'splicing', 'genetic maps'
    ]],
    
    
'biotechnology' => [
    'title_id' => 50,
    'words' => [
        'biotech', 'genetics', 'bioengineering', 'lab', 'research', 'biomaterials', 'nanotech', 
        'biopharma', 'vaccine', 'genetic engineering', 'microbiology', 'bioprocessing', 
        'biomanufacturing', 'cell culture', 'protein', 'engineering', 'fermentation', 'enzymes', 
        'metabolic engineering', 'synthetic biology', 'CRISPR', 'molecular biology', 
        'immunology', 'pharmaceuticals', 'diagnostics', 'biotherapeutics', 'transgenic', 
        'organisms', 'biodegradable', 'plastics', 'bioremediation', 'environmental biotechnology', 
        'agricultural biotechnology', 'food biotechnology', 'animal biotechnology', 
        'bioinformatics', 'genomic', 'data', 'biological', 'assays', 'bioreactors', 
        'cellular', 'therapy', 'gene therapy', 'tissue engineering', 'stem cells', 
        '3D bioprinting', 'clinical trials', 'vaccine development', 'biobanking', 
        'regenerative medicine', 'biological', 'products', 'biosensors', 'biofuels', 
        'biocatalysts', 'animal models', 'laboratory', 'techniques', 'PCR', 'gel electrophoresis', 
        'DNA sequencing', 'molecular', 'cloning', 'biophysical', 'characterization', 
        'biostatistics', 'patenting', 'biotechnology', 'innovation', 'commercialization', 
        'intellectual', 'property', 'biopharmaceutical', 'industry', 'quality', 'control', 
        'regulatory', 'affairs', 'safety', 'toxicology', 'pharmacology', 'biomarkers', 
        'clinical', 'research', 'food', 'safety', 'biological', 'safety', 'bioethics', 
        'biosafety', 'biosecurity'
    ]],
    
    
'green_energy' => [
    'title_id' => 51,
    'words' => [
        'solar', 'wind', 'renewable', 'energy', 'green', 'power', 'clean', 'hydro', 
        'sustainability', 'biomass', 'geothermal', 'tidal', 'wave', 'sustainable', 
        'electricity', 'photovoltaic', 'PV', 'wind turbine', 'solar panel', 
        'hydropower', 'carbon footprint', 'energy efficiency', 'low-carbon', 
        'alternative', 'fuel', 'clean energy', 'energy transition', 'smart grid', 
        'energy storage', 'batteries', 'microgrid', 'demand response', 
        'environmental impact', 'carbon neutrality', 'climate change', 
        'environmental sustainability', 'greenhouse gases', 'energy conservation', 
        'renewable resources', 'energy independence', 'distributed generation', 
        'net metering', 'feed-in tariff', 'grid parity', 'decarbonization', 
        'eco-friendly', 'energy policy', 'clean technology', 'clean development', 
        'offsets', 'energy audits', 'sustainable practices', 'energy management', 
        'green building', 'LEED', 'green certifications', 'urban farming', 
        'carbon credits', 'sustainable agriculture', 'clean transportation', 
        'electric vehicles', 'biofuels', 'hydrogen', 'energy innovation', 
        'renewable energy certificates', 'community solar', 'solar farms', 
        'wind farms', 'hydroelectric', 'plants', 'geothermal plants', 
        'tidal energy', 'energy resilience', 'climate action', 'sustainability goals'
    ]],
    
    
'nanotechnology' => [
    'title_id' => 52,
    'words' => [
        'nano', 'material', 'engineering', 'atomic', 'microscope', 'nanoparticle', 
        'innovation', 'science', 'nanomaterials', 'fabrication', 'characterization', 
        'applications', 'self-assembly', 'colloids', 'quantum', 'dots', 'carbon', 
        'nanotubes', 'fullerenes', 'graphene', 'thin films', 'surface', 
        'modification', 'properties', 'nanoscale', 'measurements', 'synthesis', 
        'biomedical', 'devices', 'drug delivery', 'diagnostics', 'therapeutics', 
        'catalysis', 'energy storage', 'photovoltaics', 'sensors', 
        'environmental', 'remediation', 'food safety', 'agriculture', 
        'pesticides', 'cosmetics', 'textiles', 'smart', 'materials', 
        'high-performance', 'materials', 'coatings', 'electronics', 
        'nanoelectronics', 'magnetic', 'nanoparticles', 'biocompatibility', 
        'toxicity', 'risk assessment', 'regulatory', 'frameworks', 
        'nanoindustry', 'research', 'collaboration', 'interdisciplinary', 
        'innovation', 'commercialization', 'nanotech', 'startups', 
        'market', 'growth', 'future', 'technologies', 'disruption', 
        'patents', 'intellectual property', 'sustainable', 'development', 
        'green', 'nanotechnology', 'responsible', 'research', 
        'safety', 'guidelines', 'public', 'perception', 'awareness', 
        'education', 'outreach', 'conferences', 'funding', 
        'nanomedicine', 'nanosafety', 'nanobiotechnology', 'nanosensors'
    ]],
    
    
'oceanography' => [
    'title_id' => 53,
    'words' => [
        'ocean', 'marine', 'ecosystem', 'seabed', 'waves', 'tides', 'research', 
        'oceanography', 'coral', 'biodiversity', 'plankton', 'phytoplankton', 
        'zooplankton', 'salinity', 'temperature', 'currents', 'hydrology', 
        'sediment', 'chemical composition', 'ocean circulation', 'marine life', 
        'fisheries', 'ocean floor', 'continental shelf', 'bathymetry', 
        'submarine', 'volcanoes', 'trench', 'reefs', 'ocean acidification', 
        'pollution', 'ecosystem', 'services', 'sustainability', 'conservation', 
        'marine protected areas', 'climate change', 'sea level rise', 
        'marine geology', 'biogeochemistry', 'ocean dynamics', 'ocean modeling', 
        'remote sensing', 'satellite', 'imagery', 'submersible', 
        'research vessel', 'expedition', 'fieldwork', 'marine habitats', 
        'kelp forests', 'mangroves', 'seagrass', 'estuarine', 'coastal', 
        'marine mammals', 'fish', 'invertebrates', 'ocean ecosystems', 
        'habitat loss', 'ocean governance', 'marine policy', 
        'ocean literacy', 'public engagement', 'scientific communication', 
        'international waters', 'high seas', 'ocean resources', 
        'bioprospecting', 'oceanic', 'environmental monitoring', 
        'data collection', 'oceanographic', 'instruments', 
        'buoys', 'wave sensors', 'current meters', 'sonar', 
        'submarine cables', 'marine acoustics', 'ocean exploration', 
        'polar regions', 'deep sea', 'coastal erosion', 
        'flooding', 'tsunamis', 'storm surges', 'marine geology', 
        'ocean circulation patterns', 'upwelling', 'downwelling'
    ]],
    
    
'marine_biology' => [
    'title_id' => 54,
    'words' => [
        'fish', 'coral', 'ocean', 'marine', 'ecosystem', 'biology', 'research', 
        'dolphin', 'species', 'plankton', 'seaweed', 'invertebrate', 'habitat', 
        'environment', 'organism', 'aquatic', 'reproduction', 'migration', 
        'predator', 'prey', 'diversity', 'population', 'adaptation', 
        'symbiosis', 'biomass', 'nurture', 'trophic', 'food', 
        'chain', 'nutrient', 'seawater', 'salinity', 'temperature', 
        'coast', 'reef', 'sediment', 'conservation', 'pollution', 
        'fisheries', 'impact', 'sustainability', 'climate', 
        'change', 'biodiversity', 'species', 'interaction', 
        'algae', 'crustacean', 'mollusk', 'cephalopod', 'kelp', 
        'urchin', 'seal', 'whale', 'shark', 'turtle', 
        'planktonic', 'oyster', 'mangrove', 'estuary', 'beach', 
        'biome', 'marine', 'microbe', 'chemical', 'pathogen', 
        'ecosystem', 'health', 'indicator', 'community', 'species', 
        'exotic', 'native', 'habitat', 'fragility', 'restoration', 
        'fossil', 'record', 'fieldwork', 'dissection', 'anatomy'
    ]],
    
    
'astrophysics' => [
    'title_id' => 55,
    'words' => [
        'space', 'cosmos', 'black', 'hole', 'galaxy', 'light', 'year', 
        'universe', 'gravity', 'research', 'theory', 'star', 
        'planet', 'nebula', 'quasar', 'dark', 'matter', 
        'dark', 'energy', 'radiation', 'supernova', 'asteroid', 
        'redshift', 'big', 'bang', 'cosmology', 'time', 
        'dimension', 'matter', 'cosmic', 'background', 'expansion', 
        'forces', 'kinematics', 'photons', 'luminosity', 'spectroscopy', 
        'black', 'dwarf', 'white', 'dwarf', 'red', 
        'giant', 'blue', 'shift', 'gravitational', 'waves', 
        'relativity', 'singularity', 'event', 'horizon', 'orbital', 
        'mechanics', 'spacecraft', 'simulation', 'astrobiology', 'infinity', 
        'magnitude', 'celestial', 'bodies', 'observatory', 'telescope', 
        'observations', 'field', 'theories', 'mathematics', 'calculations', 
        'hypothesis', 'models', 'galactic', 'clusters', 'density', 
        'comets', 'trajectory', 'interstellar', 'medium', 'space-time'
    ]],
    
    
'quantum_physics' => [
    'title_id' => 56,
    'words' => [
        'quantum', 'particle', 'wave', 'mechanics', 'physics', 'research', 
        'theory', 'photon', 'atom', 'superposition', 'entanglement', 
        'uncertainty', 'principle', 'electron', 'proton', 'neutron', 
        'field', 'boson', 'fermion', 'spin', 'vacuum', 
        'fluctuation', 'interference', 'tunneling', 'observable', 
        'measurement', 'decay', 'radioactivity', 'nucleus', 'molecule', 
        'detection', 'spectroscopy', 'interaction', 'quantization', 
        'wavefunction', 'collapse', 'experiments', 'theoretical', 
        'modeling', 'forces', 'electromagnetic', 'gravity', 
        'thermodynamics', 'philosophy', 'correlation', 'Bell', 
        'theorem', 'nonlocality', 'chaos', 'determinism', 
        'reality', 'information', 'entropy', 'string', 
        'theory', 'dark', 'matter', 'cosmic', 'background', 
        'quantum', 'computing', 'cryptography', 'nanotechnology', 
        'decoherence', 'symmetry', 'quantum', 'field', 'theory'
    ]],
    
    
'urban_planning' => [
    'title_id' => 57,
    'words' => [
        'city', 'infrastructure', 'development', 'urban', 'planning', 
        'transport', 'housing', 'zoning', 'policy', 'community', 
        'land', 'use', 'redevelopment', 'transportation', 'design', 
        'regulations', 'environment', 'sustainability', 'public', 
        'space', 'accessibility', 'density', 'growth', 'master', 
        'plan', 'revitalization', 'open', 'space', 'landscape', 
        'economics', 'real', 'estate', 'community', 'engagement', 
        'stakeholders', 'services', 'inclusion', 'infrastructure', 
        'transportation', 'systems', 'public', 'transport', 
        'bike', 'lanes', 'walkability', 'pedestrian', 'safety', 
        'mixed-use', 'development', 'smart', 'growth', 
        'community', 'development', 'environmental', 'impact', 
        'assessment', 'affordable', 'housing', 'gentrification', 
        'regional', 'planning', 'land', 'use', 'policy', 
        'fiscal', 'policy', 'demographics', 'data', 
        'urbanization', 'rural', 'development', 'transportation', 
        'modal', 'shift', 'public', 'health', 'resilience', 
        'climate', 'adaptation', 'economic', 'development', 
        'historic', 'preservation', 'community', 'design', 
        'green', 'infrastructure', 'urban', 'renewal'
    ]],
    
    
'bioinformatics' => [
    'title_id' => 58,
    'words' => [
        'biology', 'data', 'genomics', 'proteomics', 'analysis', 
        'algorithm', 'bioinformatics', 'research', 'sequencing', 
        'genetic', 'information', 'biostatistics', 'modeling', 
        'software', 'development', 'genetic', 'engineering', 
        'microarray', 'expression', 'database', 'systems', 
        'biological', 'information', 'systems', 'computational', 
        'biology', 'molecular', 'biology', 'big', 'data', 
        'statistical', 'bioinformatics', 'tools', 'visualization', 
        'workflow', 'integration', 'annotation', 'sequence', 
        'alignment', 'phylogenetics', 'evolutionary', 'biology', 
        'proteome', 'metagenomics', 'transcriptomics', 
        'proteomic', 'network', 'analysis', 'comparative', 
        'genomics', 'functional', 'genomics', 'pathway', 
        'analysis', 'biological', 'data', 'mining', 
        'machine', 'learning', 'data', 'modeling', 
        'hypothesis', 'testing', 'systems', 'biology', 
        'synthetic', 'biology', 'metabolomics', 'drug', 
        'discovery', 'clinical', 'bioinformatics', 'precision', 
        'medicine', 'therapeutics', 'pharmacogenomics', 
        'biochemical', 'pathways', 'genetic', 'variation', 
        'biological', 'research', 'programming', 'languages', 
        'Python', 'R', 'biological', 'datasets', 'reference', 
        'sequences', 'biorepositories'
    ]],
    
    
'linguistics' => [
    'title_id' => 59,
    'words' => [
        'language', 'grammar', 'syntax', 'phonetics', 'dialect', 
        'linguistics', 'speech', 'communication', 'study', 
        'semantics', 'morphology', 'lexicon', 'discourse', 
        'sociolinguistics', 'pragmatics', 'phonology', 'linguistic', 
        'theory', 'structure', 'variety', 'intonation', 
        'gesture', 'cognition', 'acquisition', 'linguistic', 
        'relativity', 'writing', 'system', 'alphabet', 
        'orthography', 'dialectology', 'historical', 'linguistics', 
        'sociolinguistic', 'analysis', 'language', 'contact', 
        'bilingualism', 'multilingualism', 'language', 'policy', 
        'language', 'preservation', 'language', 'endangerment', 
        'typology', 'universals', 'phoneme', 'morpheme', 
        'syntax', 'tree', 'diagrams', 'language', 'variation', 
        'standard', 'language', 'creole', 'pidgin', 
        'phonetic', 'transcription', 'intonation', 'speech', 
        'act', 'conversation', 'analysis', 'colloquial', 
        'register', 'language', 'improvement', 'language', 
        'teaching', 'applied', 'linguistics', 'rhetoric', 
        'linguistic', 'relativity', 'cognitive', 'linguistics', 
        'articulation', 'context', 'sentence', 'meaning', 
        'word', 'choice', 'style', 'function', 
        'meaning', 'interpretation', 'narrative', 'discourse'
    ]],
    
    
'pharmacology' => [
    'title_id' => 60,
    'words' => [
        'medicine', 'drug', 'pharmacy', 'treatment', 'pharmacology', 
        'dosage', 'side', 'effects', 'clinical', 'trial', 
        'therapeutic', 'intervention', 'formulation', 'administration', 
        'pharmacokinetics', 'absorption', 'distribution', 'metabolism', 
        'excretion', 'bioavailability', 'bioequivalence', 'adverse', 
        'reaction', 'drug', 'interactions', 'contraindications', 
        'safety', 'efficacy', 'prescription', 'nonprescription', 
        'over-the-counter', 'OTC', 'opioids', 'antibiotics', 
        'analgesics', 'antihistamines', 'antidepressants', 
        'antipsychotics', 'anticoagulants', 'insulin', 'vaccines', 
        'immunotherapy', 'chemotherapy', 'targeted', 'therapy', 
        'monoclonal', 'antibodies', 'hormones', 'steroids', 
        'plasma', 'proteins', 'enzyme', 'inhibitors', 'receptor', 
        'agonists', 'antagonists', 'pathways', 'mechanism', 
        'action', 'synergistic', 'potentiation', 'tolerance', 
        'dependence', 'addiction', 'withdrawal', 'regulatory', 
        'affairs', 'FDA', 'EMA', 'pharmacogenomics', 
        'personalized', 'medicine', 'drug', 'discovery', 
        'development', 'screening', 'preclinical', 'studies', 
        'research', 'methods', 'clinical', 'research', 
        'good', 'clinical', 'practice', 'GCP', 
        'randomized', 'controlled', 'trials', 'placebo', 
        'control', 'double-blind', 'open-label', 
        'monitoring', 'data', 'safety', 'monitoring', 
        'patient', 'population', 'pharmacotherapy', 
        'evidence-based', 'practice', 'formulary', 
        'medication', 'management', 'patient', 'care', 
        'outcomes', 'quality', 'assurance', 'risk', 
        'benefit', 'assessment', 'cost-effectiveness', 
        'healthcare', 'systems', 'economic', 'evaluations', 
        'pharmacists', 'clinical', 'pharmacy', 
        'community', 'hospitals', 'acute', 'care', 
        'chronic', 'conditions', 'public', 'health', 
        'education', 'advocacy', 'clinical', 'guidelines'
    ]],
    
    
'optometry' => [
    'title_id' => 61,
    'words' => [
        'eye', 'vision', 'lens', 'optical', 'optometry', 
        'glasses', 'contact', 'prescription', 'optometrist', 
        'exam', 'refraction', 'acuity', 'perception', 
        'cornea', 'retina', 'pupil', 'iris', 
        'cataract', 'astigmatism', 'myopia', 'hyperopia', 
        'presbyopia', 'visual', 'field', 'depth', 
        'color', 'blindness', 'photophobia', 'eye', 
        'muscles', 'disease', 'treatment', 'therapy', 
        'contact', 'lens', 'fitting', 'solutions', 
        'dry', 'eyes', 'vision', 'correction', 
        'sunglasses', 'frames', 'bifocals', 'trifocals', 
        'progressive', 'lenses', 'optical', 'dispensing', 
        'techniques', 'refractive', 'surgery', 'LASIK', 
        'PRK', 'diagnosis', 'eye', 'care', 
        'sight', 'health', 'pathology', 'assessment', 
        'visualization', 'sensitivity', 'binocular', 
        'function', 'adaptation', 'contrast', 'resolution', 
        'retinal', 'imaging', 'tonometry', 'ophthalmoscopy', 
        'slit', 'lamp', 'optical', 'coherence', 
        'tomography', 'UV', 'protection', 'eye', 
        'hygiene', 'screening', 'television', 'computer', 
        'blue', 'light', 'fatigue', 'pediatric', 
        'optometry', 'practice', 'patient', 'education', 
        'referrals', 'insurance', 'benefits', 'clinical', 
        'guidelines', 'rehabilitation', 'orthoptics', 
        'low', 'vision', 'aids', 'evaluation', 
        'contact', 'lens', 'care', 'safety', 
        'allergies', 'infections', 'vision', 'loss'
    ]],
    
    
'aeronautics' => [
    'title_id' => 62,
    'words' => [
        'plane', 'flight', 'aeronautics', 'aviation', 'pilot', 
        'jet', 'aircraft', 'engineering', 'design', 'takeoff', 
        'landing', 'navigation', 'altitude', 'thrust', 
        'lift', 'drag', 'control', 'surface', 
        'fuselage', 'wing', 'tail', 'cockpit', 
        'propeller', 'turbine', 'engine', 'fuel', 
        'aerodynamics', 'stability', 'control', 'systems', 
        'flaps', 'ailerons', 'rudder', 'elevator', 
        'airspace', 'regulations', 'airtraffic', 'safety', 
        'flightpath', 'runway', 'terminal', 'airport', 
        'simulation', 'training', 'instruments', 'GPS', 
        'radar', 'weather', 'conditions', 'emergency', 
        'procedures', 'navigation', 'charts', 'communications', 
        'airworthiness', 'certification', 'maintenance', 
        'inspection', 'payload', 'cargo', 'passengers', 
        'flightcrew', 'operations', 'airline', 'business', 
        'general', 'aviation', 'space', 'exploration', 
        'rocket', 'propulsion', 'spacecraft', 'design', 
        'flight', 'test', 'research', 'development', 
        'commercial', 'aviation', 'sustainability', 'environment', 
        'green', 'aviation', 'future', 'technologies'
    ]],
    
    
'human_rights' => [
    'title_id' => 63,
    'words' => [
        'freedom', 'equality', 'justice', 'rights', 'humanitarian', 
        'legal', 'defense', 'advocacy', 'dignity', 'discrimination', 
        'tolerance', 'protection', 'empowerment', 'violations', 
        'activism', 'treaties', 'conventions', 'campaigns', 
        'international', 'law', 'refugees', 'minorities', 
        'gender', 'equality', 'civil', 'liberties', 
        'social', 'justice', 'human', 'trafficking', 
        'asylum', 'children', 'disabilities', 'indigenous', 
        'rights', 'women', 'rights', 'LGBTQ+', 'rights', 
        'freedom', 'of', 'speech', 'freedom', 'of', 
        'assembly', 'freedom', 'of', 'religion', 
        'privacy', 'economic', 'rights', 'cultural', 
        'rights', 'political', 'rights', 'right', 
        'to', 'life', 'due', 'process', 'equal', 
        'protection', 'law', 'sustainable', 'development', 
        'access', 'to', 'justice', 'legal', 'aid', 
        'disability', 'rights', 'labor', 'rights', 
        'environmental', 'rights', 'human', 'traffickers', 
        'perpetrators', 'investigations', 'accountability', 
        'truth', 'commissions', 'rehabilitation', 
        'support', 'education', 'awareness', 'training', 
        'global', 'solidarity', 'intervention', 'remedies', 
        'social', 'responsibility', 'mobilization', 
        'reporting', 'monitoring', 'enforcement', 
        'implementation', 'frameworks', 'institutions'
    ]],
    
    
'space_exploration' => [
    'title_id' => 64,
    'words' => [
        'space', 'mission', 'nasa', 'launch', 'exploration', 
        'mars', 'satellite', 'astronaut', 'orbit', 'rocket', 
        'telescope', 'probe', 'shuttle', 'lunar', 'surface', 
        'gravity', 'payload', 'trajectory', 'cosmos', 
        'interstellar', 'expedition', 'voyage', 'celestial', 
        'navigation', 'astrophysics', 'technology', 'research', 
        'data', 'collection', 'solar', 'system', 'exoplanet', 
        'habitat', 'sustainability', 'outpost', 'habitation', 
        'climate', 'robotics', 'engineering', 'samples', 
        'analysis', 'communication', 'systems', 'equipment', 
        'innovation', 'observation', 'collaboration', 
        'international', 'partnerships', 'astronomy', 
        'terraforming', 'colonization', 'expansion', 
        'satellite', 'communication', 'remote', 'sensing', 
        'hydroponics', 'life', 'support', 'systems', 
        'environment', 'safety', 'exploration', 'goals', 
        'orbital', 'mechanics', 'research', 'grants', 
        'fellowships', 'public', 'engagement', 'outreach', 
        'sustainability', 'technologies', 'biological', 
        'experiments', 'hypothesis', 'testing', 'operations', 
        'challenges', 'funding', 'human', 'spaceflight', 
        'science', 'education', 'missions', 'historic', 
        'data', 'analysis', 'workshops', 'exhibits', 
        'awareness', 'programs', 'support', 'grants', 
        'private', 'sector', 'space', 'ventures'
    ]],
    
    
'ecology' => [
    'title_id' => 65,
    'words' => [
        'ecosystem', 'wildlife', 'biodiversity', 'ecology', 'habitat', 
        'environment', 'conservation', 'species', 'population', 
        'community', 'interaction', 'food', 'chain', 'niche', 
        'abiotic', 'factors', 'biotic', 'factors', 'decomposition', 
        'nutrients', 'energy', 'flow', 'trophic', 'levels', 
        'carbon', 'cycle', 'nitrogen', 'cycle', 'habitat', 
        'fragmentation', 'restoration', 'sustainability', 
        'pollination', 'adaptation', 'invasive', 'species', 
        'native', 'species', 'climate', 'change', 
        'landscape', 'ecology', 'ecological', 'services', 
        'greenhouse', 'gases', 'renewable', 'resources', 
        'urban', 'ecology', 'marine', 'ecology', 
        'freshwater', 'ecology', 'ecosystem', 'management', 
        'environmental', 'impact', 'assessment', 'ecotoxicology', 
        'ecosystem', 'diversity', 'habitat', 'loss', 
        'endangered', 'species', 'restoration', 'efforts', 
        'conservation', 'biology', 'sustainability', 'practices', 
        'wildlife', 'management', 'habitat', 'preservation', 
        'marine', 'biodiversity', 'forest', 'ecology', 
        'grassland', 'ecology', 'wetland', 'ecology', 
        'ecosystem', 'health', 'trophic', 'cascade', 
        'food', 'web', 'ecological', 'footprint', 
        'symbiosis', 'mutualism', 'commensalism', 'parasitism', 
        'succession', 'primary', 'secondary', 'pollution', 
        'habitat', 'restoration', 'green', 'infrastructure', 
        'environmental', 'education', 'climate', 'resilience'
    ]],
    
    
'paleontology' => [
    'title_id' => 66,
    'words' => [
        'fossil', 'dinosaur', 'bones', 'archaeology', 'prehistoric', 
        'excavation', 'paleontology', 'species', 'extinction', 
        'sediment', 'strata', 'geology', 'excavation', 'remains', 
        'ancient', 'life', 'vertebrate', 'invertebrate', 
        'mammoth', 'paleontologist', 'research', 'fieldwork', 
        'dig', 'site', 'carbon', 'dating', 'geological', 
        'time', 'scale', 'climate', 'change', 'morphology', 
        'taxonomy', 'classification', 'bone', 'analysis', 
        'biostratigraphy', 'paleoecology', 'taphonomy', 
        'sedimentary', 'rock', 'fossilization', 'preservation', 
        'catastrophe', 'mass', 'extinction', 'Cambrian', 
        'period', 'Jurassic', 'Cretaceous', 'Triassic', 
        'Mesozoic', 'era', 'Paleozoic', 'era', 
        'Cenozoic', 'era', 'Cretaceous-Paleogene', 'boundary', 
        'dinosaur', 'fossils', 'ichthyosaur', 'plesiosaur', 
        'pterosaur', 'trilobite', 'gastropod', 'bivalve', 
        'ammonite', 'paleoenvironment', 'fossil', 'record', 
        'fossil', 'assemblage', 'stratigraphy', 'paleoanthropology', 
        'human', 'evolution', 'neanderthal', 'hominid', 
        'skull', 'remains', 'Archaeopteryx', 'Laetoli', 
        'footprints', 'Linnaean', 'classification', 'evolution', 
        'adaptive', 'radiation', 'biogeography', 'fossil', 
        'trackways', 'paleomagnetism', 'taphonomic', 'study'
    ]],
    
    
'zoology' => [
    'title_id' => 67,
    'words' => [
        'animals', 'species', 'zoology', 'wildlife', 'habitat', 
        'research', 'biology', 'conservation', 'ethology', 
        'behavior', 'ecology', 'taxonomy', 'vertebrates', 
        'invertebrates', 'mammals', 'birds', 'reptiles', 
        'amphibians', 'fish', 'insects', 'arachnids', 
        'classification', 'physiology', 'anatomy', 'morphology', 
        'genetics', 'development', 'embryology', 'ecosystem', 
        'biodiversity', 'adaptation', 'evolution', 'migration', 
        'population', 'dynamics', 'community', 'interactions', 
        'predation', 'competition', 'symbiosis', 'mutualism', 
        'parasitism', 'commensalism', 'territoriality', 
        'social', 'structures', 'reproduction', 'life', 
        'cycles', 'endangered', 'species', 'extinction', 
        'habitat', 'loss', 'preservation', 'wildlife', 
        'sanctuaries', 'animal', 'behavior', 'studies', 
        'fieldwork', 'observation', 'data', 'collection', 
        'monitoring', 'tracking', 'migration', 'patterns', 
        'wildlife', 'rehabilitation', 'animal', 'husbandry', 
        'captivity', 'zoo', 'design', 'animal', 
        'ethics', 'aquatic', 'terrestrial', 'aerial', 
        'feeding', 'strategies', 'foraging', 'predators', 
        'prey', 'endothermic', 'ectothermic', 'metabolism', 
        'adaptation', 'survival', 'fitness', 'conservation', 
        'genetic', 'diversity', 'zoos', 'aquariums', 
        'wildlife', 'refuges', 'citizen', 'science'
    ]],
    
    
'ethnography' => [
    'title_id' => 68,
    'words' => [
        'culture', 'society', 'tradition', 'research', 'ethnography', 
        'community', 'fieldwork', 'heritage', 'identity', 
        'customs', 'practices', 'beliefs', 'values', 
        'participation', 'observation', 'qualitative', 'methods', 
        'data', 'analysis', 'interpretation', 'narrative', 
        'description', 'immersion', 'context', 'social', 
        'interactions', 'ethnic', 'groups', 'cultural', 
        'diversity', 'language', 'artifacts', 'symbols', 
        'kinship', 'structures', 'socialization', 'globalization', 
        'migration', 'settlements', 'subcultures', 'rural', 
        'urban', 'environment', 'sustainability', 'cultural', 
        'change', 'identity', 'politics', 'power', 
        'inequality', 'representation', 'emergent', 'issues', 
        'community', 'participation', 'identity', 'ethnic', 
        'conflict', 'reflexivity', 'ethnographic', 'writing', 
        'historical', 'contextualization', 'social', 'stratification', 
        'interviews', 'narratives', 'case', 'studies', 
        'grounded', 'theory', 'critical', 'reflections', 
        'ethics', 'consent', 'data', 'collection', 
        'anthropological', 'approaches', 'interpretive', 
        'frameworks', 'phenomenology', 'cultural', 'sensitivity', 
        'community', 'engagement', 'policy', 'advocacy', 
        'documentation', 'research', 'findings', 'cultural', 
        'insights', 'social', 'relations', 'social', 
        'change', 'advocacy', 'activism'
    ]],
    
    
'horticulture' => [
    'title_id' => 69,
    'words' => [
        'plants', 'garden', 'botany', 'flowers', 'horticulture', 
        'landscaping', 'soil', 'cultivation', 'irrigation', 
        'propagation', 'fertilization', 'pruning', 'grafting', 
        'pest', 'management', 'organic', 'agriculture', 
        'greenhouse', 'nursery', 'vegetables', 'fruits', 
        'herbs', 'perennials', 'annuals', 'native', 
        'species', 'mulch', 'weeding', 'compost', 
        'sustainability', 'landscape', 'design', 'botanical', 
        'diversity', 'crop', 'rotation', 'climate', 
        'zones', 'planting', 'seasons', 'hardiness', 
        'cultivar', 'land-use', 'methods', 'horticultural', 
        'therapy', 'arboriculture', 'crop', 'science', 
        'biotechnology', 'environment', 'ecosystem', 'design', 
        'permaculture', 'urban', 'agriculture', 'soil', 
        'testing', 'nutrients', 'plant', 'health', 
        'diseases', 'symptoms', 'treatments', 'landscape', 
        'maintenance', 'aesthetics', 'ecosystem', 'services', 
        'visual', 'appeal', 'hardscape', 'design', 
        'irrigation', 'systems', 'drought', 'tolerance', 
        'planting', 'schedules', 'site', 'analysis', 
        'horticultural', 'education', 'research', 'production', 
        'seed', 'saving', 'botanical', 'gardening', 
        'communities', 'sustainability', 'green', 'spaces'
    ]],
    
    
'meteorology' => [
    'title_id' => 70,
    'words' => [
        'weather', 'climate', 'forecast', 'meteorology', 'storm', 
        'temperature', 'atmosphere', 'precipitation', 'humidity', 
        'pressure', 'barometer', 'wind', 'system', 
        'radar', 'satellite', 'analysis', 'climatology', 
        'pattern', 'systems', 'modeling', 'simulation', 
        'environment', 'meteorologist', 'data', 'collection', 
        'reporting', 'event', 'temperature', 'record', 
        'extreme', 'weather', 'events', 'tornado', 
        'hurricane', 'cyclone', 'drought', 'flood', 
        'ice', 'snow', 'sleet', 'hail', 
        'storm', 'surge', 'anomaly', 'phenomenon', 
        'atmospheric', 'front', 'elevation', 'latitude', 
        'longitude', 'climatological', 'conditions', 
        'rain', 'season', 'forecasting', 'techniques', 
        'visualization', 'charts', 'graphs', 'patterns', 
        'climate', 'change', 'variability', 'ocean', 
        'currents', 'sea', 'surface', 'temperature', 
        'regional', 'models', 'local', 'influences', 
        'human', 'activities', 'effects', 'urban', 
        'heat', 'island', 'weathering', 'variations', 
        'station', 'instruments', 'observation', 
        'meteorological', 'societies', 'applications', 
        'research', 'development', 'public', 'safety', 
        'warnings', 'alerts', 'disaster', 'preparedness'
    ]],
    
    
'forestry' => [
    'title_id' => 71,
    'words' => [
        'forest', 'trees', 'conservation', 'wildlife', 'forestry', 
        'logging', 'habitat', 'ecosystem', 'biodiversity', 
        'management', 'sustainability', 'reforestation', 
        'afforestation', 'timber', 'land', 'use', 
        'regeneration', 'silviculture', 'understory', 
        'canopy', 'deforestation', 'ecosystem', 'services', 
        'carbon', 'sequestration', 'soil', 'erosion', 
        'wildfire', 'protection', 'policy', 'research', 
        'climate', 'change', 'habitat', 'restoration', 
        'native', 'species', 'pests', 'diseases', 
        'tree', 'planting', 'ecosystem', 'health', 
        'agroforestry', 'mixed', 'forests', 'sustainable', 
        'logging', 'practices', 'forest', 'inventory', 
        'yield', 'economics', 'landscape', 'fire', 
        'management', 'forest', 'productivity', 'woodland', 
        'planning', 'wildlife', 'corridors', 'forest', 
        'biomass', 'extraction', 'sustainable', 'forestry', 
        'techniques', 'community', 'engagement', 'education', 
        'forest', 'communities', 'pollution', 'climate', 
        'adaptation', 'conservation', 'efforts', 'wildlife', 
        'habitats', 'plantations', 'cultural', 'significance'
    ]],
    
    
'archaeology' => [
    'title_id' => 72,
    'words' => [
        'excavation', 'fossils', 'research', 'site', 'history', 
        'artifacts', 'archaeology', 'ancient', 'culture', 
        'stratigraphy', 'analysis', 'material', 'remains', 
        'heritage', 'preservation', 'context', 'interpretation', 
        'dating', 'carbon', 'chronology', 'fieldwork', 
        'geophysical', 'surveys', 'ceramics', 'pottery', 
        'excavations', 'methodology', 'finds', 'burials', 
        'temples', 'settlements', 'civilizations', 'paleoanthropology', 
        'architecture', 'landscape', 'environments', 'art', 
        'iconography', 'cultural', 'anthropology', 'monuments', 
        'prehistoric', 'historical', 'records', 'ancestors', 
        'material', 'culture', 'tools', 'weapons', 
        'bone', 'analysis', 'lithics', 'ethnoarchaeology', 
        'experimental', 'archaeology', 'underwater', 'archaeology', 
        'regional', 'archaeology', 'data', 'interpretative', 
        'science', 'community', 'outreach', 'archaeobotany', 
        'bioarchaeology', 'remote', 'sensing', 'photogrammetry', 
        'forensic', 'archaeology', 'cultural', 'resources', 
        'land', 'management', 'site', 'protection', 
        'conservation', 'laws', 'ethics', 'historical', 
        'preservation', 'processes', 'trench', 'investigation'
    ]],
    
    
'veterinary_science' => [
    'title_id' => 73,
    'words' => [
        'animal', 'veterinarian', 'medicine', 'treatment', 'care', 
        'disease', 'clinic', 'diagnosis', 'surgery', 
        'pharmacology', 'vaccination', 'health', 'wellness', 
        'nutrition', 'parasite', 'infection', 'rehabilitation', 
        'anesthesia', 'emergency', 'care', 'diagnostic', 
        'imaging', 'radiology', 'laboratory', 'testing', 
        'spaying', 'neutering', 'behavior', 'training', 
        'wildlife', 'domestic', 'species', 'exotics', 
        'equine', 'feline', 'canine', 'zoological', 
        'medicine', 'preventive', 'grooming', 'shelter', 
        'rescue', 'adoption', 'animal', 'welfare', 
        'ethics', 'research', 'biomedical', 'tissue', 
        'culture', 'pathology', 'virology', 'bacteriology', 
        'microbiology', 'public', 'health', 'safety', 
        'epidemiology', 'zoonotic', 'diseases', 'vaccine', 
        'formulation', 'cancer', 'therapeutics', 'surgical', 
        'procedure', 'clinical', 'pathways', 'molecular', 
        'diagnostics', 'emerging', 'diseases', 'treatment', 
        'protocols', 'clinical', 'trials', 'veterinary', 
        'medicine', 'continuing', 'education', 'technologies'
    ]],
    
    
'neurology' => [
    'title_id' => 74,
    'words' => [
        'brain', 'neuroscience', 'neurons', 'nervous', 'system', 
        'research', 'neurology', 'disorders', 'cognition', 
        'synapse', 'axons', 'dendrites', 'glial', 
        'cells', 'neurotransmitters', 'pathways', 'plasticity', 
        'brainstem', 'cerebellum', 'cerebrum', 'thalamus', 
        'hypothalamus', 'spinal', 'cord', 'reflexes', 
        'central', 'peripheral', 'neural', 'network', 
        'activity', 'functional', 'imaging', 'behavior', 
        'sensory', 'processing', 'motor', 'skills', 
        'memory', 'learning', 'attention', 'language', 
        'development', 'epilepsy', 'stroke', 'multiple', 
        'sclerosis', 'Parkinson', 'Alzheimer', 'dementia', 
        'migraine', 'headache', 'treatment', 'diagnosis', 
        'clinical', 'trials', 'neurodegenerative', 'conditions', 
        'psychological', 'disorders', 'mental', 'health', 
        'autism', 'spectrum', 'disorder', 'ADD', 
        'ADHD', 'neurobiology', 'brain', 'function', 
        'cerebrovascular', 'accident', 'spinal', 'injury', 
        'neurosurgery', 'rehabilitation', 'therapies', 
        'biofeedback', 'pain', 'management', 'pharmacology', 
        'genetics', 'inflammation', 'migraines', 'neuropathic', 
        'symptoms', 'neurological', 'examination', 'reflex', 
        'tests', 'outcomes', 'prognosis', 'risk'
    ]],
    
    
'epidemiology' => [
    'title_id' => 75,
    'words' => [
        'disease', 'spread', 'epidemic', 'pandemic', 'health', 
        'epidemiology', 'research', 'treatment', 'infection', 
        'transmission', 'outbreak', 'prevalence', 'incidence', 
        'risk', 'factors', 'surveillance', 'prevention', 
        'control', 'vaccination', 'immunization', 'intervention', 
        'public', 'health', 'bioethics', 'study', 
        'population', 'healthcare', 'outcomes', 'statistics', 
        'data', 'analysis', 'cohort', 'case', 
        'study', 'clinical', 'trials', 'methodology', 
        'qualitative', 'quantitative', 'epidemiological', 'modeling', 
        'demographics', 'socioeconomic', 'determinants', 'environmental', 
        'biostatistics', 'policy', 'implementation', 'infectious', 
        'noncommunicable', 'diseases', 'chronic', 'conditions', 
        'screening', 'diagnosis', 'health', 'promotion', 
        'survivorship', 'factors', 'healthcare', 'systems', 
        'access', 'equity', 'resources', 'community', 
        'engagement', 'interventions', 'outreach', 'education', 
        'collaboration', 'stakeholders', 'implementation', 
        'evaluation', 'programs', 'risk', 'communication', 
        'health', 'crises', 'response', 'preparedness'
    ]],
    
    
'biochemistry' => [
    'title_id' => 76,
    'words' => [
        'molecule', 'cell', 'reaction', 'biochemistry', 'enzymes', 
        'proteins', 'metabolism', 'research', 'substrate', 
        'catalyst', 'energy', 'ATP', 'DNA', 
        'RNA', 'nucleic', 'acids', 'lipids', 
        'carbohydrates', 'metabolites', 'pathways', 'synthesis', 
        'degradation', 'homeostasis', 'biochemical', 'signal', 
        'transduction', 'transport', 'membrane', 'function', 
        'structure', 'chemical', 'bonds', 'hydrogen', 
        'ionic', 'covalent', 'polar', 'nonpolar', 
        'amino', 'acids', 'peptide', 'bond', 
        'secondary', 'tertiary', 'quaternary', 'structure', 
        'enzymatic', 'kinetics', 'regulation', 'feedback', 
        'inhibition', 'allosteric', 'modulation', 'cofactors', 
        'coenzymes', 'glycolysis', 'citric', 'acid', 
        'cycle', 'photosynthesis', 'oxidative', 'phosphorylation', 
        'cellular', 'respiration', 'fermentation', 'anaerobic', 
        'aerobic', 'metabolic', 'disorders', 'biotechnology', 
        'applications', 'clinical', 'biochemistry', 'drug', 
        'discovery', 'therapeutics', 'toxicology', 'biochemical', 
        'assays', 'analytical', 'techniques', 'chromatography', 
        'electrophoresis', 'spectroscopy', 'immunology', 
        'research', 'advances', 'innovations', 'laboratory', 
        'protocols', 'experiments', 'results', 'findings'
    ]],
    
    
'genomics' => [
    'title_id' => 77,
    'words' => [
        'DNA', 'genome', 'genomics', 'genetics', 'sequencing', 
        'research', 'chromosomes', 'mutation', 'variants', 
        'analysis', 'bioinformatics', 'mapping', 'genetic', 
        'markers', 'expression', 'transcription', 'translation', 
        'alleles', 'genetic', 'modification', 'genetic', 
        'disorders', 'polygenic', 'traits', 'homozygous', 
        'heterozygous', 'genotype', 'phenotype', 'chromosomal', 
        'structure', 'organization', 'haplotype', 'synteny', 
        'comparative', 'functional', 'genomics', 'metagenomics', 
        'transcriptomics', 'proteomics', 'epigenomics', 'interactions', 
        'pathways', 'biological', 'samples', 'large-scale', 
        'studies', 'high-throughput', 'technologies', 'next-generation', 
        'sequencing', 'NGS', 'single-cell', 'sequencing', 
        'CRISPR', 'gene', 'editing', 'population', 
        'genomics', 'clinical', 'applications', 'personalized', 
        'medicine', 'genetic', 'counseling', 'pharmacogenomics', 
        'toxicogenomics', 'genetic', 'screening', 'association', 
        'studies', 'cohort', 'design', 'data', 
        'interpretation', 'genetic', 'database', 'resources', 
        'informatics', 'bioethics', 'human', 'genome', 
        'project', 'synthetic', 'biology', 'plant', 
        'genomics', 'animal', 'genomics', 'agriculture'
    ]],
    
    
'oncology' => [
    'title_id' => 78,
    'words' => [
        'cancer', 'treatment', 'tumor', 'radiation', 'chemotherapy', 
        'oncology', 'diagnosis', 'research', 'immunotherapy', 
        'targeted', 'therapy', 'biotherapy', 'screening', 
        'prevention', 'prognosis', 'staging', 'metastasis', 
        'recurrence', 'side', 'effects', 'palliative', 
        'care', 'clinical', 'trials', 'survivorship', 
        'oncogenes', 'tumor', 'suppressor', 'genes', 
        'pathology', 'biopsy', 'cytology', 'histology', 
        'oncological', 'pharmacology', 'symptoms', 'risk', 
        'factors', 'lifestyle', 'exposures', 'family', 
        'history', 'radiation', 'therapy', 'surgery', 
        'adjuvant', 'neoadjuvant', 'hormonal', 'therapy', 
        'molecular', 'genetics', 'treatment', 'personalized', 
        'precision', 'medicine', 'biomarkers', 'tumor', 
        'microenvironment', 'inflammation', 'angiogenesis', 
        'apoptosis', 'cell', 'cycle', 'growth', 
        'factors', 'tumor', 'markers', 'screening', 
        'guidelines', 'healthcare', 'access', 'education', 
        'advocacy', 'resources', 'support', 'pediatric', 
        'gastrointestinal', 'breast', 'lung', 'prostate', 
        'leukemia', 'lymphoma', 'sarcoma', 'neuroblastoma', 
        'clinical', 'research', 'collaborative', 'networks', 
        'treatment', 'approaches', 'integration', 'patient'
    ]],
    
    
'sociology' => [
    'title_id' => 79,
    'words' => [
        'society', 'culture', 'research', 'community', 'social', 
        'behavior', 'group', 'structure', 'interaction', 'norms', 
        'values', 'institutions', 'socialization', 'deviance', 
        'roles', 'statuses', 'dynamics', 'conflict', 
        'cohesion', 'collective', 'identity', 'demographics', 
        'ethnicity', 'class', 'inequality', 'gender', 
        'race', 'social', 'stratification', 'migration', 
        'globalization', 'social', 'change', 'public', 
        'policy', 'education', 'family', 'work', 
        'economic', 'system', 'urbanization', 'subculture', 
        'counterculture', 'social', 'movements', 'power', 
        'authority', 'citizenship', 'participation', 'social', 
        'network', 'social', 'capital', 'solidarity', 
        'anomie', 'ethnography', 'quantitative', 'qualitative', 
        'methods', 'fieldwork', 'surveys', 'interviews', 
        'data', 'analysis', 'theory', 'functionalism', 
        'symbolic', 'interactionism', 'conflict', 'theory', 
        'feminism', 'postmodernism', 'critical', 'theory', 
        'cultural', 'studies', 'social', 'justice', 
        'community', 'organizing', 'grassroots', 'advocacy', 
        'research', 'ethics', 'methodology', 'approaches', 
        'social', 'work', 'health', 'social', 
        'problems', 'public', 'sociology', 'contemporary', 
        'issues'
    ]],
    
    
'forensics' => [
    'title_id' => 80,
    'words' => [
        'crime', 'evidence', 'investigation', 'DNA', 'forensics', 
        'fingerprints', 'analysis', 'law', 'scene', 
        'suspect', 'witness', 'interrogation', 'testimony', 
        'autopsy', 'ballistics', 'trace', 'evidence', 
        'toxicology', 'serology', 'digital', 'forensics', 
        'cybercrime', 'biometrics', 'encryption', 'protocols', 
        'report', 'documentation', 'chain', 'custody', 
        'legal', 'standards', 'expert', 'testimony', 
        'court', 'admissibility', 'law', 'enforcement', 
        'criminal', 'justice', 'system', 'prosecution', 
        'defense', 'verdict', 'conviction', 'exoneration', 
        'evidence', 'preservation', 'sample', 'collection', 
        'DNA', 'profiling', 'investigative', 'techniques', 
        'field', 'forensics', 'laboratory', 'protocols', 
        'scene', 'reconstruction', 'behavioral', 'profiling', 
        'victimology', 'cold', 'cases', 'missing', 
        'persons', 'human', 'remains', 'facial', 
        'recognition', 'age', 'estimation', 'software', 
        'analysis', 'algorithms', 'databases', 'reporting', 
        'training', 'certification', 'standards', 'continuing', 
        'education', 'technologies', 'advancements', 'investigative', 
        'techniques'
    ]],
    
    
'seismology' => [
    'title_id' => 81,
    'words' => [
        'earthquake', 'fault', 'seismology', 'tectonic', 'plates', 
        'research', 'magnitude', 'epicenter', 'seismic', 
        'waves', 'tsunami', 'aftershock', 'hypocenter', 
        'faulting', 'subduction', 'zone', 'activity', 
        'monitoring', 'instruments', 'seismograph', 'data', 
        'analysis', 'ground', 'motion', 'risk', 
        'assessment', 'hazard', 'mitigation', 'building', 
        'codes', 'safety', 'protocols', 'vulnerability', 
        'liquefaction', 'resilience', 'geology', 'infrastructure', 
        'tremor', 'events', 'intensity', 'location', 
        'pattern', 'geophysics', 'paleoseismology', 'historical', 
        'record', 'magnitude', 'scale', 'Richter', 
        'moment', 'magnitude', 'seismicity', 'velocity', 
        'gradient', 'waveforms', 'data', 'collection', 
        'simulation', 'forecasting', 'tectonics', 'continental', 
        'drift', 'subduction', 'slip', 'stress', 
        'strain', 'fault', 'movement', 'geological', 
        'survey', 'ground', 'deformation', 'remote', 
        'sensing', 'analysis', 'computer', 'modeling', 
        'seismic', 'waves', 'refraction', 'reflection'
    ]],
    
    
'microbiology' => [
    'title_id' => 82,
    'words' => [
        'bacteria', 'virus', 'microbe', 'infection', 'pathogen', 
        'microbiology', 'research', 'disease', 'culture', 
        'antibiotics', 'antimicrobials', 'fungi', 'protozoa', 
        'algae', 'cell', 'division', 'growth', 
        'metabolism', 'immunology', 'virology', 'bacteriology', 
        'pathogenicity', 'virulence', 'toxins', 'host', 
        'immune', 'response', 'diagnosis', 'treatment', 
        'prevention', 'sterilization', 'disinfection', 
        'sanitization', 'biohazard', 'laboratory', 'protocols', 
        'fieldwork', 'specimens', 'sample', 'analysis', 
        'microscope', 'staining', 'techniques', 'genetic', 
        'engineering', 'biotechnology', 'biochemical', 'processes', 
        'environmental', 'microbiology', 'soil', 'water', 
        'industrial', 'microbiology', 'biofilms', 'bioinformatics', 
        'metagenomics', 'symbiosis', 'mutualism', 'parasitism', 
        'disease', 'outbreaks', 'epidemiology', 'resistance', 
        'clones', 'recombinant', 'DNA', 'RNA', 
        'sequencing', 'characterization', 'pathways', 'molecular', 
        'genetics', 'cellular', 'respiration', 'photosynthesis', 
        'culture', 'medium', 'asexual', 'reproduction', 
        'bacterial', 'biosecurity', 'infection', 'control', 
        'public', 'health', 'impact', 'assessment'
    ]],
    
    
'geology' => [
    'title_id' => 83,
    'words' => [
        'rock', 'earth', 'geology', 'mineral', 'fossil', 
        'layer', 'research', 'erosion', 'sediment', 
        'strata', 'composition', 'igneous', 'sedimentary', 
        'metamorphic', 'tectonics', 'plate', 'boundaries', 
        'fault', 'earthquake', 'volcano', 'magma', 
        'lava', 'crust', 'mantle', 'core', 
        'landform', 'topography', 'landslide', 'weathering', 
        'geological', 'time', 'scale', 'carbon', 
        'dating', 'radiometric', 'chronology', 'geological', 
        'maps', 'fossilization', 'paleontology', 'geophysical', 
        'surveys', 'environmental', 'impact', 'mining', 
        'resource', 'sustainability', 'groundwater', 
        'hydrology', 'soil', 'geochemistry', 'tectonic', 
        'activity', 'biogeology', 'climate', 'change', 
        'sedimentation', 'oceanography', 'continental', 
        'drift', 'mineralogy', 'rocks', 'deposits', 
        'stratigraphy', 'petrology', 'natural', 'hazards', 
        'geothermal', 'energy', 'resource', 'exploration', 
        'land', 'use', 'geosystems', 'urban', 
        'geology', 'community', 'engagement', 'education'
    ]],
    
    
'marine_engineering' => [
    'title_id' => 84,
    'words' => [
        'ship', 'engineering', 'marine', 'ocean', 'vessel', 
        'design', 'navy', 'offshore', 'construction', 
        'navigation', 'dynamics', 'propulsion', 'structures', 
        'materials', 'hydrodynamics', 'stability', 'resistance', 
        'research', 'development', 'maintenance', 'operations', 
        'environment', 'safety', 'regulations', 'standards', 
        'project', 'management', 'systems', 'automation', 
        'equipment', 'dry', 'dock', 'survey', 
        'shipbuilding', 'marine', 'technology', 'craft', 
        'mechanical', 'systems', 'electrical', 'integrated', 
        'control', 'navigation', 'satellite', 'communication', 
        'marine', 'electronics', 'environmental', 'impact', 
        'monitoring', 'sustainability', 'coastal', 'engineering', 
        'marine', 'resources', 'offshore', 'platforms', 
        'floating', 'structures', 'subsea', 'technology', 
        'installations', 'operations', 'ship', 'design', 
        'analysis', 'testing', 'seaworthiness', 'performance', 
        'towing', 'transportation', 'marine', 'logistics', 
        'fishing', 'industry', 'aquaculture', 'ports', 
        'harbors', 'research', 'facilities', 'coastal', 
        'management', 'marine', 'biotechnology', 'drilling'
    ]],
    
    
'agriculture' => [
    'title_id' => 85,
    'words' => [
        'farming', 'crops', 'soil', 'harvest', 'tractor', 
        'agriculture', 'irrigation', 'fertilizer', 'livestock', 
        'planting', 'seeds', 'cultivation', 'pesticides', 
        'agronomy', 'yield', 'production', 'sustainability', 
        'organic', 'farming', 'mechanization', 'techniques', 
        'equipment', 'agricultural', 'science', 'land', 
        'management', 'climate', 'change', 'crop', 
        'rotation', 'integrated', 'pest', 'management', 
        'greenhouse', 'farming', 'hydroponics', 'aquaculture', 
        'livestock', 'breeding', 'nutrition', 'sustainable', 
        'practices', 'market', 'economics', 'trade', 
        'farmers', 'cooperatives', 'food', 'security', 
        'biodiversity', 'conservation', 'agricultural', 
        'policies', 'research', 'extension', 'education', 
        'technology', 'biotechnology', 'crop', 'genetics', 
        'agroecology', 'precision', 'agriculture', 'rural', 
        'development', 'soil', 'health', 'water', 
        'resources', 'landscape', 'agricultural', 'systems', 
        'mechanical', 'plant', 'breeding', 'harvesting', 
        'crop', 'disease', 'resistance', 'animal', 
        'husbandry', 'food', 'production', 'system', 
        'food', 'value', 'chain', 'sustainable', 
        'intensification', 'urban', 'agriculture', 'field'
    ]],
    
    
'astrology' => [
    'title_id' => 86,
    'words' => [
        'horoscope', 'zodiac', 'stars', 'planets', 'astrology', 
        'signs', 'prediction', 'cosmos', 'constellation', 
        'astrological', 'chart', 'birth', 'ascendant', 
        'moon', 'phases', 'elements', 'fire', 
        'earth', 'air', 'water', 'houses', 
        'retrograde', 'aspect', 'transit', 'influence', 
        'mythology', 'symbolism', 'divination', 'occult', 
        'tarot', 'numerology', 'fate', 'destiny', 
        'intuition', 'energy', 'alignment', 'personal', 
        'traits', 'compatibility', 'relationships', 
        'life', 'events', 'celestial', 'phenomena', 
        'mystical', 'science', 'spirituality', 'cosmology', 
        'ecliptic', 'stellar', 'cycles', 'divinatory', 
        'practices', 'astrological', 'system', 'calendar', 
        'synchronization', 'solar', 'lunar', 'events', 
        'charting', 'interpretation', 'reading', 'characteristics', 
        'personality', 'compatibility', 'forecasts', 'consultation', 
        'mythical', 'significance', 'horoscopic', 'solar', 
        'return', 'lunar', 'return', 'solar', 'archetypes'
    ]],
    
    
'aviation' => [
    'title_id' => 87,
    'words' => [
        'plane', 'pilot', 'airport', 'aviation', 'flight', 
        'jet', 'aircraft', 'airline', 'cockpit', 'takeoff', 
        'landing', 'navigation', 'runway', 'taxiway', 
        'terminal', 'boarding', 'gate', 'crew', 
        'passenger', 'cabin', 'safety', 'emergency', 
        'protocols', 'air traffic', 'control', 'navigation', 
        'instruments', 'altitude', 'speed', 'velocity', 
        'flight plan', 'airspace', 'FAR', 'VFR', 
        'IFR', 'weather', 'conditions', 'radar', 
        'satellite', 'communication', 'navigation', 
        'systems', 'ground', 'crew', 'dispatch', 
        'fuel', 'loading', 'weight', 'balance', 
        'turbulence', 'flight path', 'airworthiness', 'maintenance', 
        'inspections', 'logbook', 'aircraft', 'design', 
        'engineering', 'aviation', 'history', 'military', 
        'commercial', 'general', 'flight training', 
        'simulator', 'aviation', 'education', 'aircraft', 
        'types', 'commercial', 'operations', 'airshow', 
        'drone', 'aviation', 'regulations', 'certifications', 
        'airworthiness', 'standards', 'aviation', 'industry'
    ]],
    
    
'baking' => [
    'title_id' => 88,
    'words' => [
        'cake', 'bread', 'oven', 'flour', 'sugar', 
        'baking', 'pastry', 'dessert', 'recipe', 'butter', 
        'dough', 'yeast', 'knead', 'proofing', 
        'batter', 'mixing', 'whisk', 'rolling', 
        'pin', 'pan', 'baking', 'sheet', 
        'muffin', 'cookies', 'brownies', 'scones', 
        'frosting', 'icing', 'glaze', 'ganache', 
        'sprinkle', 'piping', 'tip', 'layer', 
        'crust', 'filling', 'tart', 'quiche', 
        'puff', 'pastry', 'chocolate', 'vanilla', 
        'spice', 'zest', 'nuts', 'fruit', 
        'cream', 'whipped', 'custard', 'baking', 
        'powder', 'soda', 'salt', 'leavening', 
        'agent', 'temperature', 'timer', 'cooling', 
        'rack', 'parchment', 'paper', 'nonstick', 
        'spray', 'cleaning', 'techniques', 'skills', 
        'presentation', 'garnish', 'decorating', 
        'kitchen', 'tools', 'equipment', 'mixer', 
        'measuring', 'cups', 'spoons', 'scales'
    ]],
    
    
'blockchain' => [
    'title_id' => 89,
    'words' => [
        'blockchain', 'distributed', 'ledger', 'cryptography', 
        'bitcoin', 'smart', 'contract', 'decentralized', 
        'token', 'mining', 'transactions', 'consensus', 
        'network', 'nodes', 'protocol', 'decentralization', 
        'dapps', 'hash', 'function', 'immutability', 
        'transparency', 'security', 'verification', 
        'assets', 'tokenization', 'ERC20', 'Ethereum', 
        'wallet', 'public', 'private', 'keys', 
        'ICO', 'deFi', 'NFT', 'smart', 
        'contracts', 'scalability', 'gas', 'fees', 
        'hard', 'fork', 'soft', 'fork', 
        'ledger', 'technology', 'digital', 'currencies', 
        'privacy', 'anonymity', 'auditability', 
        'permissioned', 'permissionless', 'ledgers', 
        'interoperability', 'solutions', 'applications', 
        'recordkeeping', 'cryptocurrency', 'market', 
        'volatility', 'exchange', 'trading', 'platforms', 
        'asset', 'management', 'regulatory', 'compliance', 
        'governance', 'trustless', 'systems', 'smart', 
        'contracts', 'use', 'cases', 'cryptographic', 
        'tokens', 'non-fungible', 'ledger', 'technology'
    ]],
    
    
'ceramics' => [
    'title_id' => 90,
    'words' => [
        'clay', 'pottery', 'ceramics', 'kiln', 'sculpture', 
        'molding', 'glaze', 'craft', 'art', 'firing', 
        'handbuilding', 'wheelthrowing', 'slip', 'earthenware', 
        'stoneware', 'porcelain', 'bisque', 'techniques', 
        'glazing', 'surface', 'decoration', 'shaping', 
        'design', 'vessels', 'tiles', 'ceramic', 
        'sculptures', 'functional', 'artwork', 'decorative', 
        'materials', 'engobe', 'underlay', 'fire', 
        'color', 'finish', 'potter', 'wheel', 
        'tools', 'slab', 'construction', 'jugs', 
        'bowls', 'plates', 'cups', 'mugs', 
        'kiln', 'temperature', 'artistic', 'expression', 
        'techniques', 'experimenting', 'finishing', 'process', 
        'studio', 'craftsmanship', 'form', 'function', 
        'resilience', 'durability', 'workshop', 'artisanship', 
        'craft', 'potters', 'sculptors', 'industry', 
        'ceramic', 'products', 'vases', 'collections', 
        'exhibitions', 'demonstrations', 'craft fairs', 
        'education', 'workshops', 'tradition', 'innovation'
    ]],
    
    
'cinematography' => [
    'title_id' => 91,
    'words' => [
        'film', 'camera', 'cinematography', 'director', 'lighting', 
        'frame', 'shot', 'screenplay', 'lens', 'composition', 
        'angles', 'movement', 'focus', 'depth', 
        'exposure', 'color', 'grading', 'editing', 
        'storyboarding', 'visual', 'effects', 'production', 
        'design', 'location', 'scouting', 'set', 
        'dressing', 'blocking', 'action', 'performance', 
        'narrative', 'techniques', 'style', 'genre', 
        'cinematic', 'language', 'visuals', 'audio', 
        'post-production', 'scripting', 'dialogue', 'sequence', 
        'transition', 'cut', 'dissolve', 'fade', 
        'montage', 'b-roll', 'story', 'structure', 
        'format', 'aspect', 'ratio', 'screen', 
        'cinematic', 'experience', 'aesthetics', 'visual', 
        'storytelling', 'art', 'craft', 'inspiration', 
        'collaboration', 'independent', 'theatrical', 'release', 
        'box', 'office', 'audience', 'critique', 
        'festival', 'submission', 'screening', 'premiere', 
        'film', 'history', 'technology', 'advancements', 
        'digital', 'cinematographers', 'camera', 'lenses', 
        'equipment', 'techniques', 'shots', 'narrative'
    ]],
    
    
'comedy' => [
    'title_id' => 92,
    'words' => [
        'joke', 'humor', 'comedian', 'sketch', 'laughter', 
        'comedy', 'satire', 'stand-up', 'parody', 'gag', 
        'improv', 'funny', 'punchline', 'witticism', 
        'character', 'absurd', 'situation', 'ironical', 
        'timing', 'delivery', 'set-up', 'crowd', 
        'audience', 'performance', 'routine', 'pantomime', 
        'slapstick', 'farcical', 'dark', 'comedy', 
        'romantic', 'stand-up', 'one-liner', 'skit', 
        'mockumentary', 'humorist', 'comic', 'relatable', 
        'observational', 'anecdote', 'parody', 'satirical', 
        'punch', 'sarcastic', 'quirky', 'situational', 
        'characterization', 'droll', 'wit', 'sardonic', 
        'entertainment', 'comedic', 'genres', 'cultural', 
        'references', 'self-deprecating', 'gallows', 
        'banter', 'punch', 'lines', 'jest', 
        'meme', 'viral', 'sketches', 'online', 
        'content', 'humorous', 'satirical', 'treatment', 
        'cliché', 'surreal', 'spontaneity', 'improvisation'
    ]],
    
    
'consulting' => [
    'title_id' => 93,
    'words' => [
        'strategy', 'advisor', 'consulting', 'client', 'business', 
        'analysis', 'project', 'expert', 'solutions', 'implementation', 
        'recommendations', 'services', 'management', 'assessment', 
        'process', 'planning', 'operational', 'efficiency', 
        'development', 'stakeholder', 'engagement', 'facilitation', 
        'innovation', 'market', 'research', 'trends', 
        'framework', 'goals', 'objectives', 'performance', 
        'monitoring', 'evaluation', 'risk', 'mitigation', 
        'capacity', 'building', 'operational', 'audit', 
        'compliance', 'financial', 'consultant', 'change', 
        'leadership', 'program', 'design', 'workshops', 
        'training', 'communication', 'systems', 'human', 
        'resources', 'expertise', 'knowledge', 'transfer', 
        'tools', 'methodologies', 'templates', 'reporting', 
        'case', 'studies', 'feedback', 'continuous', 
        'improvement', 'partnership', 'collaboration', 'deliverables', 
        'business', 'model', 'development', 'impact', 
        'evaluation', 'fiscal', 'management', 'strategic', 
        'consultation', 'network', 'building', 'negotiation', 
        'alignment', 'roadmap', 'requirements', 'gap', 
        'analysis', 'troubleshooting', 'objectives', 'goal'
    ]],
    
    
'crafts' => [
    'title_id' => 94,
    'words' => [
        'handmade', 'craft', 'knitting', 'sewing', 'diy', 
        'art', 'embroidery', 'craftsmanship', 'tools', 'material', 
        'techniques', 'design', 'pattern', 'fabric', 
        'color', 'texture', 'weaving', 'crochet', 
        'pottery', 'ceramics', 'woodworking', 'scrapbooking', 
        'upcycling', 'recycling', 'origami', 'jewelry', 
        'beading', 'mosaic', 'furniture', 'finishing', 
        'painting', 'staining', 'glazing', 'cutting', 
        'sanding', 'assembly', 'decorative', 'arts', 
        'projects', 'creativity', 'skills', 'workshop', 
        'studio', 'supplies', 'storage', 'organization', 
        'inspiration', 'demonstration', 'exhibition', 'market', 
        'fair', 'vendors', 'community', 'classes', 
        'lessons', 'collaboration', 'personalization', 
        'technique', 'practice', 'handicraft', 'fiber', 
        'craftsman', 'craftswoman', 'pencil', 'watercolor', 
        'oil', 'painting', 'sketching', 'charcoal', 
        'mixed', 'media', 'installation', 'artwork', 
        'crafting', 'hobbies', 'passion', 'entrepreneurship'
    ]],
    
    
'criminology' => [
    'title_id' => 95,
    'words' => [
        'crime', 'law', 'justice', 'investigation', 'criminal', 
        'forensics', 'criminology', 'victim', 'evidence', 
        'offender', 'punishment', 'rehabilitation', 'deterrence', 
        'society', 'deviance', 'theory', 'prevention', 
        'felony', 'misdemeanor', 'criminality', 'penology', 
        'criminal', 'justice', 'system', 'victimology', 
        'sociology', 'law enforcement', 'police', 'courts', 
        'prosecution', 'defense', 'plea', 'bargain', 
        'trial', 'sentencing', 'appeal', 'parole', 
        'recidivism', 'detention', 'juvenile', 'delinquency', 
        'rights', 'due process', 'criminal law', 'civil law', 
        'criminogenic', 'factors', 'criminalistics', 'evidence', 
        'gathering', 'analysis', 'surveillance', 'interrogation', 
        'profiling', 'cybercrime', 'terrorism', 'white-collar', 
        'organized', 'crime', 'human trafficking', 'drug', 
        'trafficking', 'social', 'impact', 'research', 
        'statistics', 'policy', 'crime scene', 'investigator', 
        'detective', 'witness', 'testimony', 'legal', 
        'ethics', 'community', 'engagement', 'outreach'
    ]],
    
    
'diplomacy' => [
    'title_id' => 96,
    'words' => [
        'foreign', 'policy', 'ambassador', 'diplomat', 'negotiation', 
        'treaty', 'international', 'diplomacy', 'alliance', 
        'bilateral', 'multilateral', 'relations', 'communication', 
        'conflict', 'resolution', 'consulate', 'protocol', 
        'embassy', 'intervention', 'cooperation', 'sanctions', 
        'trade', 'agreements', 'foreign affairs', 'global', 
        'issues', 'sovereignty', 'human rights', 'security', 
        'economic', 'development', 'cultural', 'exchange', 
        'peacekeeping', 'missions', 'crisis', 'management', 
        'negotiators', 'representatives', 'forums', 'summits', 
        'intergovernmental', 'organizations', 'diplomatic', 
        'service', 'foreign policy', 'strategies', 'engagement', 
        'communication', 'influence', 'ambassadorship', 
        'international law', 'treaties', 'memorandum', 'understanding', 
        'host', 'nation', 'geopolitics', 'soft power', 
        'hard power', 'military', 'diplomatic', 'channels', 
        'collaboration', 'foreign relations', 'delegation', 
        'interests', 'bilateralism', 'multilateralism', 
        'negotiations', 'agreements', 'confidence', 'building'
    ]],
    
    
'diving' => [
    'title_id' => 97,
    'words' => [
        'scuba', 'snorkeling', 'diving', 'underwater', 'ocean', 
        'marine', 'equipment', 'coral', 'depth', 'regulator', 
        'wetsuit', 'drysuit', 'fins', 'mask', 
        'snorkel', 'buoyancy', 'control', 'tank', 
        'air', 'pressure', 'safety', 'buddy', 
        'divemaster', 'certification', 'training', 'courses', 
        'techniques', 'decompression', 'sickness', 'safety', 
        'stop', 'equipment', 'maintenance', 'dive', 
        'site', 'reef', 'fish', 'sea', 
        'life', 'environment', 'ecosystem', 'photography', 
        'videography', 'exploration', 'freediving', 'saturation', 
        'dives', 'tide', 'currents', 'visibility', 
        'entry', 'exit', 'shore', 'boat', 
        'diving', 'safety', 'briefing', 'site', 
        'plan', 'signals', 'communication', 'rescue', 
        'first aid', 'hazards', 'marine', 'conservation', 
        'underwater', 'caves', 'wrecks', 'diving', 
        'fishing', 'tropical', 'waters', 'open', 
        'water', 'cold', 'dives', 'exotic', 
        'locations', 'experience', 'adventure', 'vacation'
    ]],
    
    
'ecotourism' => [
    'title_id' => 98,
    'words' => [
        'sustainability', 'nature', 'ecotourism', 'travel', 
        'wildlife', 'conservation', 'responsible', 'green', 
        'environment', 'biodiversity', 'ecosystem', 'preservation', 
        'cultural', 'heritage', 'local', 'communities', 
        'adventure', 'experiences', 'educational', 'impact', 
        'ecological', 'footprint', 'voluntourism', 'environmentally', 
        'friendly', 'practices', 'outdoor', 'activities', 
        'guided', 'tours', 'nature', 'reserves', 
        'protected', 'areas', 'community-based', 'initiatives', 
        'wildlife', 'observations', 'hiking', 'camping', 
        'photography', 'sustainable', 'accommodation', 'transportation', 
        'responsibility', 'education', 'awareness', 'cultural', 
        'exchange', 'local', 'economies', 'environmental', 
        'education', 'nature', 'based', 'tourism', 
        'environment', 'stewardship', 'resource', 'management', 
        'conservation', 'ethics', 'responsible', 'travel', 
        'marine', 'ecotourism', 'land', 'conservation', 
        'eco-friendly', 'projects', 'research', 'natural', 
        'heritage', 'recreational', 'activities', 'environmental', 
        'advocacy', 'community', 'involvement', 'benefits'
    ]],
    
    
'engineering' => [
    'title_id' => 99,
    'words' => [
        'engineer', 'design', 'construction', 'system', 
        'innovation', 'mechanical', 'electrical', 'civil', 
        'problem-solving', 'architecture', 'technology', 
        'process', 'analysis', 'development', 'project', 
        'management', 'research', 'material', 'science', 
        'testing', 'quality', 'control', 'automation', 
        'methodology', 'safety', 'standards', 'regulations', 
        'prototyping', 'simulation', 'evaluation', 'optimization', 
        'efficiency', 'design', 'specifications', 'blueprints', 
        'collaboration', 'teams', 'stakeholders', 'budget', 
        'scheduling', 'resources', 'sustainability', 'environmental', 
        'impact', 'mechanics', 'thermodynamics', 'fluid', 
        'dynamics', 'electronics', 'control', 'systems', 
        'software', 'programming', 'data', 'analysis', 
        'technical', 'drawings', 'construction', 'management', 
        'field', 'operations', 'research', 'advancements', 
        'infrastructure', 'civil', 'engineering', 'environment', 
        'building', 'materials', 'energy', 'resources', 
        'safety', 'engineering', 'consulting', 'services', 
        'feasibility', 'studies', 'implementation', 'troubleshooting'
    ]],
    
    
'event_planning' => [
    'title_id' => 100,
    'words' => [
        'event', 'planner', 'wedding', 'conference', 'celebration', 
        'venue', 'catering', 'budget', 'invitation', 'logistics', 
        'schedule', 'timeline', 'decorations', 'setup', 
        'cleanup', 'guest', 'list', 'RSVP', 
        'theme', 'entertainment', 'photography', 'videography', 
        'audiovisual', 'services', 'registration', 'marketing', 
        'promotions', 'contracts', 'suppliers', 'vendors', 
        'client', 'requirements', 'coordinator', 'collaboration', 
        'site', 'visit', 'proposal', 'presentation', 
        'feedback', 'post-event', 'evaluation', 'favors', 
        'amenities', 'seating', 'arrangements', 'accessibility', 
        'security', 'insurance', 'insurance', 'transportation', 
        'accommodation', 'team', 'training', 'seminar', 
        'workshop', 'networking', 'sessions', 'attendee', 
        'experience', 'engagement', 'invitations', 'follow-up', 
        'thank-you', 'notes', 'summary', 'planning', 
        'checklists', 'budgeting', 'sponsorship', 'partnerships', 
        'timelines', 'task', 'management', 'event', 
        'technology', 'apps', 'tools', 'resources'
    ]],
    
    
'feminism' => [
    'title_id' => 101,
    'words' => [
        'equality', 'gender', 'rights', 'feminism', 'women', 
        'empowerment', 'patriarchy', 'activism', 'intersectionality', 
        'liberation', 'justice', 'advocacy', 'representation', 
        'discrimination', 'sexism', 'feminist', 'movements', 
        'solidarity', 'body', 'positivity', 'women\'s', 
        'history', 'education', 'reproductive', 'freedom', 
        'violence', 'sexual', 'harassment', 'workplace', 
        'equity', 'access', 'healthcare', 'issues', 
        'suffrage', 'rights', 'transgender', 'non-binary', 
        'gender', 'identity', 'social', 'change', 
        'global', 'initiatives', 'patriarchal', 'systems', 
        'culture', 'feminism', 'critiques', 'empowerment', 
        'economic', 'justice', 'gender-based', 'violence', 
        'domestic', 'abuse', 'advancement', 'leadership', 
        'policy', 'change', 'activists', 'dialogue', 
        'community', 'support', 'campaigns', 'debates', 
        'alliances', 'solidarity', 'gender', 'roles', 
        'intersectional', 'feminist', 'theory', 'criticism', 
        'representation', 'cultural', 'studies', 'sexuality'
    ]],
    
    
'firefighting' => [
    'title_id' => 102,
    'words' => [
        'fire', 'rescue', 'firefighter', 'emergency', 'hydrant', 
        'truck', 'safety', 'response', 'equipment', 'extinguisher', 
        'hose', 'ladder', 'station', 'alarm', 
        'dispatch', 'crew', 'incident', 'command', 
        'training', 'protocols', 'firefighting', 'gear', 
        'personal', 'protective', 'equipment', 'PPE', 
        'smoke', 'detector', 'evacuation', 'drills', 
        'hazard', 'assessment', 'fire', 'behavior', 
        'suppression', 'control', 'burn', 'firebreak', 
        'wildfire', 'containment', 'firestorm', 'arson', 
        'investigation', 'fireground', 'operations', 
        'prevention', 'community', 'outreach', 'public', 
        'education', 'first', 'responders', 'fire', 
        'code', 'emergency', 'medical', 'services', 
        'dispatch', 'response', 'protocols', 'safety', 
        'inspections', 'building', 'code', 'fire', 
        'investigation', 'equipment', 'rescue', 'vehicle', 
        'water', 'supply', 'firefighting', 'systems', 
        'urban', 'wildland', 'resources', 'firehouse'
    ]],
    
    
'furniture_design' => [
    'title_id' => 103,
    'words' => [
        'furniture', 'design', 'wood', 'upholstery', 'craft', 
        'interior', 'table', 'chair', 'modern', 'style', 
        'comfort', 'ergonomics', 'aesthetics', 'materials', 
        'functionality', 'finish', 'color', 'texture', 
        'construction', 'layout', 'space', 'utilization', 
        'form', 'fittings', 'hardware', 'designers', 
        'production', 'manufacturing', 'custom', 'pieces', 
        'collection', 'contemporary', 'traditional', 'minimalist', 
        'rustic', 'industrial', 'furnishing', 'accessories', 
        'cabinetry', 'sustainability', 'reclaimed', 'resources', 
        'modular', 'arrangement', 'lighting', 'environment', 
        'decor', 'design', 'trends', 'outdoor', 
        'patio', 'furniture', 'renovation', 'restoration', 
        'bespoke', 'vintage', 'retro', 'artisanal', 
        'comfort', 'design', 'blueprints', 'sketches', 
        'prototyping', 'workshop', 'craftsmanship', 'finishing', 
        'joinery', 'upholstery', 'cushions', 'seating', 
        'dining', 'living', 'bedroom', 'office', 
        'functional', 'design', 'customization', 'storage'
    ]],
    
    
'genealogy' => [
    'title_id' => 104,
    'words' => [
        'ancestry', 'family tree', 'heritage', 'genealogy', 
        'records', 'research', 'descendant', 'historical', 
        'lineage', 'pedigree', 'ancestor', 'genealogist', 
        'documentation', 'heritage', 'cultural', 'roots', 
        'traditions', 'records', 'vital', 'statistics', 
        'birth', 'marriage', 'death', 'census', 
        'immigration', 'naturalization', 'biography', 'oral', 
        'history', 'family', 'connections', 'heritage', 
        'society', 'ethnicity', 'cultural', 'identity', 
        'tribe', 'clan', 'relationship', 'kinship', 
        'collateral', 'lines', 'descendants', 'successors', 
        'generation', 'data', 'analysis', 'records', 
        'interpretation', 'family', 'reunions', 'gatherings', 
        'online', 'resources', 'DNA', 'testing', 
        'genealogical', 'societies', 'membership', 'heritage', 
        'websites', 'tools', 'platforms', 'software', 
        'organization', 'methods', 'conferences', 'networking'
    ]],
    
    
'geopolitics' => [
    'title_id' => 105,
    'words' => [
        'politics', 'international', 'geopolitics', 'global', 
        'power', 'territory', 'conflict', 'diplomacy', 
        'trade', 'sovereignty', 'nation-state', 'alliances', 
        'borders', 'relations', 'strategic', 'interests', 
        'influence', 'resources', 'security', 'military', 
        'hegemony', 'imperialism', 'globalization', 'regional', 
        'integration', 'crisis', 'negotiation', 'tensions', 
        'alliances', 'multilateralism', 'bilateral', 'cooperation', 
        'sanctions', 'policy', 'geography', 'economics', 
        'energy', 'climate', 'migration', 'humanitarian', 
        'issues', 'global', 'governance', 'soft power', 
        'hard power', 'international law', 'conflict', 'resolution', 
        'realism', 'liberalism', 'constructivism', 'foreign', 
        'affairs', 'diplomatic', 'relations', 'cultural', 
        'diplomatic', 'strategies', 'nationalism', 'secession', 
        'ethnic', 'identity', 'sovereign', 'states', 
        'security', 'alliances', 'think tanks', 'analysis', 
        'scholarship', 'debates', 'impact', 'technology'
    ]],
    
    
'graphic_design' => [
    'title_id' => 106,
    'words' => [
        'design', 'graphic', 'visual', 'branding', 'layout', 
        'typography', 'color', 'logo', 'creative', 'illustration', 
        'composition', 'aesthetics', 'digital', 'media', 
        'print', 'advertisement', 'marketing', 'package', 
        'identity', 'stationery', 'vector', 'raster', 
        'software', 'Photoshop', 'Illustrator', 'InDesign', 
        'mockup', 'portfolio', 'style', 'guide', 
        'branding', 'strategy', 'user', 'experience', 
        'UX', 'user', 'interface', 'UI', 
        'web', 'design', 'print', 'production', 
        'photography', 'elements', 'icons', 'symbols', 
        'infographics', 'motion', 'graphics', 'color', 
        'theory', 'contrast', 'harmony', 'balance', 
        'grid', 'system', 'project', 'management', 
        'feedback', 'revisions', 'client', 'presentation', 
        'concept', 'development', 'visualization', 'storytelling', 
        'creative', 'thinking', 'collaboration', 'trends', 
        'inspiration', 'resources', 'workshop', 'tutorials'
    ]],
    
    
'home_automation' => [
    'title_id' => 107,
    'words' => [
        'automation', 'smart home', 'IoT', 'lighting', 
        'security', 'control', 'system', 'voice assistant', 
        'device', 'sensors', 'network', 'appliance', 
        'smartphone', 'remote', 'monitoring', 'management', 
        'integration', 'connectivity', 'programmable', 'thermostat', 
        'surveillance', 'cameras', 'alerts', 'notifications', 
        'home', 'entertainment', 'media', 'streaming', 
        'home theater', 'comfort', 'energy', 'efficiency', 
        'smart', 'devices', 'ecosystem', 'automation', 
        'smart', 'locks', 'access', 'control', 
        'routine', 'schedule', 'user', 'interface', 
        'cloud', 'platform', 'data', 'analytics', 
        'home', 'network', 'setup', 'installation', 
        'customization', 'updates', 'maintenance', 'accessibility', 
        'AI', 'artificial', 'intelligence', 'customization', 
        'compatibility', 'applications', 'security', 
        'protocols', 'communication', 'standards', 'voice', 
        'recognition', 'devices', 'feedback', 'interactivity'
    ]],
    
    
'horticulture' => [
    'title_id' => 108,
    'words' => [
        'garden', 'plant', 'horticulture', 'botany', 'soil', 
        'flowers', 'landscaping', 'greenhouse', 'cultivate', 
        'irrigation', 'pruning', 'fertilizer', 'pests', 
        'diseases', 'weeding', 'crop', 'rotation', 
        'harvest', 'propagation', 'native', 'species', 
        'planting', 'season', 'perennials', 'annuals', 
        'vegetables', 'fruits', 'herbs', 'pollination', 
        'compost', 'mulch', 'landscape', 'design', 
        'environment', 'sustainability', 'organic', 'gardening', 
        'horticultural', 'therapy', 'horticultural', 'science', 
        'growth', 'sunlight', 'temperature', 'humidity', 
        'spacing', 'soil', 'testing', 'crop', 
        'management', 'resources', 'container', 'gardening', 
        'seasonal', 'plant', 'health', 'grafting', 
        'disease', 'resistance', 'climate', 'adaptation', 
        'urban', 'farming', 'community', 'engagement', 
        'education', 'workshops', 'volunteering', 'extension', 
        'research', 'development', 'trends', 'techniques', 
        'experimentation', 'varieties', 'planting', 'methods'
    ]],
    
    
'hydrology' => [
    'title_id' => 109,
    'words' => [
        'water', 'hydrology', 'river', 'lake', 'ocean', 
        'stream', 'flood', 'precipitation', 'aquifer', 
        'watershed', 'drainage', 'basin', 'runoff', 
        'groundwater', 'surface', 'flow', 'cycle', 
        'quality', 'management', 'resources', 'distribution', 
        'hydrological', 'studies', 'analysis', 'monitoring', 
        'sustainability', 'environmental', 'impact', 'irrigation', 
        'drought', 'climate', 'change', 'salinity', 
        'evaporation', 'transpiration', 'interception', 'stormwater', 
        'wetlands', 'ecosystem', 'services', 'conservation', 
        'contamination', 'pollution', 'remediation', 'hydraulics', 
        'modeling', 'simulation', 'groundwater', 'recharge', 
        'extraction', 'borehole', 'water-table', 'infiltration', 
        'field', 'measurements', 'techniques', 'instruments', 
        'data', 'collection', 'statistics', 'assessment', 
        'environmental', 'regulations', 'policies', 'community', 
        'engagement', 'education', 'outreach', 'management'
    ]],
    
    
'jewelry' => [
    'title_id' => 110,
    'words' => [
        'ring', 'necklace', 'jewelry', 'bracelet', 'gemstone', 
        'gold', 'craft', 'diamond', 'artisan', 'silver', 
        'pearl', 'pendant', 'earrings', 'design', 
        'fashion', 'accessories', 'handmade', 'custom', 
        'settings', 'stones', 'cut', 'polish', 
        'metal', 'platinum', 'rhodium', 'settings', 
        'craftsmanship', 'collection', 'style', 'fashion', 
        'vintage', 'modern', 'artisan', 'techniques', 
        'manufacturing', 'process', 'finishing', 'jewelry-making', 
        'tools', 'equipment', 'beading', 'clasp', 
        'chain', 'inlay', 'engraving', 'oxidation', 
        'repair', 'cleaning', 'valuation', 'display', 
        'packaging', 'showcase', 'trends', 'exhibitions', 
        'gemology', 'color', 'clarity', 'carat', 
        'brilliance', 'craftsman', 'workshop', 'sourcing', 
        'wholesale', 'retail', 'trademark', 'designs', 
        'show', 'market', 'jewelry', 'trends'
    ]],
    
    
'journalism' => [
    'title_id' => 111,
    'words' => [
        'news', 'reporter', 'media', 'investigation', 'journalist', 
        'press', 'interview', 'story', 'article', 'coverage', 
        'editorial', 'opinion', 'fact-checking', 'sources', 
        'breaking', 'headline', 'feature', 'column', 
        'broadcast', 'print', 'digital', 'journal', 
        'publication', 'assignment', 'scoop', 'ethics', 
        'standards', 'investigative', 'broadcasting', 'writing', 
        'editing', 'photography', 'visuals', 'graphic', 
        'layout', 'research', 'audience', 'engagement', 
        'analysis', 'reporting', 'multimedia', 'podcast', 
        'documentary', 'storytelling', 'newsroom', 'content', 
        'communication', 'dissemination', 'report', 'summarization', 
        'coverage', 'issues', 'journalistic', 'principles', 
        'objectivity', 'balance', 'accountability', 'transparency', 
        'investigative', 'skills', 'critical', 'thinking', 
        'narrative', 'investigation', 'fieldwork', 'data', 
        'journalism', 'inquiry', 'citizen', 'journalism', 
        'online', 'journalism', 'publications', 'broadcast', 
        'network', 'report', 'analysis', 'editor', 
        'editorial', 'content', 'strategy', 'distribution'
    ]],
    
    
'linguistics' => [
    'title_id' => 112,
    'words' => [
        'language', 'linguistics', 'phonetics', 'syntax', 
        'grammar', 'dialect', 'communication', 'speech', 
        'study', 'semantics', 'morphology', 'pragmatics', 
        'sociolinguistics', 'psycholinguistics', 'linguistic', 
        'theory', 'phonology', 'discourse', 'analysis', 
        'lexicon', 'structure', 'variation', 'style', 
        'register', 'context', 'gesture', 'nonverbal', 
        'communication', 'acquisition', 'cognitive', 'development', 
        'historical', 'comparative', 'linguistics', 'neuro', 
        'linguistics', 'language', 'families', 'evolution', 
        'language', 'contact', 'bilingualism', 'multilingualism', 
        'translation', 'interpretation', 'language', 'teaching', 
        'language', 'policy', 'language', 'revitalization', 
        'typology', 'universal', 'grammar', 'language', 
        'attitudes', 'language', 'resources', 'field', 
        'methods', 'documentation', 'fieldwork', 'ethnography', 
        'usage', 'language', 'pedagogy', 'writing', 
        'literacy', 'communication', 'skills', 'linguistic', 
        'identity', 'communities', 'speech', 'act', 
        'interaction', 'coherence', 'fluency', 'creativity'
    ]],
    
    
'luxury_travel' => [
    'title_id' => 113,
    'words' => [
        'luxury', 'travel', 'hotel', 'exclusive', 'resort', 
        'private', 'destination', 'vip', 'experience', 
        'concierge', 'amenities', 'first-class', 'fine dining', 
        'itinerary', 'gourmet', 'spa', 'wellness', 
        'exotic', 'private jet', 'yacht', 'charter', 
        'expedition', 'retreat', 'personalized', 'service', 
        'bespoke', 'safari', 'cultural', 'immersion', 
        'adventure', 'cruise', 'helicopter', 'tour', 
        'sightseeing', 'cabin', 'suite', 'oceanfront', 
        'villas', 'staff', 'butler', 'lounge', 
        'champagne', 'sunset', 'landscape', 'elegance', 
        'sophistication', 'itinerary', 'private guide', 
        'tailored', 'vacation', 'getaway', 'scenic', 
        'tourism', 'luxurious', 'travel', 'experience', 
        'traveler', 'opulence', 'indulgence', 'tranquility', 
        'ambiance', 'exclusive', 'retreat', 'sustainable', 
        'luxury', 'travel', 'packages', 'offers'
    ]],
    
    
'marine_engineering' => [
    'title_id' => 114,
    'words' => [
        'ship', 'marine', 'engineering', 'ocean', 'vessel', 
        'offshore', 'naval', 'design', 'construction', 
        'navigation', 'dynamics', 'propulsion', 'structures', 
        'hydrodynamics', 'stability', 'design', 'analysis', 
        'materials', 'maintenance', 'operations', 'environment', 
        'safety', 'regulations', 'management', 'systems', 
        'automation', 'equipment', 'dry dock', 'survey', 
        'marine technology', 'craft', 'mechanical', 'systems', 
        'electrical', 'integrated', 'control', 'satellite', 
        'communication', 'maritime', 'industry', 'research', 
        'development', 'sustainability', 'marine', 'resources', 
        'platforms', 'floating', 'structures', 'subsea', 
        'installations', 'operations', 'design', 'analysis', 
        'tide', 'current', 'geotechnical', 'engineering', 
        'construction', 'specifications', 'surveys', 'performance', 
        'crew', 'logistics', 'emergency', 'response', 
        'interventions', 'cost', 'analysis', 'energy', 
        'efficiency', 'transportation', 'safety', 'standards'
    ]],
    
    
'microeconomics' => [
    'title_id' => 115,
    'words' => [
        'supply', 'demand', 'market', 'economics', 'price', 
        'competition', 'business', 'consumer', 'cost', 
        'elasticity', 'utility', 'marginal', 'product', 
        'profits', 'losses', 'goods', 'services', 
        'factors', 'production', 'input', 'output', 
        'monopoly', 'oligopoly', 'market structure', 'equilibrium', 
        'shortage', 'surplus', 'incentives', 'preferences', 
        'substitutes', 'complements', 'income', 'effects', 
        'welfare', 'analysis', 'budget', 'constraint', 
        'consumer', 'behavior', 'indifference', 'curves', 
        'game', 'theory', 'strategies', 'collusion', 
        'externalities', 'public goods', 'market failure', 
        'government', 'intervention', 'regulation', 'price', 
        'discrimination', 'trade-offs', 'opportunity', 'cost', 
        'production', 'possibilities', 'frontier', 'invisible', 
        'hand', 'efficiency', 'diminishing', 'returns', 
        'labor', 'market', 'capital', 'investment'
    ]],
    
    
'mining' => [
    'title_id' => 116,
    'words' => [
        'minerals', 'mining', 'extraction', 'gold', 'resources', 
        'coal', 'quarry', 'drilling', 'earth', 'safety', 
        'operations', 'exploration', 'geology', 'metals', 
        'ore', 'processing', 'site', 'equipment', 
        'environmental', 'impact', 'regulations', 'technology', 
        'methods', 'sustainable', 'practices', 'site', 
        'preparation', 'transportation', 'mineral', 'rights', 
        'licenses', 'supply', 'chain', 'economics', 
        'feasibility', 'studies', 'waste', 'management', 
        'tailings', 'rehabilitation', 'land', 'reclamation', 
        'underground', 'surface', 'artisanal', 'small-scale', 
        'industrial', 'geophysics', 'sampling', 'tests', 
        'drilling', 'rigs', 'blasting', 'rock', 
        'material', 'deposits', 'reserves', 'mining', 
        'companies', 'concessions', 'investments', 'profits', 
        'labor', 'force', 'working', 'conditions', 
        'community', 'engagement', 'consultation', 'health', 
        'safety', 'impact', 'assessments', 'innovation'
    ]],
    
    
'mobile_technology' => [
    'title_id' => 117,
    'words' => [
        'smartphone', 'app', 'mobile', 'technology', 'device', 
        'software', '5G', 'wireless', 'network', 'connectivity', 
        'Bluetooth', 'tablet', 'application', 'user', 
        'interface', 'screen', 'resolution', 'data', 
        'transfer', 'internet', 'cloud', 'services', 
        'IoT', 'integration', 'GPS', 'location', 
        'battery', 'performance', 'hardware', 'accessibility', 
        'security', 'privacy', 'updates', 'compatibility', 
        'mobile', 'payments', 'e-commerce', 'mobile', 
        'browsing', 'streaming', 'media', 'gaming', 
        'AR', 'VR', 'innovation', 'development', 
        'platforms', 'design', 'functionality', 'support', 
        'features', 'market', 'trends', 'analysis', 
        'consumer', 'behavior', 'feedback', 'reviews', 
        'mobile-first', 'responsive', 'web', 'mobile', 
        'usage', 'analytics', 'digital', 'marketing', 
        'advertising', 'reach', 'engagement', 'strategy'
    ]],
    
    
'mountaineering' => [
    'title_id' => 118,
    'words' => [
        'mountain', 'climbing', 'altitude', 'summit', 'hiking', 
        'gear', 'expedition', 'outdoor', 'ascent', 'trail', 
        'adventure', 'base camp', 'trekking', 'fitness', 
        'endurance', 'navigation', 'routes', 'weather', 
        'conditions', 'safety', 'techniques', 'camps', 
        'backpack', 'shelter', 'sleeping bag', 'harness', 
        'carabiner', 'rope', 'ice axe', 'crampons', 
        'mountaineer', 'topography', 'landscape', 'nature', 
        'terrain', 'view', 'landmark', 'expedition', 
        'training', 'preparation', 'experience', 'summit', 
        'photo', 'journal', 'wildlife', 'environment', 
        'first aid', 'rescue', 'skills', 'community', 
        'climbing', 'clubs', 'events', 'techniques', 
        'rock', 'ice', 'alpine', 'conditions', 
        'gear', 'maintenance', 'tents', 'cooking', 
        'supplies', 'nutrition', 'hydration', 'psychology'
    ]],
    
    
'neuroscience' => [
    'title_id' => 119,
    'words' => [
        'brain', 'neurons', 'research', 'neuroscience', 
        'cognition', 'behavior', 'memory', 'neural', 
        'synapse', 'plasticity', 'neurotransmitters', 
        'electrical', 'activity', 'signals', 'central', 
        'nervous', 'system', 'cerebral', 'cortex', 
        'functions', 'processes', 'behavioral', 'science', 
        'perception', 'emotion', 'development', 'disorders', 
        'neurodevelopmental', 'neurobiology', 'psychology', 
        'cognitive', 'function', 'decision-making', 'attention', 
        'learning', 'pathways', 'anatomy', 'physiology', 
        'fMRI', 'imaging', 'techniques', 'experiments', 
        'analysis', 'plasticity', 'circuitry', 'homeostasis', 
        'medication', 'therapies', 'treatment', 'neurodegenerative', 
        'research', 'studies', 'disorders', 'Parkinson', 
        'Alzheimer', 'epilepsy', 'schizophrenia', 'neural', 
        'network', 'feedback', 'loop', 'social', 
        'interaction', 'neuroethics', 'behavioral', 'neuroscience', 
        'biopsychology', 'neurology', 'studies', 'research'
    ]],
    
'nutrition' => [
    'title_id' => 120,
    'words' => [
        'diet', 'food', 'nutrition', 'health', 'vitamins', 
        'minerals', 'protein', 'calories', 'balance', 
        'macronutrients', 'micronutrients', 'fiber', 'carbohydrates', 
        'fats', 'hydration', 'meal', 'planning', 
        'supplements', 'antioxidants', 'metabolism', 'energy', 
        'intake', 'guidelines', 'eating', 'habits', 
        'wellness', 'lifestyle', 'nutritionists', 'cooking', 
        'recipes', 'portion', 'control', 'snacking', 
        'whole foods', 'processed', 'foods', 'dietary', 
        'restrictions', 'allergies', 'preferences', 'nutrient-dense', 
        'glycemic', 'index', 'satiation', 'hunger', 
        'appetite', 'satiety', 'nutrition', 'education', 
        'food', 'safety', 'organic', 'sustainability', 
        'ethical', 'farming', 'labeling', 'food', 
        'composition', 'food', 'quality', 'nutritional', 
        'deficiency', 'eating', 'disorders', 'psychology', 
        'evidence-based', 'recommendations', 'research', 'practices'
    ]],
    
    
'oceanography' => [
    'title_id' => 121,
    'words' => [
        'ocean', 'marine', 'ecosystem', 'research', 'waves', 
        'tides', 'current', 'seafloor', 'exploration', 
        'marine biology', 'salinity', 'temperature', 'currents', 
        'biodiversity', 'habitat', 'species', 'plankton', 
        'coral', 'reefs', 'fisheries', 'pollution', 
        'acidification', 'climate', 'change', 'hydrology', 
        'geology', 'sediment', 'oceanic', 'basin', 
        'mapping', 'surveys', 'instruments', 'monitoring', 
        'submarine', 'geophysics', 'marine', 'chemistry', 
        'biochemistry', 'ecology', 'data', 'collection', 
        'analysis', 'fieldwork', 'environment', 'marine', 
        'exploration', 'submersibles', 'remote', 'sensing', 
        'satellite', 'imagery', 'biological', 'chemical', 
        'physical', 'ocean', 'circulation', 'thermohaline', 
        'upwelling', 'downwelling', 'coastal', 'processes', 
        'renewable', 'energy', 'sea-level', 'rise', 
        'habitat', 'restoration', 'conservation', 'research'
    ]],
    
    
'optics' => [
    'title_id' => 122,
    'words' => [
        'light', 'lens', 'optics', 'mirror', 'photons', 
        'vision', 'telescope', 'microscope', 'refraction', 
        'reflection', 'diffraction', 'spectroscopy', 'wave', 
        'particle', 'color', 'wavelength', 'frequency', 
        'polarization', 'focal', 'length', 'aperture', 
        'image', 'formation', 'optical', 'instruments', 
        'filters', 'camera', 'imaging', 'system', 
        'dispersion', 'chromatic', 'aberration', 'resolution', 
        'visual', 'perception', 'nearsightedness', 'farsightedness', 
        'astigmatism', 'corrective', 'lenses', 'prescription', 
        'lightwave', 'communication', 'fiber', 'optics', 
        'lasers', 'coherence', 'interference', 'holography', 
        'retroreflection', 'infrared', 'ultraviolet', 'radiation', 
        'visibility', 'projector', 'spectral', 'analysis', 
        'optical', 'fiber', 'technology', 'quantum', 
        'mechanics', 'lensmaker', 'formula', 'optomechanics'
    ]],
    
    
'parapsychology' => [
    'title_id' => 123,
    'words' => [
        'telepathy', 'clairvoyance', 'paranormal', 'ghosts', 
        'psychic', 'ESP', 'medium', 'phenomenon', 
        'spiritual', 'intuition', 'extrasensory', 'perception', 
        'psychokinesis', 'psychometry', 'haunting', 'aura', 
        'energy', 'healing', 'alternative', 'dimensions', 
        'life', 'afterlife', 'reincarnation', 'out-of-body', 
        'experiences', 'sightings', 'spirits', 'communication', 
        'entities', 'telekinesis', 'anomalies', 'research', 
        'field', 'study', 'metaphysical', 'unexplained', 
        'mystical', 'parapsychological', 'hypnosis', 'dreams', 
        'lucid', 'dreaming', 'scrying', 'divination', 
        'remote', 'viewing', 'channeling', 'mysticism', 
        'phenomena', 'supernatural', 'investigation', 
        'validation', 'energy', 'transfer', 'sensitivity', 
        'psychological', 'experiments', 'data', 'gathering', 
        'theories', 'testimonials', 'anecdotes', 'beliefs', 
        'skepticism', 'ethics', 'practices', 'communities'
    ]],
    
    
'pharmaceuticals' => [
    'title_id' => 124,
    'words' => [
        'medicine', 'drug', 'pharmaceuticals', 'treatment', 
        'dosage', 'vaccine', 'research', 'clinic', 
        'side effects', 'prescription', 'therapeutics', 
        'formulation', 'compounding', 'pharmacology', 
        'bioavailability', 'clinical', 'trials', 'administration', 
        'interactions', 'indications', 'contraindications', 
        'efficacy', 'safety', 'studies', 'regulatory', 
        'compliance', 'approval', 'market', 'discovery', 
        'development', 'clinical', 'data', 'monitoring', 
        'biotechnology', 'pharmacokinetics', 'pharmacodynamics', 
        'synthesis', 'formulations', 'active', 'ingredients', 
        'manufacturing', 'quality', 'assurance', 'packaging', 
        'distribution', 'healthcare', 'professionals', 
        'insurers', 'cost', 'benefit', 'analysis', 
        'patient', 'outcomes', 'adverse', 'reactions', 
        'education', 'prescribing', 'guidelines', 'disease', 
        'management', 'preventive', 'care', 'biologics', 
        'innovations', 'drug', 'delivery', 'systems'
    ]],
    
    
'photovoltaics' => [
    'title_id' => 125,
    'words' => [
        'solar', 'photovoltaic', 'energy', 'panel', 
        'electricity', 'sustainability', 'renewable', 
        'power', 'technology', 'cells', 'conversion', 
        'efficiency', 'installations', 'grid', 
        'connection', 'inverter', 'current', 'direct', 
        'output', 'system', 'architecture', 'solar', 
        'thermal', 'applications', 'environment', 'impact', 
        'electricity', 'production', 'land', 'usage', 
        'farming', 'integration', 'photons', 'light', 
        'absorption', 'wavelength', 'materials', 'semiconductors', 
        'maintenance', 'monitoring', 'performance', 'data', 
        'analysis', 'projects', 'development', 'research', 
        'battery', 'storage', 'grid', 'load', 
        'economics', 'investments', 'subsidies', 'incentives', 
        'installation', 'regulations', 'policies', 'climate', 
        'change', 'community', 'engagement', 'outreach', 
        'education', 'awareness', 'advancements', 'innovations'
    ]],
    
    
'renewable_energy' => [
    'title_id' => 126,
    'words' => [
        'solar', 'wind', 'renewable', 'energy', 
        'green', 'power', 'sustainability', 'hydroelectric', 
        'biomass', 'geothermal', 'hydropower', 'clean', 
        'alternative', 'resources', 'efficiency', 'environmental', 
        'impact', 'fossil', 'fuels', 'emissions', 
        'carbon', 'footprint', 'sourcing', 'technology', 
        'innovation', 'development', 'market', 'infrastructure', 
        'installations', 'regulations', 'policies', 'subsidies', 
        'economic', 'feasibility', 'studies', 'projects', 
        'investments', 'energy', 'storage', 'batteries', 
        'grid', 'integration', 'microgrid', 'demand', 
        'management', 'reliability', 'climate', 'change', 
        'community', 'engagement', 'awareness', 'advocacy', 
        'education', 'training', 'jobs', 'programs', 
        'monitoring', 'data', 'analysis', 'performance', 
        'technologies', 'innovative', 'applications', 'energy', 
        'transition', 'strategy', 'collaboration', 'networking'
    ]],
    
    
'rock_climbing' => [
    'title_id' => 127,
    'words' => [
        'climbing', 'rock', 'gear', 'rope', 'bouldering', 
        'summit', 'outdoor', 'adventure', 'altitude', 
        'crux', 'route', 'grade', 'holds', 
        'technique', 'training', 'fitness', 'belay', 
        'harness', 'carabiner', 'quickdraw', 'chalk', 
        'climber', 'safety', 'protocols', 'vertical', 
        'scaling', 'ascent', 'descent', 'camps', 
        'expedition', 'outdoor', 'skills', 'environment', 
        'community', 'gym', 'competition', 'toprope', 
        'lead', 'climb', 'footwork', 'balance', 
        'strength', 'flexibility', 'endurance', 'exploration', 
        'rescue', 'equipment', 'maintenance', 'outfit', 
        'partner', 'spotting', 'gear', 'protection', 
        'guides', 'certification', 'routes', 'mapping', 
        'ecosystem', 'wilderness', 'nature', 'experience', 
        'photography', 'landscape', 'rock', 'formation'
    ]],
    
    
'sailing' => [
    'title_id' => 128,
    'words' => [
        'boat', 'sailing', 'wind', 'ocean', 'marine', 
        'nautical', 'sea', 'yacht', 'vessel', 'hull', 
        'mast', 'sail', 'rigging', 'navigation', 
        'tacking', 'jibing', 'keel', 'anchor', 
        'buoy', 'chart', 'course', 'compass', 
        'harbor', 'dock', 'stern', 'bow', 
        'crew', 'skipper', 'race', 'regatta', 
        'trimming', 'power', 'boat', 'safety', 
        'equipment', 'weather', 'conditions', 'marine', 
        'seamanship', 'skills', 'experience', 'education', 
        'training', 'license', 'regulations', 'maintenance', 
        'rescue', 'operations', 'motor', 'sailing', 
        'community', 'clubs', 'enthusiasts', 'enthusiasm', 
        'adventure', 'exploration', 'tides', 'currents', 
        'fishing', 'offshore', 'expedition', 'cruising', 
        'environment', 'conservation', 'sustainability', 'travel'
    ]],
    
    
'social_media' => [
    'title_id' => 129,
    'words' => [
        'social', 'media', 'network', 'posts', 'followers', 
        'engagement', 'content', 'sharing', 'platform', 
        'likes', 'comments', 'hashtags', 'stories', 
        'feed', 'timeline', 'influencers', 'analytics', 
        'strategy', 'branding', 'advertising', 'campaign', 
        'community', 'interaction', 'reach', 'visibility', 
        'posts', 'updates', 'messages', 'notifications', 
        'trends', 'viral', 'content', 'creation', 
        'curation', 'management', 'user-generated', 'platforms', 
        'audience', 'demographics', 'engagement', 'metrics', 
        'interaction', 'visibility', 'sharing', 'tools', 
        'algorithms', 'privacy', 'security', 'features', 
        'applications', 'platform', 'communication', 'devices', 
        'mobile', 'desktop', 'interaction', 'feedback', 
        'monitoring', 'reporting', 'growth', 'optimization', 
        'inbox', 'visibility', 'reactions', 'conversations', 
        'social', 'networking', 'community', 'development'
    ]],
    
    
'software_development' => [
    'title_id' => 130,
    'words' => [
        'programming', 'software', 'development', 'coding', 
        'app', 'algorithm', 'technology', 'system', 
        'engineering', 'debugging', 'testing', 'deployment', 
        'architecture', 'framework', 'database', 'API', 
        'version control', 'Git', 'repository', 'sprint', 
        'agile', 'scrum', 'methodologies', 'requirements', 
        'design', 'interfaces', 'UX', 'UI', 
        'user', 'experience', 'documentation', 'maintenance', 
        'iteration', 'collaboration', 'team', 'code', 
        'review', 'integration', 'continuous', 'delivery', 
        'deployment', 'environments', 'cloud', 'services', 
        'platforms', 'DevOps', 'security', 'performance', 
        'optimization', 'scalability', 'refactoring', 'microservices', 
        'containerization', 'Docker', 'Kubernetes', 'localization', 
        'internationalization', 'software', 'solutions', 'innovations', 
        'enterprise', 'applications', 'desktop', 'mobile'
    ]],
    
    
'sustainability' => [
    'title_id' => 131,
    'words' => [
        'green', 'sustainability', 'energy', 'recycling', 
        'conservation', 'environment', 'renewable', 
        'resources', 'future', 'ecological', 'balance', 
        'climate', 'change', 'biodiversity', 'ecosystem', 
        'sustainable', 'practices', 'development', 'management', 
        'impact', 'waste', 'reduction', 'pollution', 
        'carbon', 'footprint', 'energy-efficient', 'sustainable', 
        'materials', 'ethical', 'farming', 'sourcing', 
        'transportation', 'water', 'conservation', 'community', 
        'engagement', 'innovation', 'technology', 'education', 
        'advocacy', 'policy', 'regulations', 'standards', 
        'awareness', 'renewable', 'energy', 'economy', 
        'social', 'responsibility', 'justice', 'corporate', 
        'strategies', 'infrastructure', 'resilience', 'local', 
        'global', 'partnerships', 'agriculture', 'urban', 
        'planning', 'sustainable', 'lifestyles', 'habits'
    ]],
    
    
'theology' => [
    'title_id' => 132,
    'words' => [
        'religion', 'god', 'theology', 'faith', 'belief', 
        'scripture', 'worship', 'prayer', 'spiritual', 
        'doctrine', 'ceremony', 'ritual', 'sacred', 
        'texts', 'community', 'moral', 'ethics', 
        'salvation', 'grace', 'sacraments', 'meditation', 
        'soul', 'afterlife', 'creation', 'divine', 
        'revelation', 'philosophy', 'mysticism', 'tradition', 
        'scriptural', 'interpretation', 'religious', 'history', 
        'dogma', 'hermeneutics', 'apologetics', 'soteriology', 
        'eschatology', 'liturgical', 'writings', 'covenant', 
        'sacred', 'texts', 'prophecy', 'theistic', 
        'agnosticism', 'atheism', 'spirituality', 'congregation', 
        'clergy', 'laity', 'denomination', 'gospel', 
        'testament', 'faithful', 'community', 'relationship', 
        'divinity', 'worship', 'encounter', 'grace', 
        'presence', 'witness', 'belief', 'ceremony'
    ]],
    
    
'urban_design' => [
    'title_id' => 133,
    'words' => [
        'city', 'urban', 'infrastructure', 'development', 
        'design', 'planning', 'architecture', 'building', 
        'community', 'public spaces', 'land use', 'zoning', 
        'transportation', 'mobility', 'sustainability', 'amenities', 
        'green spaces', 'walkability', 'density', 'redevelopment', 
        'civic', 'engagement', 'participation', 'revitalization', 
        'landscape', 'urbanism', 'framework', 'regulations', 
        'environment', 'accessibility', 'resilience', 'socioeconomics', 
        'design principles', 'housing', 'affordability', 'socio-cultural', 
        'context', 'smart city', 'connectivity', 'socio-spatial', 
        'design guidelines', 'landscaping', 'public transit', 'inclusivity', 
        'safety', 'aesthetics', 'identity', 'character', 
        'mixed-use', 'development', 'placemaking', 'cultural', 
        'heritage', 'urban planning', 'stakeholders', 'outcomes', 
        'evaluation', 'involvement', 'transport', 'facilities', 
        'systems', 'technology', 'urban renewal', 'environmental', 
        'impact', 'assessment', 'governance', 'initiatives'
    ]],
    
    
'wildlife_conservation' => [
    'title_id' => 134,
    'words' => [
        'wildlife', 'conservation', 'biodiversity', 'habitat', 
        'species', 'nature', 'ecosystem', 'environment', 
        'endangered', 'preservation', 'restoration', 'protection', 
        'sustainable', 'management', 'threatened', 'ecosystems', 
        'flora', 'fauna', 'migration', 'breeding', 
        'populations', 'monitoring', 'research', 'education', 
        'advocacy', 'legislation', 'protected areas', 'sanctuaries', 
        'wildlife corridors', 'farming', 'community', 'engagement', 
        'research', 'conservationists', 'habitat', 'degradation', 
        'climate', 'change', 'human-wildlife', 'conflict', 
        'poaching', 'rehabilitation', 'species', 'reintroduction', 
        'restoration', 'wildlife', 'refuges', 'environmental', 
        'impact', 'assessment', 'ecological', 'education', 
        'outreach', 'sustainability', 'biodiversity', 'ecosystem', 
        'stewardship', 'species', 'survival', 'initiatives', 
        'networks', 'collaboration', 'partnerships', 'monitoring', 
        'scientific', 'research', 'community-based', 'initiatives'
    ]],
    
    
'biophysics' => [
    'title_id' => 135,
    'words' => [
        'physics', 'biology', 'molecular', 'research', 
        'biophysics', 'energy', 'cell', 'biomechanics', 
        'protein', 'structures', 'interaction', 'dynamics', 
        'forces', 'systems', 'analyses', 'techniques', 
        'modeling', 'simulation', 'kinetics', 'spectroscopy', 
        'thermodynamics', 'nanotechnology', 'macromolecules', 
        'enzymes', 'ligands', 'membranes', 'signaling', 
        'transport', 'metabolism', 'neuroscience', 'cellular', 
        'mechanics', 'genetics', 'bioinformatics', 'biochemical', 
        'pathways', 'reaction', 'forces', 'cellular', 
        'mechanisms', 'stability', 'thermodynamic', 'properties', 
        'interfaces', 'polymers', 'microscopy', 'bioengineering', 
        'theories', 'experiments', 'methods', 'biophysical', 
        'data', 'collection', 'analysis', 'quantum', 
        'biomolecules', 'interactions', 'cell', 'behavior', 
        'dynamics', 'energy', 'transfer', 'bioenergetics', 
        'applications', 'research', 'tools', 'integration'
    ]],
    
    
'ecology' => [
    'title_id' => 136,
    'words' => [
        'ecosystem', 'environment', 'species', 'biodiversity', 
        'habitat', 'conservation', 'ecology', 'climate', 
        'wildlife', 'population', 'interactions', 'food chain', 
        'energy flow', 'nutrient cycling', 'adaptation', 
        'biomes', 'flora', 'fauna', 'abiotic', 
        'biotic', 'community', 'dynamics', 'sustainability', 
        'pollution', 'impact', 'restoration', 'management', 
        'resources', 'invasive', 'species', 'native', 
        'threatened', 'endangered', 'regeneration', 'fieldwork', 
        'research', 'monitoring', 'studies', 'ecosystem services', 
        'environmental', 'issues', 'protection', 'wildlife', 
        'conservation', 'habitats', 'restoration', 'ecosystems', 
        'climate', 'change', 'global', 'warming', 
        'forest', 'wetlands', 'marine', 'terrestrial', 
        'trophic levels', 'food webs', 'symbiosis', 'competition', 
        'predation', 'ecological', 'footprint', 'circular', 
        'economy', 'agriculture', 'urban', 'planning', 
        'community', 'engagement', 'education', 'awareness'
    ]],
    
    
'entomology' => [
    'title_id' => 137,
    'words' => [
        'insects', 'entomology', 'species', 'bugs', 
        'beetle', 'butterfly', 'mosquito', 'research', 
        'study', 'life cycle', 'habitat', 'behavior', 
        'taxonomy', 'classification', 'morphology', 'physiology', 
        'ecology', 'pest control', 'pollination', 'invertebrates', 
        'larvae', 'adults', 'metamorphosis', 'fieldwork', 
        'specimens', 'collections', 'surveys', 'identification', 
        'communities', 'diversity', 'interaction', 'environment', 
        'conservation', 'habitat', 'degradation', 'impact', 
        'agriculture', 'entomopathogens', 'predators', 'parasites', 
        'symbiosis', 'chemical', 'communication', 'pheromones', 
        'wings', 'antennae', 'exoskeleton', 'abdomen', 
        'thorax', 'forewings', 'hindwings', 'entomological', 
        'research', 'biological', 'studies', 'scientific', 
        'literature', 'applications', 'genetics', 'evolution'
    ]],
    
    
'cartography' => [
    'title_id' => 138,
    'words' => [
        'maps', 'cartography', 'geography', 'coordinates', 
        'survey', 'topography', 'satellite', 'GPS', 
        'navigation', 'projection', 'scale', 'contour', 
        'legend', 'symbols', 'data', 'visualization', 
        'spatial', 'analysis', 'demographics', 'mapping', 
        'terrain', 'features', 'boundaries', 'aerial', 
        'photography', 'geospatial', 'information', 'system', 
        'geographic', 'tools', 'software', 'GIS', 
        'interactive', 'maps', 'cartographic', 'techniques', 
        'planning', 'regional', 'development', 'environmental', 
        'resource', 'management', 'urban', 'design', 
        'routes', 'distances', 'site', 'selection', 
        'land use', 'publications', 'histories', 'cultural', 
        'aspects', 'transportation', 'networks', 'coordinates', 
        'fieldwork', 'research', 'topographical', 'representation', 
        'landscapes', 'surveys', 'data', 'mapping', 
        'accuracy', 'clarity', 'interpretation', 'legends'
    ]],
    
    
'herpetology' => [
    'title_id' => 139,
    'words' => [
        'reptiles', 'amphibians', 'herpetology', 'snakes', 
        'frogs', 'turtles', 'species', 'study', 
        'ecosystem', 'habitat', 'behavior', 'physiology', 
        'morphology', 'conservation', 'biodiversity', 
        'life cycle', 'taxonomy', 'identification', 
        'fieldwork', 'research', 'ecology', 'genetics', 
        'adaptation', 'reproduction', 'environment', 
        'population', 'distribution', 'predation', 
        'feeding', 'breeding', 'territory', 'habitat', 
        'loss', 'endangered', 'species', 'field', 
        'surveys', 'monitoring', 'invasive', 'species', 
        'native', 'environmental', 'impact', 'captivity', 
        'rehabilitation', 'education', 'advocacy', 
        'scientific', 'community', 'outreach', 'conservation', 
        'wildlife', 'management', 'climate', 'change', 
        'interaction', 'habitat', 'preservation', 'research', 
        'observations', 'techniques', 'data', 'analysis'
    ]],
    
    
'mycology' => [
    'title_id' => 140,
    'words' => [
        'fungi', 'mushrooms', 'mycology', 'spores', 
        'biome', 'species', 'growth', 'environment', 
        'ecology', 'fungal', 'decomposition', 'nutrition', 
        'symbiosis', 'pathogens', 'antibiotics', 'yeast', 
        'fermentation', 'filamentous', 'hyphae', 'mycelium', 
        'cultivation', 'identification', 'taxonomy', 'research', 
        'biodiversity', 'conservation', 'habitats', 'wild', 
        'cultivated', 'edible', 'medicinal', 'toxic', 
        'spore', 'dispersal', 'life cycle', 'fungicides', 
        'nutrient cycling', 'environmental', 'impact', 'studies', 
        'community', 'fieldwork', 'experiments', 'data', 
        'analysis', 'applications', 'agriculture', 'biotechnology', 
        'genetics', 'mycorrhizae', 'microbial', 'communities', 
        'ecosystem', 'services', 'research', 'methods', 
        'cultures', 'laboratories', 'observations', 'sampling', 
        'field', 'collections', 'ecological', 'relationships'
    ]],
    
    
'paleobotany' => [
    'title_id' => 141,
    'words' => [
        'fossil', 'plants', 'paleobotany', 'prehistoric', 
        'species', 'carbon dating', 'evolution', 'ecosystem', 
        'botany', 'paleontology', 'sediment', 'strata', 
        'reconstruction', 'morphology', 'diversity', 
        'phylogeny', 'vegetation', 'habitats', 'fossilization', 
        'assemblages', 'biogeography', 'climate', 'change', 
        'samples', 'analysis', 'research', 'methodologies', 
        'microscopy', 'documentation', 'collections', 'fieldwork', 
        'specimens', 'taxonomy', 'ecological', 'interactions', 
        'growth', 'periods', 'investigations', 'drilling', 
        'layers', 'study', 'microfossils', 'pollen', 
        'paleoenvironments', 'analysis', 'sedimentary', 'records', 
        'landscapes', 'extinction', 'adaptation', 'paleoclimate', 
        'evidence', 'carboniferous', 'jurassic', 'creaceous', 
        'development', 'flora', 'ancient', 'ecosystems', 
        'fossilized', 'remains', 'geological', 'mapping'
    ]],
    
    
'crystallography' => [
    'title_id' => 142,
    'words' => [
        'crystals', 'structure', 'crystallography', 'x-ray', 
        'molecules', 'atoms', 'solid', 'science', 
        'symmetry', 'lattice', 'cell', 'diffraction', 
        'patterns', 'analysis', 'techniques', 'solutions', 
        'electron', 'microscopy', 'structure', 'determination', 
        'data', 'refinement', 'chemical', 'bonding', 
        'geometry', 'crystal', 'growth', 'phases', 
        'solubility', 'transitions', 'thermal', 'properties', 
        'applications', 'materials', 'engineering', 'biology', 
        'pharmaceuticals', 'solid-state', 'research', 
        'metallurgy', 'phase', 'transformation', 'theory', 
        'thermodynamics', 'dynamics', 'resonance', 'spectroscopy', 
        'fields', 'computational', 'modeling', 'programs', 
        'software', 'visualization', 'programs', 'experiments', 
        'scattering', 'Bragg', 'reflections', 'reciprocal', 
        'space', 'symmetry', 'analysis', 'observations', 
        'structural', 'characterization', 'techniques', 'mathematics'
    ]],
    
    
'neonatology' => [
    'title_id' => 143,
    'words' => [
        'newborn', 'neonatology', 'infant', 'premature', 
        'hospital', 'NICU', 'medical', 'pediatric', 
        'care', 'monitoring', 'development', 'breathing', 
        'feeding', 'growth', 'treatment', 'survival', 
        'complications', 'neonatal', 'therapies', 
        'assessment', 'conditions', 'support', 'intervention', 
        'birth', 'weight', 'critical', 'health', 
        'assessment', 'screening', 'immunization', 'education', 
        'families', 'outcomes', 'equipment', 'technology', 
        'research', 'protocols', 'training', 'follow-up', 
        'caregivers', 'collaboration', 'physicians', 
        'interdisciplinary', 'approach', 'safety', 'guidelines', 
        'outcomes', 'developmental', 'milestones', 'long-term', 
        'cardiac', 'respiratory', 'gastrointestinal', 
        'infection', 'management', 'surgical', 'complications', 
        'evaluation', 'protocols', 'nursing', 'care'
    ]],
    
    
'geriatrics' => [
    'title_id' => 144,
    'words' => [
        'elderly', 'geriatrics', 'aging', 'care', 
        'health', 'retirement', 'medicine', 'nursing', 
        'treatment', 'chronic', 'conditions', 'rehabilitation', 
        'assessment', 'mobility', 'dementia', 'Alzheimer', 
        'support', 'services', 'interventions', 'psychosocial', 
        'nutrition', 'prevention', 'screening', 'diagnosis', 
        'quality', 'life', 'family', 'in-home', 
        'assistance', 'community', 'resources', 'gerontology', 
        'medications', 'pain', 'management', 'functional', 
        'decline', 'social', 'isolation', 'cognitive', 
        'disorders', 'therapy', 'palliative', 'end-of-life', 
        'planning', 'holistic', 'approach', 'patient', 
        'advocacy', 'geriatrician', 'policies', 'research', 
        'education', 'training', 'interdisciplinary', 'teams', 
        'age-related', 'stigma', 'challenges', 'adaptations'
    ]],
    
    
'endocrinology' => [
    'title_id' => 145,
    'words' => [
        'hormones', 'glands', 'endocrinology', 'metabolism', 
        'diabetes', 'thyroid', 'research', 'medical', 
        'treatment', 'insulin', 'glucose', 'secretion', 
        'feedback', 'system', 'homeostasis', 'growth', 
        'development', 'disorders', 'hormonal', 'regulation', 
        'adrenal', 'pituitary', 'hypothalamus', 'ovaries', 
        'testes', 'receptors', 'interactions', 'pathways', 
        'clinical', 'studies', 'diagnosis', 'symptoms', 
        'management', 'therapies', 'risk', 'factors', 
        'prevention', 'lifestyle', 'nutrition', 'exercise', 
        'medications', 'complications', 'screening', 'monitoring', 
        'biofeedback', 'research', 'trials', 'education', 
        'advocacy', 'awareness', 'healthcare', 'professionals', 
        'guidelines', 'protocols', 'patient', 'care'
    ]],
    
    
'occupational_therapy' => [
    'title_id' => 146,
    'words' => [
        'therapy', 'occupational', 'rehabilitation', 'well-being', 
        'treatment', 'skills', 'care', 'health', 
        'patient', 'function', 'activities', 'goals', 
        'support', 'independence', 'assessment', 'intervention', 
        'techniques', 'adaptation', 'cognition', 'motor', 
        'development', 'social', 'emotional', 'education', 
        'collaboration', 'rehabilitative', 'approach', 'practice', 
        'professionals', 'clients', 'community', 'resources', 
        'conditions', 'disabilities', 'strategies', 'engagement', 
        'evaluation', 'participation', 'facilitation', 'training', 
        'guidelines', 'caregiver', 'families', 'advocacy', 
        'research', 'evidence-based', 'methods', 'personalized', 
        'outcomes', 'management', 'interdisciplinary', 'teams', 
        'setting', 'environments', 'home', 'workplace'
    ]],
    
    
'toxicology' => [
    'title_id' => 147,
    'words' => [
        'toxins', 'poison', 'toxicology', 'exposure', 
        'chemical', 'effects', 'biological', 'research', 
        'study', 'contaminants', 'pathways', 'metabolism', 
        'risk', 'assessment', 'safety', 'protocols', 
        'evaluation', 'substances', 'analysis', 'data', 
        'environmental', 'impact', 'health', 'clinical', 
        'symptoms', 'diagnosis', 'treatment', 'remediation', 
        'regulations', 'hazardous', 'waste', 'toxicity', 
        'inhalation', 'dermal', 'ingestion', 'routes', 
        'bioavailability', 'screening', 'therapeutics', 
        'antidotes', 'research', 'toxicants', 'carcinogens', 
        'mutagens', 'environment', 'exposures', 'biomarkers', 
        'acute', 'chronic', 'sensitivity', 'populations', 
        'chemical', 'safety', 'training', 'emergency', 
        'management', 'risk', 'communications', 'public'
    ]],
    
    
'rheumatology' => [
    'title_id' => 148,
    'words' => [
        'arthritis', 'joints', 'rheumatology', 'inflammation', 
        'autoimmune', 'pain', 'treatment', 'medical', 
        'health', 'disorders', 'connective tissue', 'symptoms', 
        'diagnosis', 'management', 'therapies', 'flare-ups', 
        'remission', 'chronic', 'acute', 'medications', 
        'biologics', 'nonsteroidal', 'anti-inflammatory', 
        'steroids', 'immunosuppressants', 'exercise', 'rehabilitation', 
        'patient', 'care', 'evaluation', 'functional', 
        'status', 'assessment', 'imaging', 'labs', 
        'clinical', 'research', 'education', 'advocacy', 
        'lifestyle', 'modifications', 'diet', 'nutrition', 
        'support', 'groups', 'community', 'outcomes', 
        'comorbidities', 'genetics', 'environmental', 'factors', 
        'pathophysiology', 'prevention', 'risk', 'stratification'
    ]],
    
    
'dermatology' => [
    'title_id' => 149,
    'words' => [
        'skin', 'dermatology', 'treatment', 'rash', 
        'eczema', 'pimples', 'care', 'medical', 
        'health', 'conditions', 'acne', 'psoriasis', 
        'dermatitis', 'lesions', 'biopsy', 'examination', 
        'diagnosis', 'therapies', 'topical', 'medications', 
        'moisturizers', 'sunscreen', 'allergies', 'infections', 
        'fungal', 'viral', 'bacterial', 'cosmetic', 
        'procedures', 'dermabrasion', 'laser', 'chemical', 
        'peels', 'phototherapy', 'rejuvenation', 'scar', 
        'treatment', 'hyperpigmentation', 'melasma', 'rosacea', 
        'consultation', 'prevention', 'education', 'awareness', 
        'patient', 'history', 'management', 'outcomes', 
        'research', 'clinical', 'studies', 'guidelines', 
        'patch testing', 'skin', 'cancer', 'moles', 
        'screening', 'dermatopathology', 'referral', 'specialists'
    ]],
    
    
'seafaring' => [
    'title_id' => 150,
    'words' => [
        'sea', 'navigation', 'seafaring', 'ocean', 
        'boat', 'vessel', 'nautical', 'sailing', 
        'exploration', 'charting', 'compass', 'crew', 
        'ship', 'anchors', 'currents', 'tides', 
        'fishing', 'trade', 'maritime', 'expedition', 
        'sail', 'hull', 'deck', 'weather', 
        'seasickness', 'furling', 'rigging', 'buoy', 
        'harbor', 'port', 'expanses', 'furling', 
        'lighthouses', 'calm', 'storm', 'navigation', 
        'techniques', 'oceanography', 'lifeboat', 'rescue', 
        'emergency', 'procedures', 'chart', 'fishing', 
        'maritime', 'laws', 'cargo', 'freight', 
        'harbor', 'piloting', 'safety', 'buoyancy', 
        'research', 'submersibles', 'oceanic', 'adventures'
    ]],
    
    
'aviation_history' => [
    'title_id' => 151,
    'words' => [
        'aviation', 'history', 'planes', 'flight', 
        'aircraft', 'pioneers', 'Wright brothers', 'jet', 
        'innovation', 'aerospace', 'technology', 'design', 
        'development', 'milestones', 'aviators', 'cockpit', 
        'navigation', 'propulsion', 'landing', 'takeoff', 
        'flying', 'regulations', 'airlines', 'commercial', 
        'military', 'training', 'schools', 'accidents', 
        'safety', 'airships', 'gliders', 'helicopters', 
        'jets', 'stunts', 'airshows', 'transportation', 
        'engineering', 'challenges', 'air traffic', 
        'control', 'research', 'experiments', 'biplanes', 
        'monoplanes', 'space', 'exploration', 'parachutes', 
        'aviation', 'medicine', 'environment', 'sustainability', 
        'models', 'airframes', 'systems', 'manufacturing', 
        'innovators', 'trends', 'future', 'aviation'
    ]],
    
    
'astrophotography' => [
    'title_id' => 152,
    'words' => [
        'astronomy', 'photography', 'astrophotography', 'stars', 
        'planets', 'telescope', 'camera', 'exposure', 
        'sky', 'nebulae', 'galaxies', 'constellations', 
        'night', 'light pollution', 'focal length', 'aperture', 
        'tracking', 'settings', 'filters', 'starlight', 
        'frame', 'composition', 'landscape', 'Milky Way', 
        'wide-field', 'image processing', 'RAW', 'software', 
        'post-processing', 'calibration', 'alignment', 'field', 
        'of view', 'optics', 'focus', 'depth', 
        'polarizer', 'chromatic', 'aberration', 'dome', 
        'observatory', 'lens', 'sensor', 'resolution', 
        'astrometry', 'time-lapse', 'long exposure', 'fieldwork', 
        'experiments', 'techniques', 'skywatching', 'photonic', 
        'events', 'eclipses', 'meteor showers', 'comets', 
        'auroras', 'quasars', 'research', 'community', 
        'amateurs', 'documentation', 'imaging', 'equipment'
    ]],
    
    
'agronomy' => [
    'title_id' => 153,
    'words' => [
        'agriculture', 'soil', 'agronomy', 'crops', 
        'irrigation', 'harvest', 'farming', 'fertilizer', 
        'cultivation', 'crop rotation', 'planting', 'tillage', 
        'agroecology', 'sustainable', 'practices', 'pesticides', 
        'weeds', 'insects', 'diseases', 'genetics', 
        'yield', 'monitoring', 'management', 'precision', 
        'agriculture', 'research', 'environment', 'climate', 
        'impact', 'water', 'conservation', 'ecosystem', 
        'sustainability', 'food security', 'extension', 'services', 
        'technology', 'equipment', 'mechanization', 'biotechnology', 
        'agroforestry', 'land use', 'production', 'systems', 
        'soil health', 'compaction', 'testing', 'nutrient management', 
        'organic', 'fertility', 'field trials', 'data', 
        'analysis', 'community', 'support', 'market', 
        'trends', 'economics', 'policy', 'education'
    ]],
    
    
'microfinance' => [
    'title_id' => 154,
    'words' => [
        'microfinance', 'loans', 'investment', 'entrepreneur', 
        'community', 'business', 'funding', 'support', 
        'development', 'financial', 'inclusion', 'capital', 
        'interest', 'repayment', 'poverty', 'alleviation', 
        'empowerment', 'savings', 'institutions', 'grants', 
        'programs', 'risk', 'management', 'clients', 
        'sustainability', 'social', 'impact', 'groups', 
        'startups', 'access', 'credit', 'economic', 
        'growth', 'collateral', 'financing', 'services', 
        'training', 'education', 'resources', 'network', 
        'entrepreneurship', 'performance', 'businesses', 
        'outreach', 'loans', 'products', 'financial', 
        'literacy', 'tools', 'approaches', 'policies', 
        'assistance', 'collaboration', 'initiatives', 'strategies', 
        'results', 'metrics', 'evaluation', 'social', 
        'return', 'investment', 'impact', 'monitoring'
    ]],
    
    
'artificial_intelligence' => [
    'title_id' => 155,
    'words' => [
        'AI', 'machine learning', 'algorithm', 'artificial intelligence', 
        'data', 'automation', 'neural networks', 'robotics', 
        'technology', 'deep learning', 'natural language processing', 
        'computer vision', 'intelligence', 'analytics', 
        'big data', 'pattern recognition', 'cognitive', 
        'systems', 'intelligent agents', 'predictive', 
        'modeling', 'simulation', 'training', 'datasets', 
        'supervised learning', 'unsupervised learning', 
        'reinforcement learning', 'AI ethics', 'deployment', 
        'applications', 'chatbots', 'recommendation systems', 
        'autonomous', 'vehicles', 'security', 'computer', 
        'science', 'research', 'interface', 'development', 
        'prototyping', 'feedback', 'validation', 'performance', 
        'scalability', 'optimization', 'integration', 'collaboration', 
        'user experience', 'human-computer interaction', 
        'applications', 'virtual assistants', 'data mining', 
        'transformation', 'operations', 'insights', 'solutions'
    ]],
    
    
'blockchain_technology' => [
    'title_id' => 156,
    'words' => [
        'blockchain', 'cryptography', 'distributed ledger', 'smart contracts', 
        'crypto', 'decentralized', 'technology', 'Bitcoin', 
        'token', 'Ethereum', 'ledger', 'transactions', 
        'mining', 'proof of work', 'proof of stake', 'nodes', 
        'network', 'hash', 'security', 'wallet', 
        'decentralization', 'consensus', 'algorithms', 
        'peer-to-peer', 'application', 'digital currency', 
        'assets', 'initial coin offering', 'ICO', 'regulations', 
        'transparency', 'immutability', 'scalability', 
        'interoperability', 'supply chain', 'management', 
        'smart property', 'cryptoeconomics', 'disruption', 
        'innovation', 'financial', 'services', 'protocols', 
        'infrastructure', 'identity', 'verification', 'data', 
        'access', 'management', 'marketplace', 'security', 
        'tokenization', 'utility tokens', 'stablecoins', 'dApps', 
        'decentralized finance', 'DeFi', 'ecosystem', 'research'
    ]],
    
    
'data_science' => [
    'title_id' => 157,
    'words' => [
        'data', 'science', 'machine learning', 'analysis', 
        'statistics', 'big data', 'algorithm', 'AI', 
        'analytics', 'visualization', 'data mining', 
        'predictive modeling', 'neural networks', 'datasets', 
        'features', 'insights', 'data wrangling', 
        'cleaning', 'transformation', 'regression', 
        'classification', 'clustering', 'data engineering', 
        'data governance', 'exploratory data analysis', 
        'hypothesis testing', 'sampling', 'data sources', 
        'business intelligence', 'data storytelling', 
        'communication', 'dashboards', 'tools', 
        'software', 'programming', 'Python', 'R', 
        'SQL', 'Hadoop', 'Spark', 'ETL', 
        'data lakes', 'cloud computing', 'data privacy', 
        'ethics', 'data security', 'collaboration', 
        'teamwork', 'research', 'development', 
        'decision-making', 'automation', 'outcomes', 
        'models', 'performance', 'KPI', 'metrics'
    ]],
    
    
'user_experience' => [
    'title_id' => 158,
    'words' => [
        'UX', 'user experience', 'design', 'interface', 
        'interaction', 'research', 'testing', 'feedback', 
        'digital', 'usability', 'accessibility', 'prototyping', 
        'wireframes', 'navigation', 'aesthetics', 'personas', 
        'journey', 'mapping', 'scenarios', 'requirements', 
        'layouts', 'visual design', 'information architecture', 
        'user-centered', 'development', 'iterative', 
        'analyses', 'surveys', 'data', 'insights', 
        'evaluation', 'optimization', 'engagement', 
        'satisfaction', 'branding', 'empathy', 'storytelling', 
        'tasks', 'efficiency', 'product', 'service', 
        'experience', 'interaction design', 'mobile', 
        'responsive', 'design thinking', 'collaboration', 
        'teamwork', 'customer journey', 'context', 
        'touchpoints', 'behavior', 'patterns', 
        'trends', 'analytics', 'persona development', 
        'research methods', 'field studies', 'contextual inquiry'
    ]],
    
    
'visual_effects' => [
    'title_id' => 159,
    'words' => [
        'VFX', 'film', 'visual effects', 'animation', 
        '3D', 'compositing', 'CGI', 'graphics', 
        'special effects', 'post-production', 'rendering', 
        'simulation', 'motion capture', 'keyframe', 
        'editing', 'sequence', 'pipeline', 'design', 
        'storyboarding', 'scripting', 'texture', 
        'lighting', 'matte painting', 'integration', 
        'production', 'software', 'techniques', 
        'tools', 'artistry', 'visualization', 'directing', 
        'filmmaking', 'screenplay', 'scenes', 'shots', 
        'digital', 'effects', 'character', 'design', 
        'environment', 'modeling', 'animation', 
        'performance', 'visual storytelling', 'creative', 
        'concept art', 'drafting', 'collaboration', 
        'projects', 'budgeting', 'scheduling', 'presentation', 
        'innovation', 'trends', 'experimentation', 
        'audience', 'engagement', 'production design'
    ]],
    
    
'sound_engineering' => [
    'title_id' => 160,
    'words' => [
        'audio', 'sound', 'engineering', 'acoustics', 
        'music', 'mixing', 'recording', 'studio', 
        'technology', 'production', 'signal', 'processing', 
        'equipment', 'microphone', 'speakers', 'monitoring', 
        'equalization', 'compression', 'reverb', 'effects', 
        'editing', 'mastering', 'tracks', 'dynamics', 
        'frequency', 'waveform', 'stereo', 'surround', 
        'soundscape', 'post-production', 'design', 
        'soundtrack', 'performance', 'live', 'soundcheck', 
        'setup', 'engineering', 'transmission', 'broadcasting', 
        'media', 'filmmaking', 'sound design', 'synthesis', 
        'sampling', 'plugins', 'digital', 'analog', 
        'field recording', 'instruments', 'arrangement', 
        'genre', 'composition', 'soundproofing', 'room acoustics', 
        'creative', 'collaboration', 'projects', 'audio-visual'
    ]],
    
    
'urban_agriculture' => [
    'title_id' => 161,
    'words' => [
        'urban', 'agriculture', 'city', 'farming', 
        'sustainability', 'rooftop garden', 'community garden', 
        'food', 'green', 'local', 'farming', 'production', 
        'horticulture', 'gardening', 'permaculture', 
        'land use', 'environment', 'ecosystem', 'biodiversity', 
        'soil health', 'urban spaces', 'vegetable', 
        'fruits', 'livestock', 'education', 'community', 
        'health', 'nutrition', 'environmental', 'impact', 
        'food security', 'resources', 'agroecology', 
        'green spaces', 'eco-friendly', 'organic', 
        'composting', 'waste reduction', 'pollinators', 
        'local economy', 'entrepreneurship', 'greenhouse', 
        'agricultural techniques', 'urban farming', 
        'hydroponics', 'aquaponics', 'vertical farming', 
        'crop rotation', 'seeds', 'sustainability', 
        'food justice', 'community engagement', 'workshops', 
        'local markets', 'food production', 'food systems', 
        'environmental justice', 'awareness', 'outreach', 
        'biodynamic', 'cultivation', 'ecosystem services', 
        'rainwater harvesting', 'pollution', 'education', 
        'climate change', 'resilience', 'food deserts', 
        'social equity', 'green infrastructure', 
        'food sovereignty', 'farmers markets', 'garden design', 
        'volunteer', 'community health', 'agricultural practices', 
        'land stewardship', 'plant diversity', 'soil conservation', 
        'farm-to-table', 'cultural heritage', 'sustainable practices', 
        'workforce development', 'resource management', 
        'urban planners', 'green economy', 'community-supported', 
        'agriculture', 'challenges', 'urban policy', 
        'environmental awareness', 'public health', 'local food', 
        'urban ecosystems', 'food waste', 'sustainable development', 
        'gardening techniques', 'planting', 'crop management', 
        'landscaping', 'community building', 'economic empowerment', 
        'resource sharing', 'food access', 'urban gardening', 
        'climate adaptation', 'sustainable sourcing', 'educational programs', 
        'food literacy', 'research', 'urban design', 
        'circular economy', 'agricultural education', 'market gardening', 
        'urban resilience', 'networking', 'community initiatives'
    ]],
    
    
'genomic_medicine' => [
    'title_id' => 162,
    'words' => [
        'genetics', 'genomic', 'medicine', 'DNA', 
        'personalized', 'research', 'mutation', 'treatment', 
        'disease', 'genome', 'sequencing', 'biomarkers', 
        'pharmacogenomics', 'therapy', 'clinical', 'data', 
        'analysis', 'precision', 'health', 'inheritance', 
        'genetic testing', 'variations', 'screening', 
        'bioinformatics', 'ethics', 'protocols', 'evidence', 
        'diagnosis', 'treatment plans', 'targeted', 'therapy', 
        'outcomes', 'risk assessment', 'family history', 
        'genetic counseling', 'molecular', 'pathology', 
        'research studies', 'clinical trials', 'healthcare', 
        'genetic disorders', 'population genetics', 
        'exome sequencing', 'CRISPR', 'gene therapy', 
        'SNPs', 'single nucleotide polymorphisms', 
        'transcription', 'replication', 'expression', 
        'genetic mutations', 'inherited', 'anomalies', 
        'biological', 'variability', 'pharmacogenetics', 
        'environmental factors', 'longitudinal studies', 
        'systematic reviews', 'data sharing', 'clinical practice', 
        'medical history', 'multidisciplinary', 'approaches', 
        'interventions', 'technology', 'advancements', 
        'genome-wide association studies', 'GWAS', 
        'integrative', 'medicine', 'health systems', 
        'data management', 'patient care', 'clinical genetics', 
        'diagnostic testing', 'therapeutic strategies', 
        'translational research', 'biotechnology', 
        'somatic mutations', 'research initiatives', 
        'impact', 'policy', 'advocacy', 'support', 
        'community engagement', 'awareness', 'personalized medicine', 
        'clinical genomics', 'health outcomes', 'implementation', 
        'tools', 'resources', 'guidelines', 'education', 
        'genetic risk', 'metabolic', 'disorders', 
        'comorbidities', 'phenotypes', 'hereditary', 
        'epigenetics', 'research findings', 'collaborations', 
        'clinical implications', 'integration', 'innovation', 
        'disease prevention', 'healthcare practices'
    ]],
    
    
'augmented_reality' => [
    'title_id' => 163,
    'words' => [
        'AR', 'augmented reality', 'technology', 'virtual', 
        'interaction', '3D', 'interface', 'digital', 
        'overlay', 'immersive', 'experience', 'simulation', 
        'application', 'development', 'real-time', 'tracking', 
        'devices', 'smartphones', 'tablets', 'glasses', 
        'headsets', 'projections', 'user interface', 'design', 
        'content', 'environment', 'visualization', 'data', 
        'analytics', 'gaming', 'education', 'training', 
        'marketing', 'retail', 'entertainment', 'navigation', 
        'social', 'collaboration', 'realism', 'recognition', 
        'sensors', 'location-based', 'software', 'programming', 
        'development tools', 'frameworks', 'engagement', 
        'feedback', 'interaction design', 'storytelling', 
        'multimedia', 'creative', 'art', 'communication', 
        'business', 'operations', 'research', 'implementation', 
        'trends', 'future', 'challenges', 'solutions', 
        'community', 'awareness', 'outreach', 'devices', 
        'educational tools', 'healthcare', 'applications', 
        'real estate', 'architecture', 'automotive', 
        'design', 'prototype', 'marketing strategies', 
        'user experience', 'accessibility', 'usability', 
        'standards', 'protocols', 'integration', 'hardware', 
        'cloud computing', 'data sharing', 'compatibility', 
        'enhancements', 'dynamics', 'research', 'innovations', 
        'visual effects', 'personalization', 'training', 
        'development', 'smart cities', 'future technologies', 
        'applications', 'disruption', 'interactivity', 
        'industry', 'opportunities', 'virtual worlds', 
        'gamification', 'environmental', 'social impact', 
        'collaborative', 'tools', 'displays', 'interactions'
    ]],
    
    
'space_mining' => [
    'title_id' => 164,
    'words' => [
        'space', 'mining', 'asteroids', 'resources', 
        'exploration', 'metals', 'technology', 'planet', 
        'innovation', 'extraterrestrial', 'ore', 'harvesting', 
        'celestial', 'bodies', 'rocket', 'launch', 
        'mission', 'astronauts', 'habitats', 'prospecting', 
        'satellites', 'equipment', 'drilling', 'extraction', 
        'in-situ', 'utilization', 'solar system', 'mineral', 
        'value', 'economics', 'sustainability', 'industrial', 
        'development', 'research', 'advancements', 'scenarios', 
        'challenges', 'opportunities', 'logistics', 'transportation', 
        'regulations', 'international', 'collaboration', 'policy', 
        'infrastructure', 'manufacturing', 'refining', 
        'applications', 'geology', 'mineralogy', 'habitable', 
        'moons', 'Mars', 'comets', 'ore processing', 
        'technology transfer', 'data', 'monitoring', 'automation', 
        'innovation', 'entrepreneurship', 'investment', 
        'return on investment', 'resource allocation', 
        'surveys', 'feasibility', 'bioreactors', 
        'energy', 'consumption', 'materials', 'engineering', 
        'sensors', 'robotics', 'transport', 'exploratory', 
        'strategies', 'partnerships', 'environmental', 
        'impact', 'mission architecture', 'public-private', 
        'initiatives', 'demonstrations', 'technologies', 
        'risk', 'management', 'development', 'monitoring', 
        'support', 'systems', 'profitability', 'economic', 
        'models', 'safety', 'protocols', 'scalability'
    ]],
    
    
'bioethics' => [
    'title_id' => 165,
    'words' => [
        'ethics', 'biology', 'medicine', 'research', 
        'bioethics', 'morality', 'clinical', 'decisions', 
        'treatment', 'policy', 'responsibility', 'rights', 
        'justice', 'patient autonomy', 'consent', 'dilemma', 
        'ethical', 'standards', 'guidelines', 'clinical trials', 
        'human rights', 'scientific', 'integrity', 'equity', 
        'experimentation', 'healthcare', 'environment', 
        'reproductive', 'genetics', 'animal', 'welfare', 
        'confidentiality', 'data privacy', 'transparency', 
        'advocacy', 'disability', 'advancements', 'technology', 
        'sustainability', 'vulnerable', 'populations', 
        'cultural', 'values', 'interdisciplinary', 
        'stakeholders', 'community', 'engagement', 
        'social', 'impact', 'regulations', 'legislation', 
        'clinical ethics', 'moral philosophy', 
        'neuroscience', 'public health', 'biotechnology', 
        'risk', 'benefit', 'assessment', 'global', 
        'health', 'systems', 'palliative', 'care', 
        'euthanasia', 'end-of-life', 'decision-making', 
        'moral distress', 'professionalism', 'principles', 
        'beneficence', 'non-maleficence', 'justice', 
        'fidelity', 'ethics committees', 'guidance', 
        'case studies', 'educational programs', 'consultation', 
        'frameworks', 'evaluation', 'policy-making', 
        'conflict', 'resolution', 'socioeconomic', 
        'disparities', 'research ethics', 'scientific misconduct', 
        'bioethical', 'theories', 'framework', 'moral obligations', 
        'communication', 'healthcare professionals', 
        'accountability', 'ethical dilemmas', 'best practices', 
        'patient care', 'research integrity', 'academic', 
        'freedom', 'principled', 'ethical considerations'
    ]],
    
    
'forensic_psychology' => [
    'title_id' => 166,
    'words' => [
        'crime', 'psychology', 'forensic', 'law', 
        'behavior', 'investigation', 'trial', 'criminal', 
        'evaluation', 'witness', 'testimony', 'court', 
        'expert', 'opinion', 'assessment', 'mental health', 
        'competence', 'insanity', 'profiling', 'victim', 
        'offender', 'analysis', 'evidence', 'research', 
        'psychopathology', 'rehabilitation', 'intervention', 
        'treatment', 'justice', 'ethics', 'legal', 
        'consultation', 'practitioner', 'testimony', 
        'fieldwork', 'interviewing', 'surveys', 'case studies', 
        'decision-making', 'cognitive', 'bias', 'personality', 
        'disorders', 'criminal justice', 'factors', 'risk assessment', 
        'family', 'dynamics', 'juvenile', 'delinquency', 
        'substance abuse', 'psychological', 'analysis', 
        'theories', 'neuroscience', 'therapeutic', 'practices', 
        'sociopathy', 'research methods', 'training', 
        'law enforcement', 'victimology', 'sociological', 
        'impact', 'community', 'resources', 'treatment modalities', 
        'psychosocial', 'education', 'advocacy', 'policy', 
        'collaboration', 'cross-disciplinary', 'insights', 
        'experience', 'counseling', 'supervision', 
        'diversity', 'conflict resolution', 'psychological evaluations', 
        'trauma', 'emotional', 'intelligence', 'attachment', 
        'risk factors', 'criminal behavior', 'disability', 
        'functional assessment', 'evidence-based', 'practices', 
        'interventions', 'report writing', 'effective communication', 
        'workshops', 'support groups', 'impact assessment', 
        'social support', 'dissemination', 'findings', 
        'personal development', 'mental health issues', 
        'skills training', 'rehabilitative strategies', 
        'legal standards', 'courtroom dynamics', 'policy implications'
    ]],
    
    
'machine_learning' => [
    'title_id' => 167,
    'words' => [
        'AI', 'machine learning', 'algorithm', 'data', 
        'model', 'automation', 'statistics', 'technology', 
        'neural networks', 'training', 'testing', 'supervised', 
        'unsupervised', 'reinforcement', 'regression', 
        'classification', 'clustering', 'features', 'input', 
        'output', 'prediction', 'analysis', 'data mining', 
        'big data', 'visualization', 'metrics', 'performance', 
        'evaluation', 'validation', 'overfitting', 
        'underfitting', 'loss function', 'gradient descent', 
        'optimization', 'cross-validation', 'data preprocessing', 
        'feature selection', 'ensemble methods', 'decision trees', 
        'support vector machines', 'random forests', 'k-nearest neighbors', 
        'natural language processing', 'computer vision', 
        'artificial intelligence', 'deep learning', 
        'convolutional neural networks', 'recurrent neural networks', 
        'data sets', 'training data', 'testing data', 
        'hyperparameters', 'tuning', 'deployment', 
        'cloud computing', 'inference', 'analytics', 
        'applications', 'pattern recognition', 'business intelligence', 
        'automation', 'robots', 'systems', 'predictive modeling', 
        'semantic analysis', 'model training', 
        'exploratory data analysis', 'scaling', 'algorithms', 
        'research', 'development', 'tools', 'software', 
        'frameworks', 'libraries', 'TensorFlow', 'PyTorch', 
        'Keras', 'SciKit-Learn', 'real-time', 'streaming', 
        'interactive', 'data-driven', 'intelligence', 'applications', 
        'sensor data', 'data lakes', 'data warehousing', 
        'collaborative filtering', 'recommendation systems', 
        'personalization', 'feedback loops', 
        'ethical considerations', 'bias', 'transparency', 
        'explainability', 'compliance', 'security', 'privacy', 
        'regulatory', 'frameworks', 'research initiatives', 
        'trends', 'future applications', 'industry', 'standards'
    ]],
    
    
'quantitative_finance' => [
    'title_id' => 168,
    'words' => [
        'finance', 'quantitative', 'modeling', 'risk', 
        'algorithm', 'trading', 'investment', 'market', 
        'analysis', 'data', 'return', 'portfolio', 
        'stock', 'bond', 'asset', 'valuation', 
        'arbitrage', 'liquidity', 'volatility', 'hedging', 
        'equity', 'derivative', 'option', 'futures', 
        'strategy', 'performance', 'research', 'statistic', 
        'regression', 'forecasting', 'simulation', 
        'financial', 'instrument', 'exposure', 'event', 
        'distribution', 'benchmark', 'capital', 
        'currency', 'macro', 'micro', 'trend', 
        'signal', 'economics', 'risk-adjusted', 
        'behavior', 'quant', 'sensitivity', 'performance', 
        'correlation', 'dividend', 'yield', 'fee', 
        'margins', 'cost', 'tax', 'model', 
        'transaction', 'impact', 'speculation', 
        'position', 'extraction', 'chart', 
        'index', 'analysis', 'ratio', 
        'value', 'growth', 'screener', 'strategy', 
        'marketplace', 'volatility', 'seasonality', 
        'events', 'outcome', 'pattern', 'persistence', 
        'anomaly', 'historical', 'data', 'interpretation', 
        'returns', 'simulation', 'alpha', 'beta', 
        'gamma', 'delta', 'information', 
        'optimization', 'cost', 'leverage', 
        'drawdown', 'trends', 'strategy', 
        'regime', 'dynamic', 'static', 'arbitrage', 
        'expenditure', 'risk', 'behavior', 'portfolio', 
        'entitlement', 'financial', 'intervention', 
        'planning', 'valuation', 'interest', 
        'economic', 'factors', 'calculation', 
        'estimation', 'inference', 'distribution', 
        'coefficients', 'output', 'inputs', 
        'utilization', 'indicators', 'netting', 
        'effect', 'environment', 'global', 'domestic', 
        'valuation', 'returns', 'benchmark', 
        'diversification', 'liability', 'trader', 
        'probability', 'estimates', 'discrepancy', 
        'underlying', 'context', 'signals', 
        'momentum', 'price', 'context', 
        'framework', 'perspective', 'investors', 
        'commitment', 'resources', 'monitoring', 
        'utilization', 'support', 'recovery', 
        'intervention', 'collateral', 'dynamics', 
        'insights', 'exploration', 'adaptation', 
        'variables', 'parameters', 'innovation'
    ]],
    
    
'risk_management' => [
    'title_id' => 169,
    'words' => [
        'risk', 'management', 'assessment', 'mitigation', 
        'strategy', 'analysis', 'business', 'finance', 
        'insurance', 'identification', 'control', 'impact', 
        'monitoring', 'evaluation', 'tolerance', 
        'framework', 'regulations', 'policies', 
        'compliance', 'measures', 'process', 
        'procedures', 'planning', 'documentation', 
        'systems', 'reporting', 'guidelines', 'training', 
        'communication', 'stakeholders', 'response', 
        'crisis', 'preparedness', 'management', 
        'threats', 'vulnerabilities', 'outcomes', 
        'decisions', 'assessment', 'practices', 
        'resources', 'programs', 'tools', 'objectives', 
        'project', 'environment', 'costs', 'analysis', 
        'decision-making', 'performance', 'recommendations', 
        'external', 'internal', 'safeguards', 'audit', 
        'evaluation', 'impact', 'situational', 'analysis', 
        'operational', 'financial', 'strategic', 
        'quantitative', 'qualitative', 'criteria', 
        'key', 'performance', 'indicators', 'assignments', 
        'baseline', 'monitoring', 'tasks', 'elements', 
        'assumptions', 'historical', 'data', 'trends', 
        'situation', 'scenarios', 'parameters', 
        'success', 'factors', 'benefits', 
        'insights', 'improvement', 'recommendations', 
        'outcomes', 'support', 'team', 'programs', 
        'research', 'collaboration', 'impact', 
        'inspections', 'contingencies', 'design', 
        'options', 'expertise', 'best', 
        'practices', 'solutions', 'standards', 
        'reviews', 'findings', 'evaluation', 
        'systematic', 'approach', 'monitoring', 
        'lessons', 'learned', 'training', 
        'knowledge', 'organizational', 'alignment', 
        'external', 'reviews', 'consequences', 
        'developments', 'dependencies', 
        'regulatory', 'requirements', 'trends'
    ]],
    
    
'supply_chain_management' => [
    'title_id' => 170,
    'words' => [
        'supply', 'chain', 'logistics', 'management', 
        'inventory', 'distribution', 'procurement', 
        'business', 'efficiency', 'production', 
        'transportation', 'demand', 'warehousing', 
        'planning', 'strategies', 'operations', 
        'sourcing', 'vendor', 'contract', 'delivery', 
        'shipping', 'tracking', 'suppliers', 'customers', 
        'collaboration', 'technology', 'automation', 
        'analysis', 'data', 'visibility', 'communication', 
        'forecasting', 'cost', 'optimization', 
        'performance', 'metrics', 'quality', 
        'risk', 'assessment', 'regulations', 'standards', 
        'sustainability', 'supply', 'network', 
        'process', 'integration', 'customer', 
        'relationships', 'strategic', 'insights', 
        'solutions', 'resources', 'channels', 
        'replenishment', 'lead time', 'logistics', 
        'control', 'pipeline', 'collaborative', 
        'relationship', 'factors', 'effectiveness', 
        'inventory', 'turnover', 'management', 
        'tracking', 'responsiveness', 'plans', 
        'flexibility', 'transport', 'fulfillment', 
        'system', 'inventory', 'demand', 
        'integration', 'strategies', 'approaches', 
        'profitability', 'stakeholders', 'collaboration', 
        'logistics', 'strategic', 'coordination', 
        'implementation', 'efficiency', 'timeliness', 
        'innovation', 'technology', 'collaboration', 
        'key', 'performance', 'indicators', 'methods', 
        'optimization', 'factors', 'systems', 
        'processes', 'critical', 'outcomes', 
        'market', 'challenges', 'opportunities', 
        'practices', 'improvements', 'decisions', 
        'activities', 'operations', 'feedback', 
        'transparency', 'analysis', 'evaluation', 
        'responsibility', 'skills', 'monitoring', 
        'collaboration', 'developments', 'relationships', 
        'success', 'results', 'knowledge'
    ]],
    
    
'global_trade' => [
    'title_id' => 171,
    'words' => [
        'trade', 'global', 'economy', 'export', 
        'import', 'tariffs', 'policy', 'international', 
        'commerce', 'market', 'business', 'supply', 
        'demand', 'negotiation', 'regulation', 'goods', 
        'services', 'bilateral', 'multilateral', 'agreement', 
        'marketplace', 'competitiveness', 'currency', 
        'exchange', 'free trade', 'barriers', 'investments', 
        'protectionism', 'economics', 'factors', 'infrastructure', 
        'transparency', 'network', 'distribution', 
        'partnerships', 'exports', 'imports', 'stakeholders', 
        'impact', 'benefits', 'risks', 'strategies', 
        'trends', 'analysis', 'framework', 'challenges', 
        'opportunities', 'competitors', 'data', 
        'analysis', 'value', 'projections', 'growth', 
        'sustainability', 'globalization', 'development', 
        'resources', 'collaboration', 'capital', 
        'internationalization', 'industry', 'market', 
        'factors', 'price', 'incentives', 'revenue', 
        'balancing', 'accounts', 'projections', 
        'trade-offs', 'frameworks', 'organizations', 
        'efficiency', 'trading', 'partnership', 
        'transportation', 'logistics', 'risk', 'assessment', 
        'regulations', 'monitoring', 'evaluation', 
        'performance', 'involvement', 'trading', 
        'relationships', 'supply', 'chain', 
        'governance', 'disputes', 'processes', 
        'subsidies', 'quotas', 'trade agreements', 
        'consultation', 'impact', 'improvement', 
        'strategic', 'interventions', 'educational', 
        'initiatives', 'engagement', 'awareness', 
        'knowledge', 'investments', 'discussions', 
        'analysis', 'information', 'dialogues', 
        'understanding', 'outcomes', 'interdependence'
    ]],
    
    
'cryptography' => [
    'title_id' => 172,
    'words' => [
        'encryption', 'cryptography', 'security', 'data', 
        'algorithm', 'code', 'cipher', 'technology', 
        'information', 'decryption', 'key', 'hash', 
        'integrity', 'authentication', 'protocol', 
        'digital', 'signature', 'communication', 
        'privacy', 'system', 'transmission', 
        'verification', 'analysis', 'attacks', 
        'threats', 'vulnerability', 'firewall', 
        'malware', 'network', 'symmetric', 
        'asymmetric', 'public', 'private', 
        'key exchange', 'blockchain', 'hashing', 
        'secure', 'communication', 'ciphertext', 
        'plaintext', 'cryptanalysis', 'obfuscation', 
        'safety', 'cryptographic', 'standards', 
        'secure channels', 'PKI', 'certificate', 
        'authentication', 'authorization', 'access', 
        'control', 'encryption algorithms', 
        'data integrity', 'key management', 
        'privacy policy', 'information security', 
        'risk', 'compliance', 'regulations', 
        'laws', 'digital rights', 'user', 
        'trust', 'framework', 'best practices', 
        'technical', 'deployment', 'tools', 
        'software', 'usage', 'cloud', 
        'computing', 'resources', 'operational', 
        'process', 'cybersecurity', 'intelligence', 
        'incident', 'response', 'procedures', 
        'research', 'applications', 'standards', 
        'implementation', 'protection', 
        'management', 'analysis', 'monitoring', 
        'protocols', 'encryption techniques', 
        'strategies', 'communication channels', 
        'data breaches', 'anonymity', 'trust', 
        'enforcement', 'audit', 'traceability', 
        'exploitation', 'threat mitigation', 
        'service', 'applications', 'decisions', 
        'systems', 'monitoring', 'auditing', 
        'evaluation', 'reporting', 'transactions'
    ]],
    
    
'wildlife_photography' => [
    'title_id' => 173,
    'words' => [
        'wildlife', 'photography', 'nature', 'camera', 
        'species', 'animals', 'conservation', 'habitat', 
        'outdoors', 'landscape', 'environment', 'ecosystem', 
        'flora', 'fauna', 'capture', 'shot', 
        'exposure', 'light', 'composition', 'focus', 
        'behavior', 'migration', 'documentary', 'biodiversity', 
        'field', 'exploration', 'equipment', 'lenses', 
        'techniques', 'wild', 'adventure', 'scenery', 
        'settings', 'perspective', 'photogenic', 'subjects', 
        'season', 'wildlife reserves', 'conservation efforts', 
        'habitat preservation', 'endangered', 'species', 
        'track', 'observations', 'feeding', 'mating', 
        'camouflage', 'patterns', 'details', 'outfits', 
        'safaris', 'research', 'behavior', 'documentation', 
        'project', 'experience', 'stories', 'inspiration', 
        'journey', 'wildlife biologist', 'protection', 
        'awareness', 'education', 'community', 'advocacy', 
        'conservation programs', 'environmental', 'initiatives', 
        'resources', 'preservation', 'nature reserves', 
        'sustainability', 'climate', 'change', 'habitats', 
        'migratory', 'birds', 'fishing', 'conservation', 
        'wildlife corridors', 'ethics', 'responsibility', 
        'education', 'interpretation', 'techniques', 
        'portrait', 'landscapes', 'study', 'fieldwork', 
        'journeys', 'nature trails', 'photographers', 
        'competition', 'showcase', 'exhibitions', 
        'images', 'stories', 'events', 'impact', 
        'outreach', 'connections', 'influences', 
        'perspectives', 'beauty', 'thrills', 'emotions', 
        'moments', 'artistry', 'connections', 'insights', 
        'engagement', 'passion', 'observations', 
        'wildlife conservation', 'preservation efforts', 
        'impact', 'travel', 'local', 'engagement'
    ]],
    
    
'marine_ecology' => [
    'title_id' => 174,
    'words' => [
        'marine', 'ecology', 'ocean', 'biodiversity', 
        'species', 'conservation', 'ecosystem', 'habitat', 
        'research', 'coral', 'reef', 'plankton', 
        'fish', 'invertebrates', 'marine mammals', 'algae', 
        'coastal', 'environment', 'water', 'pollution', 
        'habitats', 'interactions', 'food', 'chain', 
        'adaptation', 'community', 'dynamics', 'resources', 
        'oceanography', 'climate', 'change', 'threats', 
        'fisheries', 'management', 'restoration', 'impact', 
        'anthropogenic', 'factors', 'biological', 'physical', 
        'chemical', 'monitoring', 'assessment', 'fieldwork', 
        'experiments', 'data', 'analysis', 'sustainability', 
        'ecosystem services', 'ocean currents', 'marine zones', 
        'temperature', 'salinity', 'depth', 'sediments', 
        'nutrients', 'biomes', 'habitat loss', 'overfishing', 
        'coastal erosion', 'migration', 'breeding', 
        'behavior', 'indicators', 'ecosystem health', 
        'resilience', 'restoration', 'efforts', 'outreach', 
        'education', 'community', 'engagement', 
        'awareness', 'collaboration', 'research', 
        'technologies', 'marine protected areas', 
        'bioinformatics', 'conservation strategies', 
        'marine policy', 'regulations', 'stakeholders', 
        'practices', 'species diversity', 'genetics', 
        'marine resources', 'trends', 'future', 
        'developments', 'partnerships', 'local', 
        'communities', 'socioeconomic', 'considerations', 
        'economic', 'benefits', 'indigenous', 'knowledge', 
        'invasive', 'species', 'ecosystem balance', 
        'trophic levels', 'niche', 'competition', 
        'habitat types', 'artificial', 'reefs', 
        'global', 'impact', 'ecosystems', 'solutions'
    ]],
    
    
'behavioral_science' => [
    'title_id' => 175,
    'words' => [
        'behavior', 'science', 'psychology', 'research', 
        'cognition', 'decision', 'making', 'social', 
        'study', 'emotion', 'attitude', 'perception', 
        'interaction', 'environment', 'motivation', 
        'bias', 'habits', 'responses', 'analysis', 
        'theory', 'development', 'context', 'learning', 
        'influence', 'experiments', 'surveys', 'quantitative', 
        'qualitative', 'data', 'variables', 'patterns', 
        'cultural', 'factors', 'neuroscience', 'communication', 
        'relationships', 'insights', 'psychological', 
        'processes', 'observations', 'outcomes', 'applications', 
        'community', 'engagement', 'interventions', 
        'strategies', 'feedback', 'implications', 
        'critical', 'thinking', 'findings', 'issues', 
        'principles', 'theories', 'frameworks', 
        'behavioral economics', 'habituation', 'socialization', 
        'groups', 'norms', 'role', 'expectations', 
        'developmental', 'psychological', 'factors', 
        'attitudes', 'emotional', 'intelligence', 
        'psychometrics', 'tests', 'instruments', 
        'validity', 'reliability', 'interpersonal', 
        'contextual', 'modeling', 'hypothesis', 
        'experimentation', 'applications', 'techniques', 
        'training', 'behavioral therapy', 'stress', 
        'well-being', 'personality', 'traits', 
        'moral', 'development', 'cognitive', 
        'neuroplasticity', 'learning', 'mindfulness', 
        'self-regulation', 'self-control', 'conflict', 
        'resolution', 'group dynamics', 'peer influence', 
        'role models', 'empathy', 'compassion', 
        'self-awareness', 'resilience', 'identity', 
        'motives', 'perceptions', 'cognitive dissonance', 
        'social identity', 'well-being', 'mental health', 
        'emotional intelligence', 'social influence', 
        'cognitive biases', 'attachment', 'theory', 
        'principles', 'research', 'cultural influences', 
        'motivations', 'values', 'beliefs'
    ]],
    
    
'speech_pathology' => [
    'title_id' => 176,
    'words' => [
        'speech', 'pathology', 'therapy', 'communication', 
        'disorder', 'language', 'treatment', 'voice', 
        'research', 'articulation', 'fluency', 'assessment', 
        'diagnosis', 'intervention', 'development', 
        'skills', 'education', 'therapy', 'evidence', 
        'practices', 'techniques', 'strategies', 
        'evaluation', 'outcomes', 'sessions', 'goals', 
        'treatment plans', 'progress', 'socioemotional', 
        'cognitive', 'language development', 'phonetics', 
        'anatomy', 'physiology', 'vocal cords', 
        'pronunciation', 'auditory', 'processing', 
        'motor', 'control', 'receptive', 'expressive', 
        'language disorders', 'dyslexia', 'apraxia', 
        'dysarthria', 'stuttering', 'voice disorders', 
        'developmental', 'assessment tools', 'intervention strategies', 
        'play', 'activities', 'family involvement', 
        'speech therapy', 'voice therapy', 'group therapy', 
        'individual therapy', 'treatment methods', 
        'swallowing', 'feeding', 'consultation', 
        'communication strategies', 'functional', 
        'augmentative', 'alternative', 'technology', 
        'device', 'social skills', 'literacy', 
        'support', 'community', 'resources', 'advocacy', 
        'stimulation', 'collaboration', 'therapist', 
        'practice', 'continuing education', 
        'clinical practice', 'research findings', 
        'cultural', 'considerations', 'clinical', 
        'multidisciplinary', 'team', 'training', 
        'feedback', 'therapeutic', 'skills training', 
        'curriculum', 'strategies', 'literacy', 
        'interdisciplinary', 'education', 'prevention', 
        'awareness', 'development', 'dissemination', 
        'knowledge', 'evidence-based', 'practice', 
        'research', 'outcomes', 'involvement', 
        'client-centered', 'approaches', 'community outreach', 
        'advancements', 'technology', 'integration', 
        'ethics', 'policy', 'advancements', 
        'communication skills', 'individualized', 
        'development', 'plans', 'rehabilitation', 
        'skills', 'implementation'
    ]],
    
    
'environmental_economics' => [
    'title_id' => 177,
    'words' => [
        'environment', 'economics', 'sustainability', 'policy', 
        'resources', 'climate', 'change', 'market', 
        'trade', 'conservation', 'cost', 'benefit', 
        'analysis', 'externalities', 'impact', 'regulations', 
        'incentives', 'ecosystems', 'valuation', 'development', 
        'environmental', 'effects', 'biodiversity', 
        'pollution', 'management', 'renewable', 
        'energy', 'fossil', 'fuels', 'waste', 
        'resource allocation', 'pricing', 'demand', 
        'supply', 'framework', 'investments', 'social', 
        'equity', 'natural', 'capital', 'policy-making', 
        'adaptation', 'mitigation', 'transparency', 
        'evaluation', 'research', 'strategies', 
        'approaches', 'community', 'engagement', 
        'education', 'governance', 'climate policy', 
        'stakeholders', 'analysis', 'ecosystem services', 
        'market failures', 'subsidies', 'environmental justice', 
        'land use', 'agriculture', 'fisheries', 
        'industrial', 'development', 'environmental assessment', 
        'sustainable practices', 'green', 'economy', 
        'climate action', 'environmental impact', 
        'indicators', 'interventions', 'benefits', 
        'environmental policy', 'economic growth', 
        'local', 'communities', 'social justice', 
        'challenges', 'strategies', 'implementation', 
        'business', 'practices', 'investment', 
        'financial', 'instruments', 'frameworks', 
        'regulatory', 'context', 'issues', 
        'analysis', 'value', 'equilibrium', 
        'dynamics', 'resources', 'innovations', 
        'systems', 'feedback', 'mechanisms', 
        'efficiency', 'investments', 'competition', 
        'sustainable development', 'socioeconomic', 
        'relationships', 'sustainable growth', 
        'ecological', 'resources', 'disparities', 
        'technology', 'collaboration', 'awareness', 
        'impact assessments', 'monitoring', 
        'goals', 'factors', 'political', 'economic'
    ]],
    
    
'biomaterials' => [
    'title_id' => 178,
    'words' => [
        'materials', 'biomaterials', 'research', 'medicine', 
        'innovation', 'tissue', 'engineering', 'biotechnology', 
        'cell', 'applications', 'synthesis', 'properties', 
        'composite', 'degradation', 'compatibility', 'functional', 
        'design', 'process', 'scaffolding', 'development', 
        'biodegradable', 'nanomaterials', 'polymers', 
        'biomedical', 'implants', 'therapeutics', 
        'drug delivery', 'repair', 'regeneration', 
        'wound healing', 'bioengineering', 'tissue scaffolds', 
        'microfabrication', 'cell culture', 'characterization', 
        'mechanical', 'strength', 'performance', 'hyaluronic', 
        'acid', 'hydrogels', 'biocompatibility', 'stability', 
        'tissue engineering', 'cells', 'stem', 
        'nanotechnology', 'genetics', 'composite materials', 
        'translational', 'research', 'clinical', 
        'applications', 'innovations', 'surgical', 
        'orthopedic', 'dentistry', 'dermatology', 
        'pharmaceutical', 'sustainability', 'toxicity', 
        'testing', 'evaluation', 'standardization', 
        'quality', 'regulatory', 'considerations', 
        'market', 'demand', 'challenges', 'opportunities', 
        'strategies', 'research and development', 
        'interdisciplinary', 'collaborations', 'advancements', 
        'commercialization', 'prototypes', 
        'mechanisms', 'responses', 'wound', 
        'regenerative medicine', 'therapies', 'safety', 
        'effects', 'bioactive', 'materials science', 
        'methods', 'cellular', 'treatment', 
        'biomechanics', 'tissue interfaces', 'molecular', 
        'characteristics', 'crosslinking', 
        'adsorption', 'release', 'pathways', 
        'tissue engineering', 'methodologies', 
        'efficacy', 'functionalization', 'immunogenicity', 
        'compatibility', 'properties', 'bulk', 
        'surface', 'analysis', 'methods', 
        'feedback', 'dynamic', 'biological', 
        'information', 'outcomes', 'performance', 
        'integration', 'impact', 'future', 
        'trends', 'insights', 'models', 
        'collaboration', 'partnerships', 'industry', 
        'environment', 'sustainability', 'applications'
    ]],
    
    
'robotics_engineering' => [
    'title_id' => 179,
    'words' => [
        'robotics', 'engineering', 'automation', 'AI', 
        'mechanical', 'robot', 'technology', 'design', 
        'programming', 'control', 'systems', 'sensors', 
        'actuators', 'intelligence', 'feedback', 
        'algorithms', 'dynamics', 'mechanism', 'motion', 
        'simulation', 'hardware', 'software', 'robotic', 
        'applications', 'research', 'development', 
        'integration', 'models', 'tasks', 'industries', 
        'interdisciplinary', 'innovation', 'challenges', 
        'solutions', 'collaboration', 'autonomous', 
        'navigation', 'recognition', 'vision', 
        'interaction', 'human-robot', 'interface', 
        'performance', 'tasks', 'mobility', 'behavior', 
        'communication', 'prototyping', 'implementation', 
        'data', 'processing', 'learning', 'neural', 
        'networks', 'flexibility', 'adaptability', 
        'algorithms', 'real-time', 'applications', 
        'standards', 'education', 'collaboration', 
        'usability', 'improvements', 'scalability', 
        'testing', 'validation', 'designs', 'feedback', 
        'analysis', 'safety', 'regulations', 
        'monitoring', 'security', 'infrastructure', 
        'hardware', 'software', 'components', 
        'systems', 'cybernetics', 'artificial', 
        'intelligence', 'bioinspired', 'technologies', 
        'intelligent', 'manufacturing', 'energy', 
        'robotic systems', 'robotics applications', 
        'collaboration', 'efficiency', 'real-world', 
        'challenges', 'tools', 'simulation', 
        'training', 'development', 'maintenance', 
        'trends', 'insights', 'sustainability', 
        'projects', 'programming languages', 
        'robotic kits', 'advanced', 'data', 
        'machine learning', 'systems engineering', 
        'computational', 'intelligence', 'hardware', 
        'software', 'design', 'tools', 
        'education', 'collaborative', 'interaction'
    ]],
    
    
'cyber_physics' => [
    'title_id' => 180,
    'words' => [
        'cyber', 'physics', 'systems', 'control', 
        'networks', 'automation', 'AI', 'interaction', 
        'technology', 'simulation', 'data', 'analysis', 
        'feedback', 'dynamics', 'modeling', 'design', 
        'optimization', 'engineering', 'intelligence', 
        'communication', 'sensors', 'actuators', 
        'integration', 'robotics', 'computational', 
        'mechanics', 'information', 'security', 
        'environment', 'processes', 'interdisciplinary', 
        'applications', 'cybernetics', 'interactions', 
        'algorithms', 'control systems', 'embedded', 
        'programming', 'software', 'hardware', 
        'technology', 'electrical', 'energy', 
        'performance', 'parameters', 'architecture', 
        'monitoring', 'control', 'optimization', 
        'safety', 'efficiency', 'data processing', 
        'real-time', 'communication', 'networking', 
        'simulation', 'physical', 'cyber-physical', 
        'quantum', 'computing', 'virtualization', 
        'sustainability', 'feedback loops', 
        'sensing', 'measurements', 'effects', 
        'variables', 'computational models', 
        'transmission', 'resource management', 
        'intelligent', 'systems engineering', 
        'information systems', 'systematic', 
        'predictive', 'analysis', 'interdisciplinary', 
        'control theory', 'applications', 
        'collaborative', 'impact', 'evaluation', 
        'cybersecurity', 'standards', 'monitoring', 
        'policy', 'standards', 'development', 
        'frameworks', 'regulations', 'data integrity', 
        'disruption', 'resilience', 'automation systems', 
        'trends', 'insights', 'advancements', 
        'research', 'problems', 'solutions', 
        'challenges', 'dynamics', 'stakeholders', 
        'outcomes', 'strategy', 'assessment', 
        'knowledge', 'interactions', 'interfaces', 
        'energy systems', 'global', 'local', 
        'innovation', 'patterns'
    ]],
    
    
'quantum_computing' => [
    'title_id' => 181,
    'words' => [
        'quantum', 'computing', 'physics', 'algorithm', 
        'data', 'processing', 'superposition', 'research', 
        'technology', 'entanglement', 'bit', 'qubit', 
        'measurement', 'information', 'theory', 
        'circuit', 'gates', 'error', 'correction', 
        'decoherence', 'computational', 'speed', 
        'complexity', 'systems', 'cryptography', 
        'applications', 'communication', 'parallelism', 
        'simulation', 'optimization', 'tasks', 
        'performance', 'advancements', 'challenges', 
        'tools', 'software', 'hardware', 'scalability', 
        'interference', 'state', 'mechanics', 'principles', 
        'algorithmic', 'design', 'protocols', 
        'architecture', 'frameworks', 'research', 
        'dynamics', 'field', 'models', 'realization', 
        'resources', 'quantization', 'phases', 
        'operations', 'computation', 'effect', 
        'classical', 'algorithms', 'data structures', 
        'logic', 'circuits', 'interaction', 'networks', 
        'systematic', 'structures', 'theoretical', 
        'measurements', 'implementation', 'problems', 
        'solutions', 'insights', 'information theory', 
        'entangled', 'properties', 'applications', 
        'hybrid', 'quantum supremacy', 'gate model', 
        'adiabatic', 'quantum annealing', 'non-locality', 
        'interpretation', 'resilience', 'parallel', 
        'framework', 'effects', 'software', 'optimization', 
        'decoherence', 'computation', 'interference', 
        'effects', 'spectroscopy', 'scientific', 
        'communities', 'infrastructure', 'conventional', 
        'transformation', 'visualization', 'technology', 
        'feedback', 'collaboration', 'industries', 
        'environments', 'operations', 'research', 
        'innovations', 'integrations', 'advancements', 
        'applications', 'strategies', 'trends'
    ]],
    
    
'neuromarketing' => [
    'title_id' => 182,
    'words' => [
        'marketing', 'neuroscience', 'behavior', 'consumer', 
        'decision', 'brand', 'advertising', 'cognition', 
        'research', 'psychology', 'emotion', 'perception', 
        'influence', 'strategy', 'preferences', 'purchase', 
        'responses', 'attention', 'stimuli', 'insights', 
        'analysis', 'engagement', 'factors', 'experience', 
        'analytics', 'consumer behavior', 'advertising', 
        'branding', 'neural', 'responses', 'impulses', 
        'research methods', 'neuroimaging', 'techniques', 
        'functional', 'MRI', 'electroencephalography', 
        'EEG', 'implicit', 'associations', 'memory', 
        'awareness', 'activation', 'signals', 'desire', 
        'product', 'services', 'neurological', 'impacts', 
        'trends', 'campaigns', 'value', 'communication', 
        'market', 'analysis', 'preferences', 'consumer insights', 
        'advertisement', 'neuropsychology', 'responses', 
        'purchase intention', 'engagement', 'emotional', 
        'brand loyalty', 'differentiation', 'impact', 
        'optimization', 'strategies', 'exposure', 
        'decisions', 'heuristics', 'neuroscience findings', 
        'message', 'design', 'effectiveness', 
        'media', 'integration', 'creativity', 
        'connection', 'triggers', 'context', 
        'sentiment', 'loyalty', 'satisfaction', 
        'communication', 'experiments', 'market research', 
        'results', 'behavioral', 'modifications', 
        'innovation', 'feedback', 'consistency', 
        'purchase patterns', 'interpretation', 'brand perception', 
        'social proof', 'psychological', 'determinants', 
        'decision-making', 'insights', 'feedback loops', 
        'conclusions', 'predictors', 'behavioral cues', 
        'communication strategies', 'connectivity', 
        'interaction', 'usability', 'consumer experiences', 
        'motivation', 'persuasion', 'emotional connections', 
        'marketing psychology', 'neuroeconomics', 
        'neurodesires', 'contextual', 'trends', 
        'products', 'recommendations', 'cross-functional', 
        'research', 'strategies', 'engagement strategies', 
        'channels', 'perceptions', 'success'
    ]],
    
    
'permaculture' => [
    'title_id' => 183,
    'words' => [
        'agriculture', 'sustainability', 'permaculture', 
        'design', 'ecosystem', 'biodiversity', 'garden', 
        'organic', 'environment', 'regeneration', 'soil', 
        'water', 'conservation', 'farming', 'agroecology', 
        'perennial', 'composting', 'cultivation', 'systems', 
        'microclimate', 'habitat', 'pollination', 
        'community', 'resources', 'agriculture', 
        'integration', 'techniques', 'landscape', 
        'environmental', 'practices', 'ecological', 
        'innovation', 'biomimicry', 'plants', 
        'pests', 'pathogens', 'crop', 'rotation', 
        'companion', 'farming', 'shelter', 'microorganisms', 
        'food', 'security', 'inputs', 'outputs', 
        'practices', 'restoration', 'recycling', 
        'waste', 'reuse', 'local', 'permaculture principles', 
        'design methods', 'education', 'knowledge', 
        'ethics', 'permaculture design', 'networks', 
        'community-building', 'economic', 'sustainability', 
        'health', 'well-being', 'bushcraft', 'agroforestry', 
        'forest gardening', 'land use', 'crops', 
        'growing', 'seasonality', 'intercropping', 
        'mixed cropping', 'harvesting', 'permaculture zones', 
        'productivity', 'soil health', 'climate', 
        'factors', 'social', 'cooperation', 
        'outcomes', 'resilience', 'circular', 
        'economy', 'pollinators', 'germination', 
        'seed saving', 'food systems', 'community gardens', 
        'urban agriculture', 'local food', 'sourcing', 
        'empowerment', 'environments', 'connection', 
        'socioeconomic', 'dynamics', 'systems thinking', 
        'sustainability', 'development', 'future', 
        'interactions', 'microclimates', 'materials', 
        'practices', 'community resilience', 'sustainable', 
        'activities', 'pathways', 'social justice', 
        'ecosystem services', 'well-being', 'global', 
        'knowledge sharing', 'action', 'interactions', 
        'techniques', 'indigenous', 'knowledge', 
        'food sovereignty', 'traditions'
    ]],
    
    
'urban_ecology' => [
    'title_id' => 184,
    'words' => [
        'city', 'ecosystem', 'urban', 'ecology', 
        'biodiversity', 'sustainability', 'habitat', 
        'environment', 'green', 'spaces', 'infrastructure', 
        'community', 'development', 'pollution', 
        'conservation', 'planning', 'greenery', 
        'landscape', 'wildlife', 'public', 
        'transportation', 'agriculture', 'heat', 
        'island', 'microclimate', 'open', 
        'area', 'water', 'management', 'connectivity', 
        'community gardens', 'restoration', 'intervention', 
        'health', 'education', 'urbanization', 
        'dynamics', 'socioeconomic', 'factors', 
        'interaction', 'land use', 'green roofs', 
        'urban forestry', 'environmental', 'justice', 
        'ecosystem services', 'resilience', 'adaptation', 
        'renewable', 'energy', 'habitat loss', 
        'green infrastructure', 'environmental justice', 
        'socio-cultural', 'dimensions', 'climate', 
        'change', 'strategies', 'networks', 
        'community engagement', 'stakeholders', 'policy', 
        'initiatives', 'monitoring', 'indicators', 
        'participation', 'urban biodiversity', 
        'green spaces', 'benefits', 'ecosystem health', 
        'outcomes', 'knowledge', 'improvement', 
        'collaboration', 'assessment', 'tools', 
        'urban heat', 'island effect', 'public spaces', 
        'community resilience', 'social interactions', 
        'urban habitat', 'landscaping', 'green corridors', 
        'strategic', 'planning', 'landscape ecology', 
        'integrated', 'resource', 'management', 
        'local', 'food', 'urban agriculture', 
        'participatory', 'research', 'approaches', 
        'technology', 'infrastructure', 'services', 
        'impact', 'trends', 'enhancement', 
        'community spaces', 'ecosystem diversity', 
        'factors', 'systems', 'outcomes', 
        'urban ecosystem', 'restoration', 'strategies', 
        'challenges', 'frameworks', 'planning', 
        'governance', 'effectiveness', 'dynamics', 
        'relationships', 'quality', 'development'
    ]],
    
'paleoanthropology' => [
    'title_id' => 185,
    'words' => [
        'humans', 'ancestors', 'evolution', 'fossil', 
        'paleoanthropology', 'hominids', 'prehistoric', 
        'archaeology', 'species', 'anthropology', 
        'bipedalism', 'genetics', 'research', 'morphology', 
        'excavation', 'artifacts', 'lineage', 'culture', 
        'adaptation', 'environment', 'heritage', 
        'tools', 'behavior', 'discovery', 'findings', 
        'dating', 'methods', 'evidence', 'remains', 
        'anatomy', 'society', 'community', 'migration', 
        'population', 'climate', 'change', 'ecology', 
        'analysis', 'comparative', 'anatomy', 'skeletal', 
        'biological', 'chronology', 'interdisciplinary', 
        'fieldwork', 'dynamics', 'habitat', 'social', 
        'interaction', 'biogeography', 'paleoecology', 
        'stratigraphy', 'genus', 'species', 'morphological', 
        'paleoenvironment', 'demography', 'evolutionary', 
        'phylogeny', 'study', 'traits', 'patterns', 
        'paleoanthropological', 'insights', 'characteristics', 
        'characterization', 'identification', 'cultural', 
        'coexistence', 'finds', 'evidences', 
        'physical', 'structure', 'function', 'morphometrics', 
        'context', 'geographical', 'distributions', 
        'archaeological', 'chronological', 'tools', 
        'cognitive', 'capabilities', 'community', 
        'adaptations', 'paleoanthropologist', 'theories', 
        'hypotheses', 'assumptions', 'evolutionary biology', 
        'speciation', 'habitats', 'dispersal', 
        'lineages', 'cultural evolution', 'species diversity', 
        'comparative analysis', 'interactions', 
        'transitions', 'fossils', 'molecular', 
        'paleontology', 'ethnography', 'influence', 
        'selection', 'differentiation', 'modern', 
        'humans', 'behavioral', 'insights', 
        'investigation', 'challenges', 'evidences'
    ]],
    
    
'speech_recognition' => [
    'title_id' => 186,
    'words' => [
        'speech', 'recognition', 'AI', 'voice', 
        'technology', 'interaction', 'language', 
        'software', 'automated', 'input', 'output', 
        'communication', 'processing', 'system', 
        'data', 'training', 'model', 'algorithm', 
        'signal', 'transcription', 'commands', 
        'features', 'context', 'accuracy', 
        'performance', 'evaluation', 'user', 
        'interface', 'application', 'neural', 
        'networks', 'learning', 'feedback', 
        'adaptation', 'recognition systems', 'patterns', 
        'commands', 'dictation', 'systematic', 
        'integration', 'enhancements', 'tools', 
        'usability', 'cognition', 'natural', 
        'language processing', 'interaction', 'framework', 
        'speech-to-text', 'data sets', 'features', 
        'vocabulary', 'understanding', 'contextual', 
        'interpretation', 'multimodal', 'experiments', 
        'improvements', 'innovations', 'applications', 
        'sensitivity', 'limitations', 'advancements', 
        'environments', 'testing', 'deployment', 
        'accuracy', 'analysis', 'contextualization', 
        'recognition algorithms', 'recognition models', 
        'user experience', 'artificial intelligence', 
        'technologies', 'evaluation metrics', 
        'continuous learning', 'market', 
        'potential', 'research', 'development', 
        'settings', 'output', 'input', 
        'input', 'feedback loops', 'standards', 
        'interactivity', 'detection', 'features', 
        'training data', 'customization', 'dynamic', 
        'recognition quality', 'language models', 
        'optimization', 'environments', 'interactions', 
        'commands', 'detection', 'training', 
        'context', 'contexts', 'applications', 
        'natural language', 'programming', 'speech patterns', 
        'variability', 'features', 'integration', 
        'improvement', 'strategies', 'collaboration', 
        'feedback', 'usage', 'analytics', 
        'trends', 'evaluation', 'research', 
        'usability', 'communication', 'understanding'
    ]],
    
    
'bioacoustics' => [
    'title_id' => 187,
    'words' => [
        'sound', 'animals', 'bioacoustics', 'communication', 
        'frequency', 'ecosystem', 'species', 'research', 
        'habitat', 'vibration', 'signals', 'behavior', 
        'listening', 'recording', 'environment', 
        'calls', 'territorial', 'mating', 'foraging', 
        'identification', 'detection', 'monitoring', 
        'analysis', 'patterns', 'response', 
        'auditory', 'habitats', 'interaction', 
        'waves', 'sonar', 'acoustic', 'data', 
        'transmission', 'bioacoustic', 'methods', 
        'cognition', 'transmission', 'fieldwork', 
        'conservation', 'evolution', 'influence', 
        'bioacoustic monitoring', 'technology', 
        'species diversity', 'impacts', 'ecosystem health', 
        'behavioral ecology', 'communication channels', 
        'localization', 'bioacoustic data', 
        'recordings', 'context', 'environmental', 
        'parameters', 'acoustic environment', 
        'behavioral patterns', 'monitoring systems', 
        'interaction', 'social', 'indicators', 
        'seasonality', 'temporal', 'methods', 
        'signal processing', 'biological', 'indicators', 
        'contextual', 'perception', 'auditory signals', 
        'species interactions', 'acoustic communication', 
        'technology', 'social behavior', 
        'recording equipment', 'frequency range', 
        'ecoacoustics', 'biophony', 'geophony', 
        'anthrophony', 'sensing', 'research', 
        'methods', 'monitoring', 'tolerance', 
        'environment', 'measurement', 'research', 
        'approaches', 'collaboration', 'community', 
        'awareness', 'impact assessments', 
        'responses', 'sustainability', 'health', 
        'biological rhythms', 'habitat use', 
        'research initiatives', 'network', 
        'monitoring', 'recording', 'data collection', 
        'analysis', 'findings', 'assessments', 
        'outcomes', 'ecosystem dynamics', 
        'education', 'community engagement', 
        'initiatives', 'monitoring programs', 
        'evolutionary', 'studies', 'discoveries'
    ]],
    
    
'ecotoxicology' => [
    'title_id' => 188,
    'words' => [
        'toxins', 'environment', 'pollution', 'ecotoxicology', 
        'species', 'habitat', 'chemicals', 'ecosystem', 
        'conservation', 'bioaccumulation', 'biomagnification', 
        'impact', 'risk', 'assessment', 'exposure', 
        'regulations', 'monitoring', 'evaluation', 
        'toxicity', 'dynamics', 'effects', 'research', 
        'study', 'substances', 'hazards', 'assessment', 
        'studies', 'concentrations', 'analyses', 'data', 
        'variables', 'species diversity', 'ecosystem health', 
        'impacts', 'toxicity tests', 'methods', 'exposure pathways', 
        'chemical analysis', 'environments', 'ecosystems', 
        'toxicity assessment', 'environmental impact', 
        'habitats', 'species interactions', 'field studies', 
        'bioassays', 'laboratory', 'experiments', 
        'monitoring programs', 'agriculture', 'pesticides', 
        'fertilizers', 'heavy metals', 'industrial', 
        'waste', 'chemical pollution', 'water', 
        'soil', 'sediment', 'air quality', 
        'toxins', 'biodiversity', 'food web', 
        'endocrine disruptors', 'molecular', 'mechanisms', 
        'genotoxicity', 'neurotoxicity', 'pathways', 
        'ecological', 'risk assessment', 'factors', 
        'animal studies', 'models', 'recovery', 
        'environmental management', 'restoration', 
        'assessment tools', 'programs', 'monitoring systems', 
        'standardization', 'guidelines', 'strategies', 
        'public health', 'ecosystem services', 'communities', 
        'sustainable practices', 'monitoring', 
        'pollution prevention', 'awareness', 
        'community involvement', 'educational initiatives', 
        'collaborative research', 'transparency', 
        'communication', 'networking', 'educational programs', 
        'initiatives', 'advocacy', 'engagement', 
        'environmental science', 'findings', 'conservation practices', 
        'rehabilitation', 'remediation', 'stewardship'
    ]],
    
    
'nanomedicine' => [
    'title_id' => 189,
    'words' => [
        'nano', 'medicine', 'treatment', 'nanotechnology', 
        'drug', 'delivery', 'biotechnology', 'research', 
        'cell', 'therapy', 'particles', 'applications', 
        'molecules', 'formulations', 'diagnostics', 
        'targeting', 'engineering', 'biocompatibility', 
        'clinical', 'trials', 'innovation', 'safety', 
        'efficacy', 'nanoparticles', 'therapeutics', 
        'development', 'bioavailability', 'pharmacology', 
        'chemical', 'properties', 'cellular', 
        'mechanisms', 'distribution', 'absorption', 
        'metabolism', 'elimination', 'toxicity', 
        'research', 'strategies', 'monitoring', 
        'environmental', 'impact', 'data', 
        'in vivo', 'in vitro', 'characterization', 
        'imaging', 'techniques', 'nanocarriers', 
        'systems', 'drug design', 'biomarkers', 
        'functionalization', 'immunotherapy', 
        'nanostructures', 'development', 'challenges', 
        'multidisciplinary', 'interdisciplinary', 
        'advancements', 'characteristics', 'assessments', 
        'formulation', 'nanoformulations', 'dosage', 
        'delivery systems', 'pathways', 'interaction', 
        'regulations', 'clinical applications', 
        'therapeutics', 'bioengineering', 'nanomedicines', 
        'customization', 'efficacy', 'improvements', 
        'analyses', 'solutions', 'testing', 
        'clinical outcomes', 'community', 
        'healthcare', 'integration', 'collaboration', 
        'products', 'technology', 'development', 
        'application', 'synthesis', 'laboratories', 
        'studies', 'evidence', 'guidelines', 
        'trends', 'insights', 'implementation', 
        'therapeutic', 'applications', 'biopharmaceuticals', 
        'diagnostics', 'quality', 'factors', 
        'evaluation', 'processes', 'knowledge', 
        'market', 'potential', 'future', 
        'discoveries', 'impact', 'benefits', 
        'outcomes', 'accessibility', 'understanding', 
        'utilization', 'advocacy', 'awareness'
    ]],
    
    
'astrobiology' => [
    'title_id' => 190,
    'words' => [
        'life', 'space', 'astrobiology', 'extraterrestrial', 
        'planet', 'research', 'universe', 'biology', 
        'exploration', 'habitat', 'origin', 'species', 
        'chemical', 'elements', 'environment', 
        'conditions', 'evolution', 'theories', 'signals', 
        'atmosphere', 'moons', 'comets', 'asteroids', 
        'microbial', 'organisms', 'biodiversity', 
        'ecosystems', 'astrochemistry', 'planetary', 
        'formation', 'solar', 'system', 'exoplanets', 
        'stellar', 'formation', 'light', 'energy', 
        'telescopes', 'instruments', 'methods', 
        'samples', 'missions', 'analysis', 
        'hypotheses', 'experiments', 'data', 
        'biochemistry', 'phenomena', 'conditions', 
        'survival', 'adaptation', 'species', 
        'extremophiles', 'theory', 'life forms', 
        'observations', 'spacecraft', 'hypotheses', 
        'cosmic', 'radiation', 'microbes', 
        'traces', 'galaxies', 'life-support', 
        'interstellar', 'bio-signatures', 'exploration', 
        'contact', 'intelligence', 'biological', 
        'organisms', 'chemical', 'substances', 
        'geochemical', 'potential', 'research', 
        'discoveries', 'studies', 'field', 
        'technologies', 'space missions', 'telescope', 
        'analysis', 'criteria', 'habitats', 
        'panspermia', 'indicators', 'global', 
        'investigation', 'universes', 'solvents', 
        'comparative', 'planetology', 'astronomy', 
        'chemical analysis', 'search', 'origin', 
        'environments', 'evidence', 'methods', 
        'theories', 'advancements', 'monitoring', 
        'publications', 'insights', 'research', 
        'developments', 'analyses', 'characteristics', 
        'collaborations', 'biological mechanisms', 
        'environmental conditions', 'explorations', 
        'initiatives', 'technological', 'growth', 
        'systems', 'observatories', 'biological signatures'
    ]],
    
    
'molecular_biology' => [
    'title_id' => 191,
    'words' => [
        'molecule', 'biology', 'DNA', 'cell', 
        'molecular', 'biology', 'protein', 'research', 
        'gene', 'genomics', 'RNA', 'chromosome', 
        'nucleotide', 'sequence', 'synthesis', 
        'genetic', 'expression', 'function', 
        'metabolism', 'pathways', 'cellular', 
        'regulation', 'interaction', 'enzymes', 
        'structural', 'biochemical', 'receptors', 
        'analyses', 'data', 'experiments', 
        'evolution', 'development', 'organisms', 
        'genetic engineering', 'techniques', 
        'laboratory', 'studies', 'observations', 
        'proteomics', 'bioinformatics', 'investigation', 
        'transcription', 'translation', 'hypotheses', 
        'applications', 'biotechnology', 'molecular mechanisms', 
        'assays', 'detection', 'bioactivity', 
        'biological pathways', 'complexes', 'catalysis', 
        'biophysics', 'experimental', 'protocols', 
        'systems', 'therapeutics', 'stability', 
        'mutations', 'analytical', 'tools', 
        'modeling', 'processes', 'functional', 
        'interactions', 'associations', 'dynamics', 
        'quantitative', 'findings', 'challenges', 
        'advancements', 'sensitivity', 'specificity', 
        'characterization', 'data analysis', 
        'comparative', 'evidence', 'studies', 
        'growth', 'approaches', 'field', 
        'insights', 'feedback', 'discoveries', 
        'characteristics', 'mechanisms', 'toxicity', 
        'inhibition', 'stimulation', 'enzyme kinetics', 
        'cell signaling', 'integrated', 'systems biology', 
        'research', 'applications', 'technologies', 
        'discoveries', 'research directions', 
        'regulatory', 'genetic disorders', 'clinical', 
        'therapies', 'strategies', 'findings', 
        'investigations', 'observations', 'transformations', 
        'molecular diagnostics', 'species', 'biochemical pathways'
    ]],
    
    
'chemical_engineering' => [
    'title_id' => 192,
    'words' => [
        'chemistry', 'engineering', 'chemical', 'process', 
        'materials', 'production', 'design', 'energy', 
        'innovation', 'reaction', 'safety', 'processes', 
        'thermodynamics', 'kinetics', 'separation', 
        'distillation', 'filtration', 'biochemical', 
        'engineering', 'systems', 'equipment', 'modeling', 
        'optimization', 'transport', 'mass transfer', 
        'heat transfer', 'unit operations', 'analysis', 
        'designing', 'sustainability', 'environmental', 
        'hazards', 'risk', 'evaluation', 'dynamics', 
        'formulation', 'reactors', 'process design', 
        'simulation', 'feedback', 'development', 
        'projects', 'research', 'efficiency', 
        'materials science', 'product', 'market', 
        'economics', 'quality', 'standards', 
        'compliance', 'testing', 'applications', 
        'industrial', 'process engineering', 
        'materials processing', 'catalysis', 
        'synthesis', 'formulation', 'bioprocessing', 
        'chemical processes', 'refining', 'polymers', 
        'compounds', 'environmental impact', 'waste', 
        'management', 'byproducts', 'recycling', 
        'process optimization', 'data', 'analytics', 
        'automation', 'control', 'instrumentation', 
        'operations', 'improvements', 'trends', 
        'energy efficiency', 'research initiatives', 
        'technologies', 'laboratory', 'practices', 
        'teamwork', 'collaboration', 'standards', 
        'professional', 'development', 'advancements', 
        'knowledge', 'economics', 'competitiveness', 
        'studies', 'discoveries', 'integrations', 
        'scientific', 'discoveries', 'production processes', 
        'sustainability practices', 'efficacy', 
        'conversions', 'energy sources', 
        'resilience', 'capabilities', 'performance'
    ]],
    
    
'photonics' => [
    'title_id' => 193,
    'words' => [
        'light', 'photon', 'optics', 'photons', 
        'technology', 'fiber', 'optics', 'communication', 
        'lasers', 'research', 'wave', 'frequency', 
        'signals', 'interference', 'emission', 
        'detection', 'devices', 'application', 
        'systems', 'illumination', 'analysis', 
        'transmission', 'components', 'quantum', 
        'infrared', 'ultraviolet', 'lasers', 
        'efficiency', 'measurement', 'spectroscopy', 
        'semiconductors', 'telecommunication', 'network', 
        'materials', 'integration', 'microsystems', 
        'fabrication', 'sensors', 'filters', 
        'modulation', 'detectors', 'technologies', 
        'advancements', 'insights', 'applications', 
        'solutions', 'optical', 'properties', 
        'nonlinear', 'dynamics', 'engineering', 
        'processing', 'systems', 'methodologies', 
        'investigation', 'innovations', 'techniques', 
        'deployment', 'performance', 'analysis', 
        'characterization', 'characteristics', 
        'guidelines', 'standards', 'environment', 
        'applications', 'trends', 'challenges', 
        'discoveries', 'collaborations', 'interdisciplinary', 
        'outcomes', 'market', 'opportunities', 
        'research', 'efforts', 'devices', 
        'telecommunication', 'biophotonics', 'applications', 
        'light sources', 'connectivity', 'integration', 
        'advances', 'collaborative', 'efficiency', 
        'monitoring', 'implementation', 'energy', 
        'sustainability', 'optical fibers', 
        'biomedical', 'telecommunications', 'trends', 
        'data', 'processing', 'integration', 
        'functionalization', 'circuits', 'theory', 
        'design', 'calculations', 'characterizations', 
        'investigations', 'spectral', 'interactions', 
        'feedback', 'patterns', 'developments'
    ]],
    
    
'earth_sciences' => [
    'title_id' => 194,
    'words' => [
        'earth', 'geology', 'climate', 'science', 
        'earth sciences', 'minerals', 'ecosystem', 
        'research', 'environment', 'atmosphere', 
        'lithosphere', 'hydrosphere', 'biosphere', 
        'geophysics', 'geochemistry', 'tectonics', 
        'sedimentology', 'petrology', 'oceanography', 
        'meteorology', 'landforms', 'soil', 
        'sediments', 'fossils', 'rock', 
        'hydrology', 'natural resources', 'land use', 
        'pollution', 'conservation', 'sustainability', 
        'climatology', 'geographic', 'mapping', 
        'drainage', 'watershed', 'environmental', 
        'issues', 'biodiversity', 'habitat', 
        'climate change', 'global warming', 'ecosystems', 
        'vegetation', 'wildlife', 'flora', 
        'fauna', 'analysis', 'remote sensing', 
        'data', 'modeling', 'monitoring', 
        'geospatial', 'resources', 'quality', 
        'impacts', 'agriculture', 'urbanization', 
        'slope stability', 'earthquakes', 'volcanology', 
        'landslides', 'glaciology', 'ocean', 
        'waves', 'currents', 'climate patterns', 
        'natural hazards', 'environmental science', 
        'marine', 'environments', 'socioeconomic', 
        'factors', 'fieldwork', 'interdisciplinary', 
        'studies', 'practices', 'field studies', 
        'climatic', 'variables', 'sustainable', 
        'investigations', 'hazards', 'risk', 
        'management', 'restoration', 'projects', 
        'outcomes', 'knowledge', 'education', 
        'communities', 'policy', 'initiatives', 
        'collaborative', 'efforts', 'technologies', 
        'advancements', 'innovation', 'insights', 
        'data analysis', 'strategies', 'monitoring', 
        'assessment', 'restoration', 'initiatives', 
        'advancements', 'dissemination', 'interactions', 
        'research', 'development', 'global', 
        'trends', 'patterns', 'engagement', 
        'effectiveness', 'discovery', 'outcomes'
    ]],
    
    
'financial_technology' => [
    'title_id' => 195,
    'words' => [
        'fintech', 'technology', 'finance', 'banking', 
        'blockchain', 'investment', 'payment', 'digital', 
        'innovation', 'cryptocurrency', 'lending', 
        'insurance', 'crowdfunding', 'regulation', 
        'transactions', 'platforms', 'apps', 
        'data', 'analytics', 'security', 
        'mobile', 'services', 'access', 
        'peer-to-peer', 'financial', 'solutions', 
        'trading', 'market', 'economy', 
        'users', 'adoption', 'infrastructure', 
        'smart contracts', 'identity', 'verification', 
        'automation', 'processes', 'financial literacy', 
        'insights', 'efficiency', 'risk', 
        'management', 'regulatory', 'compliance', 
        'customer', 'experience', 'interfaces', 
        'user-friendly', 'accessibility', 'tools', 
        'financing', 'venture', 'capital', 
        'savings', 'fees', 'charges', 
        'marketplace', 'aggregator', 'trends', 
        'disruption', 'cloud', 'services', 
        'remote', 'operations', 'analysis', 
        'investment strategies', 'financial products', 
        'decision-making', 'digital currencies', 
        'blockchain technology', 'biometric', 'authentication', 
        'rewards', 'loans', 'transactions', 
        'ecosystem', 'banking services', 'interoperability', 
        'market research', 'competitive', 'advantage', 
        'global', 'payments', 'cashless', 
        'financial data', 'services', 'platform', 
        'customer service', 'interface', 'network', 
        'insurtech', 'robo-advisors', 'protection', 
        'capital markets', 'risk assessment', 
        'analytics', 'prediction', 'personal finance', 
        'integration', 'scalability', 'convenience', 
        'challenges', 'opportunities', 'improvements', 
        'products', 'enhancements', 'efforts', 
        'strategies', 'partnerships', 'globalization', 
        'community', 'engagement', 'awareness'
    ]],
    
    
'food_security' => [
    'title_id' => 196,
    'words' => [
        'food', 'security', 'supply', 'chain', 
        'agriculture', 'resources', 'sustainability', 
        'hunger', 'distribution', 'nutrition', 
        'access', 'availability', 'affordability', 
        'production', 'supply', 'systems', 
        'farming', 'community', 'food systems', 
        'agroecology', 'environment', 'policies', 
        'innovation', 'local', 'markets', 
        'economic', 'development', 'food sovereignty', 
        'climate', 'change', 'conservation', 
        'waste', 'management', 'education', 
        'empowerment', 'programs', 'safety', 
        'food security', 'research', 'health', 
        'ecosystems', 'biotechnology', 'practices', 
        'crop', 'diversity', 'land', 
        'community gardens', 'support', 'investments', 
        'technology', 'food production', 'disaster', 
        'resilience', 'hygiene', 'nutritional', 
        'challenges', 'solutions', 'partnerships', 
        'stakeholders', 'systems', 'strategies', 
        'monitoring', 'evaluation', 'advocacy', 
        'collaboration', 'supply chains', 'distribution', 
        'transparency', 'trends', 'analysis', 
        'international', 'collaboration', 'agriculture', 
        'climate resilience', 'community support', 
        'education', 'awareness', 'food programs', 
        'investments', 'community involvement', 
        'policy', 'initiatives', 'improvements', 
        'food assistance', 'food safety', 'quality', 
        'production methods', 'crop management', 
        'agriculture technology', 'rural', 
        'development', 'capacity', 'food waste', 
        'subsidies', 'farmers', 'market access', 
        'trade', 'networks', 'health outcomes', 
        'support', 'advancement', 'knowledge', 
        'policy making', 'nutrition education', 
        'global', 'local food', 'cultivation', 
        'food initiatives', 'food justice'
    ]],
    
    
'health_informatics' => [
    'title_id' => 197,
    'words' => [
        'health', 'informatics', 'data', 'technology', 
        'patient', 'medical', 'system', 'information', 
        'care', 'records', 'electronic', 'healthcare', 
        'management', 'analysis', 'software', 
        'informatics', 'research', 'services', 
        'communication', 'monitoring', 'clinical', 
        'decisions', 'tools', 'support', 
        'workflow', 'access', 'integration', 
        'standards', 'privacy', 'security', 
        'interoperability', 'architecture', 'clinical decision support', 
        'analytics', 'outcomes', 'telehealth', 
        'applications', 'platforms', 'systems', 
        'data exchange', 'interfaces', 'software', 
        'databases', 'technology', 'improvements', 
        'strategies', 'efficiency', 'engagement', 
        'systems', 'research', 'methodologies', 
        'patient care', 'evidence', 'enhancements', 
        'practices', 'support systems', 'collaboration', 
        'professionals', 'informatics standards', 
        'workflow management', 'information systems', 
        'clinical research', 'telemedicine', 
        'electronic health records', 'patient safety', 
        'scheduling', 'records management', 
        'data integrity', 'bioinformatics', 'digital health', 
        'programs', 'education', 'outreach', 
        'health services', 'monitoring systems', 
        'knowledge management', 'data management', 
        'medical records', 'clinical systems', 
        'health information exchange', 'analysis tools', 
        'efficiency', 'integration', 'data mining', 
        'quality', 'improvement', 'strategies', 
        'healthcare delivery', 'diagnostics', 
        'interventions', 'research initiatives', 
        'informatics applications', 'personal health', 
        'engagement', 'educational', 'monitoring', 
        'resources', 'factors', 'technologies', 
        'support', 'networks', 'community', 
        'outcomes', 'e-health', 'systems integration', 
        'knowledge sharing', 'improvements', 'data analysis'
    ]],
    
    
'systems_biology' => [
    'title_id' => 198,
    'words' => [
        'biology', 'systems', 'data', 'network', 
        'genomics', 'interactions', 'research', 
        'computational', 'cell', 'dynamics', 
        'modeling', 'pathways', 'integration', 
        'analysis', 'biological', 'phenotypes', 
        'genetic', 'expression', 'proteomics', 
        'metabolomics', 'feedback', 'mechanisms', 
        'environment', 'systems biology', 'networks', 
        'processes', 'bioinformatics', 'simulation', 
        'studies', 'approaches', 'components', 
        'interaction', 'model', 'computational models', 
        'analysis', 'experiments', 'tools', 
        'techniques', 'systems', 'behavior', 
        'complexity', 'understanding', 'disease', 
        'cellular', 'systems', 'research', 
        'applications', 'data integration', 
        'theories', 'functional', 'bioenergetics', 
        'population', 'structure', 'information', 
        'biochemical', 'dynamics', 'insights', 
        'cell networks', 'biochemical pathways', 
        'biophysical', 'ecological', 'regulatory', 
        'models', 'parameters', 'evolution', 
        'comparative', 'methods', 'influence', 
        'innovation', 'testing', 'validation', 
        'insights', 'hypotheses', 'frameworks', 
        'patterns', 'variability', 'exploration', 
        'computational tools', 'analysis', 
        'research', 'genetic data', 'systematic', 
        'approaches', 'discoveries', 'characteristics', 
        'collaborative', 'interdisciplinary', 
        'knowledge', 'findings', 'observations', 
        'applications', 'systems', 'community', 
        'education', 'technologies', 'results', 
        'analytical', 'investigations', 'case studies', 
        'interactions', 'systems approach', 
        'mechanisms', 'testing', 'objectives', 
        'collaboration', 'data analysis', 'integration'
    ]],
    
    
'artificial_life' => [
    'title_id' => 199,
    'words' => [
        'AI', 'artificial', 'life', 'simulation', 
        'biology', 'robotics', 'machine', 
        'learning', 'evolution', 'research', 
        'digital', 'intelligence', 'agents', 
        'systems', 'behavior', 'models', 
        'ecosystems', 'adaptation', 'complexity', 
        'emergence', 'processes', 'virtual', 
        'organisms', 'interaction', 'genetic', 
        'algorithms', 'artificial organisms', 'simulation', 
        'experiments', 'dynamics', 'theory', 
        'network', 'phenomena', 'information', 
        'feedback', 'agents', 'evolutionary', 
        'patterns', 'development', 'structures', 
        'environment', 'life-like', 'computational', 
        'understanding', 'analyses', 'agents', 
        'evolutionary algorithms', 'artificiality', 
        'creativity', 'representations', 'social', 
        'cognition', 'process', 'exploration', 
        'interdisciplinary', 'research', 'tools', 
        'systems thinking', 'artificial life systems', 
        'biomimicry', 'synthetic', 'intelligent', 
        'nature', 'complex systems', 'adaptation', 
        'characteristics', 'bio-inspired', 'insights', 
        'computational biology', 'algorithmic', 
        'mechanisms', 'phenotypic', 'emergent', 
        'artificial systems', 'human', 'computational', 
        'sustainable', 'simulations', 'evolutionary processes', 
        'dynamics', 'systematic', 'simulated', 
        'integrative', 'methodologies', 'applications', 
        'engineering', 'models', 'programming', 
        'biologically-inspired', 'theoretical', 'research', 
        'innovation', 'development', 'challenges', 
        'outcomes', 'applications', 'virtual worlds', 
        'data', 'representations', 'connections', 
        'feedback loops', 'decision-making', 
        'collaborative', 'interactions', 'systems', 
        'intelligent systems', 'nature-inspired', 'insights'
    ]],
    
    
'behavioral_economics' => [
    'title_id' => 200,
    'words' => [
        'economics', 'behavior', 'decision-making', 'psychology', 
        'market', 'research', 'finance', 'consumer', 
        'incentive', 'cognitive', 'bias', 'rationality', 
        'preferences', 'utility', 'risk', 
        'choice', 'heuristics', 'predictability', 
        'information', 'values', 'social', 
        'norms', 'framework', 'strategies', 
        'outcomes', 'interactions', 'analysis', 
        'theory', 'investments', 'trends', 
        'motivations', 'variables', 'situations', 
        'emotions', 'factors', 'evidence', 
        'patterns', 'expectations', 'responses', 
        'context', 'assumptions', 'prospect theory', 
        'experiments', 'models', 'data', 
        'impacts', 'scenarios', 'policies', 
        'disruptions', 'long-term', 'short-term', 
        'commitment', 'preferences', 'contextual', 
        'assessments', 'market behavior', 
        'strategies', 'financial decisions', 
        'psychological', 'financial', 'decision theory', 
        'frameworks', 'insights', 'effects', 
        'relationship', 'consequences', 'cultural', 
        'intervention', 'engagement', 'experimental', 
        'education', 'experimentation', 'collaboration', 
        'understanding', 'framework', 'changes', 
        'interventions', 'success', 'social dynamics', 
        'regulations', 'challenges', 'discoveries', 
        'advancements', 'stakeholders', 'strategic', 
        'collaborative', 'evaluation', 'feedback', 
        'solutions', 'approaches', 'cooperation', 
        'well-being', 'measures', 'knowledge', 
        'planning', 'exploration', 'policy-making', 
        'implications', 'influence', 'effectiveness', 
        'integration', 'emerging', 'dynamics', 
        'application', 'consumer behavior', 'insights'
    ]],
    
    
'climatology' => [
    'title_id' => 201,
    'words' => [
        'climate', 'weather', 'climatology', 'temperature', 
        'atmosphere', 'research', 'forecast', 'environment', 
        'precipitation', 'humidity', 'pressure', 
        'patterns', 'variability', 'trends', 
        'changes', 'analysis', 'data', 
        'models', 'impact', 'phenomena', 
        'interactions', 'ocean', 'circulation', 
        'solar', 'radiation', 'ecosystem', 
        'carbon', 'greenhouse', 'gases', 
        'effects', 'temperatures', 'seasonality', 
        'regions', 'glaciers', 'biomes', 
        'temperature changes', 'extreme', 'events', 
        'variations', 'observations', 'studies', 
        'long-term', 'short-term', 'climate change', 
        'mitigation', 'adaptation', 'vulnerability', 
        'policies', 'factors', 'simulation', 
        'climate models', 'impacts', 'feedback', 
        'risk', 'assessment', 'urban', 
        'microclimates', 'agriculture', 'land use', 
        'strategies', 'research', 'information', 
        'climate variability', 'statistics', 'sensors', 
        'satellite', 'data collection', 'instruments', 
        'forecasts', 'climatological', 'observational', 
        'trends', 'changes', 'knowledge', 
        'adaptation strategies', 'scientific', 
        'implications', 'environmental', 'studies', 
        'analysis', 'integration', 'collaboration', 
        'community', 'education', 'awareness', 
        'evidence', 'trends', 'investigations', 
        'resources', 'outcomes', 'climate action', 
        'cooperation', 'decisions', 'impacts', 
        'enhancements', 'effectiveness', 'results', 
        'models', 'tools', 'platforms', 
        'decision-making', 'partnerships', 'strategies'
    ]],
    
    
'disaster_management' => [
    'title_id' => 202,
    'words' => [
        'disaster', 'management', 'emergency', 'response', 
        'resilience', 'planning', 'risk', 'infrastructure', 
        'recovery', 'preparedness', 'mitigation', 
        'impact', 'assessment', 'strategies', 
        'recovery', 'resources', 'collaboration', 
        'community', 'engagement', 'training', 
        'education', 'systems', 'evaluation', 
        'outcomes', 'coordination', 'response teams', 
        'volunteers', 'communication', 'early warning', 
        'safety', 'protocols', 'services', 
        'needs', 'preparedness plans', 'actions', 
        'initiatives', 'policies', 'evacuation', 
        'awareness', 'relief', 'support', 
        'recovery plans', 'involvement', 'stakeholders', 
        'public health', 'logistics', 'networking', 
        'community resilience', 'analysis', 'developments', 
        'partnerships', 'tools', 'technologies', 
        'systems thinking', 'risk assessment', 
        'strategies', 'governance', 'coordination', 
        'evacuation plans', 'shelter', 'response efforts', 
        'funding', 'assistance', 'safety measures', 
        'incident', 'crisis', 'environment', 
        'recovery efforts', 'hazards', 'detection', 
        'environmental', 'financial', 'aid', 
        'infrastructure', 'social', 'economic', 
        'policy-making', 'developments', 'factors', 
        'studies', 'response frameworks', 'challenges', 
        'innovations', 'initiatives', 'education', 
        'advocacy', 'response capabilities', 'practices', 
        'public awareness', 'intervention', 
        'technology', 'data collection', 'training programs', 
        'assessments', 'impact analysis', 'frameworks', 
        'community planning', 'activities', 'scenarios', 
        'monitoring', 'preparedness initiatives', 
        'lessons', 'systems', 'development'
    ]],
    
    
'earth_observation' => [
    'title_id' => 203,
    'words' => [
        'satellite', 'earth', 'observation', 'geography', 
        'monitoring', 'data', 'environment', 'technology', 
        'space', 'remote', 'sensing', 'analysis', 
        'aerospace', 'imagery', 'mapping', 
        'land', 'surface', 'climate', 
        'dynamics', 'vegetation', 'changes', 
        'ecosystem', 'applications', 'research', 
        'insights', 'models', 'information', 
        'systems', 'detection', 'features', 
        'tools', 'satellite imagery', 'information systems', 
        'climate change', 'trends', 'data collection', 
        'monitoring systems', 'geospatial', 'parameters', 
        'land use', 'regulations', 'instruments', 
        'exploration', 'fields', 'programs', 
        'observations', 'sensors', 'investigations', 
        'data analysis', 'regional', 'global', 
        'applications', 'sustainability', 'impacts', 
        'demography', 'parameters', 'characteristics', 
        'studies', 'urban', 'rural', 
        'assessment', 'resources', 'forecasts', 
        'collaboration', 'initiatives', 'decision-making', 
        'outcomes', 'investments', 'developments', 
        'challenges', 'capabilities', 'evaluation', 
        'environmental', 'policies', 'space missions', 
        'satellite data', 'applications', 'strategies', 
        'innovation', 'technologies', 'disasters', 
        'hazards', 'effectiveness', 'applications', 
        'operations', 'trends', 'insights', 
        'communities', 'networks', 'experiments', 
        'integration', 'feedback', 'communication', 
        'monitoring programs', 'research initiatives', 
        'data sharing', 'collaboration', 'knowledge', 
        'awareness', 'decision-support', 'modeling', 
        'parameters', 'monitoring', 'frameworks'
    ]],
    
    
'energy_storage' => [
    'title_id' => 204,
    'words' => [
        'energy', 'storage', 'batteries', 'renewable', 
        'power', 'technology', 'sustainability', 
        'innovation', 'capacity', 'electricity', 
        'grid', 'systems', 'demand', 
        'supply', 'solutions', 'efficiency', 
        'applications', 'mechanisms', 'development', 
        'alternatives', 'hydrogen', 'fuel', 
        'pumps', 'hydropower', 'thermal', 
        'supercapacitors', 'lifecycle', 'materials', 
        'performance', 'monitoring', 'integrations', 
        'strategies', 'management', 'distribution', 
        'impact', 'investments', 'regulations', 
        'economic', 'factors', 'research', 
        'projects', 'systems', 'challenges', 
        'environmental', 'potential', 'collaboration', 
        'advancements', 'techniques', 'cost', 
        'analysis', 'battery technology', 
        'energy efficiency', 'grid stability', 
        'energy management', 'storage solutions', 
        'system design', 'resources', 'modeling', 
        'innovations', 'materials', 'optimization', 
        'technologies', 'investigation', 'safety', 
        'standards', 'battery life', 'integration', 
        'scalability', 'reliability', 'transportation', 
        'research', 'emissions', 'systems', 
        'electrochemical', 'regenerative', 'power quality', 
        'renewable energy', 'solar', 'wind', 
        'environment', 'network', 'performance', 
        'tools', 'developments', 'strategies', 
        'system components', 'resilience', 
        'analysis', 'data', 'metrics', 
        'deployment', 'usage', 'education', 
        'community', 'monitoring', 'data analysis', 
        'future', 'technological advancements', 
        'flexibility', 'storage technology', 'feedback'
    ]],
    
    
'environmental_psychology' => [
    'title_id' => 205,
    'words' => [
        'psychology', 'environment', 'behavior', 'perception', 
        'sustainability', 'research', 'interaction', 
        'conservation', 'well-being', 'attitudes', 
        'spaces', 'design', 'nature', 
        'habitats', 'cognition', 'emotions', 
        'influence', 'impact', 'social', 
        'factors', 'settings', 'community', 
        'development', 'effects', 'mental health', 
        'experiences', 'awareness', 'climate', 
        'change', 'resilience', 'motivations', 
        'adaptation', 'education', 'public', 
        'policy', 'engagement', 'sustainability practices', 
        'preferences', 'norms', 'values', 
        'spatial', 'characteristics', 'physical', 
        'behavioral change', 'context', 'framework', 
        'decision-making', 'health', 'perceptions', 
        'involvement', 'spaces', 'attitude', 
        'feedback', 'activities', 'interventions', 
        'effects', 'initiatives', 'factors', 
        'research', 'strategies', 'models', 
        'psychological theories', 'outcomes', 'culture', 
        'collaboration', 'consequences', 'motivation', 
        'environmental attitudes', 'individual', 
        'community engagement', 'emotional', 
        'effects', 'connections', 'evaluation', 
        'lifestyle', 'interdisciplinary', 'satisfaction', 
        'barriers', 'communities', 'research', 
        'social psychology', 'collective', 'behaviors', 
        'education', 'environmental education', 
        'social norms', 'cultural', 'research initiatives', 
        'dynamics', 'dimensions', 'public perceptions', 
        'advocacy', 'frameworks', 'perspectives', 
        'innovations', 'investigations', 'understanding', 
        'practices', 'approaches', 'impacts', 
        'awareness', 'knowledge', 'community resilience', 
        'behavioral studies', 'networks', 'insights'
    ]],
    
    
'game_theory' => [
    'title_id' => 206,
    'words' => [
        'strategy', 'decision-making', 'game theory', 
        'economics', 'mathematics', 'competition', 
        'market', 'incentives', 'optimization', 
        'payoff', 'equilibrium', 'rationality', 
        'players', 'tactics', 'analysis', 
        'choices', 'outcomes', 'interactions', 
        'cooperation', 'defection', 'dilemmas', 
        'bargaining', 'auctions', 'alliances', 
        'conflicts', 'situations', 'strategies', 
        'information', 'theory', 'behavior', 
        'risk', 'utility', 'models', 
        'frameworks', 'assumptions', 'functions', 
        'elements', 'collaborative', 'negotiation', 
        'trials', 'parameters', 'efficiency', 
        'calculations', 'interdependencies', 'choices', 
        'rational choice', 'social', 'science', 
        'probabilities', 'complexity', 'concepts', 
        'dynamics', 'studies', 'investments', 
        'applications', 'real-world', 'issues', 
        'choices', 'approaches', 'context', 
        'bargaining power', 'sequential', 'simultaneous', 
        'zero-sum', 'information asymmetry', 'cooperative', 
        'non-cooperative', 'analysis', 'perspectives', 
        'trends', 'game theory applications', 'research', 
        'design', 'influence', 'calculations', 
        'strategic', 'distributions', 'solutions', 
        'experiments', 'equilibria', 'dilemmas', 
        'interactions', 'framework', 'data', 
        'situational', 'strategic moves', 'assumptions', 
        'feedback', 'insights', 'calculations', 
        'economic models', 'factors', 'optimization', 
        'collaboration', 'outcomes', 'efficiency', 
        'studies', 'systematic', 'complex systems'
    ]],
    
    
'invasive_species' => [
    'title_id' => 207,
    'words' => [
        'species', 'ecosystem', 'invasive', 'environment', 
        'conservation', 'habitat', 'wildlife', 'biodiversity', 
        'management', 'control', 'impact', 'native', 
        'flora', 'fauna', 'interactions', 'survival', 
        'colonization', 'distribution', 'adaptation', 
        'competition', 'predation', 'predators', 
        'prey', 'threats', 'invasion', 'population', 
        'regulations', 'monitoring', 'strategies', 
        'restoration', 'research', 'ecology', 
        'effects', 'habitat degradation', 'remediation', 
        'assessment', 'biodiversity loss', 'ecosystem services', 
        'trophic', 'dynamics', 'resilience', 
        'recovery', 'exotic', 'species diversity', 
        'surveys', 'legislation', 'educational', 
        'initiatives', 'public awareness', 'data', 
        'approaches', 'effects', 'community', 
        'ecosystem integrity', 'management practices', 
        'treatments', 'integrations', 'invasive plants', 
        'animals', 'pathways', 'transportation', 
        'ecological', 'habitat restoration', 'impacts', 
        'prevention', 'climate change', 'measures', 
        'strategic', 'factors', 'trends', 
        'economic', 'challenges', 'information', 
        'communication', 'collaboration', 'stakeholders', 
        'monitoring programs', 'surveys', 'case studies', 
        'outcomes', 'knowledge', 'interventions', 
        'ecosystem balance', 'guidelines', 'rehabilitation', 
        'studies', 'patterns', 'risk assessment', 
        'response', 'analysis', 'environmental health', 
        'control methods', 'policies', 'restoration ecology', 
        'impact assessment', 'awareness', 'integration'
    ]],
    
    
'landscape_architecture' => [
    'title_id' => 208,
    'words' => [
        'landscape', 'architecture', 'design', 'urban', 
        'planning', 'environment', 'green', 'space', 
        'sustainability', 'nature', 'gardens', 
        'outdoor', 'public', 'space', 
        'restoration', 'ecosystem', 'functionality', 
        'aesthetics', 'community', 'infrastructure', 
        'development', 'preservation', 'project', 
        'biophilia', 'site', 'analysis', 
        'water', 'conservation', 'land', 
        'form', 'elements', 'sustainability practices', 
        'vegetation', 'ecological', 'regulations', 
        'transportation', 'socioeconomic', 'impact', 
        'research', 'strategies', 'interventions', 
        'collaboration', 'outcomes', 'design principles', 
        'features', 'improvements', 'art', 
        'habitat', 'wellness', 'culture', 
        'socioeconomic factors', 'trends', 'insights', 
        'professionals', 'techniques', 'implementation', 
        'education', 'knowledge', 'community involvement', 
        'awareness', 'green infrastructure', 'functional', 
        'integration', 'accessibility', 'environmental', 
        'criteria', 'exploration', 'maintenance', 
        'water management', 'design elements', 'nature-based', 
        'ecosystem services', 'social', 'networks', 
        'monitoring', 'adaptive', 'development', 
        'public health', 'environmental health', 
        'landscape planning', 'case studies', 'projects', 
        'case study', 'analysis', 'interaction', 
        'guidelines', 'processes', 'indicators', 
        'services', 'balance', 'frameworks', 
        'opportunities', 'community resilience', 
        'engagement', 'public spaces', 'creativity', 
        'safety', 'standards', 'functions', 
        'education', 'outcomes', 'collaboration', 
        'design thinking', 'projects', 'urban planning', 
        'implementation', 'criteria', 'challenges', 
        'projects', 'fields', 'transformations'
    ]],
    
    
'marine_conservation' => [
    'title_id' => 209,
    'words' => [
        'marine', 'conservation', 'ocean', 'species', 
        'ecosystem', 'environment', 'biodiversity', 
        'sustainability', 'wildlife', 'habitat', 
        'protection', 'research', 'regulation', 
        'policy', 'management', 'restoration', 
        'threats', 'fishing', 'pollution', 
        'coastal', 'marine protected areas', 'resources', 
        'conservation strategies', 'advocacy', 'stakeholders', 
        'oceanography', 'biological', 'diversity', 
        'population', 'ecosystem services', 'awareness', 
        'monitoring', 'rehabilitation', 'community', 
        'participation', 'education', 'sustainability practices', 
        'data', 'collaboration', 'initiatives', 
        'legislation', 'awareness', 'conservation efforts', 
        'marine habitats', 'socioeconomic', 'impact', 
        'ecosystem health', 'science', 'marine resources', 
        'wildlife corridors', 'migrations', 'coastal management', 
        'environmental', 'organizations', 'projects', 
        'invasive species', 'fisheries', 'sustainable practices', 
        'outcomes', 'initiatives', 'community engagement', 
        'marine ecosystems', 'interventions', 'challenges', 
        'approaches', 'solutions', 'restoration ecology', 
        'species recovery', 'monitoring programs', 'field studies', 
        'data collection', 'regulations', 'outreach', 
        'collaborative', 'actions', 'conservation biology', 
        'indicators', 'coastal zones', 'programs', 
        'research initiatives', 'management plans', 
        'habitat protection', 'sustainability initiatives', 
        'marine science', 'ocean conservation', 'advancements', 
        'networks', 'technologies', 'educational', 
        'restoration projects', 'ecosystem resilience', 
        'measures', 'collaborations', 'data analysis', 
        'strategies', 'initiatives', 'advocacy', 
        'impact assessments', 'communities', 'knowledge', 
        'public awareness', 'monitoring techniques', 
        'approaches', 'habitat restoration', 'long-term', 
        'short-term', 'interdisciplinary', 'knowledge sharing'
    ]],
    
    
'membrane_technology' => [
    'title_id' => 210,
    'words' => [
        'membrane', 'technology', 'water', 'filtration', 
        'separation', 'chemical', 'treatment', 'materials', 
        'system', 'process', 'purification', 'applications', 
        'research', 'innovation', 'performance', 
        'efficiency', 'membrane processes', 'reverse osmosis', 
        'nanofiltration', 'microfiltration', 'ultrafiltration', 
        'ionic', 'selectivity', 'sustainability', 
        'crossflow', 'configuration', 'biomembrane', 
        'organic', 'inorganic', 'coating', 
        'modules', 'design', 'construction', 
        'compatibility', 'characteristics', 'polymers', 
        'membrane fouling', 'cleaning', 'maintenance', 
        'cost', 'optimization', 'safety', 
        'analysis', 'monitoring', 'quality', 
        'regulations', 'standards', 'testing', 
        'scalability', 'energy', 'recovery', 
        'environmental', 'processes', 'industrial', 
        'wastewater', 'treatment', 'effluent', 
        'solvents', 'gas', 'exchange', 
        'applications', 'performance', 'developments', 
        'technology integration', 'challenges', 'solutions', 
        'research and development', 'strategies', 
        'characterization', 'system efficiency', 
        'fluid dynamics', 'optimization', 'system design', 
        'characterization', 'feed', 'permeate', 
        'retentate', 'pressure', 'flow', 
        'mechanisms', 'transport', 'utilization', 
        'pathways', 'process parameters', 'framework', 
        'functionalization', 'molecular', 'scale', 
        'improvements', 'dimensions', 'formulations', 
        'environmental impact', 'resource', 
        'desalination', 'purification', 'characteristics', 
        'material properties', 'integration', 'feedback', 
        'performance metrics', 'process optimization', 
        'research findings', 'advanced', 'integration', 
        'monitoring techniques', 'data', 'outcomes'
    ]],
    
    
'microfluidics' => [
    'title_id' => 211,
    'words' => [
        'microfluidics', 'fluid', 'lab-on-a-chip', 'biotechnology', 
        'research', 'cell', 'molecule', 'chemistry', 
        'diagnostics', 'channels', 'devices', 
        'applications', 'samples', 'analysis', 
        'techniques', 'systems', 'integration', 
        'design', 'control', 'performance', 
        'manipulation', 'fabrication', 'precision', 
        'automation', 'processes', 'droplets', 
        'surface', 'properties', 'reaction', 
        'transport', 'integration', 'microfabrication', 
        'methods', 'platforms', 'diagnostic', 
        'assays', 'optimization', 'sensitivity', 
        'specificity', 'parameters', 'measurements', 
        'microstructures', 'sensing', 'reagents', 
        'outputs', 'input', 'microchannels', 
        'prototyping', 'stability', 'cost', 
        'testing', 'environment', 'technology', 
        'biochemical', 'research', 'data', 
        'features', 'interactions', 'devices', 
        'flow', 'patterns', 'scalability', 
        'characterization', 'integration', 'functionality', 
        'cellular', 'applications', 'automation', 
        'fabrication techniques', 'nanotechnology', 
        'fluids', 'chemicals', 'samples', 
        'biomedical', 'development', 'investigation', 
        'outputs', 'feedback', 'evaluation', 
        'understanding', 'monitoring', 'evolution', 
        'objectives', 'collaborations', 'advancements', 
        'challenges', 'success', 'interaction', 
        'mechanisms', 'technologies', 'models', 
        'interdisciplinary', 'knowledge', 'results', 
        'frameworks', 'analysis', 'efficiency', 
        'insights', 'research findings', 'understanding', 
        'testing methods', 'fluidic', 'innovations', 
        'capacity', 'applications', 'strategies', 
        'development', 'methodologies', 'integration'
    ]],
    
    
'molecular_diagnostics' => [
    'title_id' => 212,
    'words' => [
        'diagnostics', 'molecular', 'biology', 'disease', 
        'genetics', 'research', 'biotechnology', 
        'testing', 'medicine', 'analysis', 
        'techniques', 'assays', 'biomarkers', 
        'samples', 'methodologies', 'detection', 
        'applications', 'technology', 'genomic', 
        'pathogens', 'treatment', 'screening', 
        'clinical', 'data', 'outcomes', 
        'laboratory', 'protocols', 'identification', 
        'investigation', 'development', 'platforms', 
        'therapeutics', 'sensitivity', 'specificity', 
        'validation', 'innovation', 'results', 
        'automation', 'parameters', 'bioinformatics', 
        'molecular techniques', 'experiments', 
        'evaluation', 'efficacy', 'monitoring', 
        'research', 'insights', 'objectives', 
        'interdisciplinary', 'approaches', 'safety', 
        'advancements', 'quality', 'collaboration', 
        'biochemical', 'evaluation', 'characterization', 
        'samples', 'feedback', 'strategies', 
        'screening', 'clinical trials', 'technology', 
        'outreach', 'investigations', 'biological', 
        'mechanisms', 'improvement', 'assistance', 
        'guidelines', 'decision-making', 'integration', 
        'challenges', 'biological systems', 
        'applications', 'data analysis', 
        'education', 'knowledge', 'clinical settings', 
        'trials', 'research initiatives', 'testing methods', 
        'results', 'trends', 'variables', 
        'tools', 'biotechnology applications', 'research', 
        'practices', 'monitoring', 'outcomes', 
        'strategies', 'results', 'understanding', 
        'characteristics', 'analytical', 'parameters', 
        'hypotheses', 'advocacy', 'applications', 
        'insights', 'improvements', 'collaborations'
    ]],
    
    
'neurogenetics' => [
    'title_id' => 213,
    'words' => [
        'genetics', 'neuroscience', 'neurogenetics', 'DNA', 
        'mutation', 'brain', 'disease', 'research', 
        'neurology', 'genes', 'chromosomes', 'neural', 
        'pathways', 'expression', 'cognition', 
        'disorders', 'development', 'function', 
        'psychology', 'behavior', 'biomarkers', 
        'genomic', 'studies', 'heredity', 
        'phenotype', 'risk', 'factors', 
        'clinical', 'applications', 'therapy', 
        'inheritance', 'imaging', 'technology', 
        'proteins', 'neurotransmitters', 'analyses', 
        'associations', 'targets', 'outcomes', 
        'investigations', 'interventions', 'methodologies', 
        'analysis', 'molecular', 'systems', 
        'population', 'studies', 'environment', 
        'epigenetics', 'molecular biology', 'pharmacogenetics', 
        'neural networks', 'advancements', 'insights', 
        'data', 'tools', 'models', 
        'approaches', 'collaboration', 'biological', 
        'observations', 'exploration', 'clinical trials', 
        'detection', 'responses', 'symptoms', 
        'effects', 'mechanisms', 'enhancements', 
        'outcomes', 'feedback', 'information', 
        'therapeutics', 'interdisciplinary', 'investments', 
        'characterization', 'parameters', 'testing', 
        'studies', 'communication', 'contributions', 
        'knowledge', 'analysis', 'mechanisms', 
        'integration', 'variables', 'applications', 
        'training', 'resources', 'advocacy', 
        'education', 'public awareness', 'projects', 
        'strategies', 'results', 'understanding', 
        'characteristics', 'evidence', 'outreach', 
        'investigations', 'support', 'development'
    ]],
    
    
'nuclear_medicine' => [
    'title_id' => 214,
    'words' => [
        'medicine', 'nuclear', 'radiology', 'imaging', 
        'treatment', 'research', 'cancer', 'diagnosis', 
        'radiation', 'therapy', 'radioisotope', 
        'procedures', 'scintigraphy', 'SPECT', 
        'PET', 'biomedical', 'nuclear imaging', 
        'pharmaceuticals', 'evaluation', 'protocols', 
        'radiopharmaceuticals', 'technology', 'clinical', 
        'applications', 'healthcare', 'dose', 
        'safety', 'risk', 'assessment', 
        'results', 'outcomes', 'parameters', 
        'sensitivity', 'specificity', 'investigation', 
        'analysis', 'functions', 'effects', 
        'diagnostic', 'equipment', 'techniques', 
        'interventions', 'radiation therapy', 'monitoring', 
        'studies', 'practices', 'clinical trials', 
        'advancements', 'insights', 'interdisciplinary', 
        'impact', 'outreach', 'standards', 
        'guidelines', 'protocol', 'collaboration', 
        'community', 'diagnostic imaging', 
        'biological', 'mechanisms', 'characterization', 
        'supply', 'spectrum', 'radiation protection', 
        'technology integration', 'analysis tools', 
        'methodologies', 'support', 'resources', 
        'knowledge', 'feedback', 'safety measures', 
        'evaluation', 'education', 'awareness', 
        'training', 'applications', 'case studies', 
        'strategies', 'governance', 'discoveries', 
        'outcomes', 'disorders', 'consultation', 
        'techniques', 'therapy planning', 'prognosis', 
        'nuclear physics', 'evidence', 'data', 
        'infrastructure', 'treatment planning', 
        'communication', 'recommendations', 
        'health outcomes', 'exploration', 'integration', 
        'factors', 'development', 'investments', 
        'decisions', 'public health', 'dissemination', 
        'network', 'systems', 'improvement'
    ]],
    
    
'nuclear_physics' => [
    'title_id' => 215,
    'words' => [
        'physics', 'nuclear', 'energy', 'particles', 
        'atom', 'research', 'radiation', 'reactor', 
        'quantum', 'fission', 'fusion', 'isotopes', 
        'decay', 'interaction', 'neutrons', 
        'protons', 'electrons', 'matter', 'forces', 
        'theory', 'models', 'nucleus', 
        'reactions', 'cross-section', 'accelerators', 
        'studies', 'applications', 'experiments', 
        'field', 'processes', 'nuclear energy', 
        'technology', 'cosmic', 'radiochemistry', 
        'particles', 'gamma', 'spectroscopy', 
        'nuclear structure', 'ionization', 'binding', 
        'thermodynamics', 'mechanics', 'energy levels', 
        'interactions', 'collisions', 'equations', 
        'calculations', 'neutron capture', 
        'nuclear reactor', 'stability', 'radioactive', 
        'field', 'oscillation', 'quantum mechanics', 
        'applications', 'theories', 'phenomena', 
        'scattering', 'nuclear physics research', 
        'safety', 'policy', 'innovations', 
        'calculations', 'equilibrium', 'wave', 
        'vibrations', 'statistics', 'discovery', 
        'measurements', 'studies', 'developments', 
        'energy production', 'high-energy', 
        'scientific', 'collaborations', 'observations', 
        'data', 'methods', 'strategies', 
        'testing', 'modeling', 'thermonuclear', 
        'nuclear weapons', 'geophysical', 'nuclear stability', 
        'environmental', 'nuclear power', 
        'proposals', 'regulations', 'factors', 
        'future', 'energy resources', 'theoretical', 
        'dynamics', 'fields', 'collaboration', 
        'impact', 'knowledge', 'education', 
        'research initiatives', 'challenges', 
        'advancements', 'frameworks', 'sustainability', 
        'innovation', 'analysis', 'monitoring', 
        'problems', 'case studies', 'governance'
    ]],
    
    
'ocean_engineering' => [
    'title_id' => 216,
    'words' => [
        'ocean', 'engineering', 'marine', 'technology', 
        'vessel', 'research', 'waves', 'coastal', 
        'exploration', 'design', 'structures', 
        'dynamics', 'navigation', 'environment', 
        'systems', 'development', 'resources', 
        'management', 'data', 'monitoring', 
        'sustainability', 'methods', 'innovations', 
        'applications', 'analysis', 'impact', 
        'environmental', 'solutions', 'transportation', 
        'platforms', 'construction', 'projects', 
        'safety', 'performance', 'regulations', 
        'protocols', 'collaboration', 'challenges', 
        'investigations', 'infrastructure', 'energy', 
        'submarine', 'equipment', 'operations', 
        'testing', 'studies', 'techniques', 
        'hydrodynamics', 'tides', 'currents', 
        'marine systems', 'integration', 'systems thinking', 
        'tools', 'field', 'education', 
        'knowledge', 'stakeholders', 'factors', 
        'collaboration', 'advancements', 'insights', 
        'improvements', 'understanding', 'dynamics', 
        'coastal management', 'frameworks', 'interventions', 
        'research initiatives', 'outcomes', 'designs', 
        'characteristics', 'innovative', 'practices', 
        'investments', 'safety measures', 'evaluations', 
        'proposals', 'governance', 'development', 
        'methodologies', 'tools', 'models', 
        'collaborations', 'community', 'applications', 
        'efficiency', 'data collection', 'standards', 
        'imaging', 'parameters', 'systems design', 
        'inspections', 'assessment', 'experience', 
        'feedback', 'strategic planning', 'case studies', 
        'outreach', 'educational', 'technological', 
        'social', 'environmental challenges', 'future'
    ]],
    
    
'paleoclimatology' => [
    'title_id' => 217,
    'words' => [
        'climate', 'paleoclimatology', 'geology', 'fossil', 
        'earth', 'research', 'temperature', 'carbon', 
        'dating', 'ice', 'core', 'proxy', 
        'data', 'environment', 'periods', 
        'historical', 'changes', 'atmosphere', 
        'patterns', 'archives', 'sediments', 
        'analysis', 'variability', 'records', 
        'oxygen', 'isotopes', 'proxy data', 
        'sea', 'level', 'glacial', 'interglacial', 
        'periods', 'samples', 'dynamics', 
        'ecosystem', 'land', 'surfaces', 
        'temperature changes', 'historical climate', 
        'understanding', 'factors', 'variations', 
        'research methods', 'collaboration', 'interpretation', 
        'studies', 'techniques', 'models', 
        'hypotheses', 'carbon cycle', 'instruments', 
        'findings', 'environmental', 'evidence', 
        'geochemical', 'exploration', 'mechanisms', 
        'processes', 'insights', 'paleoenvironment', 
        'outcomes', 'events', 'analysis', 
        'ecosystem changes', 'contributions', 'data collection', 
        'methods', 'adaptation', 'archaeological', 
        'community', 'education', 'monitoring', 
        'awareness', 'impacts', 'knowledge', 
        'outreach', 'synthesis', 'evaluations', 
        'reconstruction', 'understanding', 'feedback', 
        'publications', 'advancements', 'collaborative', 
        'frameworks', 'future', 'investigations', 
        'testing', 'practices', 'patterns', 
        'elements', 'measures', 'discovery', 
        'interdisciplinary', 'applications', 'challenges', 
        'data analysis', 'long-term', 'short-term', 
        'implications', 'research initiatives', 'outcomes', 
        'science', 'tools', 'strategies', 
        'environmental impact', 'characteristics', 
        'modeling', 'public engagement', 'variables'
    ]],
    
    
'phytochemistry' => [
    'title_id' => 218,
    'words' => [
        'plant', 'chemistry', 'phytochemistry', 'compounds', 
        'research', 'biochemistry', 'medicine', 
        'extraction', 'bioactive', 'metabolites', 
        'secondary', 'chemical', 'analysis', 
        'botany', 'processes', 'properties', 
        'natural', 'sources', 'active', 
        'phytochemicals', 'screening', 'characterization', 
        'applications', 'plant extracts', 'techniques', 
        'formation', 'pathways', 'testing', 
        'substances', 'environment', 'development', 
        'molecules', 'agriculture', 'nutrition', 
        'benefits', 'products', 'studies', 
        'evidence', 'toxicology', 'indigenous', 
        'plant species', 'health', 'enhancements', 
        'isolation', 'safety', 'conservation', 
        'treatment', 'therapeutics', 'beneficial', 
        'chemical properties', 'synthesis', 'investigation', 
        'outcomes', 'interactions', 'variables', 
        'toxicity', 'preservation', 'screening methods', 
        'collaboration', 'insights', 'indications', 
        'clinical', 'analytical', 'innovation', 
        'systems', 'monitoring', 'integration', 
        'exploration', 'health benefits', 'research initiatives', 
        'ecology', 'environmental', 'discovery', 
        'knowledge', 'protocols', 'evaluation', 
        'guidelines', 'education', 'community', 
        'advocacy', 'awareness', 'information', 
        'improvement', 'feedback', 'techniques', 
        'molecular', 'factors', 'sustainability', 
        'advancements', 'performance', 'case studies', 
        'approaches', 'strategies', 'challenges', 
        'practices', 'investigations', 'case study', 
        'methodologies', 'technology', 'detection', 
        'evidence-based', 'characteristics', 'utilization', 
        'measurement', 'efficacy', 'resources', 
        'analysis', 'application', 'inspections'
    ]],
    
    
'prosthetics' => [
    'title_id' => 219,
    'words' => [
        'prosthetics', 'artificial', 'limb', 'technology', 
        'rehabilitation', 'mobility', 'engineering', 
        'design', 'medical', 'devices', 
        'functionality', 'innovation', 'materials', 
        'components', 'fitting', 'adaptation', 
        'customization', 'support', 'patient', 
        'therapy', 'performance', 'biomechanics', 
        'integration', 'testing', 'mechanisms', 
        'development', 'enhancements', 'applications', 
        'comfort', 'alignment', 'sensors', 
        'feedback', 'data', 'precision', 
        'improvements', 'movement', 'usage', 
        'assessment', 'clinical', 'approaches', 
        'evaluation', 'rehabilitative', 'outcomes', 
        'interventions', 'research', 'standards', 
        'trials', 'adaptations', 'challenges', 
        'education', 'knowledge', 'community', 
        'collaboration', 'awareness', 'projects', 
        'impact', 'quality', 'experience', 
        'guidelines', 'practices', 'insights', 
        'supportive', 'structures', 'tools', 
        'processes', 'advancements', 'characteristics', 
        'sustainability', 'systematic', 'models', 
        'collaboration', 'testing methods', 'technological', 
        'factors', 'designs', 'research initiatives', 
        'materials science', 'engineering techniques', 
        'publications', 'implementation', 'strategies', 
        'monitoring', 'resources', 'feedback', 
        'indicators', 'clinical settings', 'innovation', 
        'technical', 'rehabilitation technology', 'analysis', 
        'applications', 'community engagement', 'public health', 
        'workshops', 'education', 'training', 
        'understanding', 'improvements', 'integration', 
        'functions', 'dynamics', 'variables'
    ]],
    
    
'quantum_biology' => [
    'title_id' => 220,
    'words' => [
        'quantum', 'biology', 'molecules', 'research', 
        'physics', 'DNA', 'photosynthesis', 'energy', 
        'mechanics', 'interactions', 'systems', 
        'particles', 'mechanisms', 'processes', 
        'theory', 'experiments', 'applications', 
        'biophysics', 'light', 'wave', 
        'biological', 'functions', 'analyses', 
        'pathways', 'dynamics', 'spectroscopy', 
        'molecular', 'structures', 'emissions', 
        'state', 'consequences', 'variables', 
        'energy transfer', 'information', 'theoretical', 
        'techniques', 'outcomes', 'observations', 
        'phenomena', 'effects', 'measurements', 
        'models', 'ecosystems', 'development', 
        'integration', 'insights', 'feedback', 
        'collaboration', 'understanding', 'challenges', 
        'interdisciplinary', 'approaches', 'advancements', 
        'computational', 'evolution', 'adaptation', 
        'conservation', 'strategies', 'studies', 
        'biological systems', 'quantum effects', 
        'energy states', 'transitions', 'characterization', 
        'data', 'hypotheses', 'investigations', 
        'biological interactions', 'field', 'applications', 
        'research initiatives', 'sustainability', 
        'pathway analysis', 'feedback', 'environment', 
        'climate', 'systems thinking', 'innovations', 
        'knowledge', 'modeling', 'understanding', 
        'collaborations', 'frameworks', 'observational', 
        'factors', 'variables', 'research fields', 
        'predictions', 'investments', 'practices', 
        'evidence', 'discoveries', 'integration', 
        'publications', 'mechanical', 'energy conversion', 
        'tools', 'methods', 'reactions', 
        'training', 'systems', 'fields', 
        'analysis', 'outcomes', 'results'
    ]],
    
    
'renewable_resources' => [
    'title_id' => 221,
    'words' => [
        'resources', 'renewable', 'sustainability', 'environment', 
        'energy', 'conservation', 'green', 'management', 
        'future', 'solar', 'wind', 'hydropower', 
        'biomass', 'geothermal', 'efficiency', 'innovation', 
        'technology', 'sustainable', 'development', 
        'impact', 'applications', 'systems', 
        'practices', 'strategies', 'policies', 
        'education', 'awareness', 'community', 
        'initiatives', 'alternatives', 'investments', 
        'economy', 'projects', 'resources management', 
        'implementation', 'partnerships', 'collaboration', 
        'research', 'data', 'analysis', 
        'monitoring', 'feedback', 'frameworks', 
        'assessments', 'outcomes', 'challenges', 
        'interventions', 'benefits', 'reduction', 
        'carbon', 'footprint', 'advancements', 
        'models', 'processes', 'knowledge', 
        'regulations', 'evaluation', 'impacts', 
        'technologies', 'system', 'integration', 
        'usage', 'patterns', 'approaches', 
        'infrastructure', 'engagement', 'network', 
        'trends', 'governance', 'decision-making', 
        'support', 'resources efficiency', 'innovation', 
        'sustainable practices', 'publications', 'case studies', 
        'outreach', 'education', 'field', 
        'economics', 'investments', 'research initiatives', 
        'conservation practices', 'public health', 
        'collaboration', 'initiatives', 'challenges', 
        'strategies', 'results', 'developments', 
        'transformations', 'solutions', 'indicators', 
        'effects', 'environmental', 'systems thinking', 
        'metrics', 'activities', 'associations', 
        'evidence', 'experiments', 'exploration', 
        'planning', 'systems design', 'knowledge sharing'
    ]],
    
    
'science_policy' => [
    'title_id' => 222,
    'words' => [
        'science', 'policy', 'research', 'government', 
        'technology', 'innovation', 'funding', 
        'development', 'regulation', 'collaboration', 
        'assessment', 'evaluation', 'framework', 
        'impact', 'strategy', 'programs', 
        'data', 'analysis', 'priorities', 
        'resources', 'support', 'legislation', 
        'public', 'engagement', 'advocacy', 
        'science communication', 'knowledge', 'training', 
        'community', 'initiatives', 'interdisciplinary', 
        'approaches', 'challenges', 'sustainability', 
        'outcomes', 'strategies', 'implementation', 
        'monitoring', 'governance', 'networking', 
        'research initiatives', 'technology transfer', 
        'evidence-based', 'decisions', 'partnerships', 
        'outreach', 'impact assessments', 'practices', 
        'innovation ecosystems', 'scientific', 'collaboration', 
        'opportunities', 'trends', 'future', 
        'investments', 'regulatory', 'frameworks', 
        'policy development', 'knowledge sharing', 
        'scientific research', 'evaluation metrics', 
        'education', 'public policy', 'interactions', 
        'integration', 'best practices', 'studies', 
        'environmental', 'resources allocation', 
        'factors', 'advancements', 'impacts', 
        'evaluation processes', 'collaborative', 
        'recommendations', 'insights', 'tools', 
        'practices', 'interests', 'network', 
        'field', 'support mechanisms', 'scientific literacy', 
        'public understanding', 'policy analysis', 
        'outcomes assessment', 'knowledge gaps', 
        'research funding', 'advocacy efforts', 
        'decisions making', 'education programs', 
        'influence', 'capacity building', 'dialogue', 
        'participation', 'assessments', 'initiatives', 
        'exploration', 'resource management', 
        'research agendas', 'information dissemination', 
        'policy frameworks', 'collaborative research', 
        'approaches', 'action plans', 'insights', 
        'stakeholders', 'associations', 'monitoring', 
        'case studies', 'analysis', 'program development'
    ]],
    
    
'sensory_neuroscience' => [
    'title_id' => 223,
    'words' => [
        'neuroscience', 'sensory', 'brain', 'nerves', 
        'perception', 'research', 'stimulus', 'cognition', 
        'behavior', 'neurons', 'signals', 'pathways', 
        'response', 'processing', 'awareness', 
        'sensation', 'receptors', 'inputs', 
        'outputs', 'feedback', 'dynamics', 
        'mechanisms', 'studies', 'assessments', 
        'functions', 'connections', 'transmission', 
        'analysis', 'applications', 'disorders', 
        'environment', 'experiments', 'factors', 
        'activation', 'integration', 'development', 
        'circuitry', 'systems', 'behavioral', 
        'interactions', 'exploration', 'insights', 
        'responses', 'learning', 'memory', 
        'cognitive', 'neural networks', 'patterns', 
        'improvements', 'frameworks', 'techniques', 
        'experiments', 'clinical', 'outcomes', 
        'initiatives', 'models', 'data', 
        'field', 'influence', 'knowledge', 
        'collaboration', 'education', 'advancements', 
        'awareness', 'research initiatives', 'strategies', 
        'stimuli', 'processing', 'behavioral studies', 
        'neurotransmitters', 'evaluation', 'trials', 
        'mechanics', 'tools', 'evaluation', 
        'communication', 'systematic', 'evidence', 
        'associations', 'interdisciplinary', 'therapeutics', 
        'exploratory', 'observational', 'technology', 
        'advancements', 'research findings', 
        'impact assessments', 'assessment', 'development', 
        'educational', 'collaborative', 'participation', 
        'environmental', 'social', 'cultural', 
        'communities', 'evolution', 'training', 
        'knowledge sharing', 'data analysis', 
        'understanding', 'interventions', 'factors', 
        'observations', 'theoretical', 'concepts', 
        'strategies', 'insights', 'fields', 
        'programs', 'approaches', 'research fields'
    ]],
    
    
'sociocultural_anthropology' => [
    'title_id' => 224,
    'words' => [
        'anthropology', 'culture', 'society', 'sociocultural', 
        'ethnography', 'community', 'tradition', 
        'research', 'identity', 'practices', 
        'norms', 'values', 'beliefs', 
        'customs', 'interactions', 'diversity', 
        'socialization', 'integration', 'fieldwork', 
        'analysis', 'processes', 'participation', 
        'historical', 'context', 'phenomena', 
        'symbolism', 'communication', 'frameworks', 
        'approaches', 'insights', 'perspectives', 
        'influence', 'relations', 'patterns', 
        'social structures', 'language', 'dynamics', 
        'systems', 'observations', 'experiences', 
        'identity formation', 'constructs', 'methodologies', 
        'traditions', 'social behavior', 'adaptation', 
        'roles', 'representations', 'exchange', 
        'transitions', 'community engagement', 'cultural practices', 
        'social issues', 'outcomes', 'impacts', 
        'development', 'framework', 'advocacy', 
        'dialogue', 'interdisciplinary', 'collaboration', 
        'case studies', 'theories', 'knowledge', 
        'local', 'global', 'traditions', 
        'encounters', 'identities', 'narratives', 
        'relationships', 'settings', 'transformation', 
        'contemporary', 'heritage', 'engagement', 
        'methodologies', 'insights', 'dimensions', 
        'indigenous', 'social change', 'integration', 
        'advancements', 'practices', 'community dynamics', 
        'research findings', 'publications', 'frameworks', 
        'field studies', 'ethnocentrism', 'multiculturalism', 
        'education', 'training', 'collaborations', 
        'cultural evolution', 'knowledge sharing', 
        'interactions', 'values', 'social structures', 
        'symbolic', 'analysis', 'collective', 
        'sustainable', 'exploration', 'definitions'
    ]],
    
    
'sports_psychology' => [
    'title_id' => 225,
    'words' => [
        'sports', 'psychology', 'performance', 'athletes', 
        'behavior', 'motivation', 'training', 'cognition', 
        'mental', 'health', 'focus', 'emotions', 
        'skills', 'techniques', 'strategy', 
        'teamwork', 'resilience', 'mindset', 
        'confidence', 'pressure', 'goals', 
        'improvement', 'attitude', 'visualization', 
        'feedback', 'anxiety', 'stress', 
        'concentration', 'success', 'exercise', 
        'wellness', 'commitment', 'discipline', 
        'dynamics', 'challenges', 'recovery', 
        'self-talk', 'support', 'environment', 
        'individuals', 'performance enhancement', 'techniques', 
        'coaching', 'training programs', 'research', 
        'mental skills', 'evaluation', 'intervention', 
        'motivation techniques', 'psychological', 'focus', 
        'performance anxiety', 'team dynamics', 'self-esteem', 
        'behavioral techniques', 'training methods', 'athletic', 
        'optimism', 'evaluation techniques', 'coaching methods', 
        'mindfulness', 'distraction', 'engagement', 
        'goal-setting', 'sportsmanship', 'motivation theory', 
        'personal development', 'well-being', 'habits', 
        'interpersonal', 'team performance', 'cognitive', 
        'adaptation', 'practice', 'attitude', 
        'physical health', 'performance psychology', 
        'social factors', 'development', 'learning', 
        'self-regulation', 'achievement', 'research findings', 
        'publications', 'case studies', 'experiments', 
        'outcomes', 'insights', 'strategies', 
        'cohesion', 'effectiveness', 'practices', 
        'individual performance', 'cultural', 'performance training', 
        'techniques', 'monitoring', 'goal achievement', 
        'resilience training', 'collaboration', 'training techniques'
    ]],
    
    
'structural_biology' => [
    'title_id' => 226,
    'words' => [
        'biology', 'structure', 'protein', 'DNA', 
        'research', 'cell', 'molecule', 'biochemistry', 
        'molecular', 'models', 'analysis', 'techniques', 
        'crystallography', 'spectroscopy', 'interaction', 
        'dynamics', 'components', 'systems', 
        'function', 'design', 'characterization', 
        'folding', 'networks', 'pathways', 
        'data', 'methods', 'mechanisms', 
        'expression', 'identification', 'development', 
        'instruments', 'assays', 'applications', 
        'theories', 'investigation', 'visualization', 
        'characteristics', 'functional', 'bioinformatics', 
        'studies', 'subunits', 'interactions', 
        'bioengineering', 'expression', 'synthesis', 
        'molecular dynamics', 'structures', 'fields', 
        'biological', 'reactions', 'tools', 
        'experiments', 'samples', 'protocols', 
        'frameworks', 'advancements', 'insights', 
        'research initiatives', 'knowledge', 'collaboration', 
        'evaluation', 'standards', 'discovery', 
        'collaboration', 'parameters', 'monitoring', 
        'integrated', 'community', 'scientific', 
        'integration', 'feedback', 'support', 
        'technology', 'education', 'training', 
        'engagement', 'challenges', 'investments', 
        'results', 'metrics', 'performance', 
        'contribution', 'approaches', 'interdisciplinary', 
        'applications', 'concepts', 'theoretical', 
        'evidence', 'systems biology', 'integration', 
        'biomolecular', 'quantitative', 'dynamics', 
        'assessments', 'problems', 'insights', 
        'advancements', 'tools', 'biophysical', 
        'characterization', 'efficacy', 'applications', 
        'proposals', 'strategies', 'research findings', 
        'fieldwork', 'publications', 'data analysis'
    ]],
    
    
'sustainable_architecture' => [
    'title_id' => 227,
    'words' => [
        'architecture', 'sustainability', 'design', 'environment', 
        'green building', 'energy', 'materials', 'urban', 
        'development', 'efficiency', 'renewable', 'resources', 
        'construction', 'innovation', 'planning', 
        'waste', 'management', 'climate', 
        'impact', 'community', 'technology', 
        'regulations', 'aesthetics', 'bioclimatic', 
        'low-carbon', 'adaptation', 'comfort', 
        'outcomes', 'environmental', 'monitoring', 
        'integration', 'landscaping', 'local', 
        'infrastructure', 'energy-efficient', 'resilience', 
        'biomimicry', 'approaches', 'design strategies', 
        'water', 'harvesting', 'materiality', 'transportation', 
        'urbanization', 'performance', 'health', 
        'well-being', 'construction methods', 'resources management', 
        'collaboration', 'research', 'innovation', 
        'education', 'awareness', 'advocacy', 
        'community engagement', 'circular', 'economy', 
        'outreach', 'feedback', 'projects', 
        'planning', 'fieldwork', 'evaluation', 
        'strategies', 'case studies', 'publications', 
        'guidelines', 'design principles', 'green roofs', 
        'solar', 'energy production', 'factors', 
        'measurement', 'indicators', 'best practices', 
        'sustainable practices', 'experiments', 'regenerative', 
        'monitoring', 'tools', 'frameworks', 
        'sustainability assessment', 'technology integration', 
        'public spaces', 'trends', 'implementation', 
        'governance', 'land use', 'sustainable systems', 
        'design outcomes', 'field studies', 'socioeconomic', 
        'performance metrics', 'community needs', 
        'local materials', 'climatic conditions', 'knowledge', 
        'design innovation', 'future', 'solutions', 
        'applications', 'benefits', 'impacts', 
        'interdisciplinary', 'investments', 'relationships', 
        'systems thinking', 'urban ecology', 'practices', 
        'development', 'urban design', 'capacity building'
    ]],
    
    
'systems_engineering' => [
    'title_id' => 228,
    'words' => [
        'engineering', 'systems', 'design', 'technology', 
        'management', 'optimization', 'integration', 
        'processes', 'research', 'development', 
        'analysis', 'evaluation', 'methodologies', 
        'implementation', 'project', 'lifecycle', 
        'requirements', 'architecture', 'models', 
        'testing', 'documentation', 'tools', 
        'collaboration', 'stakeholders', 'performance', 
        'risk', 'assessment', 'strategies', 
        'solutions', 'feedback', 'resources', 
        'prototyping', 'evaluation metrics', 'data', 
        'metrics', 'frameworks', 'collaborative', 
        'fieldwork', 'interdisciplinary', 'approaches', 
        'development', 'insights', 'support', 
        'optimization methods', 'results', 'innovations', 
        'standards', 'guidelines', 'best practices', 
        'sustainability', 'systems thinking', 'interactions', 
        'improvements', 'inspections', 'outcomes', 
        'testing methods', 'case studies', 'technology integration', 
        'cost', 'efficiency', 'training', 
        'knowledge', 'monitoring', 'collaboration', 
        'analysis tools', 'future', 'applications', 
        'impact', 'educational', 'publications', 
        'advancements', 'design outcomes', 'requirements analysis', 
        'optimization techniques', 'performance indicators', 
        'project management', 'evaluation processes', 
        'stakeholder engagement', 'decision-making', 
        'integrated systems', 'design principles', 'systematic', 
        'risk management', 'development plans', 'resources allocation', 
        'complexity', 'communication', 'technology assessment', 
        'strategic planning', 'field', 'insights', 
        'modeling', 'information', 'integration strategies', 
        'improvement', 'outreach', 'operations', 
        'collaboration frameworks', 'transformation', 
        'knowledge transfer', 'capacity building', 'variables', 
        'monitoring systems', 'research initiatives', 'information systems'
    ]],
    
    
'tissue_engineering' => [
    'title_id' => 229,
    'words' => [
        'tissue', 'engineering', 'regeneration', 'research', 
        'cell', 'biotechnology', 'medicine', 'treatment', 
        'materials', 'scaffolds', 'cells', 'repair', 
        'growth', 'stem', 'therapy', 
        'applications', 'biomaterials', 'development', 
        'stem cells', 'transplantation', 'techniques', 
        'engineering principles', 'protocols', 'regenerative', 
        'biology', 'therapeutics', 'assessment', 
        'integration', 'biological', 'synthesis', 
        'mechanisms', 'innovation', 'models', 
        'performance', 'enhancements', 'processes', 
        'technology', 'implementation', 'evaluation', 
        'factors', 'applications', 'insights', 
        'protocols', 'design', 'in vitro', 
        'in vivo', 'testing', 'bioengineering', 
        'clinical', 'studies', 'outcomes', 
        'collaboration', 'regenerative medicine', 'strategies', 
        'knowledge', 'evaluation metrics', 'community', 
        'education', 'awareness', 'collaborative', 
        'investigations', 'clinical applications', 'advancements', 
        'sustainability', 'impact', 'futures', 
        'research initiatives', 'translational', 'data', 
        'optimization', 'monitoring', 'indications', 
        'parameters', 'best practices', 'frameworks', 
        'field studies', 'experiments', 'feedback', 
        'discovery', 'clinical trials', 'regulatory', 
        'advocacy', 'performance metrics', 'practices', 
        'training', 'tools', 'insights', 
        'education programs', 'understanding', 'field', 
        'systematic', 'community engagement', 'resources', 
        'case studies', 'improvements', 'biocompatibility', 
        'ethical considerations', 'cost', 'publications', 
        'influences', 'variables', 'collaborative research'
    ]],
    
    
'urban_mobility' => [
    'title_id' => 230,
    'words' => [
        'urban', 'mobility', 'transportation', 'city', 
        'infrastructure', 'development', 'technology', 
        'public transit', 'sustainability', 'accessibility', 
        'routes', 'systems', 'planning', 
        'commuting', 'traffic', 'pedestrian', 
        'bicycles', 'mobility solutions', 'vehicle', 
        'smart cities', 'connectivity', 'environment', 
        'transit', 'services', 'improvements', 
        'design', 'policy', 'incentives', 
        'public transport', 'integration', 'safety', 
        'green transportation', 'innovation', 'efficiency', 
        'logistics', 'community', 'challenges', 
        'solutions', 'research', 'data', 
        'analysis', 'frameworks', 'collaboration', 
        'engagement', 'strategies', 'outcomes', 
        'trends', 'investments', 'regulations', 
        'stakeholders', 'advocacy', 'initiatives', 
        'feedback', 'studies', 'resources', 
        'technology integration', 'transport networks', 
        'citizens', 'impact', 'planning processes', 
        'participation', 'public policies', 'education', 
        'awareness', 'outreach', 'urban design', 
        'local', 'global', 'transportation systems', 
        'service quality', 'socioeconomic', 'patterns', 
        'indicators', 'monitoring', 'collaborative research', 
        'safety measures', 'public spaces', 'land use', 
        'traffic management', 'community needs', 'design principles', 
        'outreach', 'public health', 'environmental', 
        'case studies', 'fieldwork', 'testing', 
        'performance metrics', 'information', 'data collection', 
        'user experience', 'approaches', 'patterns', 
        'road safety', 'monitoring systems', 'technology assessment', 
        'field studies', 'accessibility measures', 'integration strategies', 
        'improvement', 'governance', 'research findings', 
        'regulatory', 'investments', 'systematic'
    ]],
    
    
'video_game_design' => [
    'title_id' => 231,
    'words' => [
        'video game', 'design', 'development', 'graphics', 
        'programming', 'gameplay', 'engine', 'animation', 
        'interface', 'characters', 'levels', 'storyline', 
        'mechanics', 'controls', 'platform', 
        'sound', 'music', 'testing', 
        'user experience', 'environment', 'feedback', 
        'artwork', 'concept', 'prototyping', 
        'assets', 'AI', 'multiplayer', 
        'narrative', 'tools', 'frameworks', 
        'visuals', 'performance', 'optimization', 
        'user interface', 'experience', 'interactivity', 
        'storytelling', 'functionality', 'iterations', 
        'challenges', 'implementation', 'creativity', 
        'innovation', 'community', 'marketing', 
        'distribution', 'platforms', 'analysis', 
        'scripting', 'simulation', 'dynamics', 
        'architecture', 'physics', 'database', 
        'localization', 'security', 'tutorials', 
        'updates', 'collaboration', 'resources', 
        'exploration', 'immersive', 'participation', 
        'puzzles', 'AI behavior', 'progression', 
        'social', 'asynchronous', 'models', 
        'variables', 'goal setting', 'settings', 
        'virtual reality', 'augmented reality', 'games', 
        'style', 'conventions', 'research', 
        'evaluation', 'performance metrics', 'output', 
        'publishing', 'indie', 'mainstream', 
        'strategies', 'franchises', 'engagement', 
        'customization', 'demos', 'streams', 
        'market', 'analysis tools', 'field', 
        'feedback loops', 'performance tuning', 'user testing', 
        'session', 'playtesting', 'events', 
        'user demographics', 'experience design', 'prototyping tools', 
        'challenges', 'dissemination', 'agile', 
        'waterfall', 'collaboration tools', 'game engines', 
        'asset management', 'milestones', 'tutorials', 
        'updates', 'interviews', 'evaluations', 
        'fieldwork', 'case studies', 'platform integration', 
        'competitive', 'trends', 'analytics', 
        'ecosystem', 'operations', 'disruption', 
        'crossover', 'engagement metrics', 'prototyping methods'
    ]],
    
    
'water_resources' => [
    'title_id' => 232,
    'words' => [
        'water', 'resources', 'conservation', 'management', 
        'sustainability', 'infrastructure', 'ecosystem', 
        'hydrology', 'supply', 'quality', 
        'treatment', 'availability', 'distribution', 
        'monitoring', 'pollution', 'reclamation', 
        'regulations', 'usage', 'education', 
        'efficiency', 'systems', 'drainage', 
        'collection', 'storage', 'agriculture', 
        'urban', 'demand', 'projects', 
        'community', 'health', 'rainwater', 
        'irrigation', 'technologies', 'initiatives', 
        'strategies', 'awareness', 'impact', 
        'preservation', 'accessibility', 'environment', 
        'ecosystem services', 'climate', 'data', 
        'analysis', 'monitoring', 'restoration', 
        'stormwater', 'practices', 'collaboration', 
        'fieldwork', 'feedback', 'research', 
        'governance', 'partnerships', 'public policy', 
        'socioeconomic', 'development', 'outcomes', 
        'challenges', 'tools', 'funding', 
        'projects', 'indicators', 'adaptation', 
        'restoration', 'baseline', 'factors', 
        'evaluation', 'public engagement', 'field studies', 
        'innovation', 'transparency', 'participation', 
        'case studies', 'stakeholders', 'field research', 
        'action plans', 'monitoring systems', 'assessments', 
        'water quality', 'environmental health', 
        'investments', 'practices', 'protocols', 
        'methodologies', 'sustainable practices', 
        'water security', 'field studies', 'systems design', 
        'improvements', 'exploration', 'knowledge', 
        'collaborative', 'publications', 'methods', 
        'frameworks', 'education programs', 'impact assessments', 
        'dissemination', 'networking', 'regulatory', 
        'initiatives', 'stakeholder engagement', 'outreach'
    ]],
    
    
'agroforestry' => [
    'title_id' => 233,
    'words' => [
        'agriculture', 'forestry', 'sustainability', 'land use', 
        'ecosystem', 'trees', 'soil', 'conservation', 
        'cultivation', 'biodiversity', 'harvest', 'crop', 
        'intercropping', 'shade', 'management', 
        'agroecology', 'environment', 'planting', 
        'resources', 'production', 'techniques', 
        'landscaping', 'regeneration', 'water', 
        'wildlife', 'community', 'benefits', 
        'practices', 'systems', 'balance', 
        'economic', 'community engagement', 'innovation', 
        'research', 'development', 'habitat', 
        'permaculture', 'restoration', 'policy', 
        'inputs', 'outputs', 'agronomy', 
        'farming', 'landscape', 'field', 
        'climate', 'data', 'feedback', 
        'assessment', 'monitoring', 'education', 
        'training', 'knowledge', 'collaboration', 
        'case studies', 'adaptation', 'strategies', 
        'technology', 'incentives', 'fieldwork', 
        'metrics', 'ecosystem services', 'cooperation', 
        'outcomes', 'field studies', 'community benefits', 
        'yield', 'socioeconomic', 'methods', 
        'evaluation', 'factors', 'best practices', 
        'land tenure', 'stakeholders', 'participation', 
        'implementation', 'projects', 'advocacy', 
        'cultural', 'diversity', 'frameworks', 
        'publications', 'research initiatives', 'climate change', 
        'tools', 'processes', 'improvements', 
        'experiments', 'investments', 'resources management', 
        'trends', 'awareness', 'indigenous', 
        'ecological', 'collaborative', 'ecosystems', 
        'outreach', 'monitoring systems', 'regulatory', 
        'transformations', 'future', 'communication', 
        'integration', 'knowledge transfer', 'education programs', 
        'assessments', 'technical assistance', 'science', 
        'support mechanisms', 'engagement', 'solutions'
    ]],
    
    
'cognitive_science' => [
    'title_id' => 234,
    'words' => [
        'cognition', 'brain', 'science', 'behavior', 
        'learning', 'neuroscience', 'perception', 
        'research', 'psychology', 'memory', 
        'thinking', 'processing', 'intelligence', 
        'emotion', 'development', 'skills', 
        'language', 'interaction', 'analysis', 
        'attention', 'experience', 'concepts', 
        'patterns', 'decision-making', 'theories', 
        'models', 'mental processes', 'exploration', 
        'frameworks', 'insights', 'studies', 
        'outcomes', 'data', 'experiments', 
        'cognitive development', 'systems', 'strategies', 
        'neural', 'functions', 'cognitive abilities', 
        'social', 'learning styles', 'influence', 
        'environment', 'context', 'engagement', 
        'facilitation', 'adaptation', 'collaboration', 
        'methodologies', 'approaches', 'interventions', 
        'factors', 'variables', 'publications', 
        'fieldwork', 'understanding', 'integration', 
        'research initiatives', 'knowledge', 'feedback', 
        'training', 'awareness', 'evaluation', 
        'design', 'communication', 'perspectives', 
        'information', 'sociocultural', 'developmental', 
        'cognitive load', 'neuropsychology', 'insights', 
        'challenges', 'tools', 'outreach', 
        'technology', 'monitoring', 'resources', 
        'field studies', 'case studies', 'metrics', 
        'contributions', 'support', 'collaborative', 
        'education', 'cognitive functions', 'experience', 
        'projects', 'scientific', 'evaluation metrics', 
        'strategic', 'social behavior', 'exploration', 
        'learning environments', 'dimensions', 'implementation', 
        'models', 'discovery', 'impacts', 
        'knowledge sharing', 'community engagement', 'approaches'
    ]],
    
    
'cultural_psychology' => [
    'title_id' => 235,
    'words' => [
        'culture', 'psychology', 'behavior', 'society', 
        'research', 'identity', 'tradition', 'cognition', 
        'community', 'values', 'norms', 'beliefs', 
        'practices', 'interactions', 'diversity', 
        'communication', 'symbols', 'socialization', 
        'heritage', 'influence', 'perception', 
        'context', 'emotions', 'experiences', 
        'development', 'dynamics', 'integration', 
        'frameworks', 'adaptation', 'engagement', 
        'fieldwork', 'collaboration', 'education', 
        'approaches', 'insights', 'methodologies', 
        'socioeconomic', 'issues', 'inquiry', 
        'perspectives', 'understanding', 'practices', 
        'encounters', 'outcomes', 'publications', 
        'knowledge', 'assessment', 'exploration', 
        'identity formation', 'community engagement', 'contextual', 
        'influence', 'learning', 'individuals', 
        'environment', 'integration', 'social behavior', 
        'factors', 'variables', 'interdisciplinary', 
        'theories', 'feedback', 'tools', 
        'involvement', 'information', 'discourse', 
        'policy', 'strategies', 'analysis', 
        'impact', 'collaborative', 'evaluation', 
        'communication', 'social systems', 'adaptation', 
        'developmental', 'insights', 'support', 
        'experiments', 'identity studies', 'programs', 
        'traditions', 'knowledge sharing', 'evidence', 
        'participation', 'research initiatives', 'case studies', 
        'collaborative research', 'patterns', 'metrics', 
        'exploration', 'interactions', 'community dynamics', 
        'monitoring', 'assessments', 'applications', 
        'cultural heritage', 'relationships', 'socio-cultural', 
        'experience', 'public engagement', 'knowledge transfer'
    ]],
    
    
'development_economics' => [
    'title_id' => 236,
    'words' => [
        'economics', 'development', 'poverty', 'resources', 
        'policy', 'growth', 'finance', 'market', 
        'trade', 'sustainability', 'investment', 'income', 
        'inequality', 'employment', 'economic', 
        'community', 'infrastructure', 'innovation', 
        'strategies', 'research', 'evaluation', 
        'impact', 'collaboration', 'access', 
        'programs', 'governance', 'environment', 
        'capital', 'indicators', 'disparities', 
        'challenges', 'international', 'aid', 
        'outcomes', 'planning', 'agriculture', 
        'industry', 'human development', 'education', 
        'participation', 'regulations', 'social', 
        'socioeconomic', 'systematic', 'analysis', 
        'frameworks', 'approaches', 'case studies', 
        'socio-cultural', 'trends', 'monitoring', 
        'capacity', 'knowledge', 'public policy', 
        'tools', 'data', 'engagement', 
        'stakeholders', 'effectiveness', 'collateral', 
        'public engagement', 'intervention', 'market access', 
        'cooperation', 'barriers', 'field studies', 
        'publications', 'insights', 'priorities', 
        'metrics', 'investment strategies', 'regional', 
        'patterns', 'indicators', 'growth strategies', 
        'community development', 'information', 'capacity building', 
        'dynamics', 'interactions', 'funding', 
        'awareness', 'education programs', 'involvement', 
        'benefits', 'outreach', 'implementation', 
        'research initiatives', 'public finance', 
        'economic growth', 'social capital', 'knowledge sharing', 
        'inclusion', 'effectiveness', 'evaluation metrics', 
        'public resources', 'stakeholder engagement', 'evaluation', 
        'solutions', 'public infrastructure', 'income distribution', 
        'economic policy', 'initiatives', 'factors', 
        'collaborative research', 'strategies', 'impact assessments', 
        'social equity', 'dynamics', 'regional development'
    ]],
    
    
'digital_health' => [
    'title_id' => 237,
    'words' => [
        'health', 'technology', 'digital', 'data', 
        'care', 'innovation', 'AI', 'medicine', 
        'patient', 'telehealth', 'informatics', 'wellness', 
        'monitoring', 'apps', 'services', 
        'access', 'platforms', 'analytics', 
        'systems', 'interoperability', 'research', 
        'treatment', 'management', 'healthcare', 
        'solutions', 'quality', 'support', 
        'engagement', 'information', 'privacy', 
        'security', 'efficiency', 'insights', 
        'workflows', 'outcomes', 'collaboration', 
        'networking', 'integration', 'diagnostics', 
        'personalization', 'systems', 'metrics', 
        'regulations', 'stakeholders', 'field studies', 
        'feedback', 'education', 'cost-effectiveness', 
        'initiatives', 'trends', 'practices', 
        'data security', 'well-being', 'social', 
        'communication', 'platform', 'public health', 
        'development', 'engagement', 'evaluations', 
        'tools', 'protocols', 'information sharing', 
        'challenges', 'advocacy', 'collaboration', 
        'programs', 'strategies', 'interventions', 
        'outcomes', 'monitoring', 'knowledge', 
        'research findings', 'publications', 'frameworks', 
        'best practices', 'community', 'usage', 
        'barriers', 'support systems', 'fieldwork', 
        'investments', 'practices', 'resources', 
        'applications', 'clinical', 'data management', 
        'inspections', 'public engagement', 'approaches', 
        'capacity building', 'improvement', 'infrastructure', 
        'network', 'transformations', 'reliability', 
        'accessibility', 'service delivery', 'partnerships', 
        'effects', 'guidelines', 'efforts', 
        'evaluation metrics', 'publications', 'collaborative', 
        'projects', 'service models', 'future'
    ]],
    
    
'environmental_health' => [
    'title_id' => 238,
    'words' => [
        'environment', 'health', 'pollution', 'public health', 
        'disease', 'exposure', 'research', 'conservation', 
        'well-being', 'sustainability', 'toxins', 'risks', 
        'hazards', 'regulations', 'climate', 
        'ecosystem', 'factors', 'safety', 
        'community', 'awareness', 'monitoring', 
        'resources', 'frameworks', 'advocacy', 
        'education', 'interventions', 'impact', 
        'policy', 'practices', 'quality', 
        'protection', 'studies', 'outcomes', 
        'initatives', 'insights', 'strategies', 
        'approaches', 'fields', 'development', 
        'tools', 'publications', 'case studies', 
        'socioeconomic', 'analysis', 'metrics', 
        'environmental justice', 'community engagement', 
        'evaluation', 'collaboration', 'data', 
        'feedback', 'systems', 'investments', 
        'barriers', 'effectiveness', 'advancements', 
        'health outcomes', 'practices', 'research findings', 
        'public awareness', 'indicators', 'factors', 
        'networking', 'knowledge', 'risk management', 
        'interdisciplinary', 'regulatory', 'challenges', 
        'socio-cultural', 'solutions', 'best practices', 
        'assessments', 'technology', 'integration', 
        'infrastructure', 'participation', 'monitoring systems', 
        'community health', 'resource management', 'dissemination', 
        'support', 'impact assessments', 'education programs', 
        'public participation', 'experiments', 'tools', 
        'environmental policy', 'research initiatives', 
        'behavioral', 'innovation', 'information sharing', 
        'collaborative research', 'health risks', 'public services', 
        'outreach', 'engagement', 'solutions', 
        'capacity building', 'practices', 'dynamics', 
        'regional', 'global', 'local', 
        'data analysis', 'fieldwork', 'stakeholders'
    ]],
    
    
'environmental_law' => [
    'title_id' => 239,
    'words' => [
        'law', 'environment', 'regulation', 'policy', 
        'conservation', 'sustainability', 'legal', 
        'rights', 'management', 'compliance', 
        'litigation', 'statutes', 'framework', 
        'enforcement', 'governance', 'advocacy', 
        'impact', 'guidelines', 'legislation', 
        'protection', 'practices', 'analysis', 
        'environmental justice', 'stakeholders', 'ecosystem', 
        'public interest', 'research', 'dynamics', 
        'education', 'awareness', 'initiatives', 
        'challenges', 'resource management', 'outcomes', 
        'factors', 'collaboration', 'community', 
        'disputes', 'litigation', 'socioeconomic', 
        'provisions', 'frameworks', 'evaluations', 
        'participation', 'regulatory', 'standards', 
        'advancements', 'public engagement', 'transparency', 
        'impacts', 'fields', 'tools', 
        'strategies', 'assessments', 'monitoring', 
        'socio-cultural', 'education programs', 'environmental policy', 
        'practices', 'enforcement', 'support', 
        'protection measures', 'publications', 'case studies', 
        'legal frameworks', 'collaborative research', 'data', 
        'knowledge sharing', 'investments', 'fieldwork', 
        'social responsibility', 'stakeholder engagement', 'advocacy', 
        'sustainable practices', 'regulatory compliance', 'risk management', 
        'indicators', 'solutions', 'analysis', 
        'community engagement', 'governance structures', 'dynamics', 
        'evaluation metrics', 'methodologies', 'strategic planning', 
        'benefits', 'principles', 'monitoring systems', 
        'field studies', 'environmental assessments', 'local', 
        'global', 'transnational', 'education', 
        'environmental ethics', 'knowledge', 'communication', 
        'policy reforms', 'collaborative efforts', 'impact assessments'
    ]],
    
    
'epigenetics' => [
    'title_id' => 240,
    'words' => [
        'genetics', 'DNA', 'epigenetics', 'gene expression', 
        'research', 'inheritance', 'cell', 'chromosome', 
        'methylation', 'histones', 'modifications', 'expression', 
        'regulation', 'factors', 'biology', 
        'development', 'environment', 'phenotype', 
        'transcription', 'replication', 'biological', 
        'variability', 'heredity', 'study', 
        'mechanisms', 'population', 'dynamics', 
        'interactions', 'analysis', 'models', 
        'changes', 'signaling', 'profiles', 
        'insights', 'applications', 'investigations', 
        'pathways', 'effects', 'gene', 
        'assessments', 'screening', 'fieldwork', 
        'case studies', 'functional', 'imprinting', 
        'molecular', 'proteins', 'activity', 
        'comparative', 'biochemistry', 'tissues', 
        'disease', 'cancer', 'therapy', 
        'epigenome', 'stability', 'detection', 
        'expression patterns', 'experiments', 'interference', 
        'modulation', 'plasticity', 'alterations', 
        'inheritance mechanisms', 'synthesis', 'insulators', 
        'hypomethylation', 'hyperacetylation', 'chromatin', 
        'investigative', 'biological relevance', 'regulatory', 
        'factors', 'validation', 'observations', 
        'empirical', 'transcription factors', 'structure', 
        'recombination', 'response', 'stability', 
        'differentiation', 'context', 'fields', 
        'neuroscience', 'contribution', 'population dynamics', 
        'phenotypic variation', 'significance', 'interdisciplinary', 
        'methodologies', 'clinical', 'bioinformatics', 
        'association', 'community', 'fields of study', 
        'effects', 'biological systems', 'developmental', 
        'evolution', 'data analysis', 'collaborative research', 
        'molecular dynamics', 'advancements', 'dynamics'
    ]],
    
    
'family_medicine' => [
    'title_id' => 241,
    'words' => [
        'family', 'medicine', 'health', 'primary care', 
        'treatment', 'prevention', 'patient', 'disease', 
        'doctor', 'wellness', 'diagnosis', 'management', 
        'community', 'care', 'physician', 
        'counseling', 'chronic', 'acute', 
        'screening', 'intervention', 'education', 
        'referral', 'support', 'nutrition', 
        'lifestyle', 'safety', 'access', 
        'evaluation', 'monitoring', 'services', 
        'advocacy', 'research', 'collaboration', 
        'engagement', 'resources', 'barriers', 
        'outcomes', 'improvement', 'healthcare', 
        'socioeconomic', 'community health', 'interdisciplinary', 
        'clinical', 'consultation', 'emergency', 
        'strategy', 'development', 'knowledge', 
        'public health', 'assessment', 'practice', 
        'skills', 'education', 'teamwork', 
        'treatment plans', 'well-being', 'evaluation', 
        'collaborative', 'outreach', 'initiatives', 
        'protocols', 'guidelines', 'standards', 
        'indicators', 'approaches', 'policies', 
        'accessibility', 'field studies', 'programs', 
        'monitoring systems', 'insights', 'tools', 
        'advancements', 'feedback', 'documentation', 
        'statistics', 'education programs', 'community engagement', 
        'primary health', 'family care', 'holistic', 
        'consultation', 'proactive', 'team', 
        'publications', 'referrals', 'treatment modalities', 
        'services delivery', 'empowerment', 'support systems', 
        'practices', 'involvement', 'collaboration', 
        'prevention strategies', 'information', 'resources management', 
        'fieldwork', 'outcomes measurement', 'data', 
        'clinical practice', 'systematic', 'research initiatives', 
        'monitoring health', 'communication', 'intervention strategies', 
        'evidence', 'community dynamics', 'socio-cultural', 
        'training', 'risk factors', 'methods', 
        'holistic health', 'conditions', 'relationships', 
        'monitoring outcomes', 'referrals process', 'support', 
        'collaborative approaches', 'understanding', 'assessment methods'
    ]],
    
    
'global_health' => [
    'title_id' => 242,
    'words' => [
        'health', 'global', 'public health', 'disease', 
        'epidemic', 'pandemic', 'medicine', 'care', 
        'policy', 'wellness', 'access', 'treatment', 
        'prevention', 'research', 'community', 
        'equity', 'systems', 'outcomes', 
        'monitoring', 'interventions', 'strategies', 
        'collaboration', 'resources', 'education', 
        'advocacy', 'data', 'analysis', 
        'surveillance', 'nutrition', 'challenges', 
        'environment', 'globalization', 'effectiveness', 
        'population', 'capacity', 'services', 
        'partnerships', 'indicators', 'frameworks', 
        'dynamics', 'information', 'communication', 
        'training', 'infrastructure', 'stakeholders', 
        'integration', 'field studies', 'research initiatives', 
        'socioeconomic', 'practices', 'engagement', 
        'monitoring systems', 'dissemination', 'interdisciplinary', 
        'data collection', 'solutions', 'policies', 
        'impact', 'evidence', 'innovation', 
        'evaluation', 'insights', 'barriers', 
        'outreach', 'empowerment', 'commitment', 
        'social determinants', 'programs', 'collaborative', 
        'fieldwork', 'indicators', 'advancements', 
        'publications', 'feedback', 'clinical', 
        'understanding', 'safety', 'accessibility', 
        'cultural', 'training programs', 'risk factors', 
        'methodologies', 'systematic', 'public health interventions', 
        'benefits', 'research findings', 'assessment', 
        'effects', 'monitoring health', 'approaches', 
        'global health security', 'awareness', 'systems thinking', 
        'development', 'evaluation metrics', 'impact assessments', 
        'community health', 'knowledge', 'engagement strategies', 
        'conditions', 'monitoring outcomes', 'support', 
        'clinical practice', 'socio-cultural', 'empirical', 
        'education', 'awareness campaigns', 'resources management', 
        'evidence-based', 'policies', 'strategic planning'
    ]],
    
    
'human_computer_interaction' => [
    'title_id' => 243,
    'words' => [
        'HCI', 'interaction', 'user', 'interface', 
        'technology', 'design', 'usability', 'software', 
        'digital', 'experience', 'accessibility', 
        'feedback', 'usability testing', 'evaluation', 
        'prototyping', 'development', 'applications', 
        'functionality', 'ergonomics', 'communication', 
        'engagement', 'platforms', 'tools', 
        'navigation', 'features', 'layouts', 
        'systems', 'analysis', 'patterns', 
        'research', 'strategies', 'standards', 
        'standards', 'implementation', 'frameworks', 
        'collaboration', 'innovation', 'performance', 
        'visualization', 'problems', 'methods', 
        'efficiency', 'cognition', 'factors', 
        'evaluation metrics', 'affordances', 'interactivity', 
        'usability principles', 'software design', 'user-centered', 
        'interfaces', 'testing', 'data', 
        'configurations', 'human factors', 'development', 
        'feedback loops', 'monitoring', 'updates', 
        'improvements', 'enhancements', 'education', 
        'insights', 'impact', 'patterns', 
        'environments', 'trends', 'usability evaluation', 
        'interdisciplinary', 'integration', 'perspectives', 
        'community', 'awareness', 'knowledge', 
        'user research', 'ethics', 'performance metrics', 
        'field studies', 'outcomes', 'accessibility guidelines', 
        'community engagement', 'creative', 'adoption', 
        'analysis tools', 'collaborative', 'feedback systems', 
        'design guidelines', 'framework', 'application', 
        'cross-platform', 'behavior', 'user interface design', 
        'technology assessment', 'responsiveness', 'systematic', 
        'inclusivity', 'tasks', 'cultural', 
        'functionalities', 'technology integration', 'evaluation methods', 
        'user involvement', 'best practices', 'collaboration', 
        'resources', 'knowledge sharing', 'project management', 
        'case studies', 'community dynamics', 'fieldwork'
    ]],
    
    
'intelligent_transportation' => [
    'title_id' => 244,
    'words' => [
        'transportation', 'intelligent', 'mobility', 'technology', 
        'city', 'infrastructure', 'autonomous', 'traffic', 
        'smart', 'systems', 'innovation', 'logistics', 
        'sustainability', 'data', 'analytics', 
        'communication', 'connectivity', 'design', 
        'safety', 'integration', 'automation', 
        'network', 'routing', 'sensors', 
        'vehicles', 'efficiency', 'urban', 
        'planning', 'environment', 'user experience', 
        'monitoring', 'real-time', 'collaboration', 
        'feedback', 'improvements', 'challenges', 
        'management', 'research', 'applications', 
        'interoperability', 'services', 'accessibility', 
        'strategies', 'regulations', 'public transport', 
        'mobility solutions', 'dynamics', 'socioeconomic', 
        'initiatives', 'community', 'partnerships', 
        'field studies', 'evaluation', 'indicators', 
        'outcomes', 'case studies', 'knowledge', 
        'collaborative', 'safety measures', 'user engagement', 
        'road safety', 'awareness', 'development', 
        'investments', 'technology transfer', 'protocols', 
        'frameworks', 'benefits', 'education', 
        'standards', 'applications', 'trends', 
        'monitoring systems', 'outreach', 'behavior', 
        'adoption', 'efficiency', 'quality', 
        'features', 'design principles', 'resource management', 
        'stakeholder engagement', 'experience design', 
        'impact', 'integration strategies', 'systematic', 
        'evaluation metrics', 'public engagement', 
        'feedback loops', 'training', 'support', 
        'fieldwork', 'publications', 'governance', 
        'advocacy', 'innovative', 'insights', 
        'transparency', 'sustainability metrics', 'strategic planning', 
        'user-centered', 'mobility patterns', 'system performance', 
        'future', 'research initiatives', 'collaboration', 
        'analysis tools', 'framework', 'community dynamics'
    ]],
    
    
'mobile_banking' => [
    'title_id' => 245,
    'words' => [
        'banking', 'mobile', 'digital', 'finance', 
        'app', 'payment', 'technology', 'security', 
        'transactions', 'access', 'services', 'users', 
        'platform', 'innovation', 'system', 
        'interface', 'user experience', 'tools', 
        'communication', 'data', 'management', 
        'account', 'transactions', 'support', 
        'features', 'integration', 'privacy', 
        'mobile wallets', 'credit', 'debit', 
        'payments', 'authentication', 'monitoring', 
        'efficiency', 'convenience', 'online', 
        'investment', 'strategy', 'network', 
        'trends', 'market', 'analysis', 
        'adoption', 'security measures', 'regulations', 
        'reliability', 'risk', 'transparency', 
        'improvement', 'customer service', 'accessibility', 
        'analytics', 'growth', 'collaboration', 
        'feedback', 'education', 'awareness', 
        'resources', 'methods', 'protocols', 
        'community', 'benefits', 'reporting', 
        'insights', 'tools', 'publications', 
        'surveys', 'systematic', 'integration', 
        'user engagement', 'outreach', 'strategies', 
        'performance', 'monitoring systems', 'support', 
        'knowledge', 'transactions data', 'efficacy', 
        'solutions', 'fintech', 'automation', 
        'financial', 'user interface', 'investments', 
        'verification', 'privacy policy', 'innovation', 
        'capabilities', 'ecosystem', 'benefits', 
        'fieldwork', 'community dynamics', 'participation', 
        'field studies', 'case studies', 'regulatory', 
        'impact', 'participation', 'factors', 
        'collaborative', 'field research', 'best practices', 
        'metrics', 'standards', 'technology adoption', 
        'experience', 'consumer', 'issues', 
        'fieldwork', 'performance metrics', 'outcomes'
    ]],
    
    
'social_robotics' => [
    'title_id' => 246,
    'words' => [
        'robotics', 'social', 'AI', 'interaction', 
        'robot', 'technology', 'human', 'behavior', 
        'communication', 'autonomy', 'design', 
        'intelligence', 'emotion', 'collaboration', 
        'interface', 'cognition', 'adaptability', 
        'engagement', 'perception', 'feedback', 
        'tasks', 'applications', 'innovation', 
        'integration', 'systems', 'development', 
        'interaction design', 'usability', 'effectiveness', 
        'intuitive', 'responsiveness', 'community', 
        'research', 'evaluation', 'methodologies', 
        'insights', 'interdisciplinary', 'participation', 
        'dynamics', 'environment', 'challenges', 
        'collaborative', 'sensors', 'empathy', 
        'engagement', 'human-robot interaction', 'functions', 
        'data', 'models', 'psychology', 
        'experiments', 'monitoring', 'engineering', 
        'ethics', 'capabilities', 'field studies', 
        'outcomes', 'support', 'training', 
        'frameworks', 'knowledge', 'publications', 
        'metrics', 'analysis', 'strategies', 
        'education', 'advancements', 'awareness', 
        'research initiatives', 'applications', 'effectiveness', 
        'collaborative robots', 'communication skills', 
        'behavioral analysis', 'social intelligence', 
        'context', 'creativity', 'fieldwork', 
        'perception', 'user experience', 'improvements', 
        'personality', 'relationship', 'interaction models', 
        'feedback mechanisms', 'task performance', 'solutions', 
        'visualization', 'impact', 'participation', 
        'community dynamics', 'tools', 'outreach', 
        'case studies', 'benefits', 'exploration', 
        'innovations', 'system performance', 'future', 
        'implementation', 'collaboration', 'integration', 
        'discussions', 'socio-cultural', 'transparency', 
        'support systems', 'relationship-building', 'interactivity', 
        'knowledge transfer', 'community engagement', 'resources', 
        'robot design', 'adaptation', 'evaluation metrics'
    ]],
    
    
'sports_medicine' => [
    'title_id' => 247,
    'words' => [
        'sports', 'medicine', 'treatment', 'injury', 
        'rehabilitation', 'health', 'performance', 'athletes', 
        'care', 'exercise', 'physical', 'wellness', 
        'diagnosis', 'prevention', 'nutrition', 
        'fitness', 'therapy', 'training', 
        'assessment', 'recovery', 'conditioning', 
        'rehab', 'movement', 'safety', 
        'protocols', 'techniques', 'research', 
        'preparation', 'strategies', 'physical therapy', 
        'support', 'motivation', 'sports science', 
        'strength', 'monitoring', 'evaluation', 
        'treatment plans', 'risk', 'injury prevention', 
        'knowledge', 'education', 'community', 
        'outcomes', 'collaboration', 'indicators', 
        'field studies', 'publications', 'awareness', 
        'programs', 'efficiency', 'integration', 
        'diagnostics', 'feedback', 'participation', 
        'environment', 'intervention', 'improvements', 
        'coaching', 'guidelines', 'dynamics', 
        'research initiatives', 'exercise physiology', 
        'well-being', 'challenges', 'fieldwork', 
        'advocacy', 'empowerment', 'collaborative', 
        'application', 'risk management', 'innovations', 
        'resources', 'performance metrics', 'public health', 
        'socioeconomic', 'technology', 'support systems', 
        'teamwork', 'holistic', 'training programs', 
        'preparation', 'evidence-based', 'monitoring systems', 
        'strategies', 'performance enhancement', 'data', 
        'tools', 'rehabilitation programs', 'relationship', 
        'community engagement', 'consultation', 'protocols', 
        'education programs', 'workshops', 'holistic health', 
        'planning', 'physical fitness', 'balance', 
        'impact', 'social determinants', 'prevention strategies', 
        'evidence', 'feedback systems', 'initiatives', 
        'field research', 'safety protocols', 'field studies', 
        'outcomes assessment', 'systematic', 'resources management'
    ]],
    
    
'synthetic_biology' => [
    'title_id' => 248,
    'words' => [
        'biology', 'synthetic', 'engineering', 'genetics', 
        'DNA', 'research', 'cell', 'biotechnology', 
        'organism', 'modification', 'genome', 'genetic', 
        'techniques', 'design', 'systems', 
        'applications', 'proteins', 'pathways', 
        'molecular', 'expression', 'metabolism', 
        'innovations', 'components', 'functional', 
        'analysis', 'biological', 'development', 
        'processes', 'microorganisms', 'experimentation', 
        'experiments', 'constructs', 'platforms', 
        'environment', 'integration', 'tools', 
        'strategies', 'collaboration', 'applications', 
        'engineering', 'synthetic organisms', 'therapeutics', 
        'field studies', 'data', 'impact', 
        'insights', 'regulatory', 'adaptation', 
        'challenges', 'community', 'knowledge', 
        'evaluation', 'feedback', 'fieldwork', 
        'projects', 'education', 'biomolecules', 
        'synthesis', 'research initiatives', 'advancements', 
        'frameworks', 'systems biology', 'factors', 
        'testing', 'outputs', 'optimization', 
        'collaborative', 'methodologies', 'safety', 
        'innovations', 'understanding', 'regulations', 
        'monitoring', 'efficiency', 'capacity', 
        'variables', 'results', 'process', 
        'implementation', 'governance', 'tools', 
        'discovery', 'collaboration', 'knowledge sharing', 
        'metrics', 'strategic planning', 'bioengineering', 
        'experiments', 'biological systems', 'ecological', 
        'sustainability', 'publications', 'advocacy', 
        'methodologies', 'community engagement', 'issues', 
        'capacity building', 'holistic', 'analytics', 
        'validation', 'approaches', 'impact assessments', 
        'knowledge transfer', 'outcomes', 'research findings'
    ]],
    
    
'textile_engineering' => [
    'title_id' => 249,
    'words' => [
        'textile', 'engineering', 'fabric', 'materials', 
        'design', 'manufacturing', 'technology', 'clothing', 
        'innovation', 'textiles', 'weaving', 'knitting', 
        'dyeing', 'finishing', 'sustainability', 
        'processes', 'fiber', 'quality', 
        'production', 'textile science', 'textile industry', 
        'fashion', 'patterns', 'techniques', 
        'standards', 'testing', 'applications', 
        'research', 'performance', 'properties', 
        'development', 'automation', 'equipment', 
        'textile products', 'sourcing', 'supply chain', 
        'efficiency', 'fabrication', 'environment', 
        'sustainability practices', 'resources', 'innovation', 
        'collaboration', 'market', 'evaluation', 
        'safety', 'challenges', 'field studies', 
        'engineering design', 'community', 'integration', 
        'knowledge', 'insights', 'education', 
        'applications', 'advancements', 'feedback', 
        'data', 'fieldwork', 'investigation', 
        'trends', 'patterns', 'usability', 
        'interdisciplinary', 'capacity', 'validation', 
        'tools', 'experimentation', 'strategic', 
        'monitoring', 'outcomes', 'techniques', 
        'material science', 'chemistry', 'bioengineering', 
        'innovation', 'testing methods', 'standards', 
        'collaborative research', 'knowledge sharing', 
        'prototyping', 'solutions', 'design processes', 
        'projects', 'economics', 'research initiatives', 
        'market trends', 'performance metrics', 
        'distribution', 'sourcing strategies', 
        'user experience', 'product development', 'communication', 
        'regulatory', 'awareness', 'publications', 
        'socioeconomic', 'methodologies', 'community engagement', 
        'industry standards', 'sustainability metrics', 'outreach'
    ]],
    
    
'translational_research' => [
    'title_id' => 250,
    'words' => [
        'research', 'translational', 'medicine', 'clinical', 
        'treatment', 'biotechnology', 'innovation', 'disease', 
        'therapy', 'application', 'development', 'health', 
        'protocols', 'investigation', 'findings', 
        'data', 'integration', 'approaches', 
        'results', 'methodologies', 'monitoring', 
        'evaluation', 'practice', 'collaboration', 
        'impact', 'challenges', 'advancements', 
        'clinical trials', 'studies', 'outcomes', 
        'strategies', 'community', 'knowledge', 
        'insights', 'participation', 'feedback', 
        'effectiveness', 'safety', 'variables', 
        'population', 'education', 'evidence', 
        'method', 'testing', 'assessments', 
        'intervention', 'applications', 'frameworks', 
        'factors', 'engagement', 'support', 
        'resources', 'socioeconomic', 'fieldwork', 
        'collaborative', 'systems', 'technology', 
        'biomedical', 'therapeutics', 'monitoring systems', 
        'implementation', 'knowledge transfer', 'research initiatives', 
        'tools', 'clinical outcomes', 'publications', 
        'participatory', 'trials', 'standards', 
        'resources management', 'strategy', 'methods', 
        'advocacy', 'data sharing', 'sustainability', 
        'protocol development', 'advancements', 'innovation', 
        'regulations', 'community engagement', 'efficacy', 
        'parameters', 'solutions', 'investigative', 
        'biostatistics', 'assessment', 'collaborative research', 
        'context', 'performance', 'approaches', 
        'knowledge sharing', 'experiments', 'communication', 
        'public health', 'field studies', 'resource allocation', 
        'investments', 'training', 'systematic'
    ]],
    
    
'wildlife_biology' => [
    'title_id' => 251,
    'words' => [
        'wildlife', 'biology', 'species', 'habitat', 
        'research', 'conservation', 'ecosystem', 'biodiversity', 
        'animals', 'population', 'environment', 'flora', 
        'fauna', 'behavior', 'interaction', 'survival', 
        'fieldwork', 'monitoring', 'data', 
        'protection', 'endangered', 'rehabilitation', 
        'management', 'restoration', 'community', 
        'health', 'dynamics', 'migration', 
        'feeding', 'breeding', 'territory', 
        'threats', 'species diversity', 'assessment', 
        'conservation strategies', 'habitat loss', 
        'ecosystem services', 'invasive', 'native', 
        'climate change', 'genetics', 'adaptation', 
        'natural resources', 'sustainability', 'field studies', 
        'impact', 'observations', 'data analysis', 
        'education', 'awareness', 'advocacy', 
        'trends', 'regulations', 'techniques', 
        'wildlife corridors', 'research initiatives', 'collaboration', 
        'monitoring systems', 'surveys', 'factors', 
        'indicators', 'approaches', 'tools', 
        'populations', 'wildlife habitats', 'biomes', 
        'ecosystem management', 'community engagement', 'investigation', 
        'conservation biology', 'species recovery', 'practices', 
        'restoration ecology', 'preservation', 'impact assessments', 
        'partnerships', 'field guides', 'socioeconomic', 
        'research projects', 'applications', 'advancements', 
        'publications', 'education programs', 'strategies', 
        'collaborative', 'ecological', 'safety', 
        'support', 'environmental policy', 'knowledge', 
        'trials', 'innovation', 'regulations', 
        'capacity building', 'methods', 'integration', 
        'wildlife surveys', 'ecosystem health', 'evaluation', 
        'wildlife management', 'ecosystem diversity', 'solutions', 
        'species management', 'effectiveness', 'conservation efforts', 
        'data collection', 'socio-cultural', 'experimentation'
    ]],
    
        'video_games' => [
        'title_id' => 252,
        'words' => [
            'Action', 'Adventure', 'RPG', 'MMORPG', 'FPS', 'Battle-royale', 'Platformer', 'Simulation', 'Strategy',
            'Sports', 'Racing', 'Fighting', 'Stealth', 'Survival', 'Sandbox', 'Open-world', 'Puzzle', 'Idle', 'Hack-and-slash',
            'Shooter', 'Multiplayer', 'Single-player', 'Co-op', 'Turn-based', 'Real-time', 'VR', 'AR', 'Loot', 'Quest', 'Mission',
            'Guild', 'Clan', 'Level-up', 'Skill-tree', 'Boss-fight', 'Endgame', 'PvP', 'PvE', 'Crafting', 'Inventory', 'Loot-box',
            'In-game-purchase', 'Microtransactions', 'Free-to-play', 'Pay-to-win', 'DLC', 'Season-pass', 'Patch', 'Update',
            'Beta', 'Early-access', 'Cheats', 'Mods', 'Speedrun', 'Replayability', 'Cutscene', 'Graphics', 'Frame-rate',
            'Resolution', '4K', 'HDR', 'Ray-tracing', 'AI', 'Physics-engine', 'Game-engine', 'Open-beta', 'Closed-beta',
            'Console', 'PC', 'PlayStation', 'Xbox', 'Nintendo', 'Switch', 'Handheld', 'Mobile-gaming', 'Steam', 'Epic-Games-Store',
            'PlayStation-Network', 'Xbox-Live', 'Game-Pass', 'Cross-play', 'Cross-platform', 'Cloud-gaming', 'VR-headset', 'Oculus',
            'HTC-Vive', 'PlayStation-VR', 'Graphics-card', 'Processor', 'Gaming-PC', 'Gaming-laptop', 'Controller', 'Joystick',
            'Keyboard-and-mouse', 'Headset', 'Microphone', 'RPG-elements', 'Character-customization', 'Story-driven', 'Narrative',
            'Branching-paths', 'Dialogue-choices', 'Multiple-endings', 'Romance-options', 'Open-world-exploration', 'Side-quests',
            'Minigames', 'Boss-rush', 'Time-trials', 'Leaderboards', 'Achievements', 'Trophies', 'Ranked-mode', 'Casual-mode',
            'Hardcore-mode', 'New-game-plus', 'Permadeath', 'Difficult-level', 'Customization', 'Avatar', 'Character-skins',
            'Weapon-skins', 'Power-ups', 'Collectibles', 'Secrets', 'Unlockables', 'Easter-eggs', 'Game-save', 'Checkpoint',
            'Auto-save', 'Game-over', 'Respawn', 'Quick-time-events', 'Cutscenes', 'Voice-acting', 'Motion-capture',
            'Soundtrack', 'OST', 'In-game-music', 'Sound-effects', 'Ambience', 'Game-director', 'Game-designer', 'Programmer',
            'Artist', 'Animator', 'Sound-designer', 'Voice-actor', 'Producer', 'Publisher', 'Indie-games', 'Triple-A-games',
            'Crowdfunding', 'Kickstarter', 'Multiplayer-lobby', 'Game-chat', 'Text-chat', 'Voice-chat', 'Emotes', 'Ping-system',
            'Game-community', 'Toxic-behavior', 'Moderators', 'Game-moderation', 'Anti-cheat', 'Bans', 'Suspensions', 'Reports',
            'Feedback', 'Game-balance', 'Meta', 'Patch-notes', 'Hotfix', 'Game-testing', 'Alpha-testing', 'Beta-testing',
            'Test-servers', 'Early-release', 'Game-launch', 'Release-date', 'Pre-order', 'Collector’s-edition', 'Physical-copy',
            'Digital-download', 'Demos', 'Trial-versions', 'Free-weekends', 'Expansion-pack', 'Mods', 'Custom-maps', 'Game-modes',
            'Arcade-mode', 'Story-mode', 'Campaign-mode', 'Training-mode', 'Practice-mode', 'Time-attack', 'Deathmatch',
            'Capture-the-flag', 'Team-deathmatch', 'Battle-royale-mode', 'Survival-mode', 'Cooperative-mode', 'Horde-mode',
            'Escort-missions', 'Fetch-quests', 'Boss-fights', 'Raid-bosses', 'PvP-matches', 'PvE-battles', 'Guild-wars',
            'Clan-battles', 'Ranking-system', 'E-sports', 'Tournaments', 'Pro-players', 'Streamers', 'Twitch', 'YouTube-gaming',
            'Discord', 'Game-walkthrough', 'Speedrunning', 'No-hit-runs', 'Completionist', 'Achievement-hunters', 'Mods-community',
            'Game-servers', 'Dedicated-servers', 'Matchmaking', 'Ping', 'Lag', 'Latency', 'Frame-drops', 'Resolution-scaling',
            'Texture-quality', 'Anti-aliasing', 'Motion-blur', 'Vertical-sync', 'Field-of-view', 'Sensitivity', 'Aim-assist',
            'Recoil-control', 'Hitboxes', 'Headshots', 'Critical-hits', 'Damage-multipliers', 'Health-bars', 'Mana-bars', 'Stamina-bars',
            'Experience-points', 'Level-cap', 'Grinding', 'Farming', 'Boss-drops', 'Crafting-materials', 'Blueprints', 'Skill-books',
            'Character-classes', 'Warrior', 'Mage', 'Rogue', 'Archer', 'Paladin', 'Cleric', 'Tank', 'Healer', 'DPS', 'Support',
            'Hybrid-classes', 'Skill-rotation', 'Cooldowns', 'Buffs', 'Debuffs', 'Status-effects', 'Poison', 'Burning', 'Frozen',
            'Stun', 'Paralyze', 'Knockback', 'Knockdown', 'Crowd-control', 'Area-of-effect', 'Damage-over-time', 'Healing-over-time',
            'Critical-hits', 'Hit-rate', 'Evasion', 'Dodge', 'Block', 'Parry', 'Counterattack', 'Combo-system', 'Chain-attacks',
            'Special-moves', 'Ultimate-attacks', 'Final-boss', 'Secret-boss', 'New-game-plus', 'Multiple-difficulties',
            'Dynamic-difficulty', 'Story-driven-games', 'Character-development', 'Emotional-story', 'Plot-twists', 'Side-stories',
            'Post-game-content', 'Game-expansion', 'Sequel', 'Game-remake', 'Reboot', 'Classic-games', 'Retro-games',
            'Pixel-art', '8-bit', '16-bit', 'Arcade-classics', 'Game-port', 'HD-remaster', 'Indie-darlings', 'Crowdfunding-games',
            'Game-bundles', 'Flash-sales', 'Seasonal-events', 'Limited-time-modes', 'Holiday-events', 'Crossovers', 'Collaborations',
            'In-game-events', 'Character-unlocks', 'Cameos', 'Spin-offs', 'Game-franchises', 'Brand-new-IP', 'Game-development',
            'Game-jam', 'Indie-studios', 'Major-studios', 'In-house-studios', 'Game-journalism', 'Game-reviews', 'Player-feedback',
            'Game-of-the-year', 'Speedrun-records', 'TAS', 'World-records', 'Game-culture', 'Cosplay', 'Fan-art', 'Fan-theories',
            'Game-leaks', 'Game-announcements', 'E3', 'Game-awards', 'Speedrun-community', 'Leaderboards', 'World-record-holders',
            'Competitive-scene', 'Scrim', 'Ranked-matches', 'Practice-matches', 'Draft-picks', 'Ban-system', 'Meta-shift',
            'Pro-gaming', 'Game-sponsors', 'Player-coaches', 'Shoutcasters', 'Live-streaming', 'Player-rosters', 'Bootcamps',
            'Training-camps', 'Gaming-peripherals', 'RGB-lighting', 'Mechanical-keyboards', 'Gaming-mice', 'Mouse-sensitivity',
            'Console-exclusive', 'Third-party', 'First-party', 'In-game-rewards', 'Virtual-currency', 'Game-economy',
            'Player-trading', 'Auction-house', 'Black-market', 'In-game-marketplace', 'Community-mods', 'Game-tools',
            'Open-source-tools', 'Game-tutorials', 'Level-design', 'Game-mechanics', 'Game-balance-patches', 'Early-access-games',
            'Game-betas', 'Closed-betas', 'Open-betas', 'Playable-demos', 'Development-roadmaps', 'Fan-feedback',
            'Gamer-conventions', 'Cosplay-contests', 'Gaming-merchandise', 'Collector’s-editions', 'Signed-merch', 'Game-swag',
            'Game-tournaments', 'E-sports-leagues', 'Pro-players-streaming', 'Free-to-play-games', 'Pay-to-win-mechanics',
            'Microtransaction-controversies', 'DLC-packs', 'Expansion-passes', 'Game-patches', 'Day-one-patches', 'Hotfixes',
            'Game-breaking-bugs', 'Exploiters', 'Cheat-detection', 'Game-bans', 'Account-suspensions', 'In-game-reports',
            'Player-moderators', 'Game-fairness', 'Paywalls', 'Grinding-loot', 'Player-progression', 'In-game-leveling',
            'Skill-trees', 'Unlockable-abilities', 'Character-unlocks', 'Boss-battles', 'Level-bosses', 'Final-bosses',
            'Secret-bosses', 'Bonus-levels', 'Challenge-modes', 'Post-game-content', 'Game-remasters', 'Classic-game-reboots'
        ]
    ],
    
        'video_games' => [
        'title_id' => 2000,
        'words' => [
            'Action', 'Adventure', 'RPG', 'MMORPG', 'FPS', 'Battle-royale', 'Platformer', 'Simulation', 'Strategy',
            'Sports', 'Racing', 'Fighting', 'Stealth', 'Survival', 'Sandbox', 'Open-world', 'Puzzle', 'Idle', 'Hack-and-slash',
            'Shooter', 'Multiplayer', 'Single-player', 'Co-op', 'Turn-based', 'Real-time', 'VR', 'AR', 'Loot', 'Quest', 'Mission',
            'Guild', 'Clan', 'Level-up', 'Skill-tree', 'Boss-fight', 'Endgame', 'PvP', 'PvE', 'Crafting', 'Inventory', 'Loot-box',
            'In-game-purchase', 'Microtransactions', 'Free-to-play', 'Pay-to-win', 'DLC', 'Season-pass', 'Patch', 'Update',
            'Beta', 'Early-access', 'Cheats', 'Mods', 'Speedrun', 'Replayability', 'Cutscene', 'Graphics', 'Frame-rate',
            'Resolution', '4K', 'HDR', 'Ray-tracing', 'AI', 'Physics-engine', 'Game-engine', 'Open-beta', 'Closed-beta',
            'Console', 'PC', 'PlayStation', 'Xbox', 'Nintendo', 'Switch', 'Handheld', 'Mobile-gaming', 'Steam', 'Epic-Games-Store',
            'PlayStation-Network', 'Xbox-Live', 'Game-Pass', 'Cross-play', 'Cross-platform', 'Cloud-gaming', 'VR-headset', 'Oculus',
            'HTC-Vive', 'PlayStation-VR', 'Graphics-card', 'Processor', 'Gaming-PC', 'Gaming-laptop', 'Controller', 'Joystick',
            'Keyboard-and-mouse', 'Headset', 'Microphone', 'RPG-elements', 'Character-customization', 'Story-driven', 'Narrative',
            'Branching-paths', 'Dialogue-choices', 'Multiple-endings', 'Romance-options', 'Open-world-exploration', 'Side-quests',
            'Minigames', 'Boss-rush', 'Time-trials', 'Leaderboards', 'Achievements', 'Trophies', 'Ranked-mode', 'Casual-mode',
            'Hardcore-mode', 'New-game-plus', 'Permadeath', 'Difficult-level', 'Customization', 'Avatar', 'Character-skins',
            'Weapon-skins', 'Power-ups', 'Collectibles', 'Secrets', 'Unlockables', 'Easter-eggs', 'Game-save', 'Checkpoint',
            'Auto-save', 'Game-over', 'Respawn', 'Quick-time-events', 'Cutscenes', 'Voice-acting', 'Motion-capture',
            'Soundtrack', 'OST', 'In-game-music', 'Sound-effects', 'Ambience', 'Game-director', 'Game-designer', 'Programmer',
            'Artist', 'Animator', 'Sound-designer', 'Voice-actor', 'Producer', 'Publisher', 'Indie-games', 'Triple-A-games',
            'Crowdfunding', 'Kickstarter', 'Multiplayer-lobby', 'Game-chat', 'Text-chat', 'Voice-chat', 'Emotes', 'Ping-system',
            'Game-community', 'Toxic-behavior', 'Moderators', 'Game-moderation', 'Anti-cheat', 'Bans', 'Suspensions', 'Reports',
            'Feedback', 'Game-balance', 'Meta', 'Patch-notes', 'Hotfix', 'Game-testing', 'Alpha-testing', 'Beta-testing',
            'Test-servers', 'Early-release', 'Game-launch', 'Release-date', 'Pre-order', 'Collector’s-edition', 'Physical-copy',
            'Digital-download', 'Demos', 'Trial-versions', 'Free-weekends', 'Expansion-pack', 'Mods', 'Custom-maps', 'Game-modes',
            'Arcade-mode', 'Story-mode', 'Campaign-mode', 'Training-mode', 'Practice-mode', 'Time-attack', 'Deathmatch',
            'Capture-the-flag', 'Team-deathmatch', 'Battle-royale-mode', 'Survival-mode', 'Cooperative-mode', 'Horde-mode',
            'Escort-missions', 'Fetch-quests', 'Boss-fights', 'Raid-bosses', 'PvP-matches', 'PvE-battles', 'Guild-wars',
            'Clan-battles', 'Ranking-system', 'E-sports', 'Tournaments', 'Pro-players', 'Streamers', 'Twitch', 'YouTube-gaming',
            'Discord', 'Game-walkthrough', 'Speedrunning', 'No-hit-runs', 'Completionist', 'Achievement-hunters', 'Mods-community',
            'Game-servers', 'Dedicated-servers', 'Matchmaking', 'Ping', 'Lag', 'Latency', 'Frame-drops', 'Resolution-scaling',
            'Texture-quality', 'Anti-aliasing', 'Motion-blur', 'Vertical-sync', 'Field-of-view', 'Sensitivity', 'Aim-assist',
            'Recoil-control', 'Hitboxes', 'Headshots', 'Critical-hits', 'Damage-multipliers', 'Health-bars', 'Mana-bars', 'Stamina-bars',
            'Experience-points', 'Level-cap', 'Grinding', 'Farming', 'Boss-drops', 'Crafting-materials', 'Blueprints', 'Skill-books',
            'Character-classes', 'Warrior', 'Mage', 'Rogue', 'Archer', 'Paladin', 'Cleric', 'Tank', 'Healer', 'DPS', 'Support',
            'Hybrid-classes', 'Skill-rotation', 'Cooldowns', 'Buffs', 'Debuffs', 'Status-effects', 'Poison', 'Burning', 'Frozen',
            'Stun', 'Paralyze', 'Knockback', 'Knockdown', 'Crowd-control', 'Area-of-effect', 'Damage-over-time', 'Healing-over-time',
            'Critical-hits', 'Hit-rate', 'Evasion', 'Dodge', 'Block', 'Parry', 'Counterattack', 'Combo-system', 'Chain-attacks',
            'Special-moves', 'Ultimate-attacks', 'Final-boss', 'Secret-boss', 'New-game-plus', 'Multiple-difficulties',
            'Dynamic-difficulty', 'Story-driven-games', 'Character-development', 'Emotional-story', 'Plot-twists', 'Side-stories',
            'Post-game-content', 'Game-expansion', 'Sequel', 'Game-remake', 'Reboot', 'Classic-games', 'Retro-games',
            'Pixel-art', '8-bit', '16-bit', 'Arcade-classics', 'Game-port', 'HD-remaster', 'Indie-darlings', 'Crowdfunding-games',
            'Game-bundles', 'Flash-sales', 'Seasonal-events', 'Limited-time-modes', 'Holiday-events', 'Crossovers', 'Collaborations',
            'In-game-events', 'Character-unlocks', 'Cameos', 'Spin-offs', 'Game-franchises', 'Brand-new-IP', 'Game-development',
            'Game-jam', 'Indie-studios', 'Major-studios', 'In-house-studios', 'Game-journalism', 'Game-reviews', 'Player-feedback',
            'Game-of-the-year', 'Speedrun-records', 'TAS', 'World-records', 'Game-culture', 'Cosplay', 'Fan-art', 'Fan-theories',
            'Game-leaks', 'Game-announcements', 'E3', 'Game-awards', 'Speedrun-community', 'Leaderboards', 'World-record-holders',
            'Competitive-scene', 'Scrim', 'Ranked-matches', 'Practice-matches', 'Draft-picks', 'Ban-system', 'Meta-shift',
            'Pro-gaming', 'Game-sponsors', 'Player-coaches', 'Shoutcasters', 'Live-streaming', 'Player-rosters', 'Bootcamps',
            'Training-camps', 'Gaming-peripherals', 'RGB-lighting', 'Mechanical-keyboards', 'Gaming-mice', 'Mouse-sensitivity',
            'Console-exclusive', 'Third-party', 'First-party', 'In-game-rewards', 'Virtual-currency', 'Game-economy',
            'Player-trading', 'Auction-house', 'Black-market', 'In-game-marketplace', 'Community-mods', 'Game-tools',
            'Open-source-tools', 'Game-tutorials', 'Level-design', 'Game-mechanics', 'Game-balance-patches', 'Early-access-games',
            'Game-betas', 'Closed-betas', 'Open-betas', 'Playable-demos', 'Development-roadmaps', 'Fan-feedback',
            'Gamer-conventions', 'Cosplay-contests', 'Gaming-merchandise', 'Collector’s-editions', 'Signed-merch', 'Game-swag',
            'Game-tournaments', 'E-sports-leagues', 'Pro-players-streaming', 'Free-to-play-games', 'Pay-to-win-mechanics',
            'Microtransaction-controversies', 'DLC-packs', 'Expansion-passes', 'Game-patches', 'Day-one-patches', 'Hotfixes',
            'Game-breaking-bugs', 'Exploiters', 'Cheat-detection', 'Game-bans', 'Account-suspensions', 'In-game-reports',
            'Player-moderators', 'Game-fairness', 'Paywalls', 'Grinding-loot', 'Player-progression', 'In-game-leveling',
            'Skill-trees', 'Unlockable-abilities', 'Character-unlocks', 'Boss-battles', 'Level-bosses', 'Final-bosses',
            'Secret-bosses', 'Bonus-levels', 'Challenge-modes', 'Post-game-content', 'Game-remasters', 'Classic-game-reboots'
        ]
    ],

    'movies' => [
        'title_id' => 253,
        'words' => [
            'Action', 'Adventure', 'Comedy', 'Drama', 'Horror', 'Sci-fi', 'Romance', 'Thriller', 'Mystery', 'Fantasy',
            'Animation', 'Biography', 'Documentary', 'Crime', 'Family', 'Musical', 'Western', 'War', 'Sports', 'Superhero',
            'Director', 'Producer', 'Screenwriter', 'Cinematography', 'Editor', 'Composer', 'Soundtrack', 'Costume-design',
            'Set-design', 'Art-direction', 'Visual-effects', 'Special-effects', 'Stunt-coordinator', 'Stunt-double', 'Actor',
            'Actress', 'Casting', 'Supporting-role', 'Leading-role', 'Cameo', 'Character', 'Dialogue', 'Monologue', 'Plot',
            'Story-arc', 'Theme', 'Setting', 'Location', 'Sound-design', 'Sound-effects', 'Foley', 'Score', 'Scene',
            'Shot', 'Take', 'Cut', 'Editing', 'Montage', 'Pacing', 'Tone', 'Mood', 'Foreshadowing', 'Flashback', 'Subtext',
            'Motif', 'Symbolism', 'Antagonist', 'Protagonist', 'Conflict', 'Resolution', 'Climax', 'Denouement', 'Exposition',
            'Inciting-incident', 'Rising-action', 'Falling-action', 'Screenplay', 'Script', 'Storyboard', 'Producer',
            'Executive-producer', 'Assistant-director', 'Casting-director', 'Production-assistant', 'Gaffer', 'Grip',
            'Best-boy', 'Key-grip', 'Boom-operator', 'Sound-mixer', 'Costume-designer', 'Makeup-artist', 'Hair-stylist',
            'Prop-master', 'Art-director', 'Location-scout', 'Production-designer', 'Music-supervisor', 'Title-sequence',
            'End-credits', 'Sequel', 'Prequel', 'Spin-off', 'Reboot', 'Remake', 'Box-office', 'Budget', 'Gross', 'Opening-weekend',
            'Blockbuster', 'Indie-film', 'Foreign-film', 'Short-film', 'Feature-film', 'B-movie', 'Cult-classic', 'Festival',
            'Film-festival', 'Cannes', 'Sundance', 'Oscars', 'Academy-awards', 'Golden-globes', 'BAFTA', 'Emmys', 'Best-picture',
            'Best-director', 'Best-actor', 'Best-actress', 'Best-supporting-actor', 'Best-supporting-actress', 'Best-screenplay',
            'Best-original-screenplay', 'Best-adapted-screenplay', 'Best-cinematography', 'Best-film-editing', 'Best-sound',
            'Best-visual-effects', 'Best-costume-design', 'Best-makeup', 'Best-production-design', 'Best-sound-editing',
            'Best-sound-mixing', 'Best-animated-feature', 'Best-documentary', 'Best-short-film', 'Best-foreign-film', 'Nominee',
            'Winner', 'Award-season', 'Film-critic', 'Film-review', 'Rotten-tomatoes', 'IMDB', 'Metacritic', 'Box-office-hits',
            'Flop', 'Critically-acclaimed', 'Cult-following', 'Limited-release', 'Wide-release', 'Director’s-cut', 'Extended-edition',
            'Deleted-scenes', 'Behind-the-scenes', 'Bloopers', 'Cameo-appearance', 'Post-credits-scene', 'Teaser-trailer',
            'Theatrical-trailer', 'TV-spot', 'Movie-premiere', 'Red-carpet', 'Film-industry', 'Hollywood', 'Bollywood',
            'Studio', 'Production-company', 'Distributor', 'Streaming-service', 'Netflix', 'Amazon-Prime', 'Disney-plus',
            'Hulu', 'HBO-Max', 'Paramount-plus', 'Apple-TV', 'Peacock', 'Cinema', 'Movie-theater', 'Drive-in-theater', 'Box-office-report',
            'Movie-ticket', 'Popcorn', 'Concession-stand', 'Film-genres', 'Classic-films', 'Silent-films', 'Black-and-white-films',
            '3D-films', 'IMAX', 'Dolby-cinema', 'Home-theater', 'Blu-ray', 'DVD', 'Digital-download', 'Filmography', 'Movie-marathon',
            'Actor-filmography', 'Director-filmography', 'Franchise', 'Trilogy', 'Saga', 'Cinematic-universe', 'Shared-universe',
            'Marvel', 'DC', 'Star-Wars', 'The-Lord-of-the-Rings', 'Harry-Potter', 'The-Godfather', 'Jurassic-Park', 'Indiana-Jones',
            'James-Bond', 'Mission-Impossible', 'Fast-and-Furious', 'Transformers', 'Terminator', 'Rocky', 'Rambo', 'Alien',
            'Predator', 'Matrix', 'Avatar', 'Pirates-of-the-Caribbean', 'Shrek', 'Toy-Story', 'Frozen', 'The-Incredibles', 'Finding-Nemo',
            'Monsters-Inc', 'The-Lion-King', 'Beauty-and-the-Beast', 'Aladdin', 'Cinderella', 'Snow-White', 'Sleeping-Beauty',
            'The-Little-Mermaid', 'Peter-Pan', 'Mulan', 'Tangled', 'Moana', 'Coco', 'Soul', 'Onward', 'Ratatouille', 'Inside-Out',
            'WALL-E', 'Up', 'Brave', 'Cars', 'Despicable-Me', 'Minions', 'How-to-Train-Your-Dragon', 'Kung-Fu-Panda', 'Ice-Age',
            'Madagascar', 'Zootopia', 'Big-Hero-6', 'Frozen-II', 'Trolls', 'The-Croods', 'Shrek-2', 'Toy-Story-2', 'Toy-Story-3',
            'Toy-Story-4', 'The-Incredibles-2', 'Finding-Dory', 'Monsters-University', 'Spider-Man', 'Iron-Man', 'The-Avengers',
            'Guardians-of-the-Galaxy', 'Black-Panther', 'Doctor-Strange', 'Thor', 'Captain-America', 'Captain-Marvel', 'Ant-Man',
            'Deadpool', 'Logan', 'X-Men', 'Wolverine', 'The-Hulk', 'Fantastic-Four', 'Superman', 'Batman', 'Justice-League',
            'Wonder-Woman', 'Aquaman', 'Green-Lantern', 'Suicide-Squad', 'Birds-of-Prey', 'Joker', 'Venom', 'Spider-Verse',
            'Shazam', 'Blade', 'The-Flash', 'Daredevil', 'Punisher', 'Ghost-Rider', 'Hellboy', 'Kick-Ass', 'Watchmen', 'Sin-City',
            '300', 'Sucker-Punch', 'V-for-Vendetta', 'The-Dark-Knight', 'Batman-Begins', 'The-Dark-Knight-Rises', 'Spider-Man-2',
            'Spider-Man-Homecoming', 'Far-From-Home', 'No-Way-Home', 'Man-of-Steel', 'Batman-v-Superman', 'Justice-League-Snyder-Cut',
            'Godzilla', 'King-Kong', 'Pacific-Rim', 'Cloverfield', 'The-Hunger-Games', 'Divergent', 'Twilight', 'Harry-Potter-and-the-Sorcerer’s-Stone',
            'Chamber-of-Secrets', 'Prisoner-of-Azkaban', 'Goblet-of-Fire', 'Order-of-the-Phoenix', 'Half-Blood-Prince',
            'Deathly-Hallows', 'Fantastic-Beasts', 'Where-to-Find-Them', 'The-Crimes-of-Grindelwald', 'The-Secrets-of-Dumbledore',
            'Twilight-Saga', 'New-Moon', 'Eclipse', 'Breaking-Dawn', 'Divergent-Series', 'Insurgent', 'Allegiant', 'Hobbit',
            'An-Unexpected-Journey', 'The-Desolation-of-Smaug', 'The-Battle-of-the-Five-Armies', 'The-Silence-of-the-Lambs',
            'Hannibal', 'Red-Dragon', 'The-Ring', 'The-Grudge', 'Paranormal-Activity', 'Insidious', 'Conjuring', 'Saw', 'Scream',
            'Halloween', 'A-Nightmare-on-Elm-Street', 'Friday-the-13th', 'The-Texas-Chainsaw-Massacre', 'Child’s-Play', 'It',
            'Pet-Sematary', 'The-Shining', 'Doctor-Sleep', 'Carrie', 'Misery', 'The-Fog', 'The-Mist', 'The-Exorcist', 'Poltergeist',
            'The-Amityville-Horror', 'The-Omen', 'Rosemary’s-Baby', 'The-Wicker-Man', 'Hereditary', 'Midsommar', 'The-Babadook',
            'Get-Out', 'Us', 'A-Quiet-Place', 'The-Witch', 'The-Invisible-Man', 'The-Conjuring-2', 'Annabelle', 'The-Nun', 'Lights-Out',
            'Sinister', 'Don’t-Breathe', 'The-Purge', 'Escape-Room', 'Truth-or-Dare', 'Happy-Death-Day', 'Fantasy-Island'
        ]
    ],
    
    'GTA' => [
    'title_id' => 254,
    'words' => [
        'GTA', 'Grand-Theft-Auto', 'Rockstar-Games', 'Open-world', 'Crime', 'Los-Santos', 'Vice-City', 'Liberty-City', 'San-Andreas',
        'Trevor', 'Franklin', 'Michael', 'CJ', 'Tommy-Vercetti', 'Niko-Bellic', 'Heists', 'Missions', 'Gangs', 'Car-chases',
        'Wanted-level', 'Police', 'Law-enforcement', 'Cop-chases', 'Vehicles', 'Sports-cars', 'Motorcycles', 'Helicopters', 
        'Planes', 'Boats', 'Weapons', 'Guns', 'Pistols', 'Shotguns', 'Sniper-rifles', 'Melee-weapons', 'Baseball-bat', 'Knife',
        'Grenades', 'Rocket-launcher', 'Explosives', 'Custom-vehicles', 'Tuning', 'Car-mods', 'Illegal-activities', 'Street-racing',
        'Stunt-jumps', 'Racing', 'Drifting', 'Robberies', 'Bank-heists', 'Armored-trucks', 'Store-robbery', 'Drugs', 'Weapons-deal',
        'Criminal-empire', 'Drug-cartels', 'Nightclubs', 'Bars', 'Casinos', 'Safehouses', 'Real-estate', 'Apartments', 'Mansions',
        'Garages', 'Bounty-hunting', 'Assassinations', 'Vigilante', 'Undercover-cops', 'Corrupt-cops', 'Detectives', 'Street-gangs',
        'Motorcycle-gangs', 'Turf-wars', 'Skyscrapers', 'Strip-clubs', 'Exotic-cars', 'Luxury-lifestyle', 'Nightlife', 'Parachuting',
        'Jets', 'Tanks', 'Military', 'War', 'Criminal-underworld', 'Billionaires', 'Celebrities', 'Smuggling', 'Fraud', 'Corruption',
        'Hitman', 'Underworld', 'Black-market', 'Mafia', 'Mob-bosses', 'Crime-lords', 'Street-thugs', 'Underground-economy', 'Racketeering',
        'Extortion', 'Bribery', 'Grand-theft-auto', 'Kidnapping', 'Hostages', 'Weapon-smuggling', 'Street-crimes', 'Counterfeiting',
        'Gang-wars', 'Drug-dealers', 'Money-laundering', 'High-speed-chase', 'Police-brutality', 'Undercover-operations', 'Stolen-vehicles',
        'Hijacking', 'Car-theft', 'Auto-theft', 'Street-violence', 'Vehicular-manslaughter', 'Public-endangerment', 'Crime-sprees',
        'Escaping-the-law', 'Wanted-stars', 'Gang-violence', 'Crime-syndicate', 'Kingpins', 'Illegal-gambling', 'Weapons-trafficking',
        'Prison-breaks', 'Lockpicking', 'Safe-cracking', 'Burglary', 'Trespassing', 'Vandalism', 'Scams', 'Car-bombs', 'Drive-bys',
        'Vigilantism', 'Anarchy', 'Civil-unrest', 'Looting', 'Riots', 'Sabotage', 'Blackmail', 'Smuggling-rings', 'GTA-online',
        'Online-multiplayer', 'Heist-planning', 'Crew-recruitment', 'Mission-planning', 'Criminal-groups', 'Gang-leader', 'Fast-cars',
        'Escape-plan', 'Armored-vehicles', 'Crime-boss', 'Drug-trafficking', 'Cartel-leader', 'Money-heists', 'ATM-robbery', 'Vehicle-customization',
        'Armored-suits', 'Sniping', 'Gun-fights', 'Car-explosions', 'Hostage-negotiations', 'Evading-police', 'Mob-mentality', 'GTA-5',
        'Los-Santos-customs', 'Illegal-racing', 'Street-fights', 'Gun-battles', 'Escape-routes', 'Body-armor', 'Bulletproof-cars', 'Surveillance',
        'Hacking', 'CCTV-hack', 'Skilled-driver', 'Criminal-mastermind', 'Police-raid', 'Drug-deals', 'Grand-larceny', 'Mugging', 'Pimping',
        'Prostitution', 'Pickpocketing', 'Street-hustle', 'Car-boosting', 'Street-smarts', 'Getaway-cars', 'Urban-violence', 'Breaking-laws',
        'Vigilante-justice', 'Undercover-cop', 'Police-raid', 'Heist-preparation', 'Police-squad', 'Bank-robbery', 'Street-crime', 'Life-of-crime',
        'Fast-and-furious', 'Hot-pursuit', 'Survival-of-the-fittest', 'Urban-gangster', 'Elite-criminals', 'Stunt-driving', 'Saboteur', 'Outlaw',
        'Notorious-gangs', 'Biker-gangs', 'Rival-gangs', 'Bribed-cops', 'Guns-for-hire', 'Paid-assassins', 'Criminal-boss', 'Crime-fighters',
        'Kingpin-strategy', 'Getaway-planner', 'Street-cred', 'Most-wanted', 'Escape-artists', 'Guns-and-money', 'Hardcore-gamers', 'Online-heists',
        'Street-corner-deals', 'Street-king', 'Robbery-missions', 'Weapon-upgrades', 'Luxury-vehicles', 'Rooftop-escape', 'Sniper-missions',
        'Heist-mastermind', 'Car-stealing', 'Weapons-dealer', 'Car-chase-expert', 'Realistic-gaming', 'Strategic-heists', 'Money-runner', 
        'Drift-racing', 'Escape-planning', 'Stealth-mode', 'Urban-crime-world', 'Online-leaderboards', 'Action-packed', 'Crime-kingpin',
        'High-risk-missions', 'Money-makes-the-world-go-round', 'Car-jacker', 'Grand-theft-expert', 'Vice', 'Epic-missions', 'Wanted-criminals'
    ]
],


'Oregon-Trail' => [
    'title_id' => 255,
    'words' => [
        'Oregon-Trail', 'Pioneer', 'Westward-expansion', 'Trail', 'Wagon', 'Settlers', 'Dysentery', 'Hunting', 'Foraging',
        'Supplies', 'Oxen', 'Rivers', 'Prairies', 'Mountains', 'Wagon-train', 'Frontier', 'Gold-rush', 'Manifest-destiny',
        'Exploration', 'Homestead', 'Independence-Missouri', 'Chimney-Rock', 'Fort-Laramie', 'Fort-Bridger', 'Snake-River',
        'Columbia-River', 'Willamette-Valley', 'Diseases', 'Food-rations', 'Cattle', 'Crossing-rivers', 'Ford-rivers', 'Rafting',
        'Broken-wagon-wheels', 'Lost-trail', 'Starvation', 'Blizzards', 'Dangerous-terrain', 'Native-Americans', 'Trading',
        'General-store', 'Buffalo', 'Bison', 'Deer-hunting', 'Bear-encounters', 'Wildlife', 'Mountain-passes', 'Supplies-shortage',
        'Dangers-on-the-trail', 'Survival', 'Resource-management', 'Scavenging', 'Hunting-for-food', 'Crossing-the-plains',
        'Perils-of-the-west', 'Wild-West', 'Pioneering-spirit', 'Wagon-repairs', 'Oregon-country', 'Western-expansion',
        'Life-on-the-trail', 'River-crossings', 'Winter-conditions', 'Health-challenges', 'Typhoid', 'Cholera', 'Snake-bites',
        'Outdoors', 'Adventure', 'Settlements', 'Survival-strategy', 'Exploration-game', 'Historical-game', 'Education',
        'Decision-making', 'Wild-frontier', 'Risk-taking', 'Group-survival', 'Fortunes', 'Game-of-survival', 'Epic-journey',
        'Historical-expedition', 'Traveling-west', 'Old-West', 'Wagon-wheels', 'Wagon-parts', 'Trading-posts', 'Cattle-driving',
        'Travel-strategies', 'Homesteading', 'Western-migration', 'Farming', 'Wild-animals', 'Trail-adventures', 'American-frontier',
        'Mid-1800s', 'Westward-travel', 'Survival-simulator', 'Land-expansion', 'Gold-rush-era', 'Oregon-bound', 'Trail-of-danger',
        'Wilderness', 'Trail-map', 'Landscapes', 'Pioneers-on-the-move', 'Game-of-life', 'Choosing-your-path', 'Settler-life',
        'Pioneer-travel', 'Wagon-leaders', 'Settler-families', 'Horse-drawn-carriages', 'River-rafting', 'Cross-country-travel',
        'Trek-west', 'Outlaws', 'Bandits', 'Shooting-game', 'Exploration-game', 'Early-American-history', 'Fort-hopping',
        'Wagon-master', 'Homestead-building', 'Wagon-camping', 'Survival-decisions', 'Dangerous-wildlife', 'Trail-diseases',
        'Snake-bites', 'Finding-water', 'Trail-guide', 'Survival-adventure', 'Exploring-the-west', 'Weather-hazards', 'Wilderness-travel',
        'Westward-travel-challenges', 'Decision-making-game', 'Resource-allocation', 'Landmarks', 'Trail-survival-strategies',
        'Wagon-hitching', 'Wagon-leader', 'Disease-outbreaks', 'Food-rationing', 'Managing-resources', 'Pioneer-life',
        'Dysentery-simulator', 'Hunting-simulator', 'Western-frontier', 'Oregon-territory', 'Western-wilderness', 'Camping',
        'Trail-life', 'Water-scarcity', 'Trail-dangers', 'Trail-survival', 'Game-over', 'Gold-rush-adventure', 'Overland-travel',
        'Shooting-hunting', 'Living-off-the-land', 'Historical-journey', 'Wilderness-survival', 'Epic-expedition', 'Trail-obstacles',
        'Wild-West-journey', 'Making-history', 'Land-claim', 'Pioneer-legacy', 'Explorers', 'Land-route', 'Family-adventure',
        'Food-and-supplies', 'Land-pioneers', 'Oregon-bound-wagon', 'Journey-west', 'Trail-risks', 'Historical-challenge', 'Oregon-country-goals',
        'Endless-adventure', 'Wildlife-encounters', 'Mountain-challenges', 'River-rapids', 'Blizzards-on-the-trail', 'Trail-survival-journey',
        'Food-storage', 'Prairie-life', 'Crossing-America', 'Wagon-building', 'Oregon-trail-adventure', 'Family-survival',
        'Land-adventure', 'Frontier-challenges', 'Living-the-frontier', 'Land-discovery', 'Survival-on-the-prairie', 'Hardships-of-the-trail',
        'Lost-wagons', 'Broken-bones', 'Exhausted-oxen', 'Crossing-the-wilderness', 'Journey-of-the-west', 'Fur-trading', 'Mountain-trekking',
        'Saddle-up', 'Exploration-history', 'Path-to-the-west', 'Survival-quest', 'Old-American-frontier', 'Map-of-the-west',
        'Explorer-challenges', 'Lands-of-opportunity', 'Crossing-the-west', 'Trails-of-the-west', 'Oregon-trail-game', 'Prairie-trails'
    ]
],


'Pong' => [
    'title_id' => 256,
    'words' => [
        'Pong', 'Classic-game', 'Arcade-game', 'Retro-game', 'Table-tennis', 'Paddle', 'Ball', 'Ping-pong', 'Two-player', 
        'Atari', '1970s-game', 'Competitive', 'Simple-controls', 'Pixelated-graphics', 'Side-view', 'Score-points', 
        'Bounce', 'Paddle-control', 'Tennis-like', 'Left-player', 'Right-player', 'Scoreboard', 'Endless-gameplay', 
        'Arcade-classic', 'Atari-2600', 'Gaming-history', 'Simple-physics', 'Fast-paced', 'Reflex-game', 'Reaction-speed',
        'Ball-movement', 'Paddle-bouncing', 'Digital-tennis', 'Rally', 'Retro-graphics', 'Basic-gameplay', 'Addictive-gameplay',
        'High-score', 'Leaderboards', 'Multiplayer', '1v1-game', 'Computer-opponent', 'Two-paddles', 'Basic-tennis',
        'Horizontal-court', 'Pixel-paddle', 'Arcade-legend', 'Game-simplicity', 'Pong-tournament', 'Computer-controlled-paddle',
        'Arcade-experience', 'Classic-arcade-machine', 'Coin-op', 'Game-room', 'Early-video-game', 'Vintage-game', 
        'Atari-classic', 'Virtual-tennis', 'Old-school-gaming', 'Gaming-pioneer', 'Game-industry-icon', 'Simple-but-challenging',
        'Player-vs-player', 'Single-player', 'Versus-mode', 'Physics-simulation', 'Retro-arcade', 'Bounce-ball', 'Pong-champion',
        'Arcade-competition', 'Pixel-ball', 'Famous-pong', 'Paddle-ball-game', 'Basic-pong', 'Tennis-pong', 'Digital-tennis-game',
        'Arcade-sports', 'Classic-paddle', 'Simple-game-mechanics', 'Old-school-pong', 'Timeless-classic', 'Legendary-game',
        'Video-game-history', 'Original-pong', 'Paddle-tennis', 'Retro-paddle-game', 'Fast-ball', 'Pong-battle', 
        'Minimalist-game', 'One-on-one', 'Game-matches', 'Player-matches', 'Minimalist-pong', 'Ball-speed', 'Top-score',
        'Arcade-tournament', 'Legendary-arcade', 'Fast-paced-pong', 'Game-playground', 'Tennis-challenge', 'Endless-tennis',
        'Score-based', 'Pong-arcade-tournament', 'High-stakes-pong', 'Multiplayer-tennis', 'Pong-paddle-challenge', 'Bouncing-ball-game',
        'Precision-paddle', 'Side-to-side', 'Ping-pong-arcade', 'Pong-court', 'Arcade-machine', 'Virtual-competition', 
        'Pong-rematch', 'Fast-paddle-game', 'Game-of-tennis', 'Arcade-simplicity', 'Pong-championship', 'Classic-paddle-game',
        'Digital-paddle', 'Game-room-pong', 'Arcade-tennis', 'Player-paddle', 'Table-tennis-virtual', 'Virtual-ball',
        'Bouncing-ball', 'Digital-competition', 'High-speed-pong', 'Reaction-paddle', 'Pong-ball-control', 'Game-of-reflex',
        'Tennis-pong-match', 'Player-pong', 'Simple-game-physics', 'Pixelated-pong', 'Pong-high-score', 'Pong-tournament-play',
        'Classic-arcade-competition', 'Paddle-vs-paddle', 'Simple-tennis-game', 'Pong-retro', 'Atari-arcade', 'Pong-victory',
        'Classic-competition', 'Arcade-paddle-tennis', 'Reflex-pong', 'Simple-pixel-pong', 'Basic-pong-play', 'Player-vs-computer',
        'Arcade-retro', 'Gaming-legend', 'Competitive-pong', 'Video-game-classic', 'Paddle-ball', 'Atari-history', 'Fast-paced-tennis',
        'Old-school-arcade', 'Endless-paddle-game', 'Tennis-simulation', 'Arcade-classics', 'Early-gaming', 'First-video-games',
        'Atari-gaming-history', 'Retro-tennis', 'Virtual-arcade', 'Pixel-challenge', 'Classic-pong-arcade', 'Ball-paddle-control',
        'Original-arcade-game', 'Pong-champion-titles', 'Competitive-table-tennis', 'Paddle-ball-challenge', 'Fast-ball-reflex',
        'Simple-arcade', 'Arcade-competition', 'Pong-high-score-challenge', 'Classic-pixel-game', 'Old-school-tennis', 'Fastest-ball',
        'Best-of-three', 'Fast-paddle-reflex', 'Atari-classic-arcade', 'Table-tennis-simulation', 'Minimalist-tennis-game',
        'Ball-bouncing-game', 'Precision-paddle-control', 'Retro-gameplay', 'Fast-paced-reflex', 'Tennis-video-game', 'First-tennis-game',
        'Arcade-table-tennis', 'Pong-pioneer', 'High-reflex', 'Simple-tennis-challenge', 'Classic-video-game-history'
    ]
],

    
    'Combat' => [
    'title_id' => 257,
    'words' => [
        'Tank', 'Biplane', 'Battle', 'Multiplayer', 'War-game', 'Atari', 'Arcade', 'Dogfight', 'Shootout', 'Classic',
        'Duel', 'Air-combat', 'Tank-battle', 'Plane-battle', 'Maze', 'Strategy', 'Power-ups', 'Retro', 'Missiles', 
        'Obstacles', 'Dodging', 'Explosions', 'Aim', 'Fast-paced', 'Enemy', 'Two-player', 'Versus', 'Gunfire', 
        'Bullets', 'Warzone', 'Action-packed', 'Map-navigation', 'Armored-vehicles', 'Aerial-combat', 'Arcade-shooter', 
        'Chase', 'Retro-warfare', 'Tank-attack', 'Aerial-dogfight', 'Open-world', 'Terrain', 'Cover', 'Hide-and-seek', 
        'Combat-strategy', 'Tactical-combat', 'Battlefield', 'War-tactics', 'Competitive', 'Showdown', 'Score', 
        'Arcade-action', 'Shooting', 'Firepower', 'Survival', 'Airplanes', 'Destruction', 'War-strategy', 'Team-battle', 
        'Intense-action', 'Maneuver', 'Tank-destruction', 'Dogfighting', 'Shoot-to-win', 'Close-quarters', 'Aerial-battle', 
        'Open-combat', 'Armored-warfare', 'Aerial-strategy', 'Arcade-duel', 'Retro-action', 'Military', 'Tanks-vs-planes', 
        'War-maps', 'Weapons', 'Aerial-attacks', 'Maze-warfare', 'Dodge-missiles', 'Classic-combat', 'Fast-duels', 
        'Challenging-battles', 'Simple-combat', 'Arcade-battle', 'Combat-mastery', 'Versus-mode', 'Simple-controls', 
        'Rapid-fire', 'War-machines', 'Blitz-attack', 'Strategic-shooting', 'Fire', 'Weapon-aim', 'War-vehicles', 
        'Aerial-tactics', 'Tactical-warfare', 'Arcade-warfare', 'Classic-warfare', 'Maneuvering', 'Tank-warfare', 
        'Tactical-movement', 'Aerial-engagement'
    ]
],

'Zork' => [
    'title_id' => 258,
    'words' => [
        'Interactive-fiction', 'Text-adventure', 'Dungeon', 'Treasure', 'Puzzles', 'Grue', 'Adventure-game', 'Exploration', 
        'Maze', 'Underground', 'Fantasy', 'Zorkmid', 'West-of-house', 'Caverns', 'Inventory', 'Mystery', 'Magic', 
        'Ancient', 'Artifacts', 'Darkness', 'Commands', 'Parser', 'Turn-based', 'Typing', 'Hidden-treasures', 
        'Classic-adventure', 'Story-driven', 'Narrative', 'Text-based', 'Role-playing', 'Choices', 'Fictional-world', 
        'Magic-spells', 'Sword', 'Enchanted', 'Scrolls', 'Riddles', 'Adventure-puzzles', 'Unravel', 'Interactive-story', 
        'Fantasy-realm', 'Zorkian', 'Forgotten-kingdom', 'Adventure-path', 'Hero', 'Monsters', 'Traps', 'Enigmas', 
        'Underground-kingdom', 'Fiction', 'Lost-treasure', 'Adventure-narrative', 'Game-world', 'Quests', 'Dialogues', 
        'Fantasy-mystery', 'Caves', 'Labyrinth', 'Uncharted', 'Ancient-secrets', 'Fantasy-puzzles', 'Exploration-game', 
        'Legendary', 'Dark-forces', 'Mysterious-places', 'Treasure-hunting', 'Questing', 'Riddles-solving', 'Hidden-rooms', 
        'Cryptic-messages', 'Magical-kingdom', 'Ancient-ruins', 'Fantasy-adventure', 'Interactive-puzzle', 'Narrative-driven', 
        'Text-input', 'Story-puzzles', 'Interactive-commands', 'Adventurous', 'Mythical-world', 'Dungeon-exploration', 
        'Mysterious-artifacts', 'Underground-labyrinth', 'Treasure-map', 'Magic-scrolls', 'Adventurous-quest', 
        'Lost-world', 'Forgotten-realm', 'Enigmatic-world', 'Mystery-solving', 'Mythical-realm', 'Text-story', 
        'Interactive-world', 'Classic-fantasy', 'Adventure-hero', 'Hidden-caverns', 'Dungeon-crawler', 'Text-puzzles', 
        'Narrative-journey', 'Immersive-world', 'Adventure-riddles'
    ]
],


        'xxx' => $xxx_cat,  // Adicionando a categoria 'xxx'
        'hardcore' => $hardcore_cat,  // Adicionando a categoria hardcore
];