<?php
// get_pinfeeds_debug.php - Versão de Debug para identificar o erro
session_start();

// Ativa todos os erros
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Configurações
$user_id = $_SESSION['user_id'] ?? null;
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';
$resultsPerPage = 21;

// Array para coletar informações de debug
$debugInfo = [
    'mysql_version' => '',
    'steps' => [],
    'errors' => []
];

// Teste 1: Conexão
try {
    $conn = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $debugInfo['steps'][] = "✓ Conexão estabelecida";
    
    // Verifica versão do MySQL
    $version = $conn->query("SELECT VERSION()")->fetchColumn();
    $debugInfo['mysql_version'] = $version;
    $debugInfo['steps'][] = "✓ MySQL version: $version";
    
} catch (PDOException $e) {
    $debugInfo['errors'][] = "✗ Erro de conexão: " . $e->getMessage();
    die(json_encode($debugInfo));
}

// Parâmetros
$keyword = trim($_GET['search'] ?? '');
$page = max(1, intval($_GET['page'] ?? 1));
$offset = ($page - 1) * $resultsPerPage;

$debugInfo['parameters'] = [
    'keyword' => $keyword,
    'page' => $page,
    'offset' => $offset,
    'user_id' => $user_id
];

// Teste 2: Query simples primeiro
try {
    $testQuery = "SELECT COUNT(*) as total FROM pinfeeds";
    $result = $conn->query($testQuery)->fetch();
    $debugInfo['steps'][] = "✓ Total de feeds na tabela: " . $result['total'];
} catch (PDOException $e) {
    $debugInfo['errors'][] = "✗ Erro na query de teste: " . $e->getMessage();
}

// Teste 3: Query principal super simplificada
try {
    $simpleQuery = "
        SELECT 
            f.id,
            f.title,
            f.description,
            f.link,
            f.pubDate,
            f.thumbnail,
            f.author,
            f.user_id
        FROM pinfeeds f
        ORDER BY f.id DESC
        LIMIT :offset, :limit
    ";
    
    $stmt = $conn->prepare($simpleQuery);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->bindValue(':limit', $resultsPerPage, PDO::PARAM_INT);
    $stmt->execute();
    
    $feeds = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $debugInfo['steps'][] = "✓ Query simples executada. Feeds retornados: " . count($feeds);
    
} catch (PDOException $e) {
    $debugInfo['errors'][] = "✗ Erro na query simples: " . $e->getMessage();
    $debugInfo['errors'][] = "Query: " . $simpleQuery;
}

// Teste 4: Adiciona contagem de comentários
if (!empty($feeds)) {
    try {
        foreach ($feeds as &$feed) {
            // Contagem simples
            $countStmt = $conn->prepare("SELECT COUNT(*) FROM comments WHERE feed_id = ?");
            $countStmt->execute([$feed['id']]);
            $feed['comments_count'] = $countStmt->fetchColumn();
            
            // Valores padrão
            $feed['isSaved'] = 0;
            $feed['user_action'] = null;
            $feed['user_has_commented'] = 0;
        }
        $debugInfo['steps'][] = "✓ Contagem de comentários adicionada";
        
    } catch (PDOException $e) {
        $debugInfo['errors'][] = "✗ Erro ao contar comentários: " . $e->getMessage();
    }
}

// Teste 5: Se tiver user_id, tenta adicionar dados do usuário
if ($user_id && !empty($feeds)) {
    try {
        foreach ($feeds as &$feed) {
            // Verifica favoritos
            $favStmt = $conn->prepare("SELECT 1 FROM favorites WHERE feed_id = ? AND user_id = ? LIMIT 1");
            $favStmt->execute([$feed['id'], $user_id]);
            $feed['isSaved'] = $favStmt->fetchColumn() ? 1 : 0;
            
            // Verifica likes/dislikes
            $likeStmt = $conn->prepare("SELECT action FROM likes_dislikes WHERE feed_id = ? AND user_id = ? LIMIT 1");
            $likeStmt->execute([$feed['id'], $user_id]);
            $feed['user_action'] = $likeStmt->fetchColumn() ?: null;
        }
        $debugInfo['steps'][] = "✓ Dados do usuário adicionados";
        
    } catch (PDOException $e) {
        $debugInfo['errors'][] = "✗ Erro ao adicionar dados do usuário: " . $e->getMessage();
    }
}

// Resultado final
$result = [
    'success' => empty($debugInfo['errors']),
    'debug' => $debugInfo,
    'feeds' => $feeds ?? [],
    'total_feeds' => count($feeds ?? [])
];

// Retorna resultado
header('Content-Type: application/json');
echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
?>