<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerador de Categorias</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            padding: 20px;
        }
        input, textarea, button {
            width: 100%;
            margin-top: 10px;
            padding: 10px;
        }
        textarea {
            height: 150px;
        }
        .result {
            background-color: #f4f4f4;
            padding: 20px;
            border-radius: 5px;
            margin-top: 20px;
            white-space: pre-wrap;
        }
        .result pre {
            word-wrap: break-word;
        }
    </style>
</head>
<body>

<h1>Gerador de Categorias para Palavras</h1>

<form method="POST">
    <label for="category_name">Nome da Categoria:</label>
    <input type="text" id="category_name" name="category_name" required>

    <label for="category_id">ID da Categoria:</label>
    <input type="number" id="category_id" name="category_id" required>

    <label for="word_list">Lista de Palavras (separadas por vírgula, espaço ou novas linhas):</label>
    <textarea id="word_list" name="word_list" required></textarea>

    <button type="submit">Gerar Categoria</button>
</form>

<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $category_name = htmlspecialchars($_POST['category_name']);
    $category_id = (int)$_POST['category_id'];
    $word_list = $_POST['word_list'];

    // Remove números isolados e números no início ou final das palavras, preservando texto
    $words = preg_split('/[\s,]+/', $word_list); // Divide por espaço, vírgula ou nova linha
    $filtered_words = [];

    foreach ($words as $word) {
        // Remove números isolados ou que estão no começo ou final da palavra
        $word = preg_replace('/^\d+[\.\d+]*|\d+$/', '', $word); 
        $word = trim($word); // Remove espaços em branco
        if (!empty($word)) {
            $filtered_words[] = $word;
        }
    }

    // Remove duplicatas
    $filtered_words = array_unique($filtered_words);

    // Gera o código PHP no formato solicitado
    echo "<div class='result'><pre>";
    echo "'$category_name' => [\n";
    echo "    'title_id' => $category_id,\n";
    echo "    'words' => [\n";

    // Exibe as palavras com até 10 por linha
    $count = 0;
    foreach ($filtered_words as $word) {
        if ($count % 10 == 0 && $count != 0) {
            echo "\n"; // Quebra de linha após 10 palavras
        }
        echo "'$word', ";
        $count++;
    }

    echo "\n    ]\n";
    echo "];\n";
    echo "</pre></div>";
}
?>

</body>
</html>
