<?php
// register.php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Conecte-se ao banco de dados usando PDO
    $host = 'localhost';
    $db = 'digupdog_FEED';
    $user = 'digupdog_FEEDadmin';
    $pass = 'Raimundinho1';
    $charset = 'utf8mb4';
    $dsn = "mysql:host=$host;dbname=$db;charset=$charset";
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];

    try {
        $pdo = new PDO($dsn, $user, $pass, $options);
    } catch (\PDOException $e) {
        throw new \PDOException($e->getMessage(), (int)$e->getCode());
    }

    // Valide e sane os dados do formulário
    $username = filter_var($_POST['username'], FILTER_SANITIZE_STRING);
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $password = $_POST['password']; // Não sane a senha aqui, ela será hashed

    // Verifique se o usuário/email já existe
    $stmt = $pdo->prepare("SELECT * FROM user_myhashtag WHERE username = ? OR email = ?");
    $stmt->execute([$username, $email]);
    if ($stmt->fetch()) {
        // Usuário já existe, trate o erro adequadamente
        exit('Usuário ou email já registrado.');
    }

    // Hash da senha
    $passwordHash = password_hash($password, PASSWORD_DEFAULT);

    // Insira no banco de dados
    $stmt = $pdo->prepare("INSERT INTO user_myhashtag (username, email, senha) VALUES (?, ?, ?)");
    $stmt->execute([$username, $email, $passwordHash]);

    // Se o registro foi bem-sucedido, redirecione para a página de login
    header("Location: login.html");
    exit;
} else {
    // Se não for um POST, ou se o registro falhar, você pode mostrar uma mensagem ou fazer algo diferente
    echo "Operação inválida.";
}
?>
