<?php
require_once __DIR__ . '/../config.php';

// api_favorites.php
session_start();
header('Content-Type: application/json; charset=utf-8');

$host = 'localhost';
$db   = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=$charset", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success'=>false,'error'=>'db_connection_failed']);
    exit;
}

function getUserId(PDO $pdo): ?int {
    if (!isset($_SESSION['username'])) return null;
    $st = $pdo->prepare("SELECT ID FROM user_myhashtag WHERE username = :u LIMIT 1");
    $st->execute([':u' => $_SESSION['username']]);
    $r = $st->fetch(PDO::FETCH_ASSOC);
    return $r ? (int)$r['ID'] : null;
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $feedId = isset($_GET['feed_id']) ? (int)$_GET['feed_id'] : 0;
    if ($feedId <= 0) { echo json_encode(['success'=>false,'error'=>'invalid_feed']); exit; }
    $userId = getUserId($pdo);
    if (!$userId) { echo json_encode(['success'=>true,'favorited'=>false,'not_logged_in'=>true]); exit; }

    $st = $pdo->prepare("SELECT id FROM favorites WHERE user_id = ? AND feed_id = ? LIMIT 1");
    $st->execute([$userId,$feedId]);
    echo json_encode(['success'=>true, 'favorited'=>(bool)$st->fetchColumn()]);
    exit;
}

if ($method === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $feedId = isset($data['feed_id']) ? (int)$data['feed_id'] : 0;
    if ($feedId <= 0) { echo json_encode(['success'=>false,'error'=>'invalid_feed']); exit; }

    $userId = getUserId($pdo);
    if (!$userId) { echo json_encode(['success'=>false,'error'=>'not_logged_in']); exit; }

    $st = $pdo->prepare("SELECT id FROM favorites WHERE user_id = ? AND feed_id = ? LIMIT 1");
    $st->execute([$userId,$feedId]);
    $rowId = $st->fetchColumn();

    if ($rowId) {
        $del = $pdo->prepare("DELETE FROM favorites WHERE id = ?");
        $del->execute([$rowId]);
        echo json_encode(['success'=>true,'favorited'=>false,'action'=>'removed']);
    } else {
        $ins = $pdo->prepare("INSERT INTO favorites (user_id, feed_id) VALUES (?, ?)");
        $ins->execute([$userId,$feedId]);
        echo json_encode(['success'=>true,'favorited'=>true,'action'=>'added']);
    }
    exit;
}

http_response_code(405);
echo json_encode(['success'=>false,'error'=>'method_not_allowed']);
