<?php
$host = 'localhost';
$db = 'digupdog_FEED';
$user = 'digupdog_FEEDadmin';
$pass = 'Raimundinho1';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Falha ao conectar ao banco de dados: ' . $e->getMessage()]);
    exit;
}

if (isset($_POST['url'])) {
    $url = trim($_POST['url']);

    if (!filter_var($url, FILTER_VALIDATE_URL)) {
        echo json_encode(['success' => false, 'message' => 'URL inválida.']);
        exit;
    }

    // Inicializa o cURL
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Seguir redirecionamentos
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0'); // Define um user agent
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Tempo máximo de execução

    $html = curl_exec($ch);
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
    $err = curl_error($ch);
    curl_close($ch);

    if ($httpcode >= 400 || !$html) {
        echo json_encode(['success' => false, 'message' => 'Não foi possível acessar a URL. Código HTTP: ' . $httpcode]);
        exit;
    }

    // Detecta o charset
    $encoding = null;
    if (preg_match('/charset=([\w-]+)/i', $contentType, $matches)) {
        $encoding = $matches[1];
    }

    if ($encoding && strtolower($encoding) !== 'utf-8') {
        $html = mb_convert_encoding($html, 'HTML-ENTITIES', $encoding);
    }

    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    @$dom->loadHTML($html);
    libxml_clear_errors();

    $metadata = [
        'title' => '',
        'description' => '',
        'image' => ''
    ];

    // Captura título
    $nodes = $dom->getElementsByTagName('title');
    if ($nodes->length > 0) {
        $metadata['title'] = $nodes->item(0)->nodeValue;
    }

    // Arrays de propriedades para busca
    $metaProperties = [
        'title' => ['og:title', 'twitter:title'],
        'description' => ['og:description', 'twitter:description', 'description'],
        'image' => ['og:image', 'twitter:image', 'image', 'schema:image', 'image_src']
    ];

    $metas = $dom->getElementsByTagName('meta');
    foreach ($metas as $meta) {
        $attrs = [$meta->getAttribute('property'), $meta->getAttribute('name'), $meta->getAttribute('itemprop')];
        $content = $meta->getAttribute('content');
        foreach ($metaProperties as $key => $properties) {
            foreach ($properties as $prop) {
                if (in_array(strtolower($prop), array_map('strtolower', $attrs))) {
                    if (empty($metadata[$key])) {
                        $metadata[$key] = $content;
                    }
                }
            }
        }
    }

    // Normaliza URLs relativas para absolutas
    if (!empty($metadata['image'])) {
        $metadata['image'] = resolveUrl($metadata['image'], $url);
    }

    // Fallback para imagens
    if (empty($metadata['image'])) {
        $images = $dom->getElementsByTagName('img');
        if ($images->length > 0) {
            $metadata['image'] = resolveUrl($images->item(0)->getAttribute('src'), $url);
        }
    }

    // Limpa e codifica os dados
    $metadata = array_map('htmlspecialchars', $metadata);

    echo json_encode(array_merge(['success' => true], $metadata));
} else {
    echo json_encode(['success' => false, 'message' => 'URL não fornecida']);
}

// Função para converter URLs relativas em absolutas
function resolveUrl($relativeUrl, $baseUrl) {
    // Se já for uma URL absoluta, retorna como está
    if (parse_url($relativeUrl, PHP_URL_SCHEME) !== null) {
        return $relativeUrl;
    }

    // Constrói a URL absoluta
    $base = parse_url($baseUrl);
    $host = $base['scheme'] . '://' . $base['host'];
    if (strpos($relativeUrl, '/') === 0) {
        return $host . $relativeUrl;
    } else {
        $path = isset($base['path']) ? dirname($base['path']) : '';
        return $host . $path . '/' . $relativeUrl;
    }
}
?>