//ui.js

var container = document.querySelector('.category-buttons-container');
var wrapper = document.querySelector('.category-buttons-wrapper');
var leftArrow = document.querySelector('.left-arrow');
var rightArrow = document.querySelector('.right-arrow');
var scrollAmount = 0;
var scrollStep = 5;
var scrollInterval;

function startScrollLeft() {
  scrollInterval = setInterval(function() {
    scrollAmount -= scrollStep;
    if (scrollAmount <= 0) {
      scrollAmount = 0;
    }
    wrapper.scroll(scrollAmount, 0);
  }, 10);
}

function startScrollRight() {
  scrollInterval = setInterval(function() {
    scrollAmount += scrollStep;
    if (scrollAmount >= wrapper.scrollWidth - wrapper.clientWidth) {
      scrollAmount = wrapper.scrollWidth - wrapper.clientWidth;
    }
    wrapper.scroll(scrollAmount, 0);
  }, 10);
}

function stopScroll() {
  clearInterval(scrollInterval);
}

leftArrow.addEventListener('mousedown', startScrollLeft);
leftArrow.addEventListener('mouseup', stopScroll);
leftArrow.addEventListener('mouseleave', stopScroll);
rightArrow.addEventListener('mousedown', startScrollRight);
rightArrow.addEventListener('mouseup', stopScroll);
rightArrow.addEventListener('mouseleave', stopScroll);



let mybutton = document.getElementById("myBtn");

// Quando o usuário rolar 20px a partir do topo do documento, mostrar o botão
window.onscroll = function() {
scrollFunction();
};

function scrollFunction() {
if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
mybutton.style.display = "block";
} else {
mybutton.style.display = "none";
}
}

// Quando o usuário clicar no botão, rolar para o topo do documento
function topFunction() {
document.body.scrollTop = 0;
document.documentElement.scrollTop = 0;
}
